/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.graph;

import ca.sqlpower.graph.BreadthFirstSearchListener;
import ca.sqlpower.graph.GraphModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class BreadthFirstSearch<V, E> {
    private final List<BreadthFirstSearchListener<V>> searchListeners = new ArrayList<BreadthFirstSearchListener<V>>();
    private Comparator<V> comparator;

    public List<V> performSearch(GraphModel<V, E> model, V startingNode) {
        ArrayList<V> discoveredNodes = new ArrayList<V>();
        HashMap<V, Colour> colour = new HashMap<V, Colour>();
        HashMap<V, Integer> depth = new HashMap<V, Integer>();
        HashMap<V, V> predecessor = new HashMap<V, V>();
        for (Object u : model.getNodes()) {
            colour.put(u, Colour.WHITE);
            depth.put(u, Integer.MAX_VALUE);
            predecessor.put(u, null);
        }
        colour.put(startingNode, Colour.GRAY);
        depth.put(startingNode, 0);
        predecessor.put(startingNode, null);
        this.fireNodeDiscovered(startingNode);
        discoveredNodes.add(startingNode);
        LinkedList<V> queue = new LinkedList<V>();
        queue.add(startingNode);
        while (!queue.isEmpty()) {
            Object u;
            u = queue.element();
            Collection<V> adjacentNodes = model.getAdjacentNodes(u);
            if (this.comparator != null) {
                adjacentNodes = new ArrayList<V>(adjacentNodes);
                Collections.sort((List)adjacentNodes, this.comparator);
            }
            for (V v : adjacentNodes) {
                if (colour.get(v) != Colour.WHITE) continue;
                colour.put(v, Colour.GRAY);
                depth.put(v, (Integer)depth.get(u) + 1);
                predecessor.put(v, u);
                queue.add(v);
                this.fireNodeDiscovered(v);
                discoveredNodes.add(v);
            }
            queue.remove();
            colour.put(u, Colour.BLACK);
        }
        return discoveredNodes;
    }

    private void fireNodeDiscovered(V node) {
        for (int i = this.searchListeners.size() - 1; i >= 0; --i) {
            BreadthFirstSearchListener<V> l = this.searchListeners.get(i);
            l.nodeDiscovered(node);
        }
    }

    public void addBreadthFirstSearchListener(BreadthFirstSearchListener<V> l) {
        if (l == null) {
            throw new NullPointerException("Null listeners not allowed");
        }
        this.searchListeners.add(l);
    }

    public void removeBreadthFirstSearchListener(BreadthFirstSearchListener<V> l) {
        this.searchListeners.remove(l);
    }

    public Comparator<V> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    private static enum Colour {
        WHITE,
        GRAY,
        BLACK;

    }
}

