/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.XmlDocument;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@JRubyClass(name={"Nokogiri::XML::Text"}, parent="Nokogiri::XML::CharacterData")
public class XmlText
extends XmlNode {
    private static final long serialVersionUID = 1L;
    private static final ByteList TEXT = ByteList.create((CharSequence)"text");

    public XmlText(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass, node);
    }

    public XmlText(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @Override
    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw threadContext.runtime.newArgumentError(iRubyObjectArray.length, 2);
        }
        this.content = iRubyObjectArray[0];
        IRubyObject iRubyObject = iRubyObjectArray[1];
        if (!(iRubyObject instanceof XmlNode)) {
            String string = "expected second parameter to be a Nokogiri::XML::Document, received " + iRubyObject.getMetaClass();
            throw threadContext.runtime.newTypeError(string);
        }
        if (!(iRubyObject instanceof XmlDocument)) {
            threadContext.runtime.getWarnings().warn("Passing a Node as the second parameter to Text.new is deprecated. Please pass a Document instead. This will become an error in Nokogiri v1.17.0.");
        }
        Document document = XmlText.asXmlNode(threadContext, iRubyObject).getOwnerDocument();
        Text text = document.createTextNode(NokogiriHelpers.rubyStringToString(this.content));
        this.setNode(threadContext.runtime, text);
    }

    @Override
    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name == null) {
            this.name = RubyString.newStringShared((Ruby)threadContext.runtime, (ByteList)TEXT);
        }
        return this.name;
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter((Text)this.node);
        for (Node node = this.node.getFirstChild(); node != null; node = node.getNextSibling()) {
            RubyObject rubyObject;
            IRubyObject iRubyObject = NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
            if (iRubyObject instanceof XmlNode) {
                rubyObject = (XmlNode)iRubyObject;
                rubyObject.accept(threadContext, saveContextVisitor);
                continue;
            }
            if (!(iRubyObject instanceof XmlNamespace)) continue;
            rubyObject = (XmlNamespace)iRubyObject;
            rubyObject.accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(this.node);
    }

    static {
        TEXT.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
    }
}

