/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorInputStream;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ClobLocatorInputStream;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;

public abstract class Cursor {
    protected Agent agent_;
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int NULL_TERMINATED_BYTES = 7;
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public byte[] dataBuffer_;
    public ByteArrayOutputStream dataBufferStream_;
    public int position_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    private boolean allRowsReceivedFromServer_;
    long rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList<int[]> columnDataPositionCache_ = new ArrayList();
    protected ArrayList<int[]> columnDataLengthCache_ = new ArrayList();
    protected ArrayList<boolean[]> columnDataIsNullCache_ = new ArrayList();
    ArrayList<Boolean> isUpdateDeleteHoleCache_ = new ArrayList();
    boolean isUpdateDeleteHole_;
    private boolean isRowUpdated_;
    static final Boolean ROW_IS_NULL = Boolean.TRUE;
    private static final Boolean ROW_IS_NOT_NULL = Boolean.FALSE;
    private Calendar recyclableCalendar_ = null;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public Charset[] charset_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    private char[] charBuffer_;

    public Cursor(Agent agent) {
        this.agent_ = agent;
        this.isRowUpdated_ = false;
        this.dataBufferStream_ = new ByteArrayOutputStream();
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.columnDataPosition_ = new int[numberOfColumns];
        this.columnDataComputedLength_ = new int[numberOfColumns];
        this.columns_ = numberOfColumns;
        this.nullable_ = new boolean[numberOfColumns];
        this.charset_ = new Charset[numberOfColumns];
        this.ccsid_ = new int[numberOfColumns];
        this.isNull_ = new boolean[numberOfColumns];
        this.jdbcTypes_ = new int[numberOfColumns];
    }

    protected boolean stepNext(boolean allowServerFetch) throws SqlException {
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        this.isUpdateDeleteHole_ = false;
        this.isRowUpdated_ = false;
        while (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            this.getMoreData_();
        }
        boolean rowPositionIsValid = this.calculateColumnOffsetsForRow_(0, allowServerFetch);
        this.markNextRowPosition();
        return rowPositionIsValid;
    }

    public boolean next() throws SqlException {
        return this.stepNext(true);
    }

    public void setAllRowsReceivedFromServer(boolean b) {
        this.allRowsReceivedFromServer_ = b;
    }

    public final boolean allRowsReceivedFromServer() {
        return this.allRowsReceivedFromServer_;
    }

    final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.setAllRowsReceivedFromServer(false);
        this.dataBufferStream_.reset();
    }

    final boolean dataBufferHasUnprocessedData() {
        return this.lastValidBytePosition_ - this.position_ > 0;
    }

    protected abstract boolean calculateColumnOffsetsForRow_(int var1, boolean var2) throws SqlException, DisconnectException;

    protected abstract void clearLobData_();

    protected abstract void getMoreData_() throws SqlException;

    public final void setIsUpdataDeleteHole(int row, boolean isRowNull) {
        Boolean nullIndicator;
        this.isUpdateDeleteHole_ = isRowNull;
        Boolean bl = nullIndicator = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == row) {
            this.isUpdateDeleteHoleCache_.add(nullIndicator);
        } else {
            this.isUpdateDeleteHoleCache_.set(row, nullIndicator);
        }
    }

    public final void setIsRowUpdated(boolean isRowUpdated) {
        this.isRowUpdated_ = isRowUpdated;
    }

    public final boolean getIsRowUpdated() {
        return this.isRowUpdated_;
    }

    public final boolean getIsUpdateDeleteHole() {
        return this.isUpdateDeleteHole_;
    }

    protected final void markNextRowPosition() {
        this.nextRowPosition_ = this.position_;
    }

    protected final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private boolean get_BOOLEAN(int column) {
        return SignedBinary.getByte(this.dataBuffer_, this.columnDataPosition_[column - 1]) != 0;
    }

    private final short get_SMALLINT(int column) {
        return SignedBinary.getShort(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    protected final int get_INTEGER(int column) {
        return SignedBinary.getInt(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final long get_BIGINT(int column) {
        return SignedBinary.getLong(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final float get_FLOAT(int column) {
        return FloatingPoint.getFloat(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final double get_DOUBLE(int column) {
        return FloatingPoint.getDouble(this.dataBuffer_, this.columnDataPosition_[column - 1]);
    }

    private final BigDecimal get_DECIMAL(int column) throws SqlException {
        return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
    }

    private double getDoubleFromDECIMAL(int column) throws SqlException {
        try {
            return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), e, "double");
        }
    }

    private long getLongFromDECIMAL(int column, String targetType) throws SqlException {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (ArithmeticException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), e, targetType);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), e, targetType);
        }
    }

    private String getVARCHAR(int column) throws SqlException {
        if (this.ccsid_[column - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[column - 1] + 2, this.columnDataComputedLength_[column - 1] - 2);
        }
        if (this.charset_[column - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String tempString = new String(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, this.columnDataComputedLength_[column - 1] - 2, this.charset_[column - 1]);
        return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
    }

    private String getCHAR(int column) throws SqlException {
        if (this.ccsid_[column - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[column - 1], this.columnDataComputedLength_[column - 1]);
        }
        if (this.charset_[column - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String tempString = new String(this.dataBuffer_, this.columnDataPosition_[column - 1], this.columnDataComputedLength_[column - 1], this.charset_[column - 1]);
        return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
    }

    private Date getDATE(int column, Calendar cal) throws SqlException {
        return DateTime.dateBytesToDate(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private Time getTIME(int column, Calendar cal) throws SqlException {
        return DateTime.timeBytesToTime(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private final Timestamp getTIMESTAMP(int column, Calendar cal) throws SqlException {
        return DateTime.timestampBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1], this.agent_.connection_.serverSupportsTimestampNanoseconds());
    }

    private final Timestamp getTimestampFromDATE(int column, Calendar cal) throws SqlException {
        return DateTime.dateBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private final Timestamp getTimestampFromTIME(int column, Calendar cal) throws SqlException {
        return DateTime.timeBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private final Date getDateFromTIMESTAMP(int column, Calendar cal) throws SqlException {
        return DateTime.timestampBytesToDate(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private final Time getTimeFromTIMESTAMP(int column, Calendar cal) throws SqlException {
        return DateTime.timestampBytesToTime(this.dataBuffer_, this.columnDataPosition_[column - 1], cal, this.charset_[column - 1]);
    }

    private String getStringFromDATE(int column) throws SqlException {
        return this.getDATE(column, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIME(int column) throws SqlException {
        return this.getTIME(column, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIMESTAMP(int column) throws SqlException {
        return this.getTIMESTAMP(column, this.getRecyclableCalendar()).toString();
    }

    private byte[] get_CHAR_FOR_BIT_DATA(int column) throws SqlException {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1]);
        byte[] bytes = new byte[columnLength];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1], bytes, 0, columnLength);
        return bytes;
    }

    private byte[] get_VARCHAR_FOR_BIT_DATA(int column) throws SqlException {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, bytes, 0, bytes.length);
        return bytes;
    }

    private Object get_UDT(int column) throws SqlException {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[column - 1] + 2, bytes, 0, bytes.length);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XN020.S"), e, e.getMessage());
        }
    }

    private Calendar getRecyclableCalendar() {
        if (this.recyclableCalendar_ == null) {
            this.recyclableCalendar_ = new GregorianCalendar();
        }
        return this.recyclableCalendar_;
    }

    CallableLocatorProcedures getLocatorProcedures() {
        return this.agent_.connection_.locatorProcedureCall();
    }

    protected abstract int locator(int var1);

    public abstract ClientBlob getBlobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    public abstract ClientClob getClobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    final boolean getBoolean(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.get_BOOLEAN(column);
            }
            case 5: {
                return this.agent_.crossConverters_.getBooleanFromShort(this.get_SMALLINT(column));
            }
            case 4: {
                return this.agent_.crossConverters_.getBooleanFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getBooleanFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getBooleanFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.getLongFromDECIMAL(column, "boolean"));
            }
            case 1: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("boolean", column);
    }

    final byte getByte(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getByteFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.agent_.crossConverters_.getByteFromShort(this.get_SMALLINT(column));
            }
            case 4: {
                return this.agent_.crossConverters_.getByteFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getByteFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getByteFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getByteFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getByteFromLong(this.getLongFromDECIMAL(column, "byte"));
            }
            case 1: {
                return this.agent_.crossConverters_.getByteFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getByteFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("byte", column);
    }

    final short getShort(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getShortFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.agent_.crossConverters_.getShortFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return this.agent_.crossConverters_.getShortFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getShortFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getShortFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getShortFromLong(this.getLongFromDECIMAL(column, "short"));
            }
            case 1: {
                return this.agent_.crossConverters_.getShortFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getShortFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("short", column);
    }

    final int getInt(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getIntFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.agent_.crossConverters_.getIntFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return this.agent_.crossConverters_.getIntFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getIntFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getIntFromLong(this.getLongFromDECIMAL(column, "int"));
            }
            case 1: {
                return this.agent_.crossConverters_.getIntFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getIntFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("int", column);
    }

    final long getLong(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getLongFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 7: {
                return this.agent_.crossConverters_.getLongFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return this.agent_.crossConverters_.getLongFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.getLongFromDECIMAL(column, "long");
            }
            case 1: {
                return this.agent_.crossConverters_.getLongFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLongFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("long", column);
    }

    final float getFloat(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getFloatFromBoolean(this.get_BOOLEAN(column));
            }
            case 7: {
                return this.get_FLOAT(column);
            }
            case 8: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.getDoubleFromDECIMAL(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getFloatFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getFloatFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("float", column);
    }

    final double getDouble(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getDoubleFromBoolean(this.get_BOOLEAN(column));
            }
            case 7: {
                double d = this.get_FLOAT(column);
                return d;
            }
            case 8: {
                return this.get_DOUBLE(column);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(column);
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("double", column);
    }

    final BigDecimal getBigDecimal(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return BigDecimal.valueOf(this.getLong(column));
            }
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 7: {
                float f = this.get_FLOAT(column);
                return new BigDecimal(String.valueOf(f));
            }
            case 8: {
                return BigDecimal.valueOf(this.get_DOUBLE(column));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(column));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(column));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(column));
            }
            case 1: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getVARCHAR(column));
            }
        }
        throw this.coercionError("java.math.BigDecimal", column);
    }

    final Date getDate(int column, Calendar cal) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 91: {
                return this.getDATE(column, cal);
            }
            case 93: {
                return this.getDateFromTIMESTAMP(column, cal);
            }
            case 1: {
                return this.agent_.crossConverters_.getDateFromString(this.getCHAR(column), cal);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDateFromString(this.getVARCHAR(column), cal);
            }
        }
        throw this.coercionError("java.sql.Date", column);
    }

    final Time getTime(int column, Calendar cal) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 92: {
                return this.getTIME(column, cal);
            }
            case 93: {
                return this.getTimeFromTIMESTAMP(column, cal);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimeFromString(this.getCHAR(column), cal);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimeFromString(this.getVARCHAR(column), cal);
            }
        }
        throw this.coercionError("java.sql.Time", column);
    }

    final Timestamp getTimestamp(int column, Calendar cal) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 93: {
                return this.getTIMESTAMP(column, cal);
            }
            case 91: {
                return this.getTimestampFromDATE(column, cal);
            }
            case 92: {
                return this.getTimestampFromTIME(column, cal);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getCHAR(column), cal);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getVARCHAR(column), cal);
            }
        }
        throw this.coercionError("java.sql.Timestamp", column);
    }

    final String getString(int column) throws SqlException {
        try {
            switch (this.jdbcTypes_[column - 1]) {
                case 16: {
                    if (this.get_BOOLEAN(column)) {
                        return Boolean.TRUE.toString();
                    }
                    return Boolean.FALSE.toString();
                }
                case 1: {
                    return this.getCHAR(column);
                }
                case -1: 
                case 12: {
                    return this.getVARCHAR(column);
                }
                case 5: {
                    return String.valueOf(this.get_SMALLINT(column));
                }
                case 4: {
                    return String.valueOf(this.get_INTEGER(column));
                }
                case -5: {
                    return String.valueOf(this.get_BIGINT(column));
                }
                case 7: {
                    return String.valueOf(this.get_FLOAT(column));
                }
                case 8: {
                    return String.valueOf(this.get_DOUBLE(column));
                }
                case 3: {
                    return String.valueOf(this.get_DECIMAL(column));
                }
                case 91: {
                    return this.getStringFromDATE(column);
                }
                case 92: {
                    return this.getStringFromTIME(column);
                }
                case 93: {
                    return this.getStringFromTIMESTAMP(column);
                }
                case -2: {
                    String tempString = this.agent_.crossConverters_.getStringFromBytes(this.get_CHAR_FOR_BIT_DATA(column));
                    return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
                }
                case -4: 
                case -3: {
                    String tempString = this.agent_.crossConverters_.getStringFromBytes(this.get_VARCHAR_FOR_BIT_DATA(column));
                    return this.maxFieldSize_ == 0 ? tempString : tempString.substring(0, Math.min(this.maxFieldSize_, tempString.length()));
                }
                case 2000: {
                    Object obj = this.get_UDT(column);
                    if (obj == null) {
                        return null;
                    }
                    return obj.toString();
                }
                case 2004: {
                    ClientBlob b = this.getBlobColumn_(column, this.agent_, false);
                    String tempString = this.agent_.crossConverters_.getStringFromBytes(b.getBytes(1L, (int)b.length()));
                    return tempString;
                }
                case 2005: {
                    ClientClob c = this.getClobColumn_(column, this.agent_, false);
                    String tempString = c.getSubString(1L, (int)c.length());
                    return tempString;
                }
            }
            throw this.coercionError("String", column);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    final byte[] getBytes(int column) throws SqlException {
        try {
            switch (this.jdbcTypes_[column - 1]) {
                case -2: {
                    return this.get_CHAR_FOR_BIT_DATA(column);
                }
                case -4: 
                case -3: {
                    return this.get_VARCHAR_FOR_BIT_DATA(column);
                }
                case 2004: {
                    ClientBlob b = this.getBlobColumn_(column, this.agent_, false);
                    byte[] bytes = b.getBytes(1L, (int)b.length());
                    return bytes;
                }
            }
            throw this.coercionError("byte[]", column);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    final InputStream getBinaryStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                ClientBlob b = this.getBlobColumn_(column, this.agent_, false);
                if (b.isLocator()) {
                    BlobLocatorInputStream is = new BlobLocatorInputStream(this.agent_.connection_, b);
                    return new BufferedInputStream(is);
                }
                return b.getBinaryStreamX();
            }
        }
        throw this.coercionError("java.io.InputStream", column);
    }

    final InputStream getAsciiStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                ClientClob c = this.getClobColumn_(column, this.agent_, false);
                if (c.isLocator()) {
                    ClobLocatorInputStream is = new ClobLocatorInputStream(this.agent_.connection_, c);
                    return new BufferedInputStream(is);
                }
                return c.getAsciiStreamX();
            }
            case 1: {
                return new ByteArrayInputStream(this.getCHAR(column).getBytes(ISO_8859_1));
            }
            case -1: 
            case 12: {
                return new ByteArrayInputStream(this.getVARCHAR(column).getBytes(ISO_8859_1));
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                return this.getBinaryStream(column);
            }
        }
        throw this.coercionError("java.io.InputStream", column);
    }

    final Reader getCharacterStream(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                ClientClob c = this.getClobColumn_(column, this.agent_, false);
                if (c.isLocator()) {
                    ClobLocatorReader reader = new ClobLocatorReader(this.agent_.connection_, c);
                    return new BufferedReader(reader);
                }
                return c.getCharacterStreamX();
            }
            case 1: {
                return new StringReader(this.getCHAR(column));
            }
            case -1: 
            case 12: {
                return new StringReader(this.getVARCHAR(column));
            }
            case -2: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column)), UTF_16BE);
            }
            case -4: 
            case -3: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column)), UTF_16BE);
            }
            case 2004: {
                return new InputStreamReader(this.getBinaryStream(column), UTF_16BE);
            }
        }
        throw this.coercionError("java.io.Reader", column);
    }

    final Blob getBlob(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2004: {
                return this.getBlobColumn_(column, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Blob", column);
    }

    final Clob getClob(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                return this.getClobColumn_(column, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Clob", column);
    }

    final Array getArray(int column) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getArray(int)");
    }

    final Ref getRef(int column) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getRef(int)");
    }

    final Object getObject(int column) throws SqlException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.get_BOOLEAN(column);
            }
            case 5: {
                return (int)this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 7: {
                return Float.valueOf(this.get_FLOAT(column));
            }
            case 8: {
                return this.get_DOUBLE(column);
            }
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 91: {
                return this.getDATE(column, this.getRecyclableCalendar());
            }
            case 92: {
                return this.getTIME(column, this.getRecyclableCalendar());
            }
            case 93: {
                return this.getTIMESTAMP(column, this.getRecyclableCalendar());
            }
            case 1: {
                return this.getCHAR(column);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(column);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(column);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(column);
            }
            case 2000: {
                return this.get_UDT(column);
            }
            case 2004: {
                return this.getBlobColumn_(column, this.agent_, true);
            }
            case 2005: {
                return this.getClobColumn_(column, this.agent_, true);
            }
        }
        throw this.coercionError("Object", column);
    }

    public final void allocateCharBuffer() {
        int maxCharLength = 0;
        block3: for (int i = 0; i < this.columns_; ++i) {
            switch (this.jdbcTypes_[i]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i] <= maxCharLength) continue block3;
                    maxCharLength = this.fdocaLength_[i];
                }
            }
        }
        this.charBuffer_ = new char[maxCharLength];
    }

    private String getStringWithoutConvert(int position, int actualLength) {
        int end = position + actualLength;
        int charCount = 0;
        for (int start = position; start < end; start += 2) {
            this.charBuffer_[charCount++] = (char)((this.dataBuffer_[start] & 0xFF) << 8 | this.dataBuffer_[start + 1] & 0xFF);
        }
        return new String(this.charBuffer_, 0, charCount);
    }

    private ColumnTypeConversionException coercionError(String targetType, int sourceColumn) {
        return new ColumnTypeConversionException(this.agent_.logWriter_, targetType, ClientTypes.getTypeString(this.jdbcTypes_[sourceColumn - 1]));
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.dataBufferStream_ = null;
        this.columnDataPosition_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charset_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
    }

    private int getColumnPrecision(int column) {
        return this.fdocaLength_[column] >> 8 & 0xFF;
    }

    private int getColumnScale(int column) {
        return this.fdocaLength_[column] & 0xFF;
    }
}

