/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import java.util.Arrays;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCMethod;
import org.apache.derby.shared.common.sanity.SanityManager;

final class CodeChunk {
    private static final int CODE_OFFSET = 8;
    static final short[] LOAD_VARIABLE = new short[]{21, 21, 21, 22, 23, 24, 21, 25};
    static final short[] LOAD_VARIABLE_FAST = new short[]{26, 26, 26, 30, 34, 38, 26, 42};
    static final short[] STORE_VARIABLE = new short[]{54, 54, 54, 55, 56, 57, 54, 58};
    static final short[] STORE_VARIABLE_FAST = new short[]{59, 59, 59, 63, 67, 71, 59, 75};
    static final short[] ARRAY_ACCESS = new short[]{51, 53, 46, 47, 48, 49, 52, 50};
    static final short[] ARRAY_STORE = new short[]{84, 86, 79, 80, 81, 82, 85, 83};
    static final short[] RETURN_OPCODE = new short[]{172, 172, 172, 173, 174, 175, 172, 176};
    static final short[][][] CAST_CONVERSION_INFO = new short[][][]{new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{145, 0}, {147, 1}, {0, 2}, {133, 3}, {134, 4}, {135, 5}, {145, 6}, {-999, 7}}, new short[][]{{136, 2}, {136, 2}, {136, 2}, {0, 3}, {137, 4}, {138, 5}, {136, 2}, {-999, 7}}, new short[][]{{139, 2}, {139, 2}, {139, 2}, {140, 3}, {0, 4}, {141, 5}, {139, 2}, {-999, 7}}, new short[][]{{142, 2}, {142, 2}, {142, 2}, {143, 3}, {144, 4}, {0, 5}, {142, 2}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{-999, 0}, {-999, 1}, {-999, 2}, {-999, 3}, {-999, 4}, {-999, 5}, {-999, 6}, {0, 7}}};
    private static final byte[] push1_1i = new byte[]{1, 1};
    private static final byte[] push2_1i = new byte[]{2, 1};
    private static final byte[] NS = new byte[]{0, -1};
    private static final byte VARIABLE_STACK = -128;
    private static final byte[][] OPCODE_ACTION = new byte[][]{{0, 1}, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, {1, 2}, {1, 3}, {1, 2}, {1, 3}, {2, 3}, {1, 2}, {2, 2}, {1, 2}, {2, 2}, {1, 2}, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 2}, {-2, 2}, {-1, 2}, {-2, 2}, {-1, 2}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-1, 1}, {-2, 1}, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, {0, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {-1, 1}, NS, NS, NS, NS, NS, {-1, 1}, NS, {-1, 1}, NS, NS, NS, NS, push1_1i, {0, 1}, push1_1i, {-1, 1}, {-1, 1}, {0, 1}, {0, 1}, push2_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {0, 1}, {0, 1}, NS, {-1, 1}, {-1, 1}, {-3, 1}, {-3, 1}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, NS, NS, NS, NS, NS, NS, NS, NS, {0, 3}, NS, NS, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {0, 1}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 5}, NS, {1, 3}, {0, 2}, {0, 3}, {0, 1}, NS, {0, 3}, {0, 3}, NS, NS, NS, NS, {-1, 3}, {-1, 3}, {0, 5}, NS, NS};
    private final int pcDelta;
    final BCClass cb;
    private final ClassFormatOutput cout;

    private void limitHit(IOException ioe) {
        this.cb.addLimitExceeded(ioe.toString());
    }

    void addInstr(short opcode) {
        try {
            this.cout.putU1(opcode);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (OPCODE_ACTION[opcode][1] != 1) {
            SanityManager.THROWASSERT((String)("Opcode " + opcode + " incorrect entry in OPCODE_ACTION - writing 1 byte - set as " + OPCODE_ACTION[opcode][1]));
        }
    }

    void addInstrU2(short opcode, int operand) {
        try {
            this.cout.putU1(opcode);
            this.cout.putU2(operand);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (OPCODE_ACTION[opcode][1] != 3) {
            SanityManager.THROWASSERT((String)("Opcode " + opcode + " incorrect entry in OPCODE_ACTION - writing 3 bytes - set as " + OPCODE_ACTION[opcode][1]));
        }
    }

    void addInstrU4(short opcode, int operand) {
        try {
            this.cout.putU1(opcode);
            this.cout.putU4(operand);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (OPCODE_ACTION[opcode][1] != 5) {
            SanityManager.THROWASSERT((String)("Opcode " + opcode + " incorrect entry in OPCODE_ACTION - writing 5 bytes - set as " + OPCODE_ACTION[opcode][1]));
        }
    }

    void addInstrU1(short opcode, int operand) {
        try {
            this.cout.putU1(opcode);
            this.cout.putU1(operand);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (OPCODE_ACTION[opcode][1] != 2) {
            SanityManager.THROWASSERT((String)("Opcode " + opcode + " incorrect entry in OPCODE_ACTION - writing 2 bytes - set as " + OPCODE_ACTION[opcode][1]));
        }
    }

    void addInstrCPE(short opcode, int cpeNum) {
        if (cpeNum < 256) {
            this.addInstrU1(opcode, cpeNum);
        } else {
            this.addInstrU2((short)(opcode + 1), cpeNum);
        }
    }

    void addInstrWide(short opcode, int varNum) {
        if (varNum < 256) {
            this.addInstrU1(opcode, varNum);
        } else {
            this.addInstr((short)196);
            this.addInstrU2(opcode, varNum);
        }
    }

    void addInstrU2U1U1(short opcode, int operand1, short operand2, short operand3) {
        try {
            this.cout.putU1(opcode);
            this.cout.putU2(operand1);
            this.cout.putU1(operand2);
            this.cout.putU1(operand3);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (OPCODE_ACTION[opcode][1] != 5) {
            SanityManager.THROWASSERT((String)("Opcode " + opcode + " incorrect entry in OPCODE_ACTION - writing 5 bytes - set as " + OPCODE_ACTION[opcode][1]));
        }
    }

    int getPC() {
        return this.cout.size() + this.pcDelta;
    }

    private static int instructionLength(short opcode) {
        byte instructionLength = OPCODE_ACTION[opcode][1];
        if (instructionLength < 0) {
            SanityManager.THROWASSERT((String)("Opcode without instruction length " + opcode));
        }
        return instructionLength;
    }

    CodeChunk(BCClass cb) {
        this.cb = cb;
        this.cout = new ClassFormatOutput();
        try {
            this.cout.putU2(0);
            this.cout.putU2(0);
            this.cout.putU4(0);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        this.pcDelta = -8;
    }

    private CodeChunk(CodeChunk main, int pc, int byteCount) {
        this.cb = main.cb;
        ArrayOutputStream aos = new ArrayOutputStream(main.cout.getData());
        try {
            aos.setPosition(8 + pc);
            aos.setLimit(byteCount);
        }
        catch (IOException e) {
            this.limitHit(e);
        }
        this.cout = new ClassFormatOutput(aos);
        this.pcDelta = pc;
    }

    private void fixLengths(BCMethod mb, int maxStack, int maxLocals, int codeLength) {
        byte[] codeBytes = this.cout.getData();
        if (mb != null && maxStack > 65535) {
            this.cb.addLimitExceeded(mb, "max_stack", 65535, maxStack);
        }
        codeBytes[0] = (byte)(maxStack >> 8);
        codeBytes[1] = (byte)maxStack;
        if (mb != null && maxLocals > 65535) {
            this.cb.addLimitExceeded(mb, "max_locals", 65535, maxLocals);
        }
        codeBytes[2] = (byte)(maxLocals >> 8);
        codeBytes[3] = (byte)maxLocals;
        if (mb != null && codeLength > 65535) {
            this.cb.addLimitExceeded(mb, "code_length", 65535, codeLength);
        }
        codeBytes[4] = (byte)(codeLength >> 24);
        codeBytes[5] = (byte)(codeLength >> 16);
        codeBytes[6] = (byte)(codeLength >> 8);
        codeBytes[7] = (byte)codeLength;
    }

    void complete(BCMethod mb, ClassHolder ch, ClassMember method, int maxStack, int maxLocals) {
        int walkedMaxStack;
        int codeLength = this.getPC();
        ClassFormatOutput out = this.cout;
        try {
            out.putU2(0);
            if (SanityManager.DEBUG_ON((String)"ClassLineNumbers")) {
                out.putU2(1);
                int cpiUTF = ch.addUtf8("LineNumberTable");
                out.putU2(cpiUTF);
                out.putU4(codeLength * 4 + 2);
                out.putU2(codeLength);
                for (int i = 0; i < codeLength; ++i) {
                    out.putU2(i);
                    out.putU2(i);
                }
            } else {
                out.putU2(0);
            }
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        this.fixLengths(mb, maxStack, maxLocals, codeLength);
        method.addAttribute("Code", out);
        if (codeLength <= 65535 && mb != null && mb.cb.limitMsg == null && (walkedMaxStack = this.findMaxStack(ch, 0, codeLength)) != maxStack) {
            SanityManager.THROWASSERT((String)("MAX STACK MISMATCH!! " + maxStack + " <> " + walkedMaxStack));
        }
    }

    short getOpcode(int pc) {
        return (short)(this.cout.getData()[8 + pc] & 0xFF);
    }

    private int getU2(int pc) {
        byte[] codeBytes = this.cout.getData();
        int u2p = 8 + pc + 1;
        return (codeBytes[u2p] & 0xFF) << 8 | codeBytes[u2p + 1] & 0xFF;
    }

    private int getU4(int pc) {
        byte[] codeBytes = this.cout.getData();
        int u4p = 8 + pc + 1;
        return (codeBytes[u4p] & 0xFF) << 24 | (codeBytes[u4p + 1] & 0xFF) << 16 | (codeBytes[u4p + 2] & 0xFF) << 8 | codeBytes[u4p + 3] & 0xFF;
    }

    CodeChunk insertCodeSpace(int pc, int additionalBytes) {
        short existingOpcode = this.getOpcode(pc);
        int lengthOfExistingInstruction = CodeChunk.instructionLength(existingOpcode);
        if (additionalBytes > 0) {
            int sizeToMove = this.getPC() - pc - lengthOfExistingInstruction;
            for (int i = 0; i < additionalBytes; ++i) {
                this.addInstr((short)0);
            }
            byte[] codeBytes = this.cout.getData();
            int byteOffset = 8 + pc + lengthOfExistingInstruction;
            System.arraycopy(codeBytes, byteOffset, codeBytes, byteOffset + additionalBytes, sizeToMove);
            Arrays.fill(codeBytes, byteOffset, byteOffset + additionalBytes, (byte)0);
        }
        return new CodeChunk(this, pc, additionalBytes += lengthOfExistingInstruction);
    }

    private int findMaxStack(ClassHolder ch, int pc, int codeLength) {
        int endPc = pc + codeLength;
        int stack = 0;
        int maxStack = 0;
        while (pc < endPc) {
            int[] cond_pcs;
            short opcode = this.getOpcode(pc);
            int stackDelta = this.stackWordDelta(ch, pc, opcode);
            if ((stack += stackDelta) > maxStack) {
                maxStack = stack;
            }
            if ((cond_pcs = this.findConditionalPCs(pc, opcode)) != null && cond_pcs[3] != -1) {
                int blockMaxStack = this.findMaxStack(ch, cond_pcs[1], cond_pcs[2]);
                if (stack + blockMaxStack > maxStack) {
                    maxStack = stack + blockMaxStack;
                }
                pc = cond_pcs[3];
                continue;
            }
            pc += CodeChunk.instructionLength(opcode);
        }
        return maxStack;
    }

    private int stackWordDelta(ClassHolder ch, int pc, short opcode) {
        CodeChunk.instructionLength(opcode);
        int stackDelta = OPCODE_ACTION[opcode][0];
        if (stackDelta == -128) {
            stackDelta = this.getVariableStackDelta(ch, pc, opcode);
        }
        return stackDelta;
    }

    private String getTypeDescriptor(ClassHolder ch, int pc) {
        int cpi = this.getU2(pc);
        CONSTANT_Index_info cii = (CONSTANT_Index_info)ch.getEntry(cpi);
        int nameAndType = cii.getI2();
        cii = (CONSTANT_Index_info)ch.getEntry(nameAndType);
        int descriptor = cii.getI2();
        CONSTANT_Utf8_info type = (CONSTANT_Utf8_info)ch.getEntry(descriptor);
        String vmDescriptor = type.toString();
        return vmDescriptor;
    }

    private static int getDescriptorWordCount(String vmDescriptor) {
        int width;
        if ("D".equals(vmDescriptor)) {
            width = 2;
        } else if ("J".equals(vmDescriptor)) {
            width = 2;
        } else if (vmDescriptor.charAt(0) == '(') {
            switch (vmDescriptor.charAt(vmDescriptor.length() - 1)) {
                case 'D': 
                case 'J': {
                    width = 2;
                    break;
                }
                case 'V': {
                    width = 0;
                    break;
                }
                default: {
                    width = 1;
                    break;
                }
            }
        } else {
            width = 1;
        }
        return width;
    }

    private int getVariableStackDelta(ClassHolder ch, int pc, int opcode) {
        String vmDescriptor = this.getTypeDescriptor(ch, pc);
        int width = CodeChunk.getDescriptorWordCount(vmDescriptor);
        int stackDelta = 0;
        switch (opcode) {
            case 178: {
                stackDelta = width;
                break;
            }
            case 180: {
                stackDelta = width - 1;
                break;
            }
            case 179: {
                stackDelta = -width;
                break;
            }
            case 181: {
                stackDelta = -width - 1;
                break;
            }
            case 182: 
            case 183: {
                stackDelta = -1;
            }
            case 184: {
                stackDelta += width - CodeChunk.parameterWordCount(vmDescriptor);
                break;
            }
            case 185: {
                stackDelta = width - this.getOpcode(pc + 3);
                break;
            }
            default: {
                System.out.println("WHO IS THIS ");
            }
        }
        return stackDelta;
    }

    private static int parameterWordCount(String methodDescriptor) {
        int wordCount = 0;
        int i = 1;
        while (true) {
            switch (methodDescriptor.charAt(i)) {
                case ')': {
                    return wordCount;
                }
                case 'D': 
                case 'J': {
                    wordCount += 2;
                    break;
                }
                case '[': {
                    while (methodDescriptor.charAt(++i) == '[') {
                    }
                    if (methodDescriptor.charAt(i) != 'L') {
                        ++wordCount;
                        break;
                    }
                }
                case 'L': {
                    while (methodDescriptor.charAt(++i) != ';') {
                    }
                    ++wordCount;
                    break;
                }
                default: {
                    ++wordCount;
                }
            }
            ++i;
        }
    }

    private int[] findConditionalPCs(int pc, short opcode) {
        int else_len;
        int then_len;
        int else_pc;
        int then_pc;
        switch (opcode) {
            default: {
                return null;
            }
            case 153: 
            case 154: 
            case 198: 
            case 199: 
        }
        int if_off = this.getU2(pc);
        if (if_off == 8 && this.getOpcode(pc + 3) == 200) {
            then_pc = pc + 3 + 5;
            else_pc = pc + 3 + this.getU4(pc + 3);
        } else {
            then_pc = pc + 3;
            else_pc = pc + if_off;
        }
        int end_pc = -1;
        int tpc = then_pc;
        while (tpc < else_pc) {
            short opc = this.getOpcode(tpc);
            int[] innerCond = this.findConditionalPCs(tpc, opc);
            if (innerCond != null) {
                tpc = innerCond[5];
                continue;
            }
            if (opc == 167) {
                if (tpc != else_pc - 3) continue;
                end_pc = tpc + this.getU2(tpc);
                break;
            }
            if (opc == 200) {
                if (tpc != else_pc - 5) continue;
                end_pc = tpc + this.getU4(tpc);
                break;
            }
            tpc += CodeChunk.instructionLength(opc);
        }
        if (end_pc == -1) {
            end_pc = else_pc;
            else_pc = -1;
            then_len = end_pc - then_pc;
            else_len = -1;
        } else {
            then_len = else_pc - then_pc;
            else_len = end_pc - else_pc;
        }
        int[] ret = new int[]{pc, then_pc, then_len, else_pc, else_len, end_pc};
        return ret;
    }

    final int splitZeroStack(BCMethod mb, ClassHolder ch, int split_pc, int optimalMinLength) {
        int splitMinLength = CodeChunk.splitMinLength(mb);
        int stack = 0;
        int possibleSplitLength = -1;
        int outerConditionalEnd_pc = -1;
        int end_pc = this.getPC();
        int pc = split_pc;
        while (pc < end_pc) {
            short opcode = this.getOpcode(pc);
            int stackDelta = this.stackWordDelta(ch, pc, opcode);
            stack += stackDelta;
            int[] cond_pcs = this.findConditionalPCs(pc, opcode);
            if (cond_pcs != null) {
                if (cond_pcs[3] != -1) {
                    pc = cond_pcs[3];
                    continue;
                }
                if (outerConditionalEnd_pc != -1 && cond_pcs[5] >= outerConditionalEnd_pc) {
                    SanityManager.THROWASSERT((String)"NESTED CONDITIONALS!");
                }
                if (outerConditionalEnd_pc == -1) {
                    outerConditionalEnd_pc = cond_pcs[5];
                }
            }
            pc += CodeChunk.instructionLength(opcode);
            if (outerConditionalEnd_pc != -1) {
                if (pc <= outerConditionalEnd_pc) continue;
                outerConditionalEnd_pc = -1;
                continue;
            }
            if (stack != 0) continue;
            int splitLength = pc - split_pc;
            if (splitLength < optimalMinLength) {
                possibleSplitLength = splitLength;
                continue;
            }
            if (splitLength > 65534) {
                splitLength = -1;
            } else if (CodeChunk.isReturn(opcode)) {
                splitLength = -1;
            }
            if (splitLength == -1) {
                if (possibleSplitLength == -1) {
                    return -1;
                }
                if (possibleSplitLength <= splitMinLength) {
                    return -1;
                }
                splitLength = possibleSplitLength;
            }
            BCMethod subMethod = this.startSubMethod(mb, "void", split_pc, splitLength);
            return this.splitCodeIntoSubMethod(mb, ch, subMethod, split_pc, splitLength);
        }
        return -1;
    }

    private BCMethod startSubMethod(BCMethod mb, String returnType, int split_pc, int blockLength) {
        boolean needParameters = this.usesParameters(mb, split_pc, blockLength);
        return mb.getNewSubMethod(returnType, needParameters);
    }

    private boolean usesParameters(BCMethod mb, int pc, int codeLength) {
        if (mb.parameters == null) {
            return false;
        }
        boolean isStatic = (mb.myEntry.getModifier() & 8) != 0;
        int endPc = pc + codeLength;
        while (pc < endPc) {
            short opcode = this.getOpcode(pc);
            switch (opcode) {
                case 26: 
                case 30: 
                case 34: 
                case 38: {
                    return true;
                }
                case 42: {
                    if (!isStatic) break;
                    return true;
                }
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: {
                    return true;
                }
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    return true;
                }
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    return true;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return true;
                }
            }
            pc += CodeChunk.instructionLength(opcode);
        }
        return false;
    }

    private int splitCodeIntoSubMethod(BCMethod mb, ClassHolder ch, BCMethod subMethod, int split_pc, int splitLength) {
        CodeChunk subChunk = subMethod.myCode;
        byte[] codeBytes = this.cout.getData();
        try {
            subChunk.cout.write(codeBytes, 8 + split_pc, splitLength);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (subMethod.myReturnType.equals("void")) {
            subChunk.addInstr((short)177);
        } else {
            subChunk.addInstr((short)176);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        subMethod.maxStack = subChunk.findMaxStack(ch, 0, subChunk.getPC());
        subMethod.complete();
        return this.removePushedCode(mb, ch, subMethod, split_pc, splitLength);
    }

    private int removePushedCode(BCMethod mb, ClassHolder ch, BCMethod subMethod, int split_pc, int splitLength) {
        CodeChunk replaceChunk;
        int codeLength = this.getPC();
        mb.myCode = replaceChunk = new CodeChunk(mb.cb);
        mb.maxStack = 0;
        byte[] codeBytes = this.cout.getData();
        if (split_pc != 0) {
            try {
                replaceChunk.cout.write(codeBytes, 8, split_pc);
            }
            catch (IOException ioe) {
                this.limitHit(ioe);
            }
        }
        mb.callSubMethod(subMethod);
        int postSplit_pc = replaceChunk.getPC();
        int remainingCodePC = split_pc + splitLength;
        int remainingCodeLength = codeLength - splitLength - split_pc;
        try {
            replaceChunk.cout.write(codeBytes, 8 + remainingCodePC, remainingCodeLength);
        }
        catch (IOException ioe) {
            this.limitHit(ioe);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        mb.maxStack = replaceChunk.findMaxStack(ch, 0, replaceChunk.getPC());
        return postSplit_pc;
    }

    final int splitExpressionOut(BCMethod mb, ClassHolder ch, int optimalMinLength, int maxStack) {
        int bestSplitPC = -1;
        int bestSplitBlockLength = -1;
        String bestSplitRT = null;
        int splitMinLength = CodeChunk.splitMinLength(mb);
        int[] earliestIndepPC = new int[maxStack + 1];
        int stack = 0;
        int outerConditionalEnd_pc = -1;
        int end_pc = this.getPC();
        int pc = 0;
        block10: while (pc < end_pc) {
            int me;
            int blockLength;
            int selfContainedBlockStart;
            int width;
            String vmDescriptor;
            short opcode = this.getOpcode(pc);
            int stackDelta = this.stackWordDelta(ch, pc, opcode);
            stack += stackDelta;
            int[] cond_pcs = this.findConditionalPCs(pc, opcode);
            if (cond_pcs != null) {
                return -1;
            }
            pc += CodeChunk.instructionLength(opcode);
            if (outerConditionalEnd_pc != -1) {
                if (pc <= outerConditionalEnd_pc) continue;
                outerConditionalEnd_pc = -1;
                continue;
            }
            int opcode_pc = pc - CodeChunk.instructionLength(opcode);
            switch (opcode) {
                default: {
                    Arrays.fill(earliestIndepPC, 0, stack + 1, -1);
                    continue block10;
                }
                case 0: 
                case 119: 
                case 139: 
                case 143: 
                case 190: 
                case 192: {
                    continue block10;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 23: 
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    earliestIndepPC[stack] = opcode_pc;
                    continue block10;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    earliestIndepPC[stack - 1] = earliestIndepPC[stack] = opcode_pc;
                    continue block10;
                }
                case 87: 
                case 88: {
                    continue block10;
                }
                case 95: {
                    earliestIndepPC[stack] = earliestIndepPC[stack - 1];
                    continue block10;
                }
                case 133: {
                    earliestIndepPC[stack] = earliestIndepPC[stack - 1];
                    continue block10;
                }
                case 180: {
                    vmDescriptor = this.getTypeDescriptor(ch, opcode_pc);
                    width = CodeChunk.getDescriptorWordCount(vmDescriptor);
                    if (width != 2) continue block10;
                    earliestIndepPC[stack] = earliestIndepPC[stack - 1];
                    continue block10;
                }
                case 182: 
                case 185: 
            }
            vmDescriptor = this.getTypeDescriptor(ch, opcode_pc);
            width = CodeChunk.getDescriptorWordCount(vmDescriptor);
            if (width == 0) {
                selfContainedBlockStart = -1;
            } else if (width == 1) {
                selfContainedBlockStart = earliestIndepPC[stack];
            } else {
                selfContainedBlockStart = -1;
                earliestIndepPC[stack] = earliestIndepPC[stack - 1];
            }
            if (selfContainedBlockStart == -1 || (blockLength = pc - selfContainedBlockStart) <= splitMinLength || blockLength > 65534 || vmDescriptor.charAt((me = vmDescriptor.lastIndexOf(41)) + 1) != 'L') continue;
            String rt = vmDescriptor.substring(me + 2, vmDescriptor.length() - 1);
            rt = rt.replace('/', '.');
            if (blockLength >= optimalMinLength) {
                BCMethod subMethod = this.startSubMethod(mb, rt, selfContainedBlockStart, blockLength);
                return this.splitCodeIntoSubMethod(mb, ch, subMethod, selfContainedBlockStart, blockLength);
            }
            if (blockLength <= bestSplitBlockLength) continue;
            bestSplitPC = selfContainedBlockStart;
            bestSplitBlockLength = blockLength;
            bestSplitRT = rt;
        }
        if (bestSplitBlockLength != -1) {
            BCMethod subMethod = this.startSubMethod(mb, bestSplitRT, bestSplitPC, bestSplitBlockLength);
            return this.splitCodeIntoSubMethod(mb, ch, subMethod, bestSplitPC, bestSplitBlockLength);
        }
        return -1;
    }

    private static boolean isReturn(short opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    private static int splitMinLength(BCMethod mb) {
        int min = 4;
        if (mb.parameters != null) {
            int paramCount = mb.parameters.length;
            min += paramCount;
            if (paramCount > 3) {
                min += paramCount - 3;
            }
        }
        return min;
    }
}

