/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ReplaceWindowFuncCallsWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class WindowResultSetNode
extends SingleChildResultSetNode {
    FromTable parent;
    List<WindowFunctionNode> windowFuncCalls;
    WindowDefinitionNode wdn;

    WindowResultSetNode(ResultSetNode bottomPR, WindowDefinitionNode windowDef, List<WindowFunctionNode> windowFuncCalls, int nestingLevel, ContextManager cm) throws StandardException {
        super(bottomPR, null, cm);
        this.wdn = windowDef;
        this.windowFuncCalls = windowFuncCalls;
        this.setLevel(nestingLevel);
        this.parent = this;
        ResultColumnList newBottomRCL = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(newBottomRCL);
        this.addNewPRNode();
        this.addNewColumns();
    }

    private void addNewPRNode() throws StandardException {
        ResultColumnList rclNew = new ResultColumnList(this.getContextManager());
        for (ResultColumn rc : this.getResultColumns()) {
            if (rc.isGenerated()) continue;
            rclNew.addElement(rc);
        }
        rclNew.copyOrderBySelect(this.getResultColumns());
        this.parent = new ProjectRestrictNode(this, rclNew, null, null, null, null, null, this.getContextManager());
        this.childResult.setResultColumns(new ResultColumnList(this.getContextManager()));
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
        CollectNodesVisitor<ColumnReference> getCRVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.parent.getResultColumns().accept(getCRVisitor);
        ArrayList<ValueNode> uniqueCols = new ArrayList<ValueNode>();
        for (ColumnReference cr : getCRVisitor.getList()) {
            if (this.colRefAlreadySeen(uniqueCols, cr)) continue;
            uniqueCols.add(cr);
        }
        CollectNodesVisitor<VirtualColumnNode> getVCVisitor = new CollectNodesVisitor<VirtualColumnNode>(VirtualColumnNode.class);
        this.parent.getResultColumns().accept(getVCVisitor);
        uniqueCols.addAll(getVCVisitor.getList());
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList windowingRCL = this.getResultColumns();
        for (ValueNode crOrVcn : uniqueCols) {
            ResultColumn newRC = new ResultColumn("##UnWindowingColumn", crOrVcn, this.getContextManager());
            bottomRCL.addElement(newRC);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            newRC.setVirtualColumnId(bottomRCL.size());
            ResultColumn wRC = new ResultColumn("##UnWindowingColumn", crOrVcn, this.getContextManager());
            windowingRCL.addElement(wRC);
            wRC.markGenerated();
            wRC.bindResultColumnToExpression();
            wRC.setVirtualColumnId(windowingRCL.size());
            VirtualColumnNode vc = new VirtualColumnNode(this, wRC, windowingRCL.size(), this.getContextManager());
            SubstituteExpressionVisitor seVis = new SubstituteExpressionVisitor(crOrVcn, vc, null);
            this.parent.getResultColumns().accept(seVis);
        }
    }

    private boolean colRefAlreadySeen(List<ValueNode> uniqueColRefs, ColumnReference cand) throws StandardException {
        for (ValueNode uniqueColRef : uniqueColRefs) {
            ColumnReference cr = (ColumnReference)uniqueColRef;
            if (!cr.isEquivalent(cand)) continue;
            return true;
        }
        return false;
    }

    private void addNewColumns() throws StandardException {
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList windowingRCL = this.getResultColumns();
        ReplaceWindowFuncCallsWithCRVisitor replaceCallsVisitor = new ReplaceWindowFuncCallsWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceCallsVisitor);
        for (WindowFunctionNode winFunc : this.windowFuncCalls) {
            SanityManager.ASSERT((!(winFunc.getWindow() instanceof WindowReferenceNode) ? 1 : 0) != 0, (String)("unresolved window-reference: " + winFunc.getWindow().getName()));
            WindowDefinitionNode funcWindow = (WindowDefinitionNode)winFunc.getWindow();
            if (funcWindow != this.wdn) continue;
            ResultColumn newRC = new ResultColumn("##winFuncResult", winFunc.getNewNullResultExpression(), this.getContextManager());
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            ColumnReference newColumnRef = new ColumnReference(newRC.getName(), null, this.getContextManager());
            newColumnRef.setSource(newRC);
            newColumnRef.setNestingLevel(this.getLevel());
            newColumnRef.setSourceLevel(this.getLevel());
            newColumnRef.markGeneratedToReplaceWindowFunctionCall();
            ResultColumn tmpRC = new ResultColumn(newRC.getColumnName(), (ValueNode)newColumnRef, this.getContextManager());
            tmpRC.markGenerated();
            tmpRC.bindResultColumnToExpression();
            windowingRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(windowingRCL.size());
            newColumnRef = winFunc.getGeneratedRef();
            if (newColumnRef == null) continue;
            newColumnRef.setSource(tmpRC);
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        acb.pushGetResultSetFactoryExpression(mb);
        int rclSize = this.getResultColumns().size();
        FormatableBitSet referencedCols = new FormatableBitSet(rclSize);
        for (int index = rclSize - 1; index >= 0; --index) {
            ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(index);
            ValueNode expr = rc.getExpression();
            if (rc.isGenerated() && expr instanceof ColumnReference && ((ColumnReference)expr).getGeneratedToReplaceWindowFunctionCall()) continue;
            referencedCols.set(index);
        }
        int erdNumber = acb.addItem(referencedCols);
        acb.pushThisAsActivation(mb);
        this.childResult.generate(acb, mb);
        mb.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate()));
        mb.push(this.getResultSetNumber());
        mb.push(erdNumber);
        mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getWindowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 8);
    }

    final FromTable getParent() {
        return this.parent;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "wdn: ");
        this.wdn.treePrint(depth + 1);
    }
}

