<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category  Zend
 * @package   Zend_Measure
 * @copyright  Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd     New BSD License
 * @version   $Id$
 */

/**
 * Implement needed classes
 */
require_once 'Zend/Measure/Abstract.php';
require_once 'Zend/Locale.php';

/**
 * Class for handling length conversions
 *
 * @category   Zend
 * @package    Zend_Measure
 * @subpackage Zend_Measure_Length
 * @copyright  Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Zend_Measure_Length extends Zend_Measure_Abstract
{
    public const STANDARD = 'METER';

    public const AGATE                 = 'AGATE';
    public const ALEN_DANISH           = 'ALEN_DANISH';
    public const ALEN                  = 'ALEN';
    public const ALEN_SWEDISH          = 'ALEN_SWEDISH';
    public const ANGSTROM              = 'ANGSTROM';
    public const ARMS                  = 'ARMS';
    public const ARPENT_CANADIAN       = 'ARPENT_CANADIAN';
    public const ARPENT                = 'ARPENT';
    public const ARSHEEN               = 'ARSHEEN';
    public const ARSHIN                = 'ARSHIN';
    public const ARSHIN_IRAQ           = 'ARSHIN_IRAQ';
    public const ASTRONOMICAL_UNIT     = 'ASTRONOMICAL_UNIT';
    public const ATTOMETER             = 'ATTOMETER';
    public const BAMBOO                = 'BAMBOO';
    public const BARLEYCORN            = 'BARLEYCORN';
    public const BEE_SPACE             = 'BEE_SPACE';
    public const BICRON                = 'BICRON';
    public const BLOCK_US_EAST         = 'BLOCK_US_EAST';
    public const BLOCK_US_WEST         = 'BLOCK_US_WEST';
    public const BLOCK_US_SOUTH        = 'BLOCK_US_SOUTH';
    public const BOHR                  = 'BOHR';
    public const BRACCIO               = 'BRACCIO';
    public const BRAZA_ARGENTINA       = 'BRAZA_ARGENTINA';
    public const BRAZA                 = 'BRAZA';
    public const BRAZA_US              = 'BRAZA_US';
    public const BUTTON                = 'BUTTON';
    public const CABLE_US              = 'CABLE_US';
    public const CABLE_UK              = 'CABLE_UK';
    public const CALIBER               = 'CALIBER';
    public const CANA                  = 'CANA';
    public const CAPE_FOOT             = 'CAPE_FOOT';
    public const CAPE_INCH             = 'CAPE_INCH';
    public const CAPE_ROOD             = 'CAPE_ROOD';
    public const CENTIMETER            = 'CENTIMETER';
    public const CHAIN                 = 'CHAIN';
    public const CHAIN_ENGINEER        = 'CHAIN_ENGINEER';
    public const CHIH                  = 'CHIH';
    public const CHINESE_FOOT          = 'CHINESE_FOOT';
    public const CHINESE_INCH          = 'CHINESE_INCH';
    public const CHINESE_MILE          = 'CHINESE_MILE';
    public const CHINESE_YARD          = 'CHINESE_YARD';
    public const CITY_BLOCK_US_EAST    = 'CITY_BLOCK_US_EAST';
    public const CITY_BLOCK_US_WEST    = 'CITY_BLOCK_US_WEST';
    public const CITY_BLOCK_US_SOUTH   = 'CITY_BLOCK_US_SOUTH';
    public const CLICK                 = 'CLICK';
    public const CUADRA                = 'CUADRA';
    public const CUADRA_ARGENTINA      = 'CUADRA_ARGENTINA';
    public const CUBIT_EGYPT           = 'Length:CUBIT_EGYPT';
    public const CUBIT_ROYAL           = 'CUBIT_ROYAL';
    public const CUBIT_UK              = 'CUBIT_UK';
    public const CUBIT                 = 'CUBIT';
    public const CUERDA                = 'CUERDA';
    public const DECIMETER             = 'DECIMETER';
    public const DEKAMETER             = 'DEKAMETER';
    public const DIDOT_POINT           = 'DIDOT_POINT';
    public const DIGIT                 = 'DIGIT';
    public const DIRAA                 = 'DIRAA';
    public const DONG                  = 'DONG';
    public const DOUZIEME_WATCH        = 'DOUZIEME_WATCH';
    public const DOUZIEME              = 'DOUZIEME';
    public const DRA_IRAQ              = 'DRA_IRAQ';
    public const DRA                   = 'DRA';
    public const EL                    = 'EL';
    public const ELL                   = 'ELL';
    public const ELL_SCOTTISH          = 'ELL_SCOTTISH';
    public const ELLE                  = 'ELLE';
    public const ELLE_VIENNA           = 'ELLE_VIENNA';
    public const EM                    = 'EM';
    public const ESTADIO_PORTUGAL      = 'ESTADIO_PORTUGAL';
    public const ESTADIO               = 'ESTADIO';
    public const EXAMETER              = 'EXAMETER';
    public const FADEN_AUSTRIA         = 'FADEN_AUSTRIA';
    public const FADEN                 = 'FADEN';
    public const FALL                  = 'FALL';
    public const FALL_SCOTTISH         = 'FALL_SCOTTISH';
    public const FATHOM                = 'FATHOM';
    public const FATHOM_ANCIENT        = 'FATHOM_ANCIENT';
    public const FAUST                 = 'FAUST';
    public const FEET_OLD_CANADIAN     = 'FEET_OLD_CANADIAN';
    public const FEET_EGYPT            = 'FEET_EGYPT';
    public const FEET_FRANCE           = 'FEET_FRANCE';
    public const FEET                  = 'FEET';
    public const FEET_IRAQ             = 'FEET_IRAQ';
    public const FEET_NETHERLAND       = 'FEET_NETHERLAND';
    public const FEET_ITALIC           = 'FEET_ITALIC';
    public const FEET_SURVEY           = 'FEET_SURVEY';
    public const FEMTOMETER            = 'FEMTOMETER';
    public const FERMI                 = 'FERMI';
    public const FINGER                = 'FINGER';
    public const FINGERBREADTH         = 'FINGERBREADTH';
    public const FIST                  = 'FIST';
    public const FOD                   = 'FOD';
    public const FOOT_EGYPT            = 'FOOT_EGYPT';
    public const FOOT_FRANCE           = 'FOOT_FRANCE';
    public const FOOT                  = 'FOOT';
    public const FOOT_IRAQ             = 'FOOT_IRAQ';
    public const FOOT_NETHERLAND       = 'FOOT_NETHERLAND';
    public const FOOT_ITALIC           = 'FOOT_ITALIC';
    public const FOOT_SURVEY           = 'FOOT_SURVEY';
    public const FOOTBALL_FIELD_CANADA = 'FOOTBALL_FIELD_CANADA';
    public const FOOTBALL_FIELD_US     = 'FOOTBALL_FIELD_US';
    public const FOOTBALL_FIELD        = 'FOOTBALL_FIELD';
    public const FURLONG               = 'FURLONG';
    public const FURLONG_SURVEY        = 'FURLONG_SURVEY';
    public const FUSS                  = 'FUSS';
    public const GIGAMETER             = 'GIGAMETER';
    public const GIGAPARSEC            = 'GIGAPARSEC';
    public const GNATS_EYE             = 'GNATS_EYE';
    public const GOAD                  = 'GOAD';
    public const GRY                   = 'GRY';
    public const HAIRS_BREADTH         = 'HAIRS_BREADTH';
    public const HAND                  = 'HAND';
    public const HANDBREADTH           = 'HANDBREADTH';
    public const HAT                   = 'HAT';
    public const HECTOMETER            = 'HECTOMETER';
    public const HEER                  = 'HEER';
    public const HIRO                  = 'HIRO';
    public const HUBBLE                = 'HUBBLE';
    public const HVAT                  = 'HVAT';
    public const INCH                  = 'INCH';
    public const IRON                  = 'IRON';
    public const KEN                   = 'KEN';
    public const KERAT                 = 'KERAT';
    public const KILOFOOT              = 'KILOFOOT';
    public const KILOMETER             = 'KILOMETER';
    public const KILOPARSEC            = 'KILOPARSEC';
    public const KILOYARD              = 'KILOYARD';
    public const KIND                  = 'KIND';
    public const KLAFTER               = 'KLAFTER';
    public const KLAFTER_SWISS         = 'KLAFTER_SWISS';
    public const KLICK                 = 'KLICK';
    public const KYU                   = 'KYU';
    public const LAP_ANCIENT           = 'LAP_ANCIENT';
    public const LAP                   = 'LAP';
    public const LAP_POOL              = 'LAP_POOL';
    public const LEAGUE_ANCIENT        = 'LEAGUE_ANCIENT';
    public const LEAGUE_NAUTIC         = 'LEAGUE_NAUTIC';
    public const LEAGUE_UK_NAUTIC      = 'LEAGUE_UK_NAUTIC';
    public const LEAGUE                = 'LEAGUE';
    public const LEAGUE_US             = 'LEAGUE_US';
    public const LEAP                  = 'LEAP';
    public const LEGOA                 = 'LEGOA';
    public const LEGUA                 = 'LEGUA';
    public const LEGUA_US              = 'LEGUA_US';
    public const LEGUA_SPAIN_OLD       = 'LEGUA_SPAIN_OLD';
    public const LEGUA_SPAIN           = 'LEGUA_SPAIN';
    public const LI_ANCIENT            = 'LI_ANCIENT';
    public const LI_IMPERIAL           = 'LI_IMPERIAL';
    public const LI                    = 'LI';
    public const LIEUE                 = 'LIEUE';
    public const LIEUE_METRIC          = 'LIEUE_METRIC';
    public const LIEUE_NAUTIC          = 'LIEUE_NAUTIC';
    public const LIGHT_SECOND          = 'LIGHT_SECOND';
    public const LIGHT_MINUTE          = 'LIGHT_MINUTE';
    public const LIGHT_HOUR            = 'LIGHT_HOUR';
    public const LIGHT_DAY             = 'LIGHT_DAY';
    public const LIGHT_YEAR            = 'LIGHT_YEAR';
    public const LIGNE                 = 'LIGNE';
    public const LIGNE_SWISS           = 'LIGNE_SWISS';
    public const LINE                  = 'LINE';
    public const LINE_SMALL            = 'LINE_SMALL';
    public const LINK                  = 'LINK';
    public const LINK_ENGINEER         = 'LINK_ENGINEER';
    public const LUG                   = 'LUG';
    public const LUG_GREAT             = 'LUG_GREAT';
    public const MARATHON              = 'MARATHON';
    public const MARK_TWAIN            = 'MARK_TWAIN';
    public const MEGAMETER             = 'MEGAMETER';
    public const MEGAPARSEC            = 'MEGAPARSEC';
    public const MEILE_AUSTRIAN        = 'MEILE_AUSTRIAN';
    public const MEILE                 = 'MEILE';
    public const MEILE_GERMAN          = 'MEILE_GERMAN';
    public const METER                 = 'METER';
    public const METRE                 = 'METRE';
    public const METRIC_MILE           = 'METRIC_MILE';
    public const METRIC_MILE_US        = 'METRIC_MILE_US';
    public const MICROINCH             = 'MICROINCH';
    public const MICROMETER            = 'MICROMETER';
    public const MICROMICRON           = 'MICROMICRON';
    public const MICRON                = 'MICRON';
    public const MIGLIO                = 'MIGLIO';
    public const MIIL                  = 'MIIL';
    public const MIIL_DENMARK          = 'MIIL_DENMARK';
    public const MIIL_SWEDISH          = 'MIIL_SWEDISH';
    public const MIL                   = 'MIL';
    public const MIL_SWEDISH           = 'MIL_SWEDISH';
    public const MILE_UK               = 'MILE_UK';
    public const MILE_IRISH            = 'MILE_IRISH';
    public const MILE                  = 'MILE';
    public const MILE_NAUTIC           = 'MILE_NAUTIC';
    public const MILE_NAUTIC_UK        = 'MILE_NAUTIC_UK';
    public const MILE_NAUTIC_US        = 'MILE_NAUTIC_US';
    public const MILE_ANCIENT          = 'MILE_ANCIENT';
    public const MILE_SCOTTISH         = 'MILE_SCOTTISH';
    public const MILE_STATUTE          = 'MILE_STATUTE';
    public const MILE_US               = 'MILE_US';
    public const MILHA                 = 'MILHA';
    public const MILITARY_PACE         = 'MILITARY_PACE';
    public const MILITARY_PACE_DOUBLE  = 'MILITARY_PACE_DOUBLE';
    public const MILLA                 = 'MILLA';
    public const MILLE                 = 'MILLE';
    public const MILLIARE              = 'MILLIARE';
    public const MILLIMETER            = 'MILLIMETER';
    public const MILLIMICRON           = 'MILLIMICRON';
    public const MKONO                 = 'MKONO';
    public const MOOT                  = 'MOOT';
    public const MYRIAMETER            = 'MYRIAMETER';
    public const NAIL                  = 'NAIL';
    public const NANOMETER             = 'NANOMETER';
    public const NANON                 = 'NANON';
    public const PACE                  = 'PACE';
    public const PACE_ROMAN            = 'PACE_ROMAN';
    public const PALM_DUTCH            = 'PALM_DUTCH';
    public const PALM_UK               = 'PALM_UK';
    public const PALM                  = 'PALM';
    public const PALMO_PORTUGUESE      = 'PALMO_PORTUGUESE';
    public const PALMO                 = 'PALMO';
    public const PALMO_US              = 'PALMO_US';
    public const PARASANG              = 'PARASANG';
    public const PARIS_FOOT            = 'PARIS_FOOT';
    public const PARSEC                = 'PARSEC';
    public const PE                    = 'PE';
    public const PEARL                 = 'PEARL';
    public const PERCH                 = 'PERCH';
    public const PERCH_IRELAND         = 'PERCH_IRELAND';
    public const PERTICA               = 'PERTICA';
    public const PES                   = 'PES';
    public const PETAMETER             = 'PETAMETER';
    public const PICA                  = 'PICA';
    public const PICOMETER             = 'PICOMETER';
    public const PIE_ARGENTINA         = 'PIE_ARGENTINA';
    public const PIE_ITALIC            = 'PIE_ITALIC';
    public const PIE                   = 'PIE';
    public const PIE_US                = 'PIE_US';
    public const PIED_DE_ROI           = 'PIED_DE_ROI';
    public const PIK                   = 'PIK';
    public const PIKE                  = 'PIKE';
    public const POINT_ADOBE           = 'POINT_ADOBE';
    public const POINT                 = 'POINT';
    public const POINT_DIDOT           = 'POINT_DIDOT';
    public const POINT_TEX             = 'POINT_TEX';
    public const POLE                  = 'POLE';
    public const POLEGADA              = 'POLEGADA';
    public const POUCE                 = 'POUCE';
    public const PU                    = 'PU';
    public const PULGADA               = 'PULGADA';
    public const PYGME                 = 'PYGME';
    public const Q                     = 'Q';
    public const QUADRANT              = 'QUADRANT';
    public const QUARTER               = 'QUARTER';
    public const QUARTER_CLOTH         = 'QUARTER_CLOTH';
    public const QUARTER_PRINT         = 'QUARTER_PRINT';
    public const RANGE                 = 'RANGE';
    public const REED                  = 'REED';
    public const RI                    = 'RI';
    public const RIDGE                 = 'RIDGE';
    public const RIVER                 = 'RIVER';
    public const ROD                   = 'ROD';
    public const ROD_SURVEY            = 'ROD_SURVEY';
    public const ROEDE                 = 'ROEDE';
    public const ROOD                  = 'ROOD';
    public const ROPE                  = 'ROPE';
    public const ROYAL_FOOT            = 'ROYAL_FOOT';
    public const RUTE                  = 'RUTE';
    public const SADZHEN               = 'SADZHEN';
    public const SAGENE                = 'SAGENE';
    public const SCOTS_FOOT            = 'SCOTS_FOOT';
    public const SCOTS_MILE            = 'SCOTS_MILE';
    public const SEEMEILE              = 'SEEMEILE';
    public const SHACKLE               = 'SHACKLE';
    public const SHAFTMENT             = 'SHAFTMENT';
    public const SHAFTMENT_ANCIENT     = 'SHAFTMENT_ANCIENT';
    public const SHAKU                 = 'SHAKU';
    public const SIRIOMETER            = 'SIRIOMETER';
    public const SMOOT                 = 'SMOOT';
    public const SPAN                  = 'SPAN';
    public const SPAT                  = 'SPAT';
    public const STADIUM               = 'STADIUM';
    public const STEP                  = 'STEP';
    public const STICK                 = 'STICK';
    public const STORY                 = 'STORY';
    public const STRIDE                = 'STRIDE';
    public const STRIDE_ROMAN          = 'STRIDE_ROMAN';
    public const TENTHMETER            = 'TENTHMETER';
    public const TERAMETER             = 'TERAMETER';
    public const THOU                  = 'THOU';
    public const TOISE                 = 'TOISE';
    public const TOWNSHIP              = 'TOWNSHIP';
    public const T_SUN                 = 'T_SUN';
    public const TU                    = 'TU';
    public const TWAIN                 = 'TWAIN';
    public const TWIP                  = 'TWIP';
    public const U                     = 'U';
    public const VARA_CALIFORNIA       = 'VARA_CALIFORNIA';
    public const VARA_MEXICAN          = 'VARA_MEXICAN';
    public const VARA_PORTUGUESE       = 'VARA_PORTUGUESE';
    public const VARA_AMERICA          = 'VARA_AMERICA';
    public const VARA                  = 'VARA';
    public const VARA_TEXAS            = 'VARA_TEXAS';
    public const VERGE                 = 'VERGE';
    public const VERSHOK               = 'VERSHOK';
    public const VERST                 = 'VERST';
    public const WAH                   = 'WAH';
    public const WERST                 = 'WERST';
    public const X_UNIT                = 'X_UNIT';
    public const YARD                  = 'YARD';
    public const YOCTOMETER            = 'YOCTOMETER';
    public const YOTTAMETER            = 'YOTTAMETER';
    public const ZEPTOMETER            = 'ZEPTOMETER';
    public const ZETTAMETER            = 'ZETTAMETER';
    public const ZOLL                  = 'ZOLL';
    public const ZOLL_SWISS            = 'ZOLL_SWISS';

    /**
     * Calculations for all length units
     *
     * @var array
     */
    protected $_units = [
        'AGATE'           => [['' => '0.0254', '/' => '72'], 'agate'],
        'ALEN_DANISH'     => ['0.6277',           'alen'],
        'ALEN'            => ['0.6',              'alen'],
        'ALEN_SWEDISH'    => ['0.5938',           'alen'],
        'ANGSTROM'        => ['1.0e-10',          'Å'],
        'ARMS'            => ['0.7',              'arms'],
        'ARPENT_CANADIAN' => ['58.47',            'arpent'],
        'ARPENT'          => ['58.471308',        'arpent'],
        'ARSHEEN'         => ['0.7112',           'arsheen'],
        'ARSHIN'          => ['1.04',             'arshin'],
        'ARSHIN_IRAQ'     => ['74.5',             'arshin'],
        'ASTRONOMICAL_UNIT' => ['149597870691',   'AU'],
        'ATTOMETER'       => ['1.0e-18',          'am'],
        'BAMBOO'          => ['3.2',              'bamboo'],
        'BARLEYCORN'      => ['0.0085',           'barleycorn'],
        'BEE_SPACE'       => ['0.0065',           'bee space'],
        'BICRON'          => ['1.0e-12',          'µµ'],
        'BLOCK_US_EAST'   => ['80.4672',          'block'],
        'BLOCK_US_WEST'   => ['100.584',          'block'],
        'BLOCK_US_SOUTH'  => ['160.9344',         'block'],
        'BOHR'            => ['52.918e-12',       'a₀'],
        'BRACCIO'         => ['0.7',              'braccio'],
        'BRAZA_ARGENTINA' => ['1.733',            'braza'],
        'BRAZA'           => ['1.67',             'braza'],
        'BRAZA_US'        => ['1.693',            'braza'],
        'BUTTON'          => ['0.000635',         'button'],
        'CABLE_US'        => ['219.456',          'cable'],
        'CABLE_UK'        => ['185.3184',         'cable'],
        'CALIBER'         => ['0.0254',           'cal'],
        'CANA'            => ['2',                'cana'],
        'CAPE_FOOT'       => ['0.314858',         'cf'],
        'CAPE_INCH'       => [['' => '0.314858','/' => '12'], 'ci'],
        'CAPE_ROOD'       => ['3.778296',         'cr'],
        'CENTIMETER'      => ['0.01',             'cm'],
        'CHAIN'           => [['' => '79200','/' => '3937'],  'ch'],
        'CHAIN_ENGINEER'  => ['30.48',            'ch'],
        'CHIH'            => ['0.35814',          "ch'ih"],
        'CHINESE_FOOT'    => ['0.371475',         'ft'],
        'CHINESE_INCH'    => ['0.0371475',        'in'],
        'CHINESE_MILE'    => ['557.21',           'mi'],
        'CHINESE_YARD'    => ['0.89154',          'yd'],
        'CITY_BLOCK_US_EAST'  => ['80.4672',      'block'],
        'CITY_BLOCK_US_WEST'  => ['100.584',      'block'],
        'CITY_BLOCK_US_SOUTH' => ['160.9344',     'block'],
        'CLICK'           => ['1000',             'click'],
        'CUADRA'          => ['84',               'cuadra'],
        'CUADRA_ARGENTINA'=> ['130',              'cuadra'],
        'Length:CUBIT_EGYPT'      => ['0.45',             'cubit'],
        'CUBIT_ROYAL'     => ['0.5235',           'cubit'],
        'CUBIT_UK'        => ['0.4572',           'cubit'],
        'CUBIT'           => ['0.444',            'cubit'],
        'CUERDA'          => ['21',               'cda'],
        'DECIMETER'       => ['0.1',              'dm'],
        'DEKAMETER'       => ['10',               'dam'],
        'DIDOT_POINT'     => ['0.000377',         'didot point'],
        'DIGIT'           => ['0.019',            'digit'],
        'DIRAA'           => ['0.58',             ''],
        'DONG'            => [['' => '7','/' => '300'], 'dong'],
        'DOUZIEME_WATCH'  => ['0.000188',         'douzième'],
        'DOUZIEME'        => ['0.00017638888889', 'douzième'],
        'DRA_IRAQ'        => ['0.745',            'dra'],
        'DRA'             => ['0.7112',           'dra'],
        'EL'              => ['0.69',             'el'],
        'ELL'             => ['1.143',            'ell'],
        'ELL_SCOTTISH'    => ['0.945',            'ell'],
        'ELLE'            => ['0.6',              'ellen'],
        'ELLE_VIENNA'     => ['0.7793',           'ellen'],
        'EM'              => ['0.0042175176',     'em'],
        'ESTADIO_PORTUGAL'=> ['261',              'estadio'],
        'ESTADIO'         => ['174',              'estadio'],
        'EXAMETER'        => ['1.0e+18',          'Em'],
        'FADEN_AUSTRIA'   => ['1.8965',           'faden'],
        'FADEN'           => ['1.8',              'faden'],
        'FALL'            => ['6.858',            'fall'],
        'FALL_SCOTTISH'   => ['5.67',             'fall'],
        'FATHOM'          => ['1.8288',           'fth'],
        'FATHOM_ANCIENT'  => ['1.829',            'fth'],
        'FAUST'           => ['0.10536',          'faust'],
        'FEET_OLD_CANADIAN' => ['0.325',          'ft'],
        'FEET_EGYPT'      => ['0.36',             'ft'],
        'FEET_FRANCE'     => ['0.3248406',        'ft'],
        'FEET'            => ['0.3048',           'ft'],
        'FEET_IRAQ'       => ['0.316',            'ft'],
        'FEET_NETHERLAND' => ['0.28313',          'ft'],
        'FEET_ITALIC'     => ['0.296',            'ft'],
        'FEET_SURVEY'     => [['' => '1200', '/' => '3937'], 'ft'],
        'FEMTOMETER'      => ['1.0e-15',          'fm'],
        'FERMI'           => ['1.0e-15',          'f'],
        'FINGER'          => ['0.1143',           'finger'],
        'FINGERBREADTH'   => ['0.01905',          'fingerbreadth'],
        'FIST'            => ['0.1',              'fist'],
        'FOD'             => ['0.3141',           'fod'],
        'FOOT_EGYPT'      => ['0.36',             'ft'],
        'FOOT_FRANCE'     => ['0.3248406',        'ft'],
        'FOOT'            => ['0.3048',           'ft'],
        'FOOT_IRAQ'       => ['0.316',            'ft'],
        'FOOT_NETHERLAND' => ['0.28313',          'ft'],
        'FOOT_ITALIC'     => ['0.296',            'ft'],
        'FOOT_SURVEY'     => [['' => '1200', '/' => '3937'], 'ft'],
        'FOOTBALL_FIELD_CANADA' => ['100.584',    'football field'],
        'FOOTBALL_FIELD_US'     => ['91.44',      'football field'],
        'FOOTBALL_FIELD'  => ['109.728',          'football field'],
        'FURLONG'         => ['201.168',          'fur'],
        'FURLONG_SURVEY'  => [['' => '792000', '/' => '3937'], 'fur'],
        'FUSS'            => ['0.31608',          'fuss'],
        'GIGAMETER'       => ['1.0e+9',           'Gm'],
        'GIGAPARSEC'      => ['30.85678e+24',     'Gpc'],
        'GNATS_EYE'       => ['0.000125',         "gnat's eye"],
        'GOAD'            => ['1.3716',           'goad'],
        'GRY'             => ['0.000211667',      'gry'],
        'HAIRS_BREADTH'   => ['0.0001',           "hair's breadth"],
        'HAND'            => ['0.1016',           'hand'],
        'HANDBREADTH'     => ['0.08',             "hand's breadth"],
        'HAT'             => ['0.5',              'hat'],
        'HECTOMETER'      => ['100',              'hm'],
        'HEER'            => ['73.152',           'heer'],
        'HIRO'            => ['1.818',            'hiro'],
        'HUBBLE'          => ['9.4605e+24',       'hubble'],
        'HVAT'            => ['1.8965',           'hvat'],
        'INCH'            => ['0.0254',           'in'],
        'IRON'            => [['' => '0.0254', '/' => '48'], 'iron'],
        'KEN'             => ['1.818',            'ken'],
        'KERAT'           => ['0.0286',           'kerat'],
        'KILOFOOT'        => ['304.8',            'kft'],
        'KILOMETER'       => ['1000',             'km'],
        'KILOPARSEC'      => ['3.0856776e+19',    'kpc'],
        'KILOYARD'        => ['914.4',            'kyd'],
        'KIND'            => ['0.5',              'kind'],
        'KLAFTER'         => ['1.8965',           'klafter'],
        'KLAFTER_SWISS'   => ['1.8',              'klafter'],
        'KLICK'           => ['1000',             'klick'],
        'KYU'             => ['0.00025',          'kyu'],
        'LAP_ANCIENT'     => ['402.336',          ''],
        'LAP'             => ['400',              'lap'],
        'LAP_POOL'        => ['100',              'lap'],
        'LEAGUE_ANCIENT'  => ['2275',             'league'],
        'LEAGUE_NAUTIC'   => ['5556',             'league'],
        'LEAGUE_UK_NAUTIC'=> ['5559.552',         'league'],
        'LEAGUE'          => ['4828',             'league'],
        'LEAGUE_US'       => ['4828.0417',        'league'],
        'LEAP'            => ['2.0574',           'leap'],
        'LEGOA'           => ['6174.1',           'legoa'],
        'LEGUA'           => ['4200',             'legua'],
        'LEGUA_US'        => ['4233.4',           'legua'],
        'LEGUA_SPAIN_OLD' => ['4179.4',           'legua'],
        'LEGUA_SPAIN'     => ['6680',             'legua'],
        'LI_ANCIENT'      => ['500',              'li'],
        'LI_IMPERIAL'     => ['644.65',           'li'],
        'LI'              => ['500',              'li'],
        'LIEUE'           => ['3898',             'lieue'],
        'LIEUE_METRIC'    => ['4000',             'lieue'],
        'LIEUE_NAUTIC'    => ['5556',             'lieue'],
        'LIGHT_SECOND'    => ['299792458',        'light second'],
        'LIGHT_MINUTE'    => ['17987547480',      'light minute'],
        'LIGHT_HOUR'      => ['1079252848800',    'light hour'],
        'LIGHT_DAY'       => ['25902068371200',   'light day'],
        'LIGHT_YEAR'      => ['9460528404879000', 'ly'],
        'LIGNE'           => ['0.0021167',        'ligne'],
        'LIGNE_SWISS'     => ['0.002256',         'ligne'],
        'LINE'            => ['0.0021167',        'li'],
        'LINE_SMALL'      => ['0.000635',         'li'],
        'LINK'            => [['' => '792','/' => '3937'], 'link'],
        'LINK_ENGINEER'   => ['0.3048',           'link'],
        'LUG'             => ['5.0292',           'lug'],
        'LUG_GREAT'       => ['6.4008',           'lug'],
        'MARATHON'        => ['42194.988',        'marathon'],
        'MARK_TWAIN'      => ['3.6576074',        'mark twain'],
        'MEGAMETER'       => ['1000000',          'Mm'],
        'MEGAPARSEC'      => ['3.085677e+22',     'Mpc'],
        'MEILE_AUSTRIAN'  => ['7586',             'meile'],
        'MEILE'           => ['7412.7',           'meile'],
        'MEILE_GERMAN'    => ['7532.5',           'meile'],
        'METER'           => ['1',                'm'],
        'METRE'           => ['1',                'm'],
        'METRIC_MILE'     => ['1500',             'metric mile'],
        'METRIC_MILE_US'  => ['1600',             'metric mile'],
        'MICROINCH'       => ['2.54e-08',         'µin'],
        'MICROMETER'      => ['0.000001',         'µm'],
        'MICROMICRON'     => ['1.0e-12',          'µµ'],
        'MICRON'          => ['0.000001',         'µm'],
        'MIGLIO'          => ['1488.6',           'miglio'],
        'MIIL'            => ['7500',             'miil'],
        'MIIL_DENMARK'    => ['7532.5',           'miil'],
        'MIIL_SWEDISH'    => ['10687',            'miil'],
        'MIL'             => ['0.0000254',        'mil'],
        'MIL_SWEDISH'     => ['10000',            'mil'],
        'MILE_UK'         => ['1609',             'mi'],
        'MILE_IRISH'      => ['2048',             'mi'],
        'MILE'            => ['1609.344',         'mi'],
        'MILE_NAUTIC'     => ['1852',             'mi'],
        'MILE_NAUTIC_UK'  => ['1853.184',         'mi'],
        'MILE_NAUTIC_US'  => ['1852',             'mi'],
        'MILE_ANCIENT'    => ['1520',             'mi'],
        'MILE_SCOTTISH'   => ['1814',             'mi'],
        'MILE_STATUTE'    => ['1609.344',         'mi'],
        'MILE_US'         => [['' => '6336000','/' => '3937'], 'mi'],
        'MILHA'           => ['2087.3',           'milha'],
        'MILITARY_PACE'   => ['0.762',            'mil. pace'],
        'MILITARY_PACE_DOUBLE' => ['0.9144',      'mil. pace'],
        'MILLA'           => ['1392',             'milla'],
        'MILLE'           => ['1949',             'mille'],
        'MILLIARE'        => ['0.001478',         'milliare'],
        'MILLIMETER'      => ['0.001',            'mm'],
        'MILLIMICRON'     => ['1.0e-9',           'mµ'],
        'MKONO'           => ['0.4572',           'mkono'],
        'MOOT'            => ['0.0762',           'moot'],
        'MYRIAMETER'      => ['10000',            'mym'],
        'NAIL'            => ['0.05715',          'nail'],
        'NANOMETER'       => ['1.0e-9',           'nm'],
        'NANON'           => ['1.0e-9',           'nanon'],
        'PACE'            => ['1.524',            'pace'],
        'PACE_ROMAN'      => ['1.48',             'pace'],
        'PALM_DUTCH'      => ['0.10',             'palm'],
        'PALM_UK'         => ['0.075',            'palm'],
        'PALM'            => ['0.2286',           'palm'],
        'PALMO_PORTUGUESE'=> ['0.22',             'palmo'],
        'PALMO'           => ['0.20',             'palmo'],
        'PALMO_US'        => ['0.2117',           'palmo'],
        'PARASANG'        => ['6000',             'parasang'],
        'PARIS_FOOT'      => ['0.3248406',        'paris foot'],
        'PARSEC'          => ['3.0856776e+16',    'pc'],
        'PE'              => ['0.33324',          'pé'],
        'PEARL'           => ['0.001757299',      'pearl'],
        'PERCH'           => ['5.0292',           'perch'],
        'PERCH_IRELAND'   => ['6.4008',           'perch'],
        'PERTICA'         => ['2.96',             'pertica'],
        'PES'             => ['0.2967',           'pes'],
        'PETAMETER'       => ['1.0e+15',          'Pm'],
        'PICA'            => ['0.0042175176',     'pi'],
        'PICOMETER'       => ['1.0e-12',          'pm'],
        'PIE_ARGENTINA'   => ['0.2889',           'pie'],
        'PIE_ITALIC'      => ['0.298',            'pie'],
        'PIE'             => ['0.2786',           'pie'],
        'PIE_US'          => ['0.2822',           'pie'],
        'PIED_DE_ROI'     => ['0.3248406',        'pied de roi'],
        'PIK'             => ['0.71',             'pik'],
        'PIKE'            => ['0.71',             'pike'],
        'POINT_ADOBE'     => [['' => '0.3048', '/' => '864'], 'pt'],
        'POINT'           => ['0.00035',          'pt'],
        'POINT_DIDOT'     => ['0.000377',         'pt'],
        'POINT_TEX'       => ['0.0003514598035',  'pt'],
        'POLE'            => ['5.0292',           'pole'],
        'POLEGADA'        => ['0.02777',          'polegada'],
        'POUCE'           => ['0.02707',          'pouce'],
        'PU'              => ['1.7907',           'pu'],
        'PULGADA'         => ['0.02365',          'pulgada'],
        'PYGME'           => ['0.346',            'pygme'],
        'Q'               => ['0.00025',          'q'],
        'QUADRANT'        => ['10001300',         'quad'],
        'QUARTER'         => ['402.336',          'Q'],
        'QUARTER_CLOTH'   => ['0.2286',           'Q'],
        'QUARTER_PRINT'   => ['0.00025',          'Q'],
        'RANGE'           => [['' => '38016000','/' => '3937'], 'range'],
        'REED'            => ['2.679',            'reed'],
        'RI'              => ['3927',             'ri'],
        'RIDGE'           => ['6.1722',           'ridge'],
        'RIVER'           => ['2000',             'river'],
        'ROD'             => ['5.0292',           'rd'],
        'ROD_SURVEY'      => [['' => '19800', '/' => '3937'], 'rd'],
        'ROEDE'           => ['10',               'roede'],
        'ROOD'            => ['3.7783',           'rood'],
        'ROPE'            => ['3.7783',           'rope'],
        'ROYAL_FOOT'      => ['0.3248406',        'royal foot'],
        'RUTE'            => ['3.75',             'rute'],
        'SADZHEN'         => ['2.1336',           'sadzhen'],
        'SAGENE'          => ['2.1336',           'sagene'],
        'SCOTS_FOOT'      => ['0.30645',          'scots foot'],
        'SCOTS_MILE'      => ['1814.2',           'scots mile'],
        'SEEMEILE'        => ['1852',             'seemeile'],
        'SHACKLE'         => ['27.432',           'shackle'],
        'SHAFTMENT'       => ['0.15124',          'shaftment'],
        'SHAFTMENT_ANCIENT' => ['0.165',          'shaftment'],
        'SHAKU'           => ['0.303',            'shaku'],
        'SIRIOMETER'      => ['1.4959787e+17',    'siriometer'],
        'SMOOT'           => ['1.7018',           'smoot'],
        'SPAN'            => ['0.2286',           'span'],
        'SPAT'            => ['1.0e+12',          'spat'],
        'STADIUM'         => ['185',              'stadium'],
        'STEP'            => ['0.762',            'step'],
        'STICK'           => ['3.048',            'stk'],
        'STORY'           => ['3.3',              'story'],
        'STRIDE'          => ['1.524',            'stride'],
        'STRIDE_ROMAN'    => ['1.48',             'stride'],
        'TENTHMETER'      => ['1.0e-10',          'tenth-meter'],
        'TERAMETER'       => ['1.0e+12',          'Tm'],
        'THOU'            => ['0.0000254',        'thou'],
        'TOISE'           => ['1.949',            'toise'],
        'TOWNSHIP'        => [['' => '38016000','/' => '3937'], 'twp'],
        'T_SUN'           => ['0.0358',           "t'sun"],
        'TU'              => ['161130',           'tu'],
        'TWAIN'           => ['3.6576074',        'twain'],
        'TWIP'            => ['0.000017639',      'twip'],
        'U'               => ['0.04445',          'U'],
        'VARA_CALIFORNIA' => ['0.83820168',       'vara'],
        'VARA_MEXICAN'    => ['0.83802',          'vara'],
        'VARA_PORTUGUESE' => ['1.10',             'vara'],
        'VARA_AMERICA'    => ['0.864',            'vara'],
        'VARA'            => ['0.83587',          'vara'],
        'VARA_TEXAS'      => ['0.84666836',       'vara'],
        'VERGE'           => ['0.9144',           'verge'],
        'VERSHOK'         => ['0.04445',          'vershok'],
        'VERST'           => ['1066.8',           'verst'],
        'WAH'             => ['2',                'wah'],
        'WERST'           => ['1066.8',           'werst'],
        'X_UNIT'          => ['1.0020722e-13',    'Xu'],
        'YARD'            => ['0.9144',           'yd'],
        'YOCTOMETER'      => ['1.0e-24',          'ym'],
        'YOTTAMETER'      => ['1.0e+24',          'Ym'],
        'ZEPTOMETER'      => ['1.0e-21',          'zm'],
        'ZETTAMETER'      => ['1.0e+21',          'Zm'],
        'ZOLL'            => ['0.02634',          'zoll'],
        'ZOLL_SWISS'      => ['0.03',             'zoll'],
        'STANDARD'        => 'METER'
    ];
}
