/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.NoriDecompoundMode;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NoriTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, NoriTokenizer> {
    @Nullable
    private final NoriDecompoundMode decompoundMode;
    @Nullable
    private final Boolean discardPunctuation;
    @Nullable
    private final String userDictionary;
    @Nonnull
    private final List<String> userDictionaryRules;
    public static final JsonpDeserializer<NoriTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriTokenizer::setupNoriTokenizerDeserializer);

    private NoriTokenizer(Builder builder) {
        super(builder);
        this.decompoundMode = builder.decompoundMode;
        this.discardPunctuation = builder.discardPunctuation;
        this.userDictionary = builder.userDictionary;
        this.userDictionaryRules = ApiTypeHelper.unmodifiable(builder.userDictionaryRules);
    }

    public static NoriTokenizer of(Function<Builder, ObjectBuilder<NoriTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.NoriTokenizer;
    }

    @Nullable
    public final NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    @Nullable
    public final Boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Nonnull
    public final List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori_tokenizer");
        super.serializeInternal(generator, mapper);
        if (this.decompoundMode != null) {
            generator.writeKey("decompound_mode");
            this.decompoundMode.serialize(generator, mapper);
        }
        if (this.discardPunctuation != null) {
            generator.writeKey("discard_punctuation");
            generator.write(this.discardPunctuation.booleanValue());
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
        if (ApiTypeHelper.isDefined(this.userDictionaryRules)) {
            generator.writeKey("user_dictionary_rules");
            generator.writeStartArray();
            for (String item0 : this.userDictionaryRules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNoriTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        NoriTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode");
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.decompoundMode);
        result = 31 * result + Objects.hashCode(this.discardPunctuation);
        result = 31 * result + Objects.hashCode(this.userDictionary);
        result = 31 * result + Objects.hashCode(this.userDictionaryRules);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoriTokenizer other = (NoriTokenizer)o;
        return Objects.equals(this.decompoundMode, other.decompoundMode) && Objects.equals(this.discardPunctuation, other.discardPunctuation) && Objects.equals(this.userDictionary, other.userDictionary) && Objects.equals(this.userDictionaryRules, other.userDictionaryRules);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NoriTokenizer> {
        @Nullable
        private NoriDecompoundMode decompoundMode;
        @Nullable
        private Boolean discardPunctuation;
        @Nullable
        private String userDictionary;
        @Nullable
        private List<String> userDictionaryRules;

        public Builder() {
        }

        private Builder(NoriTokenizer o) {
            super(o);
            this.decompoundMode = o.decompoundMode;
            this.discardPunctuation = o.discardPunctuation;
            this.userDictionary = o.userDictionary;
            this.userDictionaryRules = Builder._listCopy(o.userDictionaryRules);
        }

        private Builder(Builder o) {
            super(o);
            this.decompoundMode = o.decompoundMode;
            this.discardPunctuation = o.discardPunctuation;
            this.userDictionary = o.userDictionary;
            this.userDictionaryRules = Builder._listCopy(o.userDictionaryRules);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder decompoundMode(@Nullable NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        @Nonnull
        public final Builder discardPunctuation(@Nullable Boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        @Nonnull
        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Nonnull
        public final Builder userDictionaryRules(List<String> list) {
            this.userDictionaryRules = Builder._listAddAll(this.userDictionaryRules, list);
            return this;
        }

        @Nonnull
        public final Builder userDictionaryRules(String value, String ... values) {
            this.userDictionaryRules = Builder._listAdd(this.userDictionaryRules, value, values);
            return this;
        }

        @Override
        @Nonnull
        public NoriTokenizer build() {
            this._checkSingleUse();
            return new NoriTokenizer(this);
        }
    }
}

