/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.metrics;

import com.github.wnameless.json.unflattener.JsonUnflattener;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.opensearch.observability.metrics.BasicCounter;
import org.opensearch.observability.metrics.Counter;
import org.opensearch.observability.metrics.RollingCounter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/observability/metrics/Metrics;", "", "metricName", "", "counter", "Lorg/opensearch/observability/metrics/Counter;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lorg/opensearch/observability/metrics/Counter;)V", "getMetricName", "()Ljava/lang/String;", "getCounter", "()Lorg/opensearch/observability/metrics/Counter;", "REQUEST_TOTAL", "REQUEST_INTERVAL_COUNT", "REQUEST_SUCCESS", "REQUEST_USER_ERROR", "REQUEST_SYSTEM_ERROR", "OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR", "OBSERVABILITY_SECURITY_PERMISSION_ERROR", "OBSERVABILITY_PERMISSION_USER_ERROR", "Companion", "opensearch-observability"})
public final class Metrics
extends Enum<Metrics> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String metricName;
    @NotNull
    private final Counter<?> counter;
    @NotNull
    private static final Metrics[] values;
    public static final /* enum */ Metrics REQUEST_TOTAL;
    public static final /* enum */ Metrics REQUEST_INTERVAL_COUNT;
    public static final /* enum */ Metrics REQUEST_SUCCESS;
    public static final /* enum */ Metrics REQUEST_USER_ERROR;
    public static final /* enum */ Metrics REQUEST_SYSTEM_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_SECURITY_PERMISSION_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_PERMISSION_USER_ERROR;
    private static final /* synthetic */ Metrics[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Metrics(String metricName, Counter<?> counter) {
        this.metricName = metricName;
        this.counter = counter;
    }

    @NotNull
    public final String getMetricName() {
        return this.metricName;
    }

    @NotNull
    public final Counter<?> getCounter() {
        return this.counter;
    }

    public static Metrics[] values() {
        return (Metrics[])$VALUES.clone();
    }

    public static Metrics valueOf(String value) {
        return Enum.valueOf(Metrics.class, value);
    }

    @NotNull
    public static EnumEntries<Metrics> getEntries() {
        return $ENTRIES;
    }

    static {
        REQUEST_TOTAL = new Metrics("request_total", new BasicCounter());
        REQUEST_INTERVAL_COUNT = new Metrics("request_count", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_SUCCESS = new Metrics("success_count", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_USER_ERROR = new Metrics("failed_request_count_user_error", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_SYSTEM_ERROR = new Metrics("failed_request_count_system_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION = new Metrics("exception.opensearch_status", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION = new Metrics("exception.opensearch_security", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION = new Metrics("exception.version_conflict_engine", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION = new Metrics("exception.index_not_found", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION = new Metrics("exception.invalid_index_name", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION = new Metrics("exception.illegal_argument", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION = new Metrics("exception.illegal_state", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION = new Metrics("exception.io", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR = new Metrics("exception.internal_server_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_SECURITY_PERMISSION_ERROR = new Metrics("security_permission_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_PERMISSION_USER_ERROR = new Metrics("permission_user_error", new RollingCounter(0L, 0L, null, 7, null));
        $VALUES = metricsArray = new Metrics[]{Metrics.REQUEST_TOTAL, Metrics.REQUEST_INTERVAL_COUNT, Metrics.REQUEST_SUCCESS, Metrics.REQUEST_USER_ERROR, Metrics.REQUEST_SYSTEM_ERROR, Metrics.OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR, Metrics.OBSERVABILITY_SECURITY_PERMISSION_ERROR, Metrics.OBSERVABILITY_PERMISSION_USER_ERROR};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        values = Metrics.values();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\tR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/observability/metrics/Metrics$Companion;", "", "<init>", "()V", "values", "", "Lorg/opensearch/observability/metrics/Metrics;", "[Lorg/opensearch/observability/metrics/Metrics;", "collectToJSON", "", "collectToFlattenedJSON", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final String collectToJSON() {
            JSONObject metricsJSONObject = new JSONObject();
            for (Metrics metric : values) {
                metricsJSONObject.put(metric.getMetricName(), metric.getCounter().getValue());
            }
            String string = metricsJSONObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String collectToFlattenedJSON() {
            String string = JsonUnflattener.unflatten((String)this.collectToJSON());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unflatten(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

