/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Holder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFrame;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.subquery.SubqueryExpression;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.CalciteAggCallVisitor;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import org.opensearch.sql.calcite.utils.JoinAndLookupUtils;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;
import org.opensearch.sql.utils.ParseUtils;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Iterables;
import shaded.com.google.common.collect.Streams;

public class CalciteRelNodeVisitor
extends AbstractNodeVisitor<RelNode, CalcitePlanContext> {
    private final CalciteRexNodeVisitor rexVisitor = new CalciteRexNodeVisitor(this);
    private final CalciteAggCallVisitor aggVisitor = new CalciteAggCallVisitor(this.rexVisitor);

    public RelNode analyze(UnresolvedPlan unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public RelNode visitRelation(Relation node, CalcitePlanContext context) {
        context.relBuilder.scan(node.getTableQualifiedName().getParts());
        return context.relBuilder.peek();
    }

    private RelBuilder scan(RelOptTable tableSchema, CalcitePlanContext context) {
        RelNode scan = context.relBuilder.getScanFactory().createScan(ViewExpanders.simpleContext((RelOptCluster)context.relBuilder.getCluster()), tableSchema);
        context.relBuilder.push(scan);
        return context.relBuilder;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public RelNode visitFilter(Filter node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        boolean containsSubqueryExpression = this.containsSubqueryExpression(node.getCondition());
        @Nullable Holder v = Holder.empty();
        if (containsSubqueryExpression) {
            context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
            context.pushCorrelVar((RexCorrelVariable)v.get());
        }
        RexNode condition = this.rexVisitor.analyze(node.getCondition(), context);
        if (containsSubqueryExpression) {
            context.relBuilder.filter((Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id), new RexNode[]{condition});
            context.popCorrelVar();
        } else {
            context.relBuilder.filter(new RexNode[]{condition});
        }
        return context.relBuilder.peek();
    }

    private boolean containsSubqueryExpression(Node expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof SubqueryExpression) {
            return true;
        }
        if (expr instanceof Let) {
            Let l = (Let)expr;
            return this.containsSubqueryExpression(l.getExpression());
        }
        for (Node node : expr.getChild()) {
            if (!this.containsSubqueryExpression(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelNode visitProject(Project node, CalcitePlanContext context) {
        UnresolvedExpression unresolvedExpression;
        this.visitChildren(node, context);
        if (node.getProjectList().size() == 1 && (unresolvedExpression = node.getProjectList().getFirst()) instanceof AllFields) {
            AllFields allFields = (AllFields)unresolvedExpression;
            CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
            CalciteRelNodeVisitor.tryToRemoveMetaFields(context, allFields instanceof AllFieldsExcludeMeta);
            return context.relBuilder.peek();
        }
        List projectList = node.getProjectList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
        if (node.isExcluded()) {
            context.relBuilder.projectExcept(projectList);
        } else {
            if (!context.isResolvingSubquery()) {
                context.setProjectVisited(true);
            }
            context.relBuilder.project(projectList);
        }
        return context.relBuilder.peek();
    }

    private static void tryToRemoveNestedFields(CalcitePlanContext context) {
        HashSet allFields = new HashSet(context.relBuilder.peek().getRowType().getFieldNames());
        List<RexNode> duplicatedNestedFields = allFields.stream().filter(field -> {
            int lastDot = field.lastIndexOf(".");
            return -1 != lastDot && allFields.contains(field.substring(0, lastDot));
        }).map(field -> context.relBuilder.field(field)).toList();
        if (!duplicatedNestedFields.isEmpty()) {
            CalciteRelNodeVisitor.forceProjectExcept(context.relBuilder, duplicatedNestedFields);
        }
    }

    private static void forceProjectExcept(RelBuilder relBuilder, Iterable<RexNode> expressions) {
        ArrayList allExpressions = new ArrayList(relBuilder.fields());
        HashSet<RexNode> excludeExpressions = new HashSet<RexNode>();
        for (RexNode excludeExp : expressions) {
            if (!excludeExpressions.add(excludeExp)) {
                throw new IllegalArgumentException("Input list contains duplicates. Expression " + String.valueOf(excludeExp) + " exists multiple times.");
            }
            if (allExpressions.remove(excludeExp)) continue;
            throw new IllegalArgumentException("Expression " + excludeExp.toString() + " not found.");
        }
        relBuilder.project(allExpressions, (Iterable)ImmutableList.of(), true);
    }

    private static void tryToRemoveMetaFields(CalcitePlanContext context, boolean excludeByForce) {
        if (excludeByForce || !context.isProjectVisited()) {
            List originalFields = context.relBuilder.peek().getRowType().getFieldNames();
            List<RexNode> metaFieldsRef = originalFields.stream().filter(OpenSearchConstants.METADATAFIELD_TYPE_MAP::containsKey).map(metaField -> context.relBuilder.field(metaField)).toList();
            if (!metaFieldsRef.isEmpty() && metaFieldsRef.size() != originalFields.size()) {
                context.relBuilder.projectExcept(metaFieldsRef);
            }
        }
    }

    @Override
    public RelNode visitRename(Rename node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalNames = context.relBuilder.peek().getRowType().getFieldNames();
        ArrayList<String> newNames = new ArrayList<String>(originalNames);
        for (Map renameMap : node.getRenameList()) {
            UnresolvedExpression unresolvedExpression = renameMap.getTarget();
            if (unresolvedExpression instanceof Field) {
                Field t = (Field)unresolvedExpression;
                String newName = t.getField().toString();
                RexNode check = this.rexVisitor.analyze(renameMap.getOrigin(), context);
                if (check instanceof RexInputRef) {
                    RexInputRef ref = (RexInputRef)check;
                    newNames.set(ref.getIndex(), newName);
                    continue;
                }
                throw new SemanticCheckException(String.format("the original field %s cannot be resolved", renameMap.getOrigin()));
            }
            throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
        }
        context.relBuilder.rename(newNames);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSort(Sort node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sortList = node.getSortList().stream().map(expr -> {
            RexNode sortField = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            Sort.SortOption sortOption = this.analyzeSortOption(expr.getFieldArgs());
            if (sortOption == Sort.SortOption.DEFAULT_DESC) {
                return context.relBuilder.desc(sortField);
            }
            return sortField;
        }).collect(Collectors.toList());
        context.relBuilder.sort(sortList);
        return context.relBuilder.peek();
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }

    @Override
    public RelNode visitHead(Head node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.limit(node.getFrom().intValue(), node.getSize().intValue());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitParse(Parse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        this.buildParseRelNode(node, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitPatterns(Patterns node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (PatternMethod.SIMPLE_PATTERN.equals((Object)node.getPatternMethod())) {
            Parse parseNode = new Parse(ParseMethod.PATTERNS, node.getSourceField(), node.getArguments().getOrDefault("pattern", AstDSL.stringLiteral("")), node.getArguments());
            this.buildParseRelNode(parseNode, context);
            if (PatternMode.AGGREGATION.equals((Object)node.getPatternMode())) {
                Field patternField = AstDSL.field(node.getAlias());
                List<RelBuilder.AggCall> aggCalls = Stream.of(new Alias("pattern_count", new AggregateFunction(BuiltinFunctionName.COUNT.name(), patternField)), new Alias("sample_logs", new AggregateFunction(BuiltinFunctionName.TAKE.name(), node.getSourceField(), (List<UnresolvedExpression>)ImmutableList.of((Object)node.getPatternMaxSampleCount())))).map(aggFun -> this.aggVisitor.analyze((UnresolvedExpression)aggFun, context)).toList();
                ArrayList<RexNode> groupByList = new ArrayList<RexNode>();
                groupByList.add(this.rexVisitor.analyze(patternField, context));
                groupByList.addAll(node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList());
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), aggCalls);
                RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, new RexNode[]{context.relBuilder.field(node.getAlias()), context.relBuilder.field("sample_logs")});
                this.flattenParsedPattern(node.getAlias(), parsedNode, context, false);
                context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("sample_logs")});
            } else {
                RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, new RexNode[]{context.relBuilder.field(node.getAlias()), this.rexVisitor.analyze(node.getSourceField(), context)});
                this.flattenParsedPattern(node.getAlias(), parsedNode, context, false);
            }
        } else {
            ArrayList<UnresolvedExpression> funcParamList = new ArrayList<UnresolvedExpression>();
            funcParamList.add(node.getSourceField());
            funcParamList.add(node.getPatternMaxSampleCount());
            funcParamList.add(node.getPatternBufferLimit());
            funcParamList.addAll(node.getArguments().entrySet().stream().map(entry -> new Argument((String)entry.getKey(), (Literal)entry.getValue())).sorted(Comparator.comparing(Argument::getArgName)).toList());
            if (PatternMode.LABEL.equals((Object)node.getPatternMode())) {
                RexNode windowNode = this.rexVisitor.analyze(new WindowFunction(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), node.getPartitionByList(), List.of()), context);
                RexNode nestedNode = context.relBuilder.alias(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, this.rexVisitor.analyze(node.getSourceField(), context), windowNode), node.getAlias());
                context.relBuilder.projectPlus(new RexNode[]{nestedNode});
                this.flattenParsedPattern(node.getAlias(), (RexNode)context.relBuilder.field(node.getAlias()), context, false);
            } else {
                RelBuilder.AggCall aggCall = this.aggVisitor.analyze(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), context).as(node.getAlias());
                List<RexNode> groupByList = node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), new RelBuilder.AggCall[]{aggCall});
                this.buildExpandRelNode(context.relBuilder.field(node.getAlias()), node.getAlias(), node.getAlias(), context);
                this.flattenParsedPattern(node.getAlias(), (RexNode)context.relBuilder.field(node.getAlias()), context, true);
            }
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitEval(Eval node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        node.getExpressionList().forEach(expr -> {
            boolean containsSubqueryExpression = this.containsSubqueryExpression((Node)expr);
            @Nullable Holder v = Holder.empty();
            if (containsSubqueryExpression) {
                context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
                context.pushCorrelVar((RexCorrelVariable)v.get());
            }
            RexNode eval = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            if (containsSubqueryExpression) {
                context.relBuilder.project(Iterables.concat((Iterable)context.relBuilder.fields(), (Iterable)ImmutableList.of((Object)eval)), (Iterable)ImmutableList.of(), false, (Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id));
                context.popCorrelVar();
            } else {
                String alias = (String)((RexLiteral)((RexCall)eval).getOperands().get(1)).getValueAs(String.class);
                this.projectPlusOverriding(List.of(eval), List.of(alias), context);
            }
        });
        return context.relBuilder.peek();
    }

    private void projectPlusOverriding(List<RexNode> newFields, List<String> newNames, CalcitePlanContext context) {
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> toOverrideList = originalFieldNames.stream().filter(newNames::contains).map(a -> context.relBuilder.field(a)).toList();
        context.relBuilder.projectPlus(newFields);
        if (!toOverrideList.isEmpty()) {
            context.relBuilder.projectExcept(toOverrideList);
        }
        List currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        int length = currentFields.size();
        ArrayList<String> expectedRenameFields = new ArrayList<String>(currentFields.subList(0, length - newNames.size()));
        expectedRenameFields.addAll(newNames);
        context.relBuilder.rename(expectedRenameFields);
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregateWithTrimming(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context) {
        Pair<List<RexNode>, List<RelBuilder.AggCall>> resolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        ArrayList<RexInputRef> trimmedRefs = new ArrayList<RexInputRef>();
        trimmedRefs.addAll(PlanUtils.getInputRefs((List)resolved.getLeft()));
        trimmedRefs.addAll(PlanUtils.getInputRefsFromAggCall((List)resolved.getRight()));
        context.relBuilder.project(trimmedRefs);
        Pair<List<RexNode>, List<RelBuilder.AggCall>> reResolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        context.relBuilder.aggregate(context.relBuilder.groupKey((Iterable)reResolved.getLeft()), (Iterable)reResolved.getRight());
        return Pair.of((Object)((List)reResolved.getLeft()), (Object)((List)reResolved.getRight()));
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> resolveAttributesForAggregation(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context) {
        List<RelBuilder.AggCall> aggCallList = aggExprList.stream().map(expr -> this.aggVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        List<RexNode> groupByList = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        return Pair.of(groupByList, aggCallList);
    }

    @Override
    public RelNode visitAggregation(Aggregation node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<UnresolvedExpression> aggExprList = node.getAggExprList();
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>();
        UnresolvedExpression span = node.getSpan();
        if (!Objects.isNull(span)) {
            groupExprList.add(span);
        }
        groupExprList.addAll(node.getGroupExprList());
        Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregationAttributes = this.aggregateWithTrimming(groupExprList, aggExprList, context);
        ImmutableList outputFields = context.relBuilder.fields();
        int numOfOutputFields = outputFields.size();
        int numOfAggList = aggExprList.size();
        ArrayList reordered = new ArrayList(numOfOutputFields);
        List aggRexList = outputFields.subList(numOfOutputFields - numOfAggList, numOfOutputFields);
        reordered.addAll(aggRexList);
        List<RexNode> aliasedGroupByList = ((List)aggregationAttributes.getLeft()).stream().map(this::extractAliasLiteral).flatMap(Optional::stream).map(ref -> (String)ref.getValueAs(String.class)).map(arg_0 -> ((RelBuilder)context.relBuilder).field(arg_0)).map(f -> f).toList();
        reordered.addAll(aliasedGroupByList);
        context.relBuilder.project(reordered);
        return context.relBuilder.peek();
    }

    private Optional<RexLiteral> extractAliasLiteral(RexNode node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node.getKind() == SqlKind.AS) {
            return Optional.of((RexLiteral)((RexCall)node).getOperands().get(1));
        }
        return Optional.empty();
    }

    @Override
    public RelNode visitJoin(Join node, CalcitePlanContext context) {
        List<UnresolvedPlan> children = node.getChildren();
        children.forEach(c -> this.analyze((UnresolvedPlan)c, context));
        RexNode joinCondition = node.getJoinCondition().map(c -> this.rexVisitor.analyzeJoinCondition((UnresolvedExpression)c, context)).orElse((RexNode)context.relBuilder.literal((Object)true));
        if (node.getJoinType() == Join.JoinType.SEMI || node.getJoinType() == Join.JoinType.ANTI) {
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
        } else {
            List leftColumns = context.relBuilder.peek(1).getRowType().getFieldNames();
            List rightColumns = context.relBuilder.peek().getRowType().getFieldNames();
            List rightTableName = PlanUtils.findTable(context.relBuilder.peek()).getQualifiedName();
            String rightTableQualifiedName = (String)rightTableName.getLast();
            List<String> rightColumnsWithAliasIfConflict = rightColumns.stream().map(col -> leftColumns.contains(col) ? node.getRightAlias().map(a -> a + "." + col).orElse(rightTableQualifiedName + "." + col) : col).toList();
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
            JoinAndLookupUtils.renameToExpectedFields(rightColumnsWithAliasIfConflict, leftColumns.size(), context);
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSubqueryAlias(SubqueryAlias node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.as(node.getAlias());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitLookup(Lookup node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sourceFieldsNames = context.relBuilder.peek().getRowType().getFieldNames();
        this.analyze(node.getLookupRelation(), context);
        JoinAndLookupUtils.addProjectionIfNecessary(node, context);
        List lookupTableFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<String> toBeRemovedLookupFieldNames = node.getMappingAliasMap().keySet().stream().filter(k -> !node.getOutputAliasMap().containsKey(k)).toList();
        List<String> providedFieldNames = lookupTableFieldNames.stream().filter(k -> !toBeRemovedLookupFieldNames.contains(k)).toList();
        List<RexNode> toBeRemovedLookupFields = toBeRemovedLookupFieldNames.stream().map(d -> context.relBuilder.field(2, 1, d)).toList();
        ArrayList<RexNode> toBeRemovedFields = new ArrayList<RexNode>(toBeRemovedLookupFields);
        java.util.Map<String, String> duplicatedFieldNamesMap = JoinAndLookupUtils.findDuplicatedFields(node, sourceFieldsNames, providedFieldNames);
        List<RexNode> duplicatedSourceFields = duplicatedFieldNamesMap.keySet().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList();
        toBeRemovedFields.addAll(duplicatedSourceFields);
        List<String> expectedProvidedFieldNames = providedFieldNames.stream().map(k -> node.getOutputAliasMap().getOrDefault(k, (String)k)).toList();
        ArrayList<RexNode> newCoalesceList = new ArrayList<RexNode>();
        if (!duplicatedFieldNamesMap.isEmpty() && node.getOutputStrategy() == Lookup.OutputStrategy.APPEND) {
            List<RexNode> duplicatedProvidedFields = duplicatedFieldNamesMap.values().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            for (int i = 0; i < duplicatedProvidedFields.size(); ++i) {
                newCoalesceList.add(context.rexBuilder.coalesce(duplicatedSourceFields.get(i), duplicatedProvidedFields.get(i)));
            }
            toBeRemovedFields.addAll(duplicatedProvidedFields);
            ArrayList<String> newExpectedFieldNames = new ArrayList<String>(expectedProvidedFieldNames.stream().filter(k -> !duplicatedFieldNamesMap.containsKey(k)).toList());
            newExpectedFieldNames.addAll(duplicatedFieldNamesMap.keySet());
            expectedProvidedFieldNames = newExpectedFieldNames;
        }
        JoinAndLookupUtils.addJoinForLookUp(node, context);
        if (!newCoalesceList.isEmpty()) {
            context.relBuilder.projectPlus(newCoalesceList);
        }
        if (!toBeRemovedFields.isEmpty()) {
            context.relBuilder.projectExcept(toBeRemovedFields);
        }
        JoinAndLookupUtils.renameToExpectedFields(expectedProvidedFieldNames, sourceFieldsNames.size() - duplicatedSourceFields.size(), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitDedupe(Dedupe node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        if (allowedDuplication <= 0) {
            throw new IllegalArgumentException("Number of duplicate events must be greater than 0");
        }
        if (consecutive.booleanValue()) {
            throw new UnsupportedOperationException("Consecutive deduplication is not supported");
        }
        List<RexNode> dedupeFields = node.getFields().stream().map(f -> this.rexVisitor.analyze((UnresolvedExpression)f, context)).toList();
        if (keepEmpty.booleanValue()) {
            RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_");
            context.relBuilder.projectPlus(new RexNode[]{rowNumber});
            RexInputRef _row_number_ = context.relBuilder.field("_row_number_");
            RexNode[] rexNodeArray = new RexNode[1];
            RexNode[] rexNodeArray2 = new RexNode[2];
            rexNodeArray2[0] = context.relBuilder.or(dedupeFields.stream().map(arg_0 -> ((RelBuilder)context.relBuilder).isNull(arg_0)).toList());
            rexNodeArray2[1] = context.relBuilder.lessThanOrEqual((RexNode)_row_number_, (RexNode)context.relBuilder.literal((Object)allowedDuplication));
            rexNodeArray[0] = context.relBuilder.or(rexNodeArray2);
            context.relBuilder.filter(rexNodeArray);
            context.relBuilder.projectExcept(new RexNode[]{_row_number_});
        } else {
            RexNode[] rexNodeArray = new RexNode[1];
            rexNodeArray[0] = context.relBuilder.and(dedupeFields.stream().map(arg_0 -> ((RelBuilder)context.relBuilder).isNotNull(arg_0)).toList());
            context.relBuilder.filter(rexNodeArray);
            RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_");
            context.relBuilder.projectPlus(new RexNode[]{rowNumber});
            RexInputRef _row_number_ = context.relBuilder.field("_row_number_");
            context.relBuilder.filter(new RexNode[]{context.relBuilder.lessThanOrEqual((RexNode)_row_number_, (RexNode)context.relBuilder.literal((Object)allowedDuplication))});
            context.relBuilder.projectExcept(new RexNode[]{_row_number_});
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitWindow(Window node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<RexNode> overExpressions = node.getWindowFunctionList().stream().map(w -> this.rexVisitor.analyze((UnresolvedExpression)w, context)).toList();
        context.relBuilder.projectPlus(overExpressions);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitFillNull(FillNull node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (node.getFields().size() != new HashSet<String>(node.getFields().stream().map(f -> f.getField().toString()).toList()).size()) {
            throw new IllegalArgumentException("The field list cannot be duplicated in fillnull");
        }
        ArrayList<Object> projects = new ArrayList<Object>();
        List fieldsList = context.relBuilder.peek().getRowType().getFieldList();
        for (RelDataTypeField field : fieldsList) {
            RexInputRef fieldRef = context.rexBuilder.makeInputRef(field.getType(), field.getIndex());
            boolean toReplace = false;
            for (Pair<Field, UnresolvedExpression> pair : node.getReplacementPairs()) {
                if (!field.getName().equalsIgnoreCase(((Field)pair.getLeft()).getField().toString())) continue;
                RexNode replacement = this.rexVisitor.analyze((UnresolvedExpression)pair.getRight(), context);
                RexNode coalesce = context.rexBuilder.coalesce(new RexNode[]{fieldRef, replacement});
                RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
                projects.add(coalesceWithAlias);
                toReplace = true;
                break;
            }
            if (!toReplace && node.getReplacementForAll().isEmpty()) {
                projects.add(fieldRef);
                continue;
            }
            if (!node.getReplacementForAll().isPresent()) continue;
            RexNode replacement = this.rexVisitor.analyze(node.getReplacementForAll().get(), context);
            RexNode coalesce = context.rexBuilder.coalesce(new RexNode[]{fieldRef, replacement});
            RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
            projects.add(coalesceWithAlias);
        }
        context.relBuilder.project(projects);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppendCol(AppendCol node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode mainRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(mainRowNumber, "_row_number_main_")});
        UnresolvedPlan relation = PlanUtils.getRelation(node);
        PlanUtils.transformPlanToAttachChild(node.getSubSearch(), relation);
        node.getSubSearch().accept(this, context);
        RexNode subsearchRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(subsearchRowNumber, "_row_number_subsearch_")});
        List subsearchFields = context.relBuilder.peek().getRowType().getFieldNames();
        List mainFields = context.relBuilder.peek(1).getRowType().getFieldNames();
        if (!node.isOverride()) {
            List<String> subsearchProjectList = subsearchFields.stream().filter(r -> !mainFields.contains(r)).toList();
            context.relBuilder.project((Iterable)context.relBuilder.fields(subsearchProjectList));
        }
        RexNode joinCondition = context.relBuilder.equals((RexNode)context.relBuilder.field(2, 0, "_row_number_main_"), (RexNode)context.relBuilder.field(2, 1, "_row_number_subsearch_"));
        context.relBuilder.join(JoinAndLookupUtils.translateJoinType(Join.JoinType.FULL), joinCondition);
        if (!node.isOverride()) {
            context.relBuilder.projectExcept(List.of(context.relBuilder.field("_row_number_main_"), context.relBuilder.field("_row_number_subsearch_")));
            return context.relBuilder.peek();
        }
        ArrayList<Object> finalProjections = new ArrayList<Object>();
        ArrayList<String> finalFieldNames = new ArrayList<String>();
        int mainFieldCount = mainFields.size();
        Set duplicatedFields = mainFields.stream().filter(subsearchFields::contains).collect(Collectors.toSet());
        RexNode caseCondition = context.relBuilder.equals((RexNode)context.relBuilder.field("_row_number_main_"), (RexNode)context.relBuilder.field("_row_number_subsearch_"));
        for (int mainFieldIndex = 0; mainFieldIndex < mainFields.size(); ++mainFieldIndex) {
            String mainFieldName = (String)mainFields.get(mainFieldIndex);
            if (mainFieldName.equals("_row_number_main_")) continue;
            finalFieldNames.add(mainFieldName);
            if (duplicatedFields.contains(mainFieldName)) {
                int subsearchFieldIndex = mainFieldCount + subsearchFields.indexOf(mainFieldName);
                RexNode caseExpr = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{caseCondition, context.relBuilder.field(subsearchFieldIndex), context.relBuilder.field(mainFieldIndex)});
                finalProjections.add(caseExpr);
                continue;
            }
            finalProjections.add(context.relBuilder.field(mainFieldIndex));
        }
        for (int subsearchFieldIndex = 0; subsearchFieldIndex < subsearchFields.size(); ++subsearchFieldIndex) {
            String subsearchFieldName = (String)subsearchFields.get(subsearchFieldIndex);
            if (subsearchFieldName.equals("_row_number_subsearch_") || duplicatedFields.contains(subsearchFieldName)) continue;
            finalProjections.add(context.relBuilder.field(mainFieldCount + subsearchFieldIndex));
            finalFieldNames.add(subsearchFieldName);
        }
        context.relBuilder.project(finalProjections, finalFieldNames);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAD(AD node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("AD command is unsupported in Calcite");
    }

    @Override
    public RelNode visitCloseCursor(CloseCursor closeCursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Close cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitFetchCursor(FetchCursor cursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Fetch cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitML(ML node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("ML command is unsupported in Calcite");
    }

    @Override
    public RelNode visitPaginate(Paginate paginate, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Paginate operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitKmeans(Kmeans node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Kmeans command is unsupported in Calcite");
    }

    @Override
    public RelNode visitRareTopN(RareTopN node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        Argument.ArgumentMap arguments = Argument.ArgumentMap.of(node.getArguments());
        String countFieldName = (String)arguments.get("countField").getValue();
        if (context.relBuilder.peek().getRowType().getFieldNames().contains(countFieldName)) {
            throw new IllegalArgumentException("Field `" + countFieldName + "` is existed, change the count field by setting countfield='xyz'");
        }
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>(node.getGroupExprList());
        List<UnresolvedExpression> fieldList = node.getFields().stream().map(f -> f).toList();
        groupExprList.addAll(fieldList);
        List<UnresolvedExpression> aggExprList = List.of(AstDSL.alias(countFieldName, AstDSL.aggregate("count", null)));
        this.aggregateWithTrimming(groupExprList, aggExprList, context);
        List<RexNode> partitionKeys = this.rexVisitor.analyze(node.getGroupExprList(), context);
        Object countField = node.getCommandType() == RareTopN.CommandType.TOP ? context.relBuilder.desc((RexNode)context.relBuilder.field(countFieldName)) : context.relBuilder.field(countFieldName);
        RexNode rowNumberWindowOver = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), partitionKeys, List.of(countField), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(rowNumberWindowOver, "_row_number_")});
        Integer N = (Integer)arguments.get("noOfResults").getValue();
        context.relBuilder.filter(new RexNode[]{context.relBuilder.lessThanOrEqual((RexNode)context.relBuilder.field("_row_number_"), (RexNode)context.relBuilder.literal((Object)N))});
        Boolean showCount = (Boolean)arguments.get("showCount").getValue();
        if (showCount.booleanValue()) {
            context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("_row_number_")});
        } else {
            context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("_row_number_"), context.relBuilder.field(countFieldName)});
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitTableFunction(TableFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Table function is unsupported in Calcite");
    }

    @Override
    public RelNode visitFlatten(Flatten node, CalcitePlanContext context) {
        List<String> expandedFieldNames;
        this.visitChildren(node, context);
        RelBuilder relBuilder = context.relBuilder;
        String fieldName = node.getField().getField().toString();
        List<RelDataTypeField> fieldsToExpand = relBuilder.peek().getRowType().getFieldList().stream().filter(f -> f.getName().startsWith(fieldName + ".")).toList();
        if (node.getAliases() != null) {
            if (node.getAliases().size() != fieldsToExpand.size()) {
                throw new IllegalArgumentException(String.format("The number of aliases has to match the number of flattened fields. Expected %d (%s), got %d (%s)", fieldsToExpand.size(), fieldsToExpand.stream().map(RelDataTypeField::getName).collect(Collectors.joining(", ")), node.getAliases().size(), String.join((CharSequence)", ", node.getAliases())));
            }
            expandedFieldNames = node.getAliases();
        } else {
            expandedFieldNames = fieldsToExpand.stream().map(RelDataTypeField::getName).map(name -> name.substring(fieldName.length() + 1)).collect(Collectors.toList());
        }
        List expandedFields = Streams.zip(fieldsToExpand.stream(), expandedFieldNames.stream(), (f, n) -> relBuilder.alias((RexNode)relBuilder.field(f.getName()), n)).collect(Collectors.toList());
        relBuilder.projectPlus(expandedFields);
        return relBuilder.peek();
    }

    @Override
    public RelNode visitTrendline(Trendline node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        node.getSortByField().ifPresent(sortField -> {
            Sort.SortOption sortOption = this.analyzeSortOption(sortField.getFieldArgs());
            RexNode field = this.rexVisitor.analyze((UnresolvedExpression)sortField, context);
            if (sortOption == Sort.SortOption.DEFAULT_DESC) {
                context.relBuilder.sort(new RexNode[]{context.relBuilder.desc(field)});
            } else {
                context.relBuilder.sort(new RexNode[]{field});
            }
        });
        ArrayList<RexNode> trendlineNodes = new ArrayList<RexNode>();
        ArrayList<String> aliases = new ArrayList<String>();
        node.getComputations().forEach(trendlineComputation -> {
            RexNode field = this.rexVisitor.analyze(trendlineComputation.getDataField(), context);
            context.relBuilder.filter(new RexNode[]{context.relBuilder.isNotNull(field)});
            WindowFrame windowFrame = WindowFrame.of(WindowFrame.FrameType.ROWS, StringUtils.format("%d PRECEDING", trendlineComputation.getNumberOfDataPoints() - 1), "CURRENT ROW");
            RexNode countExpr = PlanUtils.makeOver(context, BuiltinFunctionName.COUNT, null, List.of(), List.of(), List.of(), windowFrame);
            RexNode whenConditionExpr = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ">", new RexNode[]{countExpr, context.relBuilder.literal((Object)(trendlineComputation.getNumberOfDataPoints() - 1))});
            RexNode thenExpr = switch (trendlineComputation.getComputationType()) {
                case Trendline.TrendlineType.SMA -> PlanUtils.makeOver(context, BuiltinFunctionName.AVG, field, List.of(), List.of(), List.of(), windowFrame);
                case Trendline.TrendlineType.WMA -> this.buildWmaRexNode(field, trendlineComputation.getNumberOfDataPoints(), windowFrame, context);
                default -> throw new IllegalStateException("Unsupported trendline type");
            };
            RexLiteral elseExpr = context.relBuilder.literal(null);
            ArrayList<Object> caseOperands = new ArrayList<Object>();
            caseOperands.add(whenConditionExpr);
            caseOperands.add(thenExpr);
            caseOperands.add(elseExpr);
            RexNode trendlineNode = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
            trendlineNodes.add(trendlineNode);
            aliases.add(trendlineComputation.getAlias());
        });
        this.projectPlusOverriding(trendlineNodes, aliases, context);
        return context.relBuilder.peek();
    }

    private RexNode buildWmaRexNode(RexNode field, Integer numberOfDataPoints, WindowFrame windowFrame, CalcitePlanContext context) {
        RexLiteral divisor = context.relBuilder.literal((Object)(numberOfDataPoints * (numberOfDataPoints + 1) / 2));
        RexLiteral divider = context.relBuilder.literal((Object)0);
        for (int i = 1; i <= numberOfDataPoints; ++i) {
            RexNode nthValueExpr = PlanUtils.makeOver(context, BuiltinFunctionName.NTH_VALUE, field, List.of(context.relBuilder.literal((Object)i)), List.of(), List.of(), windowFrame);
            divider = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{divider, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{nthValueExpr, context.relBuilder.literal((Object)i)})});
        }
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{divider, context.relBuilder.cast((RexNode)divisor, SqlTypeName.DOUBLE)});
    }

    @Override
    public RelNode visitExpand(Expand expand, CalcitePlanContext context) {
        this.visitChildren(expand, context);
        Field arrayField = expand.getField();
        RexInputRef arrayFieldRex = (RexInputRef)this.rexVisitor.analyze(arrayField, context);
        String alias = expand.getAlias();
        this.buildExpandRelNode(arrayFieldRex, arrayField.getField().toString(), alias, context);
        return context.relBuilder.peek();
    }

    private void buildParseRelNode(Parse node, CalcitePlanContext context) {
        RexNode sourceField = this.rexVisitor.analyze(node.getSourceField(), context);
        ParseMethod parseMethod = node.getParseMethod();
        java.util.Map<String, Literal> arguments = node.getArguments();
        String patternValue = (String)node.getPattern().getValue();
        String pattern = ParseMethod.PATTERNS.equals((Object)parseMethod) && Strings.isNullOrEmpty((String)patternValue) ? "[a-zA-Z0-9]+" : patternValue;
        List<String> groupCandidates = ParseUtils.getNamedGroupCandidates(parseMethod, pattern, arguments);
        Object[] rexNodeList = new RexNode[]{sourceField, context.rexBuilder.makeLiteral(pattern, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)};
        if (ParseMethod.PATTERNS.equals((Object)parseMethod)) {
            rexNodeList = (RexNode[])ArrayUtils.add((Object[])rexNodeList, (Object)context.relBuilder.literal((Object)"<*>"));
        }
        ArrayList<RexNode> newFields = new ArrayList<RexNode>();
        for (String groupCandidate : groupCandidates) {
            RexNode innerRex = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ParseUtils.BUILTIN_FUNCTION_MAP.get((Object)parseMethod), (RexNode[])rexNodeList);
            if (ParseMethod.GROK.equals((Object)parseMethod)) {
                newFields.add(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{innerRex, context.relBuilder.literal((Object)groupCandidate)}));
                continue;
            }
            newFields.add(innerRex);
        }
        this.projectPlusOverriding(newFields, groupCandidates, context);
    }

    private void flattenParsedPattern(String originalPatternResultAlias, RexNode parsedNode, CalcitePlanContext context, boolean flattenPatternCount) {
        ArrayList<RexNode> fattenedNodes = new ArrayList<RexNode>();
        ArrayList<String> projectNames = new ArrayList<String>();
        RexNode patternExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("pattern")}), true, true);
        fattenedNodes.add(context.relBuilder.alias(patternExpr, originalPatternResultAlias));
        projectNames.add(originalPatternResultAlias);
        if (flattenPatternCount) {
            RexNode patternCountExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("pattern_count")}), true, true);
            fattenedNodes.add(context.relBuilder.alias(patternCountExpr, "pattern_count"));
            projectNames.add("pattern_count");
        }
        RexNode tokensExpr = context.rexBuilder.makeCast(UserDefinedFunctionUtils.tokensMap, PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("tokens")}), true, true);
        fattenedNodes.add(context.relBuilder.alias(tokensExpr, "tokens"));
        projectNames.add("tokens");
        this.projectPlusOverriding(fattenedNodes, projectNames, context);
    }

    private void buildExpandRelNode(RexInputRef arrayFieldRex, String arrayFieldName, String alias, CalcitePlanContext context) {
        Holder correlVariable = Holder.empty();
        context.relBuilder.variable(arg_0 -> ((Holder)correlVariable).set(arg_0));
        RexNode correlArrayFieldAccess = context.relBuilder.field(context.rexBuilder.makeCorrel(context.relBuilder.peek().getRowType(), ((RexCorrelVariable)correlVariable.get()).id), arrayFieldRex.getIndex());
        RelNode leftNode = context.relBuilder.build();
        RelNode rightNode = context.relBuilder.push((RelNode)LogicalValues.createOneRow((RelOptCluster)context.relBuilder.getCluster())).project(List.of(correlArrayFieldAccess), List.of(arrayFieldName)).uncollect(List.of(), false).build();
        context.relBuilder.push(leftNode).push(rightNode).correlate(JoinRelType.INNER, ((RexCorrelVariable)correlVariable.get()).id, List.of(arrayFieldRex)).projectExcept(new RexNode[]{arrayFieldRex});
        if (alias != null) {
            CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
            RexInputRef expandedField = context.relBuilder.field(arrayFieldName);
            ArrayList<String> names = new ArrayList<String>(context.relBuilder.peek().getRowType().getFieldNames());
            names.set(expandedField.getIndex(), alias);
            context.relBuilder.rename(names);
        }
    }
}

