/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Properties;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.util.Util;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.udf.udaf.NullableSqlAvgAggFunction;
import shaded.com.google.common.collect.ImmutableList;

public class CalciteToolsHelper {
    public static final SqlAggFunction AVG_NULLABLE = new NullableSqlAvgAggFunction(SqlKind.AVG);
    public static final SqlAggFunction STDDEV_POP_NULLABLE = new NullableSqlAvgAggFunction(SqlKind.STDDEV_POP);
    public static final SqlAggFunction STDDEV_SAMP_NULLABLE = new NullableSqlAvgAggFunction(SqlKind.STDDEV_SAMP);
    public static final SqlAggFunction VAR_POP_NULLABLE = new NullableSqlAvgAggFunction(SqlKind.VAR_POP);
    public static final SqlAggFunction VAR_SAMP_NULLABLE = new NullableSqlAvgAggFunction(SqlKind.VAR_SAMP);

    public static RelBuilder create(FrameworkConfig config) {
        return RelBuilder.create((FrameworkConfig)config);
    }

    public static RelBuilder create(FrameworkConfig config, JavaTypeFactory typeFactory, Connection connection) {
        return (RelBuilder)CalciteToolsHelper.withPrepare(config, typeFactory, connection, (cluster, relOptSchema, rootSchema, statement) -> new OpenSearchRelBuilder(config.getContext(), cluster, relOptSchema));
    }

    public static Connection connect(FrameworkConfig config, JavaTypeFactory typeFactory) {
        Properties info = new Properties();
        if (config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
            info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), config.getTypeSystem().getClass().getName());
        }
        try {
            return new OpenSearchDriver().connect("jdbc:calcite:", info, null, typeFactory);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static <R> R withPrepare(FrameworkConfig config, JavaTypeFactory typeFactory, Connection connection, Frameworks.BasePrepareAction<R> action) {
        try {
            Properties info = new Properties();
            if (config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
                info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), config.getTypeSystem().getClass().getName());
            }
            CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
            return new OpenSearchPrepareImpl().perform(statement, config, typeFactory, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class OpenSearchDriver
    extends Driver {
        public Connection connect(String url, Properties info, CalciteSchema rootSchema, JavaTypeFactory typeFactory) throws SQLException {
            Instant now = Instant.now();
            long nanosSinceEpoch = now.getEpochSecond() * 1000000000L + (long)now.getNano();
            Hook.CURRENT_TIME.addThread(h -> h.set((Object)nanosSinceEpoch));
            CalciteJdbc41Factory factory = new CalciteJdbc41Factory();
            CalciteJdbc41Factory.CalciteJdbc41Connection connection = factory.newConnection((UnregisteredDriver)this, (AvaticaFactory)factory, url, info, rootSchema, typeFactory);
            this.handler.onConnectionInit((AvaticaConnection)connection);
            return connection;
        }
    }

    public static class OpenSearchPrepareImpl
    extends CalcitePrepareImpl {
        public <R> R perform(CalciteServerStatement statement, FrameworkConfig config, JavaTypeFactory typeFactory, Frameworks.BasePrepareAction<R> action) {
            CalcitePrepare.Context prepareContext = statement.createPrepareContext();
            SchemaPlus defaultSchema = config.getDefaultSchema();
            CalciteSchema schema = defaultSchema != null ? CalciteSchema.from((SchemaPlus)defaultSchema) : prepareContext.getRootSchema();
            CalciteCatalogReader catalogReader = new CalciteCatalogReader(schema.root(), schema.path(null), (RelDataTypeFactory)typeFactory, prepareContext.config());
            RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
            RelOptPlanner planner = this.createPlanner(prepareContext, Contexts.of((Object)prepareContext.config()), config.getCostFactory());
            RelOptCluster cluster = this.createCluster(planner, rexBuilder);
            return (R)action.apply(cluster, (RelOptSchema)catalogReader, prepareContext.getRootSchema().plus(), statement);
        }
    }

    public static class OpenSearchRelBuilder
    extends RelBuilder {
        public OpenSearchRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
            super(context, cluster, relOptSchema);
        }

        public RelBuilder.AggCall avg(boolean distinct, String alias, RexNode operand) {
            return this.aggregateCall(SqlParserPos.ZERO, AVG_NULLABLE, distinct, false, false, null, null, ImmutableList.of(), alias, ImmutableList.of(), ImmutableList.of((Object)operand));
        }
    }

    public static class OpenSearchRelRunners {
        public static PreparedStatement run(CalcitePlanContext context, RelNode rel) {
            PreparedStatement preparedStatement;
            block8: {
                RelHomogeneousShuttle shuttle = new RelHomogeneousShuttle(){

                    public RelNode visit(TableScan scan) {
                        RelOptTable table = scan.getTable();
                        if (scan instanceof LogicalTableScan && Bindables.BindableTableScan.canHandle((RelOptTable)table)) {
                            return Bindables.BindableTableScan.create((RelOptCluster)scan.getCluster(), (RelOptTable)table);
                        }
                        return super.visit(scan);
                    }
                };
                rel = rel.accept((RelShuttle)shuttle);
                Connection connection = context.connection;
                try {
                    RelRunner runner = connection.unwrap(RelRunner.class);
                    preparedStatement = runner.prepareStatement(rel);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw Util.throwAsRuntime((Throwable)e);
                    }
                }
                connection.close();
            }
            return preparedStatement;
        }
    }
}

