/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Optionality;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class UserDefinedFunctionUtils {
    public static final RelDataType NULLABLE_DATE_UDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_DATE, true);
    public static final RelDataType NULLABLE_TIME_UDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_TIME, true);
    public static final RelDataType NULLABLE_TIMESTAMP_UDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP, true);
    public static final RelDataType NULLABLE_STRING = OpenSearchTypeFactory.TYPE_FACTORY.createTypeWithNullability(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), true);
    public static RelDataType nullablePatternAggList = SqlTypeUtil.createArrayType((RelDataTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, (RelDataType)OpenSearchTypeFactory.TYPE_FACTORY.createMapType(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY)), (boolean)true);
    public static RelDataType patternStruct = SqlTypeUtil.createMapType((RelDataTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, (RelDataType)OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), (RelDataType)OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY), (boolean)false);
    public static RelDataType tokensMap = OpenSearchTypeFactory.TYPE_FACTORY.createMapType(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), SqlTypeUtil.createArrayType((RelDataTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, (RelDataType)OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), (boolean)false));

    public static RelBuilder.AggCall TransferUserDefinedAggFunction(Class<? extends UserDefinedAggFunction> UDAF, String functionName, SqlReturnTypeInference returnType, List<RexNode> fields, List<RexNode> argList, RelBuilder relBuilder) {
        SqlUserDefinedAggFunction sqlUDAF = new SqlUserDefinedAggFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, returnType, null, null, (AggregateFunction)AggregateFunctionImpl.create(UDAF), false, false, Optionality.FORBIDDEN);
        ArrayList<RexNode> addArgList = new ArrayList<RexNode>(fields);
        addArgList.addAll(argList);
        return relBuilder.aggregateCall((SqlAggFunction)sqlUDAF, addArgList);
    }

    public static SqlReturnTypeInference getReturnTypeInferenceForArray() {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            List argTypes = opBinding.collectOperandTypes();
            if (argTypes.isEmpty()) {
                throw new IllegalArgumentException("Function requires at least one argument.");
            }
            RelDataType firstArgType = (RelDataType)argTypes.getFirst();
            return SqlTypeUtil.createArrayType((RelDataTypeFactory)typeFactory, (RelDataType)firstArgType, (boolean)true);
        };
    }

    public static SqlTypeName convertRelDataTypeToSqlTypeName(RelDataType type) {
        if (type instanceof AbstractExprRelDataType) {
            AbstractExprRelDataType exprType = (AbstractExprRelDataType)type;
            return switch (exprType.getUdt()) {
                case OpenSearchTypeFactory.ExprUDT.EXPR_DATE -> SqlTypeName.DATE;
                case OpenSearchTypeFactory.ExprUDT.EXPR_TIME -> SqlTypeName.TIME;
                case OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP -> SqlTypeName.TIMESTAMP;
                case OpenSearchTypeFactory.ExprUDT.EXPR_IP -> SqlTypeName.VARCHAR;
                case OpenSearchTypeFactory.ExprUDT.EXPR_BINARY -> SqlTypeName.VARBINARY;
                default -> type.getSqlTypeName();
            };
        }
        return type.getSqlTypeName();
    }

    public static FunctionProperties restoreFunctionProperties(DataContext dataContext) {
        long currentTimeInNanos = (Long)DataContext.Variable.UTC_TIMESTAMP.get(dataContext);
        Instant instant = Instant.ofEpochSecond(currentTimeInNanos / 1000000000L, currentTimeInNanos % 1000000000L);
        TimeZone timeZone = TimeZone.getDefault();
        ZoneId zoneId = timeZone.toZoneId();
        return new FunctionProperties(instant, zoneId, QueryType.PPL);
    }

    public static List<Expression> convertToExprValues(List<Expression> operands, RexCall rexCall) {
        List<RelDataType> types = rexCall.getOperands().stream().map(RexNode::getType).toList();
        return UserDefinedFunctionUtils.convertToExprValues(operands, types);
    }

    public static List<Expression> convertToExprValues(List<Expression> operands, List<RelDataType> types) {
        List<ExprType> exprTypes = types.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).toList();
        ArrayList<Expression> exprValues = new ArrayList<Expression>();
        for (int i = 0; i < operands.size(); ++i) {
            UnaryExpression operand = Expressions.convert_((Expression)operands.get(i), Object.class);
            exprValues.add(i, (Expression)Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{operand, Expressions.constant((Object)exprTypes.get(i))}));
        }
        return exprValues;
    }

    public static ImplementorUDF adaptExprMethodToUDF(Type type, String methodName, final SqlReturnTypeInference returnTypeInference, NullPolicy nullPolicy, final @Nullable UDFOperandMetadata operandMetadata) {
        NotNullImplementor implementor = (translator, call, translatedOperands) -> {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues((List<Expression>)translatedOperands, call.getOperands().stream().map(RexNode::getType).toList());
            MethodCallExpression exprResult = Expressions.call((Type)type, (String)methodName, operands);
            return Expressions.call((Expression)exprResult, (String)"valueForCalcite", (Expression[])new Expression[0]);
        };
        return new ImplementorUDF(implementor, nullPolicy){

            @Override
            public SqlReturnTypeInference getReturnTypeInference() {
                return returnTypeInference;
            }

            @Override
            public UDFOperandMetadata getOperandMetadata() {
                return operandMetadata;
            }
        };
    }

    public static List<Expression> prependFunctionProperties(List<Expression> operands, RexToLixTranslator translator) {
        ArrayList<Expression> operandsWithProperties = new ArrayList<Expression>(operands);
        MethodCallExpression properties = Expressions.call(UserDefinedFunctionUtils.class, (String)"restoreFunctionProperties", (Expression[])new Expression[]{translator.getRoot()});
        operandsWithProperties.addFirst((Expression)properties);
        return Collections.unmodifiableList(operandsWithProperties);
    }

    public static ImplementorUDF adaptExprMethodWithPropertiesToUDF(Type type, String methodName, final SqlReturnTypeInference returnTypeInference, NullPolicy nullPolicy, final UDFOperandMetadata operandMetadata) {
        NotNullImplementor implementor = (translator, call, translatedOperands) -> {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues((List<Expression>)translatedOperands, call.getOperands().stream().map(RexNode::getType).toList());
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(operands, translator);
            MethodCallExpression exprResult = Expressions.call((Type)type, (String)methodName, operandsWithProperties);
            return Expressions.call((Expression)exprResult, (String)"valueForCalcite", (Expression[])new Expression[0]);
        };
        return new ImplementorUDF(implementor, nullPolicy){

            @Override
            public SqlReturnTypeInference getReturnTypeInference() {
                return returnTypeInference;
            }

            @Override
            public UDFOperandMetadata getOperandMetadata() {
                return operandMetadata;
            }
        };
    }
}

