/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.datetime;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnit;
import org.opensearch.sql.calcite.utils.datetime.DateTimeParser;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionProperties;

public final class DateTimeConversionUtils {
    private DateTimeConversionUtils() {
    }

    public static ExprTimestampValue forceConvertToTimestampValue(ExprValue value, FunctionProperties properties) {
        ExprValue exprValue = value;
        Objects.requireNonNull(exprValue);
        ExprValue exprValue2 = exprValue;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExprTimestampValue.class, ExprDateValue.class, ExprTimeValue.class, ExprStringValue.class}, (Object)exprValue2, n)) {
            case 0 -> {
                ExprTimestampValue timestampValue;
                yield timestampValue = (ExprTimestampValue)exprValue2;
            }
            case 1 -> {
                ExprDateValue dateValue = (ExprDateValue)exprValue2;
                yield (ExprTimestampValue)ExprValueUtils.timestampValue(dateValue.timestampValue());
            }
            case 2 -> {
                ExprTimeValue timeValue = (ExprTimeValue)exprValue2;
                yield (ExprTimestampValue)ExprValueUtils.timestampValue(timeValue.timestampValue(properties));
            }
            case 3 -> {
                ExprStringValue stringValue = (ExprStringValue)exprValue2;
                yield new ExprTimestampValue(DateTimeParser.parse(stringValue.stringValue()));
            }
            default -> throw new SemanticCheckException(String.format("Cannot convert %s to timestamp, only STRING, DATE, TIME and TIMESTAMP are supported", value.type()));
        };
    }

    public static ExprTimestampValue convertToTimestampValue(ExprValue value, FunctionProperties properties) {
        if (value instanceof ExprTimestampValue) {
            ExprTimestampValue timestampValue = (ExprTimestampValue)value;
            return timestampValue;
        }
        if (value instanceof ExprTimeValue) {
            return new ExprTimestampValue(((ExprTimeValue)value).timestampValue(properties));
        }
        if (value.type() == ExprCoreType.STRING) {
            return new ExprTimestampValue(value.stringValue());
        }
        try {
            return new ExprTimestampValue(value.timestampValue());
        }
        catch (SemanticCheckException e) {
            throw new SemanticCheckException(String.format("Cannot convert %s to timestamp, only STRING, DATE, TIME and TIMESTAMP are supported", value.type()), e);
        }
    }

    public static ExprDateValue convertToDateValue(ExprValue value, FunctionProperties properties) {
        ExprValue exprValue = value;
        Objects.requireNonNull(exprValue);
        ExprValue exprValue2 = exprValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExprDateValue.class, ExprTimeValue.class, ExprTimestampValue.class, ExprStringValue.class}, (Object)exprValue2, n)) {
            case 0: {
                ExprDateValue dateValue = (ExprDateValue)exprValue2;
                return dateValue;
            }
            case 1: {
                ExprTimeValue timeValue = (ExprTimeValue)exprValue2;
                return new ExprDateValue(timeValue.dateValue(properties));
            }
            case 2: {
                ExprTimestampValue timestampValue = (ExprTimestampValue)exprValue2;
                return new ExprDateValue(timestampValue.dateValue());
            }
            case 3: {
                ExprStringValue ignored = (ExprStringValue)exprValue2;
                return new ExprDateValue(value.stringValue());
            }
        }
        throw new SemanticCheckException(String.format("Cannot convert %s to date, only STRING, DATE, TIME and TIMESTAMP are supported", value.type()));
    }

    public static TemporalAmount convertToTemporalAmount(long number, TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.YEAR -> Period.ofYears((int)number);
            case TimeUnit.QUARTER -> Period.ofMonths((int)number * 3);
            case TimeUnit.MONTH -> Period.ofMonths((int)number);
            case TimeUnit.WEEK -> Period.ofWeeks((int)number);
            case TimeUnit.DAY -> Period.ofDays((int)number);
            case TimeUnit.HOUR -> Duration.ofHours(number);
            case TimeUnit.MINUTE -> Duration.ofMinutes(number);
            case TimeUnit.SECOND -> Duration.ofSeconds(number);
            case TimeUnit.MILLISECOND -> Duration.ofMillis(number);
            case TimeUnit.MICROSECOND -> Duration.ofNanos(number * 1000L);
            case TimeUnit.NANOSECOND -> Duration.ofNanos(number);
            default -> throw new UnsupportedOperationException("No mapping defined for Calcite TimeUnit: " + String.valueOf(unit));
        };
    }
}

