/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.udf.udaf.LogPatternAggFunction;
import org.opensearch.sql.calcite.udf.udaf.PercentileApproxFunction;
import org.opensearch.sql.calcite.udf.udaf.TakeAggFunction;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.CalciteFuncSignature;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.expression.function.PPLTypeChecker;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class PPLFuncImpTable {
    private static final Logger logger = LogManager.getLogger(PPLFuncImpTable.class);
    public static final PPLFuncImpTable INSTANCE;
    private final ImmutableMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> functionRegistry;
    private final Map<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> externalFunctionRegistry;
    private final ImmutableMap<BuiltinFunctionName, AggHandler> aggFunctionRegistry;
    private final Map<BuiltinFunctionName, AggHandler> aggExternalFunctionRegistry;

    private PPLFuncImpTable(Builder builder, AggBuilder aggBuilder) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        builder.map.forEach((k, v) -> mapBuilder.put((Object)k, List.copyOf(v)));
        this.functionRegistry = ImmutableMap.copyOf((Map)mapBuilder.build());
        this.externalFunctionRegistry = new ConcurrentHashMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>>();
        ImmutableMap.Builder aggMapBuilder = ImmutableMap.builder();
        aggBuilder.map.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)aggMapBuilder).put(arg_0, arg_1));
        this.aggFunctionRegistry = ImmutableMap.copyOf((Map)aggMapBuilder.build());
        this.aggExternalFunctionRegistry = new ConcurrentHashMap<BuiltinFunctionName, AggHandler>();
    }

    public void registerExternalFunction(BuiltinFunctionName functionName, FunctionImp functionImp) {
        CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), functionImp.getTypeChecker());
        this.externalFunctionRegistry.compute(functionName, (name, existingList) -> {
            ArrayList<Pair> list = existingList == null ? new ArrayList<Pair>() : new ArrayList(existingList);
            list.add(Pair.of((Object)signature, (Object)functionImp));
            return list;
        });
    }

    public void registerExternalAggFunction(BuiltinFunctionName functionName, AggHandler functionImp) {
        this.aggExternalFunctionRegistry.put(functionName, functionImp);
    }

    public RelBuilder.AggCall resolveAgg(BuiltinFunctionName functionName, boolean distinct, RexNode field, List<RexNode> argList, CalcitePlanContext context) {
        AggHandler handler = this.aggExternalFunctionRegistry.get((Object)functionName);
        if (handler == null) {
            handler = (AggHandler)this.aggFunctionRegistry.get((Object)functionName);
        }
        if (handler == null) {
            throw new IllegalStateException(String.format("Cannot resolve function: %s", new Object[]{functionName}));
        }
        return handler.apply(distinct, field, argList, context);
    }

    public RexNode resolve(RexBuilder builder, String functionName, RexNode ... args) {
        Optional<BuiltinFunctionName> funcNameOpt = BuiltinFunctionName.of(functionName);
        if (funcNameOpt.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unsupported function: %s", functionName));
        }
        return this.resolve(builder, funcNameOpt.get(), args);
    }

    public RexNode resolve(RexBuilder builder, BuiltinFunctionName functionName, RexNode ... args) {
        List implementList = this.externalFunctionRegistry.get((Object)functionName);
        if (implementList == null) {
            implementList = (List)this.functionRegistry.get((Object)functionName);
        }
        if (implementList == null || implementList.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot resolve function: %s", new Object[]{functionName}));
        }
        List<RelDataType> argTypes = Arrays.stream(args).map(RexNode::getType).toList();
        try {
            for (Map.Entry implement : implementList) {
                if (!((CalciteFuncSignature)implement.getKey()).match(functionName.getName(), argTypes)) continue;
                return ((FunctionImp)implement.getValue()).resolve(builder, args);
            }
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(String.format("Cannot resolve function: %s, arguments: %s, caused by: %s", new Object[]{functionName, PPLFuncImpTable.getActualSignature(argTypes), e.getMessage()}), e);
        }
        StringJoiner allowedSignatures = new StringJoiner(",");
        for (Pair implement : implementList) {
            allowedSignatures.add(((CalciteFuncSignature)implement.getKey()).typeChecker().getAllowedSignatures());
        }
        throw new ExpressionEvaluationException(String.format("%s function expects {%s}, but got %s", new Object[]{functionName, allowedSignatures, PPLFuncImpTable.getActualSignature(argTypes)}));
    }

    private static String getActualSignature(List<RelDataType> argTypes) {
        return "[" + argTypes.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).map(Objects::toString).collect(Collectors.joining(",")) + "]";
    }

    static {
        Builder builder = new Builder();
        builder.populate();
        AggBuilder aggBuilder = new AggBuilder();
        aggBuilder.populate();
        INSTANCE = new PPLFuncImpTable(builder, aggBuilder);
    }

    private static class Builder
    extends AbstractBuilder {
        private final Map<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> map = new HashMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>>();

        private Builder() {
        }

        @Override
        void register(BuiltinFunctionName functionName, FunctionImp implement) {
            CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), implement.getTypeChecker());
            if (this.map.containsKey((Object)functionName)) {
                this.map.get((Object)functionName).add((Pair<CalciteFuncSignature, FunctionImp>)Pair.of((Object)signature, (Object)implement));
            } else {
                this.map.put(functionName, new ArrayList<Pair>(List.of(Pair.of((Object)signature, (Object)implement))));
            }
        }
    }

    private static class AggBuilder {
        private final Map<BuiltinFunctionName, AggHandler> map = new HashMap<BuiltinFunctionName, AggHandler>();

        private AggBuilder() {
        }

        void register(BuiltinFunctionName functionName, AggHandler aggHandler) {
            this.map.put(functionName, aggHandler);
        }

        void populate() {
            this.register(BuiltinFunctionName.MAX, (distinct, field, argList, ctx) -> ctx.relBuilder.max(field));
            this.register(BuiltinFunctionName.MIN, (distinct, field, argList, ctx) -> ctx.relBuilder.min(field));
            this.register(BuiltinFunctionName.AVG, (distinct, field, argList, ctx) -> ctx.relBuilder.avg(distinct, null, field));
            this.register(BuiltinFunctionName.COUNT, (distinct, field, argList, ctx) -> ctx.relBuilder.count(distinct, null, (Iterable)(field == null ? ImmutableList.of() : ImmutableList.of((Object)field))));
            this.register(BuiltinFunctionName.SUM, (distinct, field, argList, ctx) -> ctx.relBuilder.sum(distinct, null, field));
            this.register(BuiltinFunctionName.VARSAMP, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(CalciteToolsHelper.VAR_SAMP_NULLABLE, new RexNode[]{field}));
            this.register(BuiltinFunctionName.VARPOP, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(CalciteToolsHelper.VAR_POP_NULLABLE, new RexNode[]{field}));
            this.register(BuiltinFunctionName.STDDEV_SAMP, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(CalciteToolsHelper.STDDEV_SAMP_NULLABLE, new RexNode[]{field}));
            this.register(BuiltinFunctionName.STDDEV_POP, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(CalciteToolsHelper.STDDEV_POP_NULLABLE, new RexNode[]{field}));
            this.register(BuiltinFunctionName.TAKE, (distinct, field, argList, ctx) -> UserDefinedFunctionUtils.TransferUserDefinedAggFunction(TakeAggFunction.class, "TAKE", UserDefinedFunctionUtils.getReturnTypeInferenceForArray(), List.of(field), argList, ctx.relBuilder));
            this.register(BuiltinFunctionName.PERCENTILE_APPROX, (distinct, field, argList, ctx) -> {
                ArrayList<RexNode> newArgList = new ArrayList<RexNode>(argList);
                newArgList.add((RexNode)ctx.rexBuilder.makeFlag((Enum)field.getType().getSqlTypeName()));
                return UserDefinedFunctionUtils.TransferUserDefinedAggFunction(PercentileApproxFunction.class, "percentile_approx", ReturnTypes.ARG0_FORCE_NULLABLE, List.of(field), newArgList, ctx.relBuilder);
            });
            this.register(BuiltinFunctionName.INTERNAL_PATTERN, (distinct, field, argList, ctx) -> UserDefinedFunctionUtils.TransferUserDefinedAggFunction(LogPatternAggFunction.class, "pattern", (SqlReturnTypeInference)ReturnTypes.explicit((RelDataType)UserDefinedFunctionUtils.nullablePatternAggList), List.of(field), argList, ctx.relBuilder));
        }
    }

    public static interface FunctionImp {
        public static final RelDataType ANY_TYPE = OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY);

        public RexNode resolve(RexBuilder var1, RexNode ... var2);

        default public PPLTypeChecker getTypeChecker() {
            return null;
        }
    }

    @FunctionalInterface
    public static interface AggHandler {
        public RelBuilder.AggCall apply(boolean var1, RexNode var2, List<RexNode> var3, CalcitePlanContext var4);
    }

    private static class XOR_FUNC
    implements FunctionImp2 {
        private XOR_FUNC() {
        }

        @Override
        public RexNode resolve(RexBuilder builder, RexNode arg1, RexNode arg2) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{arg1, arg2});
        }

        @Override
        public PPLTypeChecker getTypeChecker() {
            SqlTypeFamily booleanFamily = SqlTypeName.BOOLEAN.getFamily();
            return PPLTypeChecker.family(booleanFamily, booleanFamily);
        }
    }

    private static abstract class AbstractBuilder {
        private AbstractBuilder() {
        }

        abstract void register(BuiltinFunctionName var1, FunctionImp var2);

        void registerOperator(BuiltinFunctionName functionName, SqlOperator operator) {
            SqlOperandTypeChecker typeChecker;
            if (operator instanceof SqlUserDefinedFunction) {
                SqlUserDefinedFunction udfOperator = (SqlUserDefinedFunction)operator;
                typeChecker = AbstractBuilder.extractTypeCheckerFromUDF(udfOperator);
            } else {
                typeChecker = operator.getOperandTypeChecker();
            }
            if (operator instanceof SqlUserDefinedFunction && typeChecker instanceof CompositeOperandTypeChecker) {
                CompositeOperandTypeChecker compositeTypeChecker = (CompositeOperandTypeChecker)typeChecker;
                this.register(functionName, AbstractBuilder.wrapWithCompositeTypeChecker(operator, compositeTypeChecker, false));
            } else if (typeChecker instanceof ImplicitCastOperandTypeChecker) {
                ImplicitCastOperandTypeChecker implicitCastTypeChecker = (ImplicitCastOperandTypeChecker)typeChecker;
                this.register(functionName, AbstractBuilder.wrapWithImplicitCastTypeChecker(operator, implicitCastTypeChecker));
            } else if (typeChecker instanceof CompositeOperandTypeChecker) {
                CompositeOperandTypeChecker compositeTypeChecker = (CompositeOperandTypeChecker)typeChecker;
                this.register(functionName, AbstractBuilder.wrapWithCompositeTypeChecker(operator, compositeTypeChecker, true));
            } else if (typeChecker instanceof SameOperandTypeChecker) {
                SameOperandTypeChecker comparableTypeChecker = (SameOperandTypeChecker)typeChecker;
                this.register(functionName, AbstractBuilder.wrapWithComparableTypeChecker(operator, comparableTypeChecker));
            } else {
                logger.info("Cannot create type checker for function: {}. Will skip its type checking", (Object)functionName);
                this.register(functionName, (builder, node) -> builder.makeCall(operator, node));
            }
        }

        private static SqlOperandTypeChecker extractTypeCheckerFromUDF(SqlUserDefinedFunction udfOperator) {
            UDFOperandMetadata udfOperandMetadata = (UDFOperandMetadata)udfOperator.getOperandTypeChecker();
            return udfOperandMetadata == null ? null : udfOperandMetadata.getInnerTypeChecker();
        }

        private static FunctionImp wrapWithCompositeTypeChecker(final SqlOperator operator, final CompositeOperandTypeChecker typeChecker, final boolean checkCompositionType) {
            return new FunctionImp(){

                @Override
                public RexNode resolve(RexBuilder builder, RexNode ... args) {
                    return builder.makeCall(operator, args);
                }

                @Override
                public PPLTypeChecker getTypeChecker() {
                    try {
                        return PPLTypeChecker.wrapComposite(typeChecker, checkCompositionType);
                    }
                    catch (IllegalArgumentException | UnsupportedOperationException e) {
                        logger.debug(String.format("Failed to create composite type checker for operator: %s. Will skip its type checking", operator.getName()), (Throwable)e);
                        return null;
                    }
                }
            };
        }

        private static FunctionImp wrapWithImplicitCastTypeChecker(final SqlOperator operator, final ImplicitCastOperandTypeChecker typeChecker) {
            return new FunctionImp(){

                @Override
                public RexNode resolve(RexBuilder builder, RexNode ... args) {
                    return builder.makeCall(operator, args);
                }

                @Override
                public PPLTypeChecker getTypeChecker() {
                    return PPLTypeChecker.wrapFamily(typeChecker);
                }
            };
        }

        private static FunctionImp wrapWithComparableTypeChecker(final SqlOperator operator, final SameOperandTypeChecker typeChecker) {
            return new FunctionImp(){

                @Override
                public RexNode resolve(RexBuilder builder, RexNode ... args) {
                    return builder.makeCall(operator, args);
                }

                @Override
                public PPLTypeChecker getTypeChecker() {
                    return PPLTypeChecker.wrapComparable(typeChecker);
                }
            };
        }

        private static FunctionImp createFunctionImpWithTypeChecker(final BiFunction<RexBuilder, RexNode, RexNode> resolver, final PPLTypeChecker typeChecker) {
            return new FunctionImp1(){

                @Override
                public RexNode resolve(RexBuilder builder, RexNode arg1) {
                    return (RexNode)resolver.apply(builder, arg1);
                }

                @Override
                public PPLTypeChecker getTypeChecker() {
                    return typeChecker;
                }
            };
        }

        private static FunctionImp createFunctionImpWithTypeChecker(final TriFunction<RexBuilder, RexNode, RexNode, RexNode> resolver, final PPLTypeChecker typeChecker) {
            return new FunctionImp2(){

                @Override
                public RexNode resolve(RexBuilder builder, RexNode arg1, RexNode arg2) {
                    return (RexNode)resolver.apply((Object)builder, (Object)arg1, (Object)arg2);
                }

                @Override
                public PPLTypeChecker getTypeChecker() {
                    return typeChecker;
                }
            };
        }

        void populate() {
            this.registerOperator(BuiltinFunctionName.AND, (SqlOperator)SqlStdOperatorTable.AND);
            this.registerOperator(BuiltinFunctionName.OR, (SqlOperator)SqlStdOperatorTable.OR);
            this.registerOperator(BuiltinFunctionName.NOT, (SqlOperator)SqlStdOperatorTable.NOT);
            this.registerOperator(BuiltinFunctionName.NOTEQUAL, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
            this.registerOperator(BuiltinFunctionName.EQUAL, (SqlOperator)SqlStdOperatorTable.EQUALS);
            this.registerOperator(BuiltinFunctionName.GREATER, (SqlOperator)SqlStdOperatorTable.GREATER_THAN);
            this.registerOperator(BuiltinFunctionName.GTE, (SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
            this.registerOperator(BuiltinFunctionName.LESS, (SqlOperator)SqlStdOperatorTable.LESS_THAN);
            this.registerOperator(BuiltinFunctionName.LTE, (SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
            this.registerOperator(BuiltinFunctionName.ADD, (SqlOperator)SqlStdOperatorTable.PLUS);
            this.registerOperator(BuiltinFunctionName.SUBTRACT, (SqlOperator)SqlStdOperatorTable.MINUS);
            this.registerOperator(BuiltinFunctionName.MULTIPLY, (SqlOperator)SqlStdOperatorTable.MULTIPLY);
            this.registerOperator(BuiltinFunctionName.TRUNCATE, (SqlOperator)SqlStdOperatorTable.TRUNCATE);
            this.registerOperator(BuiltinFunctionName.ASCII, (SqlOperator)SqlStdOperatorTable.ASCII);
            this.registerOperator(BuiltinFunctionName.LENGTH, (SqlOperator)SqlStdOperatorTable.CHAR_LENGTH);
            this.registerOperator(BuiltinFunctionName.LOWER, (SqlOperator)SqlStdOperatorTable.LOWER);
            this.registerOperator(BuiltinFunctionName.POSITION, (SqlOperator)SqlStdOperatorTable.POSITION);
            this.registerOperator(BuiltinFunctionName.LOCATE, (SqlOperator)SqlStdOperatorTable.POSITION);
            this.registerOperator(BuiltinFunctionName.REPLACE, (SqlOperator)SqlStdOperatorTable.REPLACE);
            this.registerOperator(BuiltinFunctionName.UPPER, (SqlOperator)SqlStdOperatorTable.UPPER);
            this.registerOperator(BuiltinFunctionName.ABS, (SqlOperator)SqlStdOperatorTable.ABS);
            this.registerOperator(BuiltinFunctionName.ACOS, (SqlOperator)SqlStdOperatorTable.ACOS);
            this.registerOperator(BuiltinFunctionName.ASIN, (SqlOperator)SqlStdOperatorTable.ASIN);
            this.registerOperator(BuiltinFunctionName.ATAN, (SqlOperator)SqlStdOperatorTable.ATAN);
            this.registerOperator(BuiltinFunctionName.ATAN2, (SqlOperator)SqlStdOperatorTable.ATAN2);
            this.registerOperator(BuiltinFunctionName.CEIL, (SqlOperator)SqlStdOperatorTable.CEIL);
            this.registerOperator(BuiltinFunctionName.CEILING, (SqlOperator)SqlStdOperatorTable.CEIL);
            this.registerOperator(BuiltinFunctionName.COS, (SqlOperator)SqlStdOperatorTable.COS);
            this.registerOperator(BuiltinFunctionName.COT, (SqlOperator)SqlStdOperatorTable.COT);
            this.registerOperator(BuiltinFunctionName.DEGREES, (SqlOperator)SqlStdOperatorTable.DEGREES);
            this.registerOperator(BuiltinFunctionName.EXP, (SqlOperator)SqlStdOperatorTable.EXP);
            this.registerOperator(BuiltinFunctionName.FLOOR, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.registerOperator(BuiltinFunctionName.LN, (SqlOperator)SqlStdOperatorTable.LN);
            this.registerOperator(BuiltinFunctionName.LOG10, (SqlOperator)SqlStdOperatorTable.LOG10);
            this.registerOperator(BuiltinFunctionName.PI, (SqlOperator)SqlStdOperatorTable.PI);
            this.registerOperator(BuiltinFunctionName.POW, (SqlOperator)SqlStdOperatorTable.POWER);
            this.registerOperator(BuiltinFunctionName.POWER, (SqlOperator)SqlStdOperatorTable.POWER);
            this.registerOperator(BuiltinFunctionName.RADIANS, (SqlOperator)SqlStdOperatorTable.RADIANS);
            this.registerOperator(BuiltinFunctionName.RAND, (SqlOperator)SqlStdOperatorTable.RAND);
            this.registerOperator(BuiltinFunctionName.ROUND, (SqlOperator)SqlStdOperatorTable.ROUND);
            this.registerOperator(BuiltinFunctionName.SIGN, (SqlOperator)SqlStdOperatorTable.SIGN);
            this.registerOperator(BuiltinFunctionName.SIN, (SqlOperator)SqlStdOperatorTable.SIN);
            this.registerOperator(BuiltinFunctionName.CBRT, (SqlOperator)SqlStdOperatorTable.CBRT);
            this.registerOperator(BuiltinFunctionName.IS_NOT_NULL, (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
            this.registerOperator(BuiltinFunctionName.IS_PRESENT, (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
            this.registerOperator(BuiltinFunctionName.IS_NULL, (SqlOperator)SqlStdOperatorTable.IS_NULL);
            this.registerOperator(BuiltinFunctionName.IFNULL, (SqlOperator)SqlStdOperatorTable.COALESCE);
            this.registerOperator(BuiltinFunctionName.EARLIEST, PPLBuiltinOperators.EARLIEST);
            this.registerOperator(BuiltinFunctionName.LATEST, PPLBuiltinOperators.LATEST);
            this.registerOperator(BuiltinFunctionName.COALESCE, (SqlOperator)SqlStdOperatorTable.COALESCE);
            this.registerOperator(BuiltinFunctionName.REGEXP, (SqlOperator)SqlLibraryOperators.REGEXP);
            this.registerOperator(BuiltinFunctionName.CONCAT, (SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION);
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, (SqlOperator)SqlLibraryOperators.CONCAT_WS);
            this.registerOperator(BuiltinFunctionName.LIKE, (SqlOperator)SqlLibraryOperators.ILIKE);
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, (SqlOperator)SqlLibraryOperators.CONCAT_WS);
            this.registerOperator(BuiltinFunctionName.REVERSE, (SqlOperator)SqlLibraryOperators.REVERSE);
            this.registerOperator(BuiltinFunctionName.RIGHT, (SqlOperator)SqlLibraryOperators.RIGHT);
            this.registerOperator(BuiltinFunctionName.LEFT, (SqlOperator)SqlLibraryOperators.LEFT);
            this.registerOperator(BuiltinFunctionName.LOG2, (SqlOperator)SqlLibraryOperators.LOG2);
            this.registerOperator(BuiltinFunctionName.MD5, (SqlOperator)SqlLibraryOperators.MD5);
            this.registerOperator(BuiltinFunctionName.SHA1, (SqlOperator)SqlLibraryOperators.SHA1);
            this.registerOperator(BuiltinFunctionName.INTERNAL_REGEXP_EXTRACT, (SqlOperator)SqlLibraryOperators.REGEXP_EXTRACT);
            this.registerOperator(BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_3, (SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_3);
            this.registerOperator(BuiltinFunctionName.SPAN, PPLBuiltinOperators.SPAN);
            this.registerOperator(BuiltinFunctionName.E, PPLBuiltinOperators.E);
            this.registerOperator(BuiltinFunctionName.CONV, PPLBuiltinOperators.CONV);
            this.registerOperator(BuiltinFunctionName.MOD, PPLBuiltinOperators.MOD);
            this.registerOperator(BuiltinFunctionName.MODULUS, PPLBuiltinOperators.MOD);
            this.registerOperator(BuiltinFunctionName.MODULUSFUNCTION, PPLBuiltinOperators.MOD);
            this.registerOperator(BuiltinFunctionName.CRC32, PPLBuiltinOperators.CRC32);
            this.registerOperator(BuiltinFunctionName.DIVIDE, PPLBuiltinOperators.DIVIDE);
            this.registerOperator(BuiltinFunctionName.SHA2, PPLBuiltinOperators.SHA2);
            this.registerOperator(BuiltinFunctionName.CIDRMATCH, PPLBuiltinOperators.CIDRMATCH);
            this.registerOperator(BuiltinFunctionName.INTERNAL_GROK, PPLBuiltinOperators.GROK);
            this.registerOperator(BuiltinFunctionName.TIMESTAMP, PPLBuiltinOperators.TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.DATE, PPLBuiltinOperators.DATE);
            this.registerOperator(BuiltinFunctionName.TIME, PPLBuiltinOperators.TIME);
            this.registerOperator(BuiltinFunctionName.UTC_TIME, PPLBuiltinOperators.UTC_TIME);
            this.registerOperator(BuiltinFunctionName.UTC_DATE, PPLBuiltinOperators.UTC_DATE);
            this.registerOperator(BuiltinFunctionName.UTC_TIMESTAMP, PPLBuiltinOperators.UTC_TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.YEAR, PPLBuiltinOperators.YEAR);
            this.registerOperator(BuiltinFunctionName.YEARWEEK, PPLBuiltinOperators.YEARWEEK);
            this.registerOperator(BuiltinFunctionName.WEEKDAY, PPLBuiltinOperators.WEEKDAY);
            this.registerOperator(BuiltinFunctionName.UNIX_TIMESTAMP, PPLBuiltinOperators.UNIX_TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.TO_SECONDS, PPLBuiltinOperators.TO_SECONDS);
            this.registerOperator(BuiltinFunctionName.TO_DAYS, PPLBuiltinOperators.TO_DAYS);
            this.registerOperator(BuiltinFunctionName.ADDTIME, PPLBuiltinOperators.ADDTIME);
            this.registerOperator(BuiltinFunctionName.SUBTIME, PPLBuiltinOperators.SUBTIME);
            this.registerOperator(BuiltinFunctionName.ADDDATE, PPLBuiltinOperators.ADDDATE);
            this.registerOperator(BuiltinFunctionName.SUBDATE, PPLBuiltinOperators.SUBDATE);
            this.registerOperator(BuiltinFunctionName.DATE_ADD, PPLBuiltinOperators.DATE_ADD);
            this.registerOperator(BuiltinFunctionName.DATE_SUB, PPLBuiltinOperators.DATE_SUB);
            this.registerOperator(BuiltinFunctionName.EXTRACT, PPLBuiltinOperators.EXTRACT);
            this.registerOperator(BuiltinFunctionName.QUARTER, PPLBuiltinOperators.QUARTER);
            this.registerOperator(BuiltinFunctionName.MONTH, PPLBuiltinOperators.MONTH);
            this.registerOperator(BuiltinFunctionName.MONTH_OF_YEAR, PPLBuiltinOperators.MONTH);
            this.registerOperator(BuiltinFunctionName.DAY, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAYOFMONTH, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAY_OF_MONTH, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAYOFWEEK, PPLBuiltinOperators.DAY_OF_WEEK);
            this.registerOperator(BuiltinFunctionName.DAY_OF_WEEK, PPLBuiltinOperators.DAY_OF_WEEK);
            this.registerOperator(BuiltinFunctionName.DAYOFYEAR, PPLBuiltinOperators.DAY_OF_YEAR);
            this.registerOperator(BuiltinFunctionName.DAY_OF_YEAR, PPLBuiltinOperators.DAY_OF_YEAR);
            this.registerOperator(BuiltinFunctionName.HOUR, PPLBuiltinOperators.HOUR);
            this.registerOperator(BuiltinFunctionName.HOUR_OF_DAY, PPLBuiltinOperators.HOUR);
            this.registerOperator(BuiltinFunctionName.MINUTE, PPLBuiltinOperators.MINUTE);
            this.registerOperator(BuiltinFunctionName.MINUTE_OF_HOUR, PPLBuiltinOperators.MINUTE);
            this.registerOperator(BuiltinFunctionName.MINUTE_OF_DAY, PPLBuiltinOperators.MINUTE_OF_DAY);
            this.registerOperator(BuiltinFunctionName.SECOND, PPLBuiltinOperators.SECOND);
            this.registerOperator(BuiltinFunctionName.SECOND_OF_MINUTE, PPLBuiltinOperators.SECOND);
            this.registerOperator(BuiltinFunctionName.MICROSECOND, PPLBuiltinOperators.MICROSECOND);
            this.registerOperator(BuiltinFunctionName.CURRENT_TIMESTAMP, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.NOW, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.LOCALTIMESTAMP, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.LOCALTIME, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.CURTIME, PPLBuiltinOperators.CURRENT_TIME);
            this.registerOperator(BuiltinFunctionName.CURRENT_TIME, PPLBuiltinOperators.CURRENT_TIME);
            this.registerOperator(BuiltinFunctionName.CURRENT_DATE, PPLBuiltinOperators.CURRENT_DATE);
            this.registerOperator(BuiltinFunctionName.CURDATE, PPLBuiltinOperators.CURRENT_DATE);
            this.registerOperator(BuiltinFunctionName.DATE_FORMAT, PPLBuiltinOperators.DATE_FORMAT);
            this.registerOperator(BuiltinFunctionName.TIME_FORMAT, PPLBuiltinOperators.TIME_FORMAT);
            this.registerOperator(BuiltinFunctionName.DAYNAME, PPLBuiltinOperators.DAYNAME);
            this.registerOperator(BuiltinFunctionName.MONTHNAME, PPLBuiltinOperators.MONTHNAME);
            this.registerOperator(BuiltinFunctionName.CONVERT_TZ, PPLBuiltinOperators.CONVERT_TZ);
            this.registerOperator(BuiltinFunctionName.DATEDIFF, PPLBuiltinOperators.DATEDIFF);
            this.registerOperator(BuiltinFunctionName.DATETIME, PPLBuiltinOperators.DATETIME);
            this.registerOperator(BuiltinFunctionName.TIMESTAMPDIFF, PPLBuiltinOperators.TIMESTAMPDIFF);
            this.registerOperator(BuiltinFunctionName.LAST_DAY, PPLBuiltinOperators.LAST_DAY);
            this.registerOperator(BuiltinFunctionName.FROM_DAYS, PPLBuiltinOperators.FROM_DAYS);
            this.registerOperator(BuiltinFunctionName.FROM_UNIXTIME, PPLBuiltinOperators.FROM_UNIXTIME);
            this.registerOperator(BuiltinFunctionName.GET_FORMAT, PPLBuiltinOperators.GET_FORMAT);
            this.registerOperator(BuiltinFunctionName.MAKEDATE, PPLBuiltinOperators.MAKEDATE);
            this.registerOperator(BuiltinFunctionName.MAKETIME, PPLBuiltinOperators.MAKETIME);
            this.registerOperator(BuiltinFunctionName.PERIOD_ADD, PPLBuiltinOperators.PERIOD_ADD);
            this.registerOperator(BuiltinFunctionName.PERIOD_DIFF, PPLBuiltinOperators.PERIOD_DIFF);
            this.registerOperator(BuiltinFunctionName.SEC_TO_TIME, PPLBuiltinOperators.SEC_TO_TIME);
            this.registerOperator(BuiltinFunctionName.STR_TO_DATE, PPLBuiltinOperators.STR_TO_DATE);
            this.registerOperator(BuiltinFunctionName.SYSDATE, PPLBuiltinOperators.SYSDATE);
            this.registerOperator(BuiltinFunctionName.TIME_TO_SEC, PPLBuiltinOperators.TIME_TO_SEC);
            this.registerOperator(BuiltinFunctionName.TIMEDIFF, PPLBuiltinOperators.TIMEDIFF);
            this.registerOperator(BuiltinFunctionName.TIMESTAMPADD, PPLBuiltinOperators.TIMESTAMPADD);
            this.registerOperator(BuiltinFunctionName.WEEK, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.WEEK_OF_YEAR, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.WEEKOFYEAR, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.INTERNAL_PATTERN_PARSER, PPLBuiltinOperators.PATTERN_PARSER);
            this.registerOperator(BuiltinFunctionName.ARRAY, PPLBuiltinOperators.ARRAY);
            this.registerOperator(BuiltinFunctionName.ARRAY_LENGTH, (SqlOperator)SqlLibraryOperators.ARRAY_LENGTH);
            this.registerOperator(BuiltinFunctionName.FORALL, PPLBuiltinOperators.FORALL);
            this.registerOperator(BuiltinFunctionName.EXISTS, PPLBuiltinOperators.EXISTS);
            this.registerOperator(BuiltinFunctionName.FILTER, PPLBuiltinOperators.FILTER);
            this.registerOperator(BuiltinFunctionName.TRANSFORM, PPLBuiltinOperators.TRANSFORM);
            this.registerOperator(BuiltinFunctionName.REDUCE, PPLBuiltinOperators.REDUCE);
            this.register(BuiltinFunctionName.JSON_ARRAY, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, (RexNode[])Stream.concat(Stream.of(builder.makeFlag((Enum)SqlJsonConstructorNullClause.NULL_ON_NULL)), Arrays.stream(args)).toArray(RexNode[]::new)));
            this.register(BuiltinFunctionName.JSON_OBJECT, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, (RexNode[])Stream.concat(Stream.of(builder.makeFlag((Enum)SqlJsonConstructorNullClause.NULL_ON_NULL)), Arrays.stream(args)).toArray(RexNode[]::new)));
            this.registerOperator(BuiltinFunctionName.JSON, PPLBuiltinOperators.JSON);
            this.registerOperator(BuiltinFunctionName.JSON_ARRAY_LENGTH, PPLBuiltinOperators.JSON_ARRAY_LENGTH);
            this.registerOperator(BuiltinFunctionName.JSON_EXTRACT, PPLBuiltinOperators.JSON_EXTRACT);
            this.registerOperator(BuiltinFunctionName.JSON_KEYS, PPLBuiltinOperators.JSON_KEYS);
            this.registerOperator(BuiltinFunctionName.JSON_VALID, (SqlOperator)SqlStdOperatorTable.IS_JSON_VALUE);
            this.registerOperator(BuiltinFunctionName.JSON_SET, PPLBuiltinOperators.JSON_SET);
            this.registerOperator(BuiltinFunctionName.JSON_DELETE, PPLBuiltinOperators.JSON_DELETE);
            this.registerOperator(BuiltinFunctionName.JSON_APPEND, PPLBuiltinOperators.JSON_APPEND);
            this.registerOperator(BuiltinFunctionName.JSON_EXTEND, PPLBuiltinOperators.JSON_EXTEND);
            this.register(BuiltinFunctionName.TRIM, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), builder.makeLiteral(" "), arg}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.STRING)));
            this.register(BuiltinFunctionName.LTRIM, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.LEADING), builder.makeLiteral(" "), arg}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.STRING)));
            this.register(BuiltinFunctionName.RTRIM, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), builder.makeLiteral(" "), arg}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.STRING)));
            this.register(BuiltinFunctionName.ATAN, AbstractBuilder.createFunctionImpWithTypeChecker((TriFunction<RexBuilder, RexNode, RexNode, RexNode>)((TriFunction)(builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.ATAN2, new RexNode[]{arg1, arg2})), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC)));
            this.register(BuiltinFunctionName.STRCMP, AbstractBuilder.createFunctionImpWithTypeChecker((TriFunction<RexBuilder, RexNode, RexNode, RexNode>)((TriFunction)(builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.STRCMP, new RexNode[]{arg2, arg1})), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
            this.register(BuiltinFunctionName.SUBSTRING, AbstractBuilder.wrapWithCompositeTypeChecker((SqlOperator)SqlStdOperatorTable.SUBSTRING, (CompositeOperandTypeChecker)OperandTypes.STRING_INTEGER.or(OperandTypes.STRING_INTEGER_INTEGER), false));
            this.register(BuiltinFunctionName.SUBSTR, AbstractBuilder.wrapWithCompositeTypeChecker((SqlOperator)SqlStdOperatorTable.SUBSTRING, (CompositeOperandTypeChecker)OperandTypes.STRING_INTEGER.or(OperandTypes.STRING_INTEGER_INTEGER), false));
            this.register(BuiltinFunctionName.INTERNAL_ITEM, AbstractBuilder.wrapWithCompositeTypeChecker(SqlStdOperatorTable.ITEM, (CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.ANY})), false));
            this.register(BuiltinFunctionName.LOG, AbstractBuilder.createFunctionImpWithTypeChecker((TriFunction<RexBuilder, RexNode, RexNode, RexNode>)((TriFunction)(builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg2, arg1})), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC)));
            this.register(BuiltinFunctionName.LOG, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg, builder.makeApproxLiteral(BigDecimal.valueOf(Math.E))}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.NUMERIC)));
            this.register(BuiltinFunctionName.SQRT, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{arg, builder.makeApproxLiteral(BigDecimal.valueOf(0.5))}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.NUMERIC)));
            this.register(BuiltinFunctionName.TYPEOF, (builder, arg) -> builder.makeLiteral(OpenSearchTypeFactory.getLegacyTypeName(arg.getType(), QueryType.PPL)));
            this.register(BuiltinFunctionName.XOR, new XOR_FUNC());
            this.register(BuiltinFunctionName.IF, AbstractBuilder.wrapWithImplicitCastTypeChecker((SqlOperator)SqlStdOperatorTable.CASE, (ImplicitCastOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BOOLEAN, SqlTypeFamily.ANY, SqlTypeFamily.ANY})));
            this.register(BuiltinFunctionName.NULLIF, AbstractBuilder.createFunctionImpWithTypeChecker((TriFunction<RexBuilder, RexNode, RexNode, RexNode>)((TriFunction)(builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{arg1, arg2}), builder.makeNullLiteral(arg1.getType()), arg1})), (PPLTypeChecker)PPLTypeChecker.wrapComparable((SameOperandTypeChecker)OperandTypes.SAME_SAME)));
            this.register(BuiltinFunctionName.IS_EMPTY, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg}), builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_EMPTY, new RexNode[]{arg})}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.ANY)));
            this.register(BuiltinFunctionName.IS_BLANK, AbstractBuilder.createFunctionImpWithTypeChecker((RexBuilder builder, RexNode arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg}), builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_EMPTY, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), builder.makeLiteral(" "), arg})})}), (PPLTypeChecker)PPLTypeChecker.family(SqlTypeFamily.ANY)));
        }
    }

    public static interface FunctionImp2
    extends FunctionImp {
        public static final PPLTypeChecker IGNORE_2 = PPLTypeChecker.family(SqlTypeFamily.IGNORE, SqlTypeFamily.IGNORE);

        public RexNode resolve(RexBuilder var1, RexNode var2, RexNode var3);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException("This function requires exactly 2 arguments");
            }
            return this.resolve(builder, args[0], args[1]);
        }

        @Override
        default public PPLTypeChecker getTypeChecker() {
            return IGNORE_2;
        }
    }

    public static interface FunctionImp1
    extends FunctionImp {
        public static final PPLTypeChecker IGNORE_1 = PPLTypeChecker.family(SqlTypeFamily.IGNORE);

        public RexNode resolve(RexBuilder var1, RexNode var2);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("This function requires exactly 1 arguments");
            }
            return this.resolve(builder, args[0]);
        }

        @Override
        default public PPLTypeChecker getTypeChecker() {
            return IGNORE_1;
        }
    }
}

