/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import shaded.com.google.common.collect.Lists;

public interface PPLTypeChecker {
    public boolean checkOperandTypes(List<RelDataType> var1);

    public String getAllowedSignatures();

    private static boolean validateOperands(List<SqlTypeFamily> funcTypeFamilies, List<RelDataType> operandTypes) {
        if (funcTypeFamilies.size() != operandTypes.size()) {
            return false;
        }
        for (int i = 0; i < operandTypes.size(); ++i) {
            SqlTypeName paramType = UserDefinedFunctionUtils.convertRelDataTypeToSqlTypeName(operandTypes.get(i));
            SqlTypeFamily funcTypeFamily = funcTypeFamilies.get(i);
            if (paramType.getFamily() == SqlTypeFamily.IGNORE || funcTypeFamily == SqlTypeFamily.IGNORE || funcTypeFamily.getTypeNames().contains(paramType)) continue;
            return false;
        }
        return true;
    }

    public static PPLFamilyTypeChecker family(SqlTypeFamily ... families) {
        return new PPLFamilyTypeChecker(families);
    }

    public static PPLFamilyTypeCheckerWrapper wrapFamily(ImplicitCastOperandTypeChecker typeChecker) {
        return new PPLFamilyTypeCheckerWrapper(typeChecker);
    }

    public static PPLCompositeTypeChecker wrapComposite(CompositeOperandTypeChecker typeChecker, boolean checkCompositionType) throws IllegalArgumentException, UnsupportedOperationException {
        if (checkCompositionType) {
            try {
                if (!PPLTypeChecker.isCompositionOr(typeChecker)) {
                    throw new IllegalArgumentException("Currently only support CompositeOperandTypeChecker with a OR composition");
                }
            }
            catch (ReflectiveOperationException | SecurityException | InaccessibleObjectException e) {
                throw new UnsupportedOperationException(String.format("Failed to check composition type of %s", typeChecker), e);
            }
        }
        for (SqlOperandTypeChecker rule : typeChecker.getRules()) {
            if (rule instanceof ImplicitCastOperandTypeChecker) continue;
            throw new IllegalArgumentException("Currently only compositions of ImplicitCastOperandTypeChecker are supported, found:" + rule.getClass().getName());
        }
        return new PPLCompositeTypeChecker(typeChecker);
    }

    public static PPLComparableTypeChecker wrapComparable(SameOperandTypeChecker typeChecker) {
        return new PPLComparableTypeChecker(typeChecker);
    }

    private static List<String> getFamilySignatures(FamilyOperandTypeChecker typeChecker) {
        SqlOperandCountRange operandCountRange = typeChecker.getOperandCountRange();
        int min = operandCountRange.getMin();
        int max = operandCountRange.getMax();
        ArrayList<String> allowedSignatures = new ArrayList<String>();
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        for (int i = 0; i < min; ++i) {
            families.add(typeChecker.getOperandSqlTypeFamily(i));
        }
        allowedSignatures.add(PPLTypeChecker.getFamilySignature(families));
        int MAX_ARGS = 10;
        max = Math.min(max, 10);
        for (int i = min; i < max; ++i) {
            families.add(typeChecker.getOperandSqlTypeFamily(i));
            allowedSignatures.add(PPLTypeChecker.getFamilySignature(families));
        }
        return allowedSignatures;
    }

    private static List<ExprType> getExprTypes(SqlTypeFamily family) {
        List<RelDataType> concreteTypes = switch (family) {
            case SqlTypeFamily.DATETIME -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.DATE), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.TIME), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.TIMESTAMP));
            case SqlTypeFamily.NUMERIC -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.DOUBLE));
            case SqlTypeFamily.INTEGER -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER));
            case SqlTypeFamily.ANY, SqlTypeFamily.IGNORE -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY));
            default -> {
                RelDataType type = family.getDefaultConcreteType((RelDataTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY);
                if (type == null) {
                    yield List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.OTHER));
                }
                yield List.of(type);
            }
        };
        return concreteTypes.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).collect(Collectors.toList());
    }

    private static String getFamilySignature(List<SqlTypeFamily> families) {
        List exprTypes = families.stream().map(PPLTypeChecker::getExprTypes).collect(Collectors.toList());
        List signatures = Lists.cartesianProduct(exprTypes);
        return signatures.stream().map(types -> "[" + types.stream().map(t -> t == ExprCoreType.UNDEFINED ? "ANY" : t.toString()).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(","));
    }

    private static boolean isCompositionOr(CompositeOperandTypeChecker typeChecker) throws NoSuchFieldException, IllegalAccessException, InaccessibleObjectException, SecurityException {
        Field compositionField = CompositeOperandTypeChecker.class.getDeclaredField("composition");
        compositionField.setAccessible(true);
        CompositeOperandTypeChecker.Composition composition = (CompositeOperandTypeChecker.Composition)compositionField.get(typeChecker);
        return composition == CompositeOperandTypeChecker.Composition.OR;
    }

    public static class PPLFamilyTypeChecker
    implements PPLTypeChecker {
        private final List<SqlTypeFamily> families;

        public PPLFamilyTypeChecker(SqlTypeFamily ... families) {
            this.families = List.of(families);
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            if (this.families.size() != types.size()) {
                return false;
            }
            return PPLTypeChecker.validateOperands(this.families, types);
        }

        @Override
        public String getAllowedSignatures() {
            return PPLTypeChecker.getFamilySignature(this.families);
        }

        public String toString() {
            return String.format("PPLFamilyTypeChecker[families=%s]", this.getAllowedSignatures());
        }
    }

    public static class PPLFamilyTypeCheckerWrapper
    implements PPLTypeChecker {
        protected final ImplicitCastOperandTypeChecker innerTypeChecker;

        public PPLFamilyTypeCheckerWrapper(ImplicitCastOperandTypeChecker typeChecker) {
            this.innerTypeChecker = typeChecker;
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            SqlOperandTypeChecker sqlOperandTypeChecker;
            ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = this.innerTypeChecker;
            if (implicitCastOperandTypeChecker instanceof SqlOperandTypeChecker && !(sqlOperandTypeChecker = (SqlOperandTypeChecker)implicitCastOperandTypeChecker).getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            List<SqlTypeFamily> families = IntStream.range(0, types.size()).mapToObj(arg_0 -> ((ImplicitCastOperandTypeChecker)this.innerTypeChecker).getOperandSqlTypeFamily(arg_0)).collect(Collectors.toList());
            return PPLTypeChecker.validateOperands(families, types);
        }

        @Override
        public String getAllowedSignatures() {
            ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = this.innerTypeChecker;
            if (implicitCastOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)implicitCastOperandTypeChecker;
                List<String> allowedSignatures = PPLTypeChecker.getFamilySignatures(familyOperandTypeChecker);
                return String.join((CharSequence)",", allowedSignatures);
            }
            return "";
        }
    }

    public static class PPLCompositeTypeChecker
    implements PPLTypeChecker {
        private final List<? extends SqlOperandTypeChecker> allowedRules;

        public PPLCompositeTypeChecker(CompositeOperandTypeChecker typeChecker) {
            this.allowedRules = typeChecker.getRules();
        }

        private static boolean validateWithFamilyTypeChecker(SqlOperandTypeChecker checker, List<RelDataType> types) {
            if (!checker.getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            if (checker instanceof ImplicitCastOperandTypeChecker) {
                ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = (ImplicitCastOperandTypeChecker)checker;
                List<SqlTypeFamily> families = IntStream.range(0, types.size()).mapToObj(arg_0 -> ((ImplicitCastOperandTypeChecker)implicitCastOperandTypeChecker).getOperandSqlTypeFamily(arg_0)).toList();
                return PPLTypeChecker.validateOperands(families, types);
            }
            throw new IllegalArgumentException("Currently only compositions of ImplicitCastOperandTypeChecker are supported");
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            boolean operandCountValid = this.allowedRules.stream().anyMatch(rule -> rule.getOperandCountRange().isValidCount(types.size()));
            if (!operandCountValid) {
                return false;
            }
            return this.allowedRules.stream().anyMatch(rule -> PPLCompositeTypeChecker.validateWithFamilyTypeChecker(rule, types));
        }

        @Override
        public String getAllowedSignatures() {
            ArrayList<String> allowedSignatures = new ArrayList<String>();
            for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
                if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                    FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                    allowedSignatures.addAll(PPLTypeChecker.getFamilySignatures(familyOperandTypeChecker));
                    continue;
                }
                throw new IllegalArgumentException("Currently only compositions of FamilyOperandTypeChecker are supported");
            }
            return String.join((CharSequence)",", allowedSignatures);
        }
    }

    public static class PPLComparableTypeChecker
    implements PPLTypeChecker {
        private final SameOperandTypeChecker innerTypeChecker;

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            if (!this.innerTypeChecker.getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            for (int i = 0; i < types.size() - 1; ++i) {
                RelDataType type_r;
                RelDataType type_l = types.get(i);
                if (!SqlTypeUtil.isComparable((RelDataType)type_l, (RelDataType)(type_r = types.get(i + 1)))) {
                    if (PPLComparableTypeChecker.areIpAndStringTypes(type_l, type_r) || PPLComparableTypeChecker.areIpAndStringTypes(type_r, type_l)) continue;
                    return false;
                }
                if ((type_l.getFamily() != SqlTypeFamily.CHARACTER || !PPLComparableTypeChecker.cannotConvertStringInCompare((SqlTypeFamily)type_r.getFamily())) && (type_r.getFamily() != SqlTypeFamily.CHARACTER || !PPLComparableTypeChecker.cannotConvertStringInCompare((SqlTypeFamily)type_l.getFamily()))) continue;
                return false;
            }
            return true;
        }

        private static boolean cannotConvertStringInCompare(SqlTypeFamily typeFamily) {
            return switch (typeFamily) {
                case SqlTypeFamily.BOOLEAN, SqlTypeFamily.INTEGER, SqlTypeFamily.NUMERIC, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.APPROXIMATE_NUMERIC -> true;
                default -> false;
            };
        }

        private static boolean areIpAndStringTypes(RelDataType typeIp, RelDataType typeString) {
            if (typeIp instanceof AbstractExprRelDataType) {
                AbstractExprRelDataType exprRelDataType = (AbstractExprRelDataType)typeIp;
                return exprRelDataType.getExprType() == ExprCoreType.IP && typeString.getFamily() == SqlTypeFamily.CHARACTER;
            }
            return false;
        }

        @Override
        public String getAllowedSignatures() {
            int min = this.innerTypeChecker.getOperandCountRange().getMin();
            int max = this.innerTypeChecker.getOperandCountRange().getMax();
            String typeName = "COMPARABLE_TYPE";
            if (min == -1 || max == -1) {
                return String.format("[%s...]", "COMPARABLE_TYPE");
            }
            ArrayList<CallSite> signatures = new ArrayList<CallSite>();
            int MAX_ARGS = 10;
            max = Math.min(10, max);
            for (int i = min; i <= max; ++i) {
                signatures.add((CallSite)((Object)("[" + String.join((CharSequence)",", Collections.nCopies(i, "COMPARABLE_TYPE")) + "]")));
            }
            return String.join((CharSequence)",", signatures);
        }

        @Generated
        public PPLComparableTypeChecker(SameOperandTypeChecker innerTypeChecker) {
            this.innerTypeChecker = innerTypeChecker;
        }
    }
}

