/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class TimestampAddFunction
extends ImplementorUDF {
    public TimestampAddFunction() {
        super(new TimestampAddImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIMESTAMP_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME})));
    }

    public static class TimestampAddImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ExprType timestampBaseType = OpenSearchTypeFactory.convertRelDataTypeToExprType(((RexNode)call.getOperands().get(2)).getType());
            MethodCallExpression timestampBase = Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{translatedOperands.get(2), Expressions.constant((Object)timestampBaseType)});
            if (ExprCoreType.TIME.equals(timestampBaseType)) {
                return Expressions.call(TimestampAddImplementor.class, (String)"timestampAddForTimeType", (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1), timestampBase, translator.getRoot()});
            }
            return Expressions.call(TimestampAddImplementor.class, (String)"timestampAdd", (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1), timestampBase});
        }

        public static String timestampAddForTimeType(String addUnit, long amount, ExprValue timestampBase, DataContext propertyContext) {
            FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(propertyContext);
            return (String)DateTimeFunctions.exprTimestampAddForTimeType(restored.getQueryStartClock(), new ExprStringValue(addUnit), new ExprLongValue(amount), timestampBase).valueForCalcite();
        }

        public static String timestampAdd(String addUnit, long amount, ExprValue timestampBase) {
            ExprValue returnValue = DateTimeFunctions.exprTimestampAdd(new ExprStringValue(addUnit), new ExprLongValue(amount), timestampBase);
            return (String)returnValue.valueForCalcite();
        }
    }
}

