/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.CompositeAggregationParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.NoBucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.response.agg.SingleValueParser;
import org.opensearch.sql.opensearch.response.agg.StatsParser;
import shaded.com.google.common.base.Throwables;
import shaded.com.google.common.collect.ImmutableList;

public class AggregateAnalyzer {
    public static final int AGGREGATION_BUCKET_SIZE = 1000;
    private static final String METADATA_FIELD = "_index";

    private AggregateAnalyzer() {
    }

    public static Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> analyze(Aggregate aggregate, List<String> schema, Map<String, ExprType> fieldTypes, List<String> outputFields) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(aggregate, "aggregate");
        try {
            List groupList = aggregate.getGroupSet().asList();
            FieldExpressionCreator fieldExpressionCreator = fieldIndex -> new PredicateAnalyzer.NamedFieldExpression(fieldIndex, schema, fieldTypes);
            Pair<AggregatorFactories.Builder, List<MetricParser>> builderAndParser = AggregateAnalyzer.processAggregateCalls(groupList.size(), aggregate.getAggCallList(), fieldExpressionCreator, outputFields);
            AggregatorFactories.Builder metricBuilder = (AggregatorFactories.Builder)builderAndParser.getLeft();
            List metricParserList = (List)builderAndParser.getRight();
            if (aggregate.getGroupSet().isEmpty()) {
                return Pair.of((Object)ImmutableList.copyOf((Collection)metricBuilder.getAggregatorFactories()), (Object)new NoBucketAggregationParser(metricParserList));
            }
            List<CompositeValuesSourceBuilder<?>> buckets = AggregateAnalyzer.createCompositeBuckets(groupList, fieldExpressionCreator);
            return Pair.of(Collections.singletonList(((CompositeAggregationBuilder)AggregationBuilders.composite((String)"composite_buckets", buckets).subAggregations(metricBuilder)).size(1000)), (Object)new CompositeAggregationParser(metricParserList));
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, UnsupportedOperationException.class);
            throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(aggregate), e);
        }
    }

    private static Pair<AggregatorFactories.Builder, List<MetricParser>> processAggregateCalls(int groupOffset, List<AggregateCall> aggCalls, FieldExpressionCreator fieldExpressionCreator, List<String> outputFields) {
        assert (aggCalls.size() + groupOffset == outputFields.size()) : "groups size and agg calls size should match with output fields";
        AggregatorFactories.Builder metricBuilder = new AggregatorFactories.Builder();
        ArrayList<MetricParser> metricParserList = new ArrayList<MetricParser>();
        for (int i = 0; i < aggCalls.size(); ++i) {
            AggregateCall aggCall = aggCalls.get(i);
            String argStr = aggCall.getAggregation().kind == SqlKind.COUNT && aggCall.getArgList().isEmpty() ? METADATA_FIELD : fieldExpressionCreator.create((Integer)aggCall.getArgList().getFirst()).getReferenceForTermQuery();
            String aggField = outputFields.get(groupOffset + i);
            Pair<ValuesSourceAggregationBuilder<?>, MetricParser> builderAndParser = AggregateAnalyzer.createAggregationBuilderAndParser(aggCall, argStr, aggField);
            metricBuilder.addAggregator((AggregationBuilder)builderAndParser.getLeft());
            metricParserList.add((MetricParser)builderAndParser.getRight());
        }
        return Pair.of((Object)metricBuilder, metricParserList);
    }

    private static Pair<ValuesSourceAggregationBuilder<?>, MetricParser> createAggregationBuilderAndParser(AggregateCall aggCall, String argStr, String aggField) {
        if (aggCall.isDistinct()) {
            return AggregateAnalyzer.createDistinctAggregation(aggCall, argStr, aggField);
        }
        return AggregateAnalyzer.createRegularAggregation(aggCall, argStr, aggField);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<ValuesSourceAggregationBuilder<?>, MetricParser> createDistinctAggregation(AggregateCall aggCall, String argStr, String aggField) {
        switch (aggCall.getAggregation().kind) {
            case COUNT: {
                return Pair.of((Object)AggregationBuilders.cardinality((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            }
            default: {
                throw new AggregateAnalyzerException(String.format("unsupported distinct aggregator %s", aggCall.getAggregation()));
            }
        }
    }

    private static Pair<ValuesSourceAggregationBuilder<?>, MetricParser> createRegularAggregation(AggregateCall aggCall, String argStr, String aggField) {
        return switch (aggCall.getAggregation().kind) {
            case SqlKind.AVG -> Pair.of((Object)AggregationBuilders.avg((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            case SqlKind.SUM -> Pair.of((Object)AggregationBuilders.sum((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            case SqlKind.COUNT -> Pair.of((Object)AggregationBuilders.count((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            case SqlKind.MIN -> Pair.of((Object)AggregationBuilders.min((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            case SqlKind.MAX -> Pair.of((Object)AggregationBuilders.max((String)aggField).field(argStr), (Object)new SingleValueParser(aggField));
            case SqlKind.VAR_SAMP -> Pair.of((Object)AggregationBuilders.extendedStats((String)aggField).field(argStr), (Object)new StatsParser(ExtendedStats::getVarianceSampling, aggField));
            case SqlKind.VAR_POP -> Pair.of((Object)AggregationBuilders.extendedStats((String)aggField).field(argStr), (Object)new StatsParser(ExtendedStats::getVariancePopulation, aggField));
            case SqlKind.STDDEV_SAMP -> Pair.of((Object)AggregationBuilders.extendedStats((String)aggField).field(argStr), (Object)new StatsParser(ExtendedStats::getStdDeviationSampling, aggField));
            case SqlKind.STDDEV_POP -> Pair.of((Object)AggregationBuilders.extendedStats((String)aggField).field(argStr), (Object)new StatsParser(ExtendedStats::getStdDeviationPopulation, aggField));
            default -> throw new AggregateAnalyzerException(String.format("unsupported aggregator %s", aggCall.getAggregation()));
        };
    }

    private static List<CompositeValuesSourceBuilder<?>> createCompositeBuckets(List<Integer> groupList, FieldExpressionCreator fieldExpressionCreator) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int groupIndex : groupList) {
            PredicateAnalyzer.NamedFieldExpression groupExpr = fieldExpressionCreator.create(groupIndex);
            CompositeValuesSourceBuilder<?> sourceBuilder = AggregateAnalyzer.createTermsSourceBuilder(groupExpr);
            resultBuilder.add(sourceBuilder);
        }
        return resultBuilder.build();
    }

    private static CompositeValuesSourceBuilder<?> createTermsSourceBuilder(PredicateAnalyzer.NamedFieldExpression groupExpr) {
        CompositeValuesSourceBuilder sourceBuilder = ((TermsValuesSourceBuilder)((TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(groupExpr.getRootName()).missingBucket(true)).missingOrder(MissingOrder.FIRST)).order(SortOrder.ASC)).field(groupExpr.getReferenceForTermQuery());
        if (List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(groupExpr.getExprType())) {
            sourceBuilder.userValuetypeHint(ValueType.LONG);
        }
        return sourceBuilder;
    }

    private static interface FieldExpressionCreator {
        public PredicateAnalyzer.NamedFieldExpression create(int var1);
    }

    public static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class AggregateAnalyzerException
    extends RuntimeException {
        AggregateAnalyzerException(String message) {
            super(message);
        }

        AggregateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }
}

