/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.setting;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.sql.common.setting.Settings;
import shaded.com.google.common.annotations.VisibleForTesting;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class OpenSearchSettings
extends org.opensearch.sql.common.setting.Settings {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenSearchSettings.class);
    private final Map<Settings.Key, Setting<?>> defaultSettings;
    @VisibleForTesting
    private final Map<Settings.Key, Object> latestSettings = new ConcurrentHashMap<Settings.Key, Object>();
    public static final Setting<?> SQL_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.SQL_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> SQL_SLOWLOG_SETTING = Setting.intSetting((String)Settings.Key.SQL_SLOWLOG.getKeyValue(), (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> SQL_CURSOR_KEEP_ALIVE_SETTING = Setting.positiveTimeSetting((String)Settings.Key.SQL_CURSOR_KEEP_ALIVE.getKeyValue(), (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> PPL_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.PPL_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> DEFAULT_PATTERN_METHOD_SETTING = Setting.simpleString((String)Settings.Key.PATTERN_METHOD.getKeyValue(), (String)"SIMPLE_PATTERN", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> DEFAULT_PATTERN_MODE_SETTING = Setting.simpleString((String)Settings.Key.PATTERN_MODE.getKeyValue(), (String)"LABEL", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> DEFAULT_PATTERN_MAX_SAMPLE_COUNT_SETTING = Setting.intSetting((String)Settings.Key.PATTERN_MAX_SAMPLE_COUNT.getKeyValue(), (int)10, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> DEFAULT_PATTERN_BUFFER_LIMIT_SETTING = Setting.intSetting((String)Settings.Key.PATTERN_BUFFER_LIMIT.getKeyValue(), (int)100000, (int)50000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> CALCITE_ENGINE_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.CALCITE_ENGINE_ENABLED.getKeyValue(), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> CALCITE_FALLBACK_ALLOWED_SETTING = Setting.boolSetting((String)Settings.Key.CALCITE_FALLBACK_ALLOWED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> CALCITE_PUSHDOWN_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.CALCITE_PUSHDOWN_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Double> CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR_SETTING = Setting.doubleSetting((String)Settings.Key.CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR.getKeyValue(), (double)0.9, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> QUERY_MEMORY_LIMIT_SETTING = Setting.memorySizeSetting((String)Settings.Key.QUERY_MEMORY_LIMIT.getKeyValue(), (String)"85%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> QUERY_SIZE_LIMIT_SETTING = Setting.intSetting((String)Settings.Key.QUERY_SIZE_LIMIT.getKeyValue(), (Setting)IndexSettings.MAX_RESULT_WINDOW_SETTING, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> METRICS_ROLLING_WINDOW_SETTING = Setting.longSetting((String)Settings.Key.METRICS_ROLLING_WINDOW.getKeyValue(), (long)3600L, (long)2L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> METRICS_ROLLING_INTERVAL_SETTING = Setting.longSetting((String)Settings.Key.METRICS_ROLLING_INTERVAL.getKeyValue(), (long)60L, (long)1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<InputStream> DATASOURCE_CONFIG = SecureSetting.secureFile((String)"plugins.query.federation.datasources.config", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated});
    public static final Setting<String> DATASOURCE_MASTER_SECRET_KEY = Setting.simpleString((String)Settings.Key.ENCYRPTION_MASTER_KEY.getKeyValue(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final, Setting.Property.Filtered});
    public static final Setting<List<String>> DATASOURCE_URI_HOSTS_DENY_LIST = Setting.listSetting((String)Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST.getKeyValue(), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> DATASOURCE_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.DATASOURCES_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> ASYNC_QUERY_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.ASYNC_QUERY_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<String> ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL_SETTING = Setting.simpleString((String)Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL.getKeyValue(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<String> SPARK_EXECUTION_ENGINE_CONFIG = Setting.simpleString((String)Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG.getKeyValue(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> SPARK_EXECUTION_SESSION_LIMIT_SETTING = Setting.intSetting((String)Settings.Key.SPARK_EXECUTION_SESSION_LIMIT.getKeyValue(), (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> SPARK_EXECUTION_REFRESH_JOB_LIMIT_SETTING = Setting.intSetting((String)Settings.Key.SPARK_EXECUTION_REFRESH_JOB_LIMIT.getKeyValue(), (int)5, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SESSION_INDEX_TTL_SETTING = Setting.positiveTimeSetting((String)Settings.Key.SESSION_INDEX_TTL.getKeyValue(), (TimeValue)TimeValue.timeValueDays((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> RESULT_INDEX_TTL_SETTING = Setting.positiveTimeSetting((String)Settings.Key.RESULT_INDEX_TTL.getKeyValue(), (TimeValue)TimeValue.timeValueDays((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> AUTO_INDEX_MANAGEMENT_ENABLED_SETTING = Setting.boolSetting((String)Settings.Key.AUTO_INDEX_MANAGEMENT_ENABLED.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> DATASOURCES_LIMIT_SETTING = Setting.intSetting((String)Settings.Key.DATASOURCES_LIMIT.getKeyValue(), (int)20, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> SESSION_INACTIVITY_TIMEOUT_MILLIS_SETTING = Setting.longSetting((String)Settings.Key.SESSION_INACTIVITY_TIMEOUT_MILLIS.getKeyValue(), (long)180000L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> STREAMING_JOB_HOUSEKEEPER_INTERVAL_SETTING = Setting.positiveTimeSetting((String)Settings.Key.STREAMING_JOB_HOUSEKEEPER_INTERVAL.getKeyValue(), (TimeValue)TimeValue.timeValueMinutes((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<?> FIELD_TYPE_TOLERANCE_SETTING = Setting.boolSetting((String)Settings.Key.FIELD_TYPE_TOLERANCE.getKeyValue(), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public OpenSearchSettings(ClusterSettings clusterSettings) {
        ImmutableMap.Builder settingBuilder = new ImmutableMap.Builder();
        this.register(settingBuilder, clusterSettings, Settings.Key.SQL_ENABLED, SQL_ENABLED_SETTING, new Updater(Settings.Key.SQL_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.SQL_SLOWLOG, SQL_SLOWLOG_SETTING, new Updater(Settings.Key.SQL_SLOWLOG));
        this.register(settingBuilder, clusterSettings, Settings.Key.SQL_CURSOR_KEEP_ALIVE, SQL_CURSOR_KEEP_ALIVE_SETTING, new Updater(Settings.Key.SQL_CURSOR_KEEP_ALIVE));
        this.register(settingBuilder, clusterSettings, Settings.Key.PPL_ENABLED, PPL_ENABLED_SETTING, new Updater(Settings.Key.PPL_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.PATTERN_METHOD, DEFAULT_PATTERN_METHOD_SETTING, new Updater(Settings.Key.PATTERN_METHOD));
        this.register(settingBuilder, clusterSettings, Settings.Key.PATTERN_MODE, DEFAULT_PATTERN_MODE_SETTING, new Updater(Settings.Key.PATTERN_MODE));
        this.register(settingBuilder, clusterSettings, Settings.Key.PATTERN_MAX_SAMPLE_COUNT, DEFAULT_PATTERN_MAX_SAMPLE_COUNT_SETTING, new Updater(Settings.Key.PATTERN_MAX_SAMPLE_COUNT));
        this.register(settingBuilder, clusterSettings, Settings.Key.PATTERN_BUFFER_LIMIT, DEFAULT_PATTERN_BUFFER_LIMIT_SETTING, new Updater(Settings.Key.PATTERN_BUFFER_LIMIT));
        this.register(settingBuilder, clusterSettings, Settings.Key.CALCITE_ENGINE_ENABLED, CALCITE_ENGINE_ENABLED_SETTING, new Updater(Settings.Key.CALCITE_ENGINE_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.CALCITE_FALLBACK_ALLOWED, CALCITE_FALLBACK_ALLOWED_SETTING, new Updater(Settings.Key.CALCITE_FALLBACK_ALLOWED));
        this.register(settingBuilder, clusterSettings, Settings.Key.CALCITE_PUSHDOWN_ENABLED, CALCITE_PUSHDOWN_ENABLED_SETTING, new Updater(Settings.Key.CALCITE_PUSHDOWN_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR, CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR_SETTING, new Updater(Settings.Key.CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR));
        this.register(settingBuilder, clusterSettings, Settings.Key.QUERY_MEMORY_LIMIT, QUERY_MEMORY_LIMIT_SETTING, new Updater(Settings.Key.QUERY_MEMORY_LIMIT));
        this.register(settingBuilder, clusterSettings, Settings.Key.QUERY_SIZE_LIMIT, QUERY_SIZE_LIMIT_SETTING, new Updater(Settings.Key.QUERY_SIZE_LIMIT));
        this.register(settingBuilder, clusterSettings, Settings.Key.METRICS_ROLLING_WINDOW, METRICS_ROLLING_WINDOW_SETTING, new Updater(Settings.Key.METRICS_ROLLING_WINDOW));
        this.register(settingBuilder, clusterSettings, Settings.Key.METRICS_ROLLING_INTERVAL, METRICS_ROLLING_INTERVAL_SETTING, new Updater(Settings.Key.METRICS_ROLLING_INTERVAL));
        this.register(settingBuilder, clusterSettings, Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST, DATASOURCE_URI_HOSTS_DENY_LIST, new Updater(Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST));
        this.register(settingBuilder, clusterSettings, Settings.Key.DATASOURCES_ENABLED, DATASOURCE_ENABLED_SETTING, new Updater(Settings.Key.DATASOURCES_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.ASYNC_QUERY_ENABLED, ASYNC_QUERY_ENABLED_SETTING, new Updater(Settings.Key.ASYNC_QUERY_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED, ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED_SETTING, new Updater(Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL, ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL_SETTING, new Updater(Settings.Key.ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL));
        this.register(settingBuilder, clusterSettings, Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG, SPARK_EXECUTION_ENGINE_CONFIG, new Updater(Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG));
        this.register(settingBuilder, clusterSettings, Settings.Key.SPARK_EXECUTION_SESSION_LIMIT, SPARK_EXECUTION_SESSION_LIMIT_SETTING, new Updater(Settings.Key.SPARK_EXECUTION_SESSION_LIMIT));
        this.register(settingBuilder, clusterSettings, Settings.Key.SPARK_EXECUTION_REFRESH_JOB_LIMIT, SPARK_EXECUTION_REFRESH_JOB_LIMIT_SETTING, new Updater(Settings.Key.SPARK_EXECUTION_REFRESH_JOB_LIMIT));
        this.register(settingBuilder, clusterSettings, Settings.Key.SESSION_INDEX_TTL, SESSION_INDEX_TTL_SETTING, new Updater(Settings.Key.SESSION_INDEX_TTL));
        this.register(settingBuilder, clusterSettings, Settings.Key.RESULT_INDEX_TTL, RESULT_INDEX_TTL_SETTING, new Updater(Settings.Key.RESULT_INDEX_TTL));
        this.register(settingBuilder, clusterSettings, Settings.Key.AUTO_INDEX_MANAGEMENT_ENABLED, AUTO_INDEX_MANAGEMENT_ENABLED_SETTING, new Updater(Settings.Key.AUTO_INDEX_MANAGEMENT_ENABLED));
        this.register(settingBuilder, clusterSettings, Settings.Key.DATASOURCES_LIMIT, DATASOURCES_LIMIT_SETTING, new Updater(Settings.Key.DATASOURCES_LIMIT));
        this.registerNonDynamicSettings(settingBuilder, clusterSettings, Settings.Key.CLUSTER_NAME, ClusterName.CLUSTER_NAME_SETTING);
        this.register(settingBuilder, clusterSettings, Settings.Key.SESSION_INACTIVITY_TIMEOUT_MILLIS, SESSION_INACTIVITY_TIMEOUT_MILLIS_SETTING, new Updater(Settings.Key.SESSION_INACTIVITY_TIMEOUT_MILLIS));
        this.register(settingBuilder, clusterSettings, Settings.Key.STREAMING_JOB_HOUSEKEEPER_INTERVAL, STREAMING_JOB_HOUSEKEEPER_INTERVAL_SETTING, new Updater(Settings.Key.STREAMING_JOB_HOUSEKEEPER_INTERVAL));
        this.register(settingBuilder, clusterSettings, Settings.Key.FIELD_TYPE_TOLERANCE, FIELD_TYPE_TOLERANCE_SETTING, new Updater(Settings.Key.FIELD_TYPE_TOLERANCE));
        this.defaultSettings = settingBuilder.build();
    }

    @Override
    public <T> T getSettingValue(Settings.Key key) {
        return (T)this.latestSettings.getOrDefault((Object)key, this.defaultSettings.get((Object)key).getDefault(Settings.EMPTY));
    }

    private void register(ImmutableMap.Builder<Settings.Key, Setting<?>> settingBuilder, ClusterSettings clusterSettings, Settings.Key key, Setting setting, Consumer<Object> updater) {
        if (clusterSettings.get(setting) != null) {
            this.latestSettings.put(key, clusterSettings.get(setting));
        }
        settingBuilder.put((Object)key, (Object)setting);
        clusterSettings.addSettingsUpdateConsumer(setting, updater);
    }

    private void registerNonDynamicSettings(ImmutableMap.Builder<Settings.Key, Setting<?>> settingBuilder, ClusterSettings clusterSettings, Settings.Key key, Setting setting) {
        settingBuilder.put((Object)key, (Object)setting);
        this.latestSettings.put(key, clusterSettings.get(setting));
    }

    public static List<Setting<?>> pluginSettings() {
        return new ImmutableList.Builder().add(SQL_ENABLED_SETTING).add(SQL_SLOWLOG_SETTING).add(SQL_CURSOR_KEEP_ALIVE_SETTING).add(PPL_ENABLED_SETTING).add(CALCITE_ENGINE_ENABLED_SETTING).add(CALCITE_FALLBACK_ALLOWED_SETTING).add(CALCITE_PUSHDOWN_ENABLED_SETTING).add(CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR_SETTING).add(DEFAULT_PATTERN_METHOD_SETTING).add(DEFAULT_PATTERN_MODE_SETTING).add(DEFAULT_PATTERN_MAX_SAMPLE_COUNT_SETTING).add(DEFAULT_PATTERN_BUFFER_LIMIT_SETTING).add(QUERY_MEMORY_LIMIT_SETTING).add(QUERY_SIZE_LIMIT_SETTING).add(METRICS_ROLLING_WINDOW_SETTING).add(METRICS_ROLLING_INTERVAL_SETTING).add(DATASOURCE_URI_HOSTS_DENY_LIST).add(DATASOURCE_ENABLED_SETTING).add(ASYNC_QUERY_ENABLED_SETTING).add(ASYNC_QUERY_EXTERNAL_SCHEDULER_ENABLED_SETTING).add(ASYNC_QUERY_EXTERNAL_SCHEDULER_INTERVAL_SETTING).add(SPARK_EXECUTION_ENGINE_CONFIG).add(SPARK_EXECUTION_SESSION_LIMIT_SETTING).add(SPARK_EXECUTION_REFRESH_JOB_LIMIT_SETTING).add(SESSION_INDEX_TTL_SETTING).add(RESULT_INDEX_TTL_SETTING).add(AUTO_INDEX_MANAGEMENT_ENABLED_SETTING).add(DATASOURCES_LIMIT_SETTING).add(SESSION_INACTIVITY_TIMEOUT_MILLIS_SETTING).add(STREAMING_JOB_HOUSEKEEPER_INTERVAL_SETTING).add(FIELD_TYPE_TOLERANCE_SETTING).build();
    }

    public static List<Setting<?>> pluginNonDynamicSettings() {
        return new ImmutableList.Builder().add(DATASOURCE_MASTER_SECRET_KEY).add(DATASOURCE_CONFIG).build();
    }

    public List<Setting<?>> getSettings() {
        return OpenSearchSettings.pluginSettings();
    }

    @VisibleForTesting
    class Updater
    implements Consumer {
        private final Settings.Key key;

        public void accept(Object newValue) {
            log.debug("The value of setting [{}] changed to [{}]", (Object)this.key, newValue);
            OpenSearchSettings.this.latestSettings.put(this.key, newValue);
        }

        @Generated
        public Updater(Settings.Key key) {
            this.key = key;
        }
    }
}

