/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChunkResult {
    private final int chunkIndex;
    private final int totalChunks;
    private final boolean isLastChunk;
    private final Map<Integer, String> succeededChunks;
    private final Map<Integer, String> failedChunks;

    public ChunkResult(int chunkIndex, String response, String error, int totalChunks, boolean isLastChunk) {
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.isLastChunk = isLastChunk;
        this.succeededChunks = new HashMap<Integer, String>();
        this.failedChunks = new HashMap<Integer, String>();
        if (error != null) {
            this.failedChunks.put(chunkIndex, error);
        } else {
            this.succeededChunks.put(chunkIndex, response);
        }
    }

    public ChunkResult(int chunkIndex, int totalChunks, boolean isLastChunk, Map<Integer, String> succeededChunks, Map<Integer, String> failedChunks) {
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.isLastChunk = isLastChunk;
        this.succeededChunks = new HashMap<Integer, String>(succeededChunks);
        this.failedChunks = new HashMap<Integer, String>(failedChunks);
    }

    public int getSuccessfulChunksCount() {
        return this.succeededChunks.size();
    }

    public int getFailedChunksCount() {
        return this.failedChunks.size();
    }

    public Map<Integer, String> getSucceededChunks() {
        return Collections.unmodifiableMap(this.succeededChunks);
    }

    public Map<Integer, String> getFailedChunks() {
        return Collections.unmodifiableMap(this.failedChunks);
    }

    public boolean isLastChunk() {
        return this.isLastChunk;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }
}

