/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats.events;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.opensearch.searchrelevance.stats.events.EventStat;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.events.TimestampedEventStatSnapshot;

public class TimestampedEventStat
implements EventStat {
    private static final long TRAILING_BUCKET_INTERVAL_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final int TRAILING_NUMBER_OF_INTERVALS = 5;
    private EventStatName statName;
    private long lastEventTimestamp;
    private LongAdder totalCounter;
    private Bucket[] buckets;

    public TimestampedEventStat(EventStatName statName) {
        this.statName = statName;
        this.lastEventTimestamp = 0L;
        this.totalCounter = new LongAdder();
        this.buckets = new Bucket[6];
        for (int i = 0; i < 6; ++i) {
            this.buckets[i] = new Bucket(this);
        }
    }

    @Override
    public long getValue() {
        return this.totalCounter.longValue();
    }

    @Override
    public void increment() {
        this.totalCounter.increment();
        this.lastEventTimestamp = this.getCurrentTimeInMillis();
        this.incrementCurrentBucket();
    }

    private void incrementCurrentBucket() {
        long now = this.getCurrentTimeInMillis();
        long currentBucketTime = now - now % TRAILING_BUCKET_INTERVAL_MS;
        int bucketIndex = (int)(now / TRAILING_BUCKET_INTERVAL_MS % 6L);
        Bucket bucket = this.buckets[bucketIndex];
        long bucketTimestamp = bucket.timestamp.get();
        if (bucketTimestamp != currentBucketTime && bucket.timestamp.compareAndSet(bucketTimestamp, currentBucketTime)) {
            bucket.count.reset();
        }
        bucket.count.add(1L);
    }

    public long getTrailingIntervalValue() {
        long now = this.getCurrentTimeInMillis();
        long currentBucketTime = now - now % TRAILING_BUCKET_INTERVAL_MS;
        long cutoff = now - 5L * TRAILING_BUCKET_INTERVAL_MS;
        long alignedCutoff = cutoff / TRAILING_BUCKET_INTERVAL_MS * TRAILING_BUCKET_INTERVAL_MS;
        long sum = 0L;
        for (Bucket bucket : this.buckets) {
            long timestamp = bucket.timestamp.get();
            if (timestamp < alignedCutoff || timestamp >= currentBucketTime) continue;
            sum += bucket.count.longValue();
        }
        return sum;
    }

    public long getMinutesSinceLastEvent() {
        long currentTimestamp = this.getCurrentTimeInMillis();
        return currentTimestamp / 60000L - this.lastEventTimestamp / 60000L;
    }

    public TimestampedEventStatSnapshot getStatSnapshot() {
        return TimestampedEventStatSnapshot.builder().statName(this.statName).value(this.getValue()).trailingIntervalValue(this.getTrailingIntervalValue()).minutesSinceLastEvent(this.getMinutesSinceLastEvent()).build();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].timestamp.set(0L);
            this.buckets[i].count.reset();
        }
        this.totalCounter.reset();
        this.lastEventTimestamp = 0L;
    }

    @VisibleForTesting
    protected long getCurrentTimeInMillis() {
        return System.currentTimeMillis();
    }

    private class Bucket {
        AtomicLong timestamp = new AtomicLong(0L);
        LongAdder count = new LongAdder();

        private Bucket(TimestampedEventStat timestampedEventStat) {
        }
    }
}

