/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.experiment.ExperimentOptionsFactory;
import org.opensearch.searchrelevance.experiment.ExperimentOptionsForHybridSearch;
import org.opensearch.searchrelevance.experiment.ExperimentVariantHybridSearchDTO;
import org.opensearch.searchrelevance.metrics.MetricsHelper;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.SearchConfiguration;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class PutExperimentTransportAction
extends HandledTransportAction<PutExperimentRequest, IndexResponse> {
    private final ClusterService clusterService;
    private final ExperimentDao experimentDao;
    private final ExperimentVariantDao experimentVariantDao;
    private final QuerySetDao querySetDao;
    private final SearchConfigurationDao searchConfigurationDao;
    private final MetricsHelper metricsHelper;
    private static final Logger LOGGER = LogManager.getLogger(PutExperimentTransportAction.class);

    @Inject
    public PutExperimentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ExperimentDao experimentDao, ExperimentVariantDao experimentVariantDao, QuerySetDao querySetDao, SearchConfigurationDao searchConfigurationDao, MetricsHelper metricsHelper) {
        super("cluster:admin/opensearch/search_relevance/experiment/create", transportService, actionFilters, PutExperimentRequest::new);
        this.clusterService = clusterService;
        this.experimentDao = experimentDao;
        this.experimentVariantDao = experimentVariantDao;
        this.querySetDao = querySetDao;
        this.searchConfigurationDao = searchConfigurationDao;
        this.metricsHelper = metricsHelper;
    }

    protected void doExecute(Task task, PutExperimentRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            String id = UUID.randomUUID().toString();
            Experiment initialExperiment = new Experiment(id, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.PROCESSING, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), new ArrayList<Map<String, Object>>());
            this.experimentDao.putExperiment(initialExperiment, ActionListener.wrap(response -> {
                listener.onResponse((Object)((IndexResponse)response));
                this.triggerAsyncProcessing(id, request);
            }, e -> {
                LOGGER.error("Failed to create initial experiment", (Throwable)e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to create initial experiment", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (Exception e2) {
            LOGGER.error("Failed to process experiment request", (Throwable)e2);
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to process experiment request", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    private void triggerAsyncProcessing(String experimentId, PutExperimentRequest request) {
        try {
            QuerySet querySet = this.querySetDao.getQuerySetSync(request.getQuerySetId());
            List<String> queryTextWithReferences = querySet.querySetQueries().stream().map(e -> e.queryText()).collect(Collectors.toList());
            List searchConfigurations = request.getSearchConfigurationList().stream().map(id -> this.searchConfigurationDao.getSearchConfigurationSync((String)id)).collect(Collectors.toList());
            HashMap<String, List<String>> indexAndQueries = new HashMap<String, List<String>>();
            for (SearchConfiguration config : searchConfigurations) {
                indexAndQueries.put(config.id(), Arrays.asList(config.index(), config.query(), config.searchPipeline()));
            }
            this.calculateMetricsAsync(experimentId, request, indexAndQueries, queryTextWithReferences);
        }
        catch (Exception e2) {
            this.handleAsyncFailure(experimentId, request, "Failed to start async processing", e2);
        }
    }

    private void calculateMetricsAsync(String experimentId, PutExperimentRequest request, Map<String, List<String>> indexAndQueries, List<String> queryTextWithReferences) {
        if (queryTextWithReferences == null || indexAndQueries == null) {
            throw new IllegalStateException("Missing required data for metrics calculation");
        }
        this.processQueryTextMetrics(experimentId, request, indexAndQueries, queryTextWithReferences);
    }

    private void processQueryTextMetrics(String experimentId, PutExperimentRequest request, Map<String, List<String>> indexAndQueries, List<String> queryTexts) {
        List<Map<String, Object>> finalResults = Collections.synchronizedList(new ArrayList());
        AtomicInteger pendingQueries = new AtomicInteger(queryTexts.size());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        this.executeExperimentEvaluation(experimentId, request, indexAndQueries, queryTexts, finalResults, pendingQueries, hasFailure, request.getJudgmentList());
    }

    private void executeExperimentEvaluation(String experimentId, PutExperimentRequest request, Map<String, List<String>> indexAndQueries, List<String> queryTexts, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, AtomicBoolean hasFailure, List<String> judgmentList) {
        for (String queryText : queryTexts) {
            if (request.getType() == ExperimentType.PAIRWISE_COMPARISON) {
                this.metricsHelper.processPairwiseMetrics(queryText, indexAndQueries, request.getSize(), (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)));
                continue;
            }
            if (request.getType() == ExperimentType.HYBRID_OPTIMIZER) {
                Map<String, Object> defaultParametersForHybridSearch = ExperimentOptionsFactory.createDefaultExperimentParametersForHybridSearch();
                ExperimentOptionsForHybridSearch experimentOptionForHybridSearch = (ExperimentOptionsForHybridSearch)ExperimentOptionsFactory.createExperimentOptions("HYBRID_SEARCH_EXPERIMENT_OPTIONS", defaultParametersForHybridSearch);
                List<ExperimentVariantHybridSearchDTO> experimentVariantDTOs = experimentOptionForHybridSearch.getParameterCombinations(true);
                ArrayList<ExperimentVariant> experimentVariants = new ArrayList<ExperimentVariant>();
                for (ExperimentVariantHybridSearchDTO experimentVariantDTO : experimentVariantDTOs) {
                    HashMap<String, float[]> parameters = new HashMap<String, float[]>(Map.of("normalization", experimentVariantDTO.getNormalizationTechnique(), "combination", experimentVariantDTO.getCombinationTechnique(), "weights", experimentVariantDTO.getQueryWeightsForCombination()));
                    String experimentVariantId = UUID.randomUUID().toString();
                    ExperimentVariant experimentVariant = new ExperimentVariant(experimentVariantId, TimeUtils.getTimestamp(), ExperimentType.HYBRID_OPTIMIZER, AsyncStatus.PROCESSING, experimentId, parameters, Map.of());
                    experimentVariants.add(experimentVariant);
                    this.experimentVariantDao.putExperimentVariant(experimentVariant, ActionListener.wrap(response -> {}, e -> {}));
                }
                this.metricsHelper.processEvaluationMetrics(queryText, indexAndQueries, request.getSize(), judgmentList, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> {
                    HashMap<String, Object> convertedResults = new HashMap<String, Object>((Map<String, Object>)queryResults);
                    this.handleQueryResults(queryText, convertedResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList);
                }, error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)), experimentVariants);
                continue;
            }
            if (request.getType() == ExperimentType.POINTWISE_EVALUATION) {
                this.metricsHelper.processEvaluationMetrics(queryText, indexAndQueries, request.getSize(), judgmentList, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> {
                    HashMap<String, Object> convertedResults = new HashMap<String, Object>((Map<String, Object>)queryResults);
                    this.handleQueryResults(queryText, convertedResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList);
                }, error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)));
                continue;
            }
            throw new SearchRelevanceException("Unknown experimentType" + String.valueOf((Object)request.getType()), RestStatus.BAD_REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryResults(String queryText, Map<String, Object> queryResults, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, String experimentId, PutExperimentRequest request, AtomicBoolean hasFailure, List<String> judgmentList) {
        if (hasFailure.get()) {
            return;
        }
        try {
            List<Map<String, Object>> list = finalResults;
            synchronized (list) {
                queryResults.put("queryText", queryText);
                finalResults.add(queryResults);
                if (pendingQueries.decrementAndGet() == 0) {
                    this.updateFinalExperiment(experimentId, request, finalResults, judgmentList);
                }
            }
        }
        catch (Exception e) {
            this.handleFailure(e, hasFailure, experimentId, request);
        }
    }

    private void handleFailure(Exception error, AtomicBoolean hasFailure, String experimentId, PutExperimentRequest request) {
        if (hasFailure.compareAndSet(false, true)) {
            this.handleAsyncFailure(experimentId, request, "Failed to process metrics", error);
        }
    }

    private void updateFinalExperiment(String experimentId, PutExperimentRequest request, List<Map<String, Object>> finalResults, List<String> judgmentList) {
        Experiment finalExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.COMPLETED, request.getQuerySetId(), request.getSearchConfigurationList(), judgmentList, request.getSize(), finalResults);
        this.experimentDao.updateExperiment(finalExperiment, ActionListener.wrap(response -> LOGGER.debug("Updated final experiment: {}", (Object)experimentId), error -> this.handleAsyncFailure(experimentId, request, "Failed to update final experiment", (Exception)error)));
    }

    private void handleAsyncFailure(String experimentId, PutExperimentRequest request, String message, Exception error) {
        LOGGER.error(message + " for experiment: " + experimentId, (Throwable)error);
        Experiment errorExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.ERROR, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), List.of(Map.of("error", error.getMessage())));
        this.experimentDao.updateExperiment(errorExperiment, ActionListener.wrap(response -> LOGGER.info("Updated experiment {} status to ERROR", (Object)experimentId), e -> LOGGER.error("Failed to update error status for experiment: " + experimentId, (Throwable)e)));
    }
}

