/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.PublishFindingsRequest;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertService;
import org.opensearch.securityanalytics.correlation.alert.CorrelationRuleScheduler;
import org.opensearch.securityanalytics.correlation.alert.notifications.NotificationService;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.CorrelationQuery;
import org.opensearch.securityanalytics.model.CorrelationRule;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.transport.TransportCorrelateFindingAction;
import org.opensearch.securityanalytics.util.AutoCorrelationsRepo;
import org.opensearch.transport.client.Client;

public class JoinEngine {
    private final Client client;
    private final PublishFindingsRequest request;
    private final NamedXContentRegistry xContentRegistry;
    private volatile long corrTimeWindow;
    private volatile boolean enableAutoCorrelations;
    private final TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction;
    private final LogTypeService logTypeService;
    private final CorrelationAlertService correlationAlertService;
    private final NotificationService notificationService;
    private volatile TimeValue indexTimeout;
    private static final Logger log = LogManager.getLogger(JoinEngine.class);
    private final User user;

    public JoinEngine(Client client, PublishFindingsRequest request, NamedXContentRegistry xContentRegistry, long corrTimeWindow, TimeValue indexTimeout, TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction, LogTypeService logTypeService, boolean enableAutoCorrelations, CorrelationAlertService correlationAlertService, NotificationService notificationService, User user) {
        this.client = client;
        this.request = request;
        this.xContentRegistry = xContentRegistry;
        this.corrTimeWindow = corrTimeWindow;
        this.indexTimeout = indexTimeout;
        this.correlateFindingAction = correlateFindingAction;
        this.logTypeService = logTypeService;
        this.enableAutoCorrelations = enableAutoCorrelations;
        this.correlationAlertService = correlationAlertService;
        this.notificationService = notificationService;
        this.user = user;
    }

    public void onSearchDetectorResponse(Detector detector, Finding finding) {
        try {
            if (this.enableAutoCorrelations) {
                this.generateAutoCorrelations(detector, finding);
            } else {
                this.onAutoCorrelations(detector, finding, Map.of());
            }
        }
        catch (IOException ex) {
            this.onFailure(ex);
        }
    }

    private void generateAutoCorrelations(Detector detector, Finding finding) throws IOException {
        Map<String, Set<String>> autoCorrelations = AutoCorrelationsRepo.autoCorrelationsAsMap();
        long findingTimestamp = finding.getTimestamp().toEpochMilli();
        HashSet<String> tags = new HashSet<String>();
        for (DocLevelQuery query : finding.getDocLevelQueries()) {
            tags.addAll(query.getTags().stream().filter(tag -> tag.startsWith("attack.")).collect(Collectors.toList()));
        }
        Set<String> validIntrusionSets = AutoCorrelationsRepo.validIntrusionSets(autoCorrelations, tags);
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"source", (Object)"Sigma");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(100);
        SearchRequest request = new SearchRequest();
        request.source(searchSourceBuilder);
        this.logTypeService.searchLogTypes(request, (ActionListener<SearchResponse>)ActionListener.wrap(response -> {
            MultiSearchRequest mSearchRequest = new MultiSearchRequest();
            SearchHit[] logTypes = response.getHits().getHits();
            ArrayList<String> logTypeNames = new ArrayList<String>();
            for (SearchHit logType : logTypes) {
                String logTypeName = logType.getSourceAsMap().get("name").toString();
                logTypeNames.add(logTypeName);
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - this.corrTimeWindow)).lte((Object)(findingTimestamp + this.corrTimeWindow));
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                sourceBuilder.query((QueryBuilder)rangeQueryBuilder);
                sourceBuilder.size(10000);
                sourceBuilder.fetchField("queries");
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(logTypeName)});
                searchRequest.source(sourceBuilder);
                searchRequest.preference(Preference.PRIMARY_FIRST.type());
                searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
                mSearchRequest.add(searchRequest);
            }
            if (!mSearchRequest.requests().isEmpty()) {
                this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    HashMap<String, List<String>> autoCorrelationsMap = new HashMap<String, List<String>>();
                    int idx = 0;
                    for (MultiSearchResponse.Item item : responses) {
                        SearchHit[] findings;
                        if (item.isFailure()) {
                            log.info(item.getFailureMessage());
                            continue;
                        }
                        String logTypeName = (String)logTypeNames.get(idx);
                        for (SearchHit foundFinding : findings = item.getResponse().getHits().getHits()) {
                            Object query2;
                            if (foundFinding.getId().equals(finding.getId())) continue;
                            HashSet<String> findingTags = new HashSet<String>();
                            List queries = (List)foundFinding.getSourceAsMap().get("queries");
                            for (Object query2 : queries) {
                                List queryTags = (List)query2.get("tags");
                                findingTags.addAll(queryTags.stream().filter(queryTag -> queryTag.startsWith("attack.")).collect(Collectors.toList()));
                            }
                            boolean canCorrelate = false;
                            query2 = tags.iterator();
                            while (query2.hasNext()) {
                                String tag = (String)query2.next();
                                if (!findingTags.contains(tag)) continue;
                                canCorrelate = true;
                                break;
                            }
                            Set<String> foundIntrusionSets = AutoCorrelationsRepo.validIntrusionSets(autoCorrelations, findingTags);
                            for (String validIntrusionSet : validIntrusionSets) {
                                if (!foundIntrusionSets.contains(validIntrusionSet)) continue;
                                canCorrelate = true;
                                break;
                            }
                            if (!canCorrelate) continue;
                            if (autoCorrelationsMap.containsKey(logTypeName)) {
                                ((List)autoCorrelationsMap.get(logTypeName)).add(foundFinding.getId());
                                continue;
                            }
                            ArrayList<String> autoCorrelatedFindings = new ArrayList<String>();
                            autoCorrelatedFindings.add(foundFinding.getId());
                            autoCorrelationsMap.put(logTypeName, autoCorrelatedFindings);
                        }
                        ++idx;
                    }
                    this.onAutoCorrelations(detector, finding, autoCorrelationsMap);
                }, this::onFailure));
            } else {
                this.onFailure((Exception)new OpenSearchStatusException("Empty findings for all log types", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, this::onFailure));
    }

    private void onAutoCorrelations(Detector detector, Finding finding, Map<String, List<String>> autoCorrelations) {
        String detectorType = detector.getDetectorType().toLowerCase(Locale.ROOT);
        List<String> indices = detector.getInputs().get(0).getIndices();
        List relatedDocIds = finding.getCorrelatedDocIds();
        NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"correlate", (QueryBuilder)QueryBuilders.matchQuery((String)"correlate.category", (Object)detectorType), (ScoreMode)ScoreMode.None);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(true);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".opensearch-sap-correlation-rules-config"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            if (response.isTimedOut()) {
                this.onFailure((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
            }
            Iterator hits = response.getHits().iterator();
            ArrayList<CorrelationRule> correlationRules = new ArrayList<CorrelationRule>();
            while (hits.hasNext()) {
                SearchHit hit = (SearchHit)hits.next();
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                CorrelationRule rule = CorrelationRule.parse(xcp, hit.getId(), hit.getVersion());
                correlationRules.add(rule);
            }
            if (!correlationRules.isEmpty() || !autoCorrelations.isEmpty()) {
                this.getValidDocuments(detectorType, indices, correlationRules, relatedDocIds, autoCorrelations);
            } else {
                this.correlateFindingAction.onOperation();
            }
        }, e -> {
            try {
                log.error("[CORRELATIONS] Exception encountered while searching correlation rule index for finding id {}", (Object)finding.getId(), e);
                if (!autoCorrelations.isEmpty()) {
                    this.getValidDocuments(detectorType, indices, List.of(), List.of(), autoCorrelations);
                } else {
                    this.correlateFindingAction.onOperation();
                }
            }
            catch (Exception ex) {
                this.onFailure(ex);
            }
        }));
    }

    private void getValidDocuments(String detectorType, List<String> indices, List<CorrelationRule> correlationRules, List<String> relatedDocIds, Map<String, List<String>> autoCorrelations) {
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        ArrayList<CorrelationRule> validCorrelationRules = new ArrayList<CorrelationRule>();
        ArrayList<String> validFields = new ArrayList<String>();
        for (CorrelationRule rule : correlationRules) {
            Optional<CorrelationQuery> query = rule.getCorrelationQueries().stream().filter(correlationQuery -> correlationQuery.getCategory().equals(detectorType)).findFirst();
            if (!query.isPresent()) continue;
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", relatedDocIds));
            queryBuilder = query.get().getField() != null ? queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)query.get().getField())) : queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)query.get().getQuery()));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            if (query.get().getField() != null) {
                searchSourceBuilder.fetchField(query.get().getField());
            }
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(indices.toArray(new String[0]));
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            validCorrelationRules.add(rule);
            validFields.add(query.get().getField());
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                MultiSearchResponse.Item[] responses = items.getResponses();
                ArrayList<FilteredCorrelationRule> filteredCorrelationRules = new ArrayList<FilteredCorrelationRule>();
                int idx = 0;
                for (MultiSearchResponse.Item response : responses) {
                    if (response.isFailure()) {
                        log.info(response.getFailureMessage());
                        continue;
                    }
                    if ((long)response.getResponse().getHits().getHits().length > 0L) {
                        filteredCorrelationRules.add(new FilteredCorrelationRule((CorrelationRule)validCorrelationRules.get(idx), response.getResponse().getHits().getHits(), (String)validFields.get(idx)));
                    }
                    ++idx;
                }
                HashMap<String, List<CorrelationQuery>> categoryToQueriesMap = new HashMap<String, List<CorrelationQuery>>();
                HashMap<String, Long> categoryToTimeWindowMap = new HashMap<String, Long>();
                for (FilteredCorrelationRule rule : filteredCorrelationRules) {
                    List<CorrelationQuery> queries = rule.correlationRule.getCorrelationQueries();
                    Long timeWindow = rule.correlationRule.getCorrTimeWindow();
                    for (CorrelationQuery query : queries) {
                        List correlationQueries = categoryToQueriesMap.containsKey(query.getCategory()) ? (List)categoryToQueriesMap.get(query.getCategory()) : new ArrayList();
                        if (categoryToTimeWindowMap.containsKey(query.getCategory())) {
                            categoryToTimeWindowMap.put(query.getCategory(), Math.max(timeWindow, (Long)categoryToTimeWindowMap.get(query.getCategory())));
                        } else {
                            categoryToTimeWindowMap.put(query.getCategory(), timeWindow);
                        }
                        if (query.getField() == null) {
                            correlationQueries.add(query);
                        } else {
                            SearchHit[] hits = rule.filteredDocs;
                            StringBuilder qb = new StringBuilder(query.getField()).append(":(");
                            for (int i = 0; i < hits.length; ++i) {
                                String value = (String)hits[i].field(rule.field).getValue();
                                qb.append(value);
                                if (i < hits.length - 1) {
                                    qb.append(" OR ");
                                    continue;
                                }
                                qb.append(")");
                            }
                            if (query.getQuery() != null) {
                                qb.append(" AND ").append(query.getQuery());
                            }
                            correlationQueries.add(new CorrelationQuery(query.getIndex(), qb.toString(), query.getCategory(), null));
                        }
                        categoryToQueriesMap.put(query.getCategory(), correlationQueries);
                    }
                }
                this.searchFindingsByTimestamp(detectorType, categoryToQueriesMap, categoryToTimeWindowMap, filteredCorrelationRules.stream().map(it -> it.correlationRule).collect(Collectors.toList()), autoCorrelations);
            }, this::onFailure));
        } else {
            this.getTimestampFeature(detectorType, List.of(), autoCorrelations);
        }
    }

    private void searchFindingsByTimestamp(String detectorType, Map<String, List<CorrelationQuery>> categoryToQueriesMap, Map<String, Long> categoryToTimeWindowMap, List<CorrelationRule> correlationRules, Map<String, List<String>> autoCorrelations) {
        long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        ArrayList<Pair> categoryToQueriesPairs = new ArrayList<Pair>();
        for (Map.Entry<String, List<CorrelationQuery>> categoryToQueries : categoryToQueriesMap.entrySet()) {
            RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - categoryToTimeWindowMap.get(categoryToQueries.getKey()))).lte((Object)(findingTimestamp + categoryToTimeWindowMap.get(categoryToQueries.getKey())));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            searchSourceBuilder.fetchField("correlated_doc_ids");
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(categoryToQueries.getKey())});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            mSearchRequest.add(searchRequest);
            categoryToQueriesPairs.add(Pair.of((Object)categoryToQueries.getKey(), categoryToQueries.getValue()));
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                MultiSearchResponse.Item[] responses = items.getResponses();
                HashMap<String, DocSearchCriteria> relatedDocsMap = new HashMap<String, DocSearchCriteria>();
                int idx = 0;
                for (MultiSearchResponse.Item response : responses) {
                    SearchHit[] hits;
                    if (response.isFailure()) {
                        log.info(response.getFailureMessage());
                        continue;
                    }
                    ArrayList<String> relatedDocIds = new ArrayList<String>();
                    for (SearchHit hit : hits = response.getResponse().getHits().getHits()) {
                        relatedDocIds.addAll(((DocumentField)hit.getFields().get("correlated_doc_ids")).getValues().stream().map(Object::toString).collect(Collectors.toList()));
                    }
                    List correlationQueries = (List)((Pair)categoryToQueriesPairs.get(idx)).getValue();
                    List<String> indices = correlationQueries.stream().map(CorrelationQuery::getIndex).collect(Collectors.toList());
                    List<String> queries = correlationQueries.stream().map(CorrelationQuery::getQuery).collect(Collectors.toList());
                    relatedDocsMap.put((String)((Pair)categoryToQueriesPairs.get(idx)).getKey(), new DocSearchCriteria(indices, queries, relatedDocIds));
                    ++idx;
                }
                this.searchDocsWithFilterKeys(detectorType, relatedDocsMap, categoryToTimeWindowMap, correlationRules, autoCorrelations);
            }, this::onFailure));
        } else {
            this.getTimestampFeature(detectorType, correlationRules.stream().map(CorrelationRule::getId).collect(Collectors.toList()), autoCorrelations);
        }
    }

    private void searchDocsWithFilterKeys(String detectorType, Map<String, DocSearchCriteria> relatedDocsMap, Map<String, Long> categoryToTimeWindowMap, List<CorrelationRule> correlationRules, Map<String, List<String>> autoCorrelations) {
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        ArrayList<String> categories = new ArrayList<String>();
        for (Map.Entry<String, DocSearchCriteria> docSearchCriteria : relatedDocsMap.entrySet()) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", docSearchCriteria.getValue().relatedDocIds));
            for (String query : docSearchCriteria.getValue().queries) {
                queryBuilder = queryBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)query));
            }
            queryBuilder.minimumShouldMatch(1).boost(1.0f);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(docSearchCriteria.getValue().indices.toArray(new String[0]));
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            categories.add(docSearchCriteria.getKey());
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                MultiSearchResponse.Item[] responses = items.getResponses();
                HashMap<String, List<String>> filteredRelatedDocIds = new HashMap<String, List<String>>();
                int idx = 0;
                for (MultiSearchResponse.Item response : responses) {
                    if (response.isFailure()) {
                        log.info(response.getFailureMessage());
                        continue;
                    }
                    SearchHit[] hits = response.getResponse().getHits().getHits();
                    ArrayList<String> docIds = new ArrayList<String>();
                    for (SearchHit hit : hits) {
                        docIds.add(hit.getId());
                    }
                    filteredRelatedDocIds.put((String)categories.get(idx), docIds);
                    ++idx;
                }
                this.getCorrelatedFindings(detectorType, filteredRelatedDocIds, categoryToTimeWindowMap, correlationRules, autoCorrelations);
            }, this::onFailure));
        } else {
            this.getTimestampFeature(detectorType, correlationRules.stream().map(CorrelationRule::getId).collect(Collectors.toList()), autoCorrelations);
        }
    }

    private void getCorrelatedFindings(String detectorType, Map<String, List<String>> filteredRelatedDocIds, Map<String, Long> categoryToTimeWindowMap, List<CorrelationRule> correlationRules, Map<String, List<String>> autoCorrelations) {
        long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
        MultiSearchRequest mSearchRequest = new MultiSearchRequest();
        ArrayList<String> categories = new ArrayList<String>();
        for (Map.Entry<String, List<String>> relatedDocIds : filteredRelatedDocIds.entrySet()) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - categoryToTimeWindowMap.get(relatedDocIds.getKey()))).lte((Object)(findingTimestamp + categoryToTimeWindowMap.get(relatedDocIds.getKey())))).must((QueryBuilder)QueryBuilders.termsQuery((String)"correlated_doc_ids", (Collection)relatedDocIds.getValue()));
            if (relatedDocIds.getKey().equals(detectorType)) {
                queryBuilder = queryBuilder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)this.request.getFinding().getId()));
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{DetectorMonitorConfig.getAllFindingsIndicesPattern(relatedDocIds.getKey())});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            categories.add(relatedDocIds.getKey());
            mSearchRequest.add(searchRequest);
        }
        if (!mSearchRequest.requests().isEmpty()) {
            this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                MultiSearchResponse.Item[] responses = items.getResponses();
                HashMap<String, List<String>> correlatedFindings = new HashMap<String, List<String>>();
                int idx = 0;
                for (MultiSearchResponse.Item response : responses) {
                    if (response.isFailure()) {
                        log.info(response.getFailureMessage());
                        ++idx;
                        continue;
                    }
                    SearchHit[] hits = response.getResponse().getHits().getHits();
                    ArrayList<String> findings = new ArrayList<String>();
                    for (SearchHit hit : hits) {
                        findings.add(hit.getId());
                    }
                    if (!findings.isEmpty()) {
                        correlatedFindings.put((String)categories.get(idx), findings);
                    }
                    ++idx;
                }
                if (!correlatedFindings.isEmpty()) {
                    CorrelationRuleScheduler correlationRuleScheduler = new CorrelationRuleScheduler(this.client, this.correlationAlertService, this.notificationService);
                    correlationRuleScheduler.schedule(correlationRules, correlatedFindings, this.request.getFinding().getId(), this.indexTimeout, this.user);
                }
                for (Map.Entry entry : autoCorrelations.entrySet()) {
                    if (correlatedFindings.containsKey(entry.getKey())) {
                        HashSet alreadyCorrelatedFindings = new HashSet((Collection)correlatedFindings.get(entry.getKey()));
                        alreadyCorrelatedFindings.addAll((Collection)entry.getValue());
                        correlatedFindings.put((String)entry.getKey(), new ArrayList(alreadyCorrelatedFindings));
                        continue;
                    }
                    correlatedFindings.put((String)entry.getKey(), (List)entry.getValue());
                }
                this.correlateFindingAction.initCorrelationIndex(detectorType, correlatedFindings, correlationRules.stream().map(CorrelationRule::getId).collect(Collectors.toList()));
            }, this::onFailure));
        } else {
            this.getTimestampFeature(detectorType, correlationRules.stream().map(CorrelationRule::getId).collect(Collectors.toList()), autoCorrelations);
        }
    }

    private void getTimestampFeature(String detectorType, List<String> correlationRules, Map<String, List<String>> autoCorrelations) {
        if (!autoCorrelations.isEmpty()) {
            this.correlateFindingAction.getTimestampFeature(detectorType, autoCorrelations, null, List.of());
        } else {
            this.correlateFindingAction.getTimestampFeature(detectorType, null, this.request.getFinding(), correlationRules);
        }
    }

    private void onFailure(Exception e) {
        this.correlateFindingAction.onFailures(e);
    }

    static class DocSearchCriteria {
        List<String> indices;
        List<String> queries;
        List<String> relatedDocIds;

        public DocSearchCriteria(List<String> indices, List<String> queries, List<String> relatedDocIds) {
            this.indices = indices;
            this.queries = queries;
            this.relatedDocIds = relatedDocIds;
        }
    }

    static class FilteredCorrelationRule {
        CorrelationRule correlationRule;
        SearchHit[] filteredDocs;
        String field;

        public FilteredCorrelationRule(CorrelationRule correlationRule, SearchHit[] filteredDocs, String field) {
            this.correlationRule = correlationRule;
            this.filteredDocs = filteredDocs;
            this.field = field;
        }
    }
}

