/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.findings;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.GetFindingsRequest;
import org.opensearch.commons.alerting.action.GetFindingsResponse;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.FindingWithDocs;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.PrefixQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.securityanalytics.action.FindingDto;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetDetectorRequest;
import org.opensearch.securityanalytics.action.GetDetectorResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class FindingsService {
    private Client client;
    private static final Logger log = LogManager.getLogger(FindingsService.class);

    public FindingsService() {
    }

    public FindingsService(Client client) {
        this.client = client;
    }

    public void getFindingsByDetectorId(final String detectorId, final Table table, final String severity, final String detectionType, final List<String> findingIds, final Instant startTime, final Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        this.client.execute((ActionType)GetDetectorAction.INSTANCE, (ActionRequest)new GetDetectorRequest(detectorId, -3L), (ActionListener)new ActionListener<GetDetectorResponse>(){

            public void onResponse(GetDetectorResponse getDetectorResponse) {
                Detector detector = getDetectorResponse.getDetector();
                ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> getFindingsResponseListener = new ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse>(){

                    public void onResponse(org.opensearch.securityanalytics.action.GetFindingsResponse resp) {
                        Integer totalFindings = 0;
                        ArrayList<FindingDto> findings = new ArrayList<FindingDto>();
                        totalFindings = totalFindings + resp.getTotalFindings();
                        findings.addAll(resp.getFindings());
                        org.opensearch.securityanalytics.action.GetFindingsResponse masterResponse = new org.opensearch.securityanalytics.action.GetFindingsResponse(totalFindings, findings);
                        listener.onResponse((Object)masterResponse);
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to fetch findings for detector " + detectorId, (Throwable)e);
                        listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
                    }
                };
                HashMap<String, Detector> monitorToDetectorMapping = new HashMap<String, Detector>();
                detector.getMonitorIds().forEach(monitorId -> {
                    if (detector.getRuleIdMonitorIdMap().containsKey("chained_findings_monitor")) {
                        if (!detector.getRuleIdMonitorIdMap().get("chained_findings_monitor").equals(monitorId)) {
                            monitorToDetectorMapping.put((String)monitorId, detector);
                        }
                    } else {
                        monitorToDetectorMapping.put((String)monitorId, detector);
                    }
                });
                FindingsService.this.getFindingsByMonitorIds(monitorToDetectorMapping, new ArrayList<String>(monitorToDetectorMapping.keySet()), DetectorMonitorConfig.getAllFindingsIndicesPattern(detector.getDetectorType()), table, severity, detectionType, findingIds, startTime, endTime, getFindingsResponseListener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void getFindingsByMonitorIds(final Map<String, Detector> monitorToDetectorMapping, List<String> monitorIds, String findingIndexName, Table table, String severity, String detectionType, List<String> findingIds, Instant startTime, Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        BoolQueryBuilder queryBuilder = FindingsService.getBoolQueryBuilder(detectionType, severity, findingIds, startTime, endTime);
        GetFindingsRequest req = new GetFindingsRequest(null, table, null, findingIndexName, monitorIds, queryBuilder);
        AlertingPluginInterface.INSTANCE.getFindings((NodeClient)this.client, req, (ActionListener)new ActionListener<GetFindingsResponse>(){

            public void onResponse(GetFindingsResponse getFindingsResponse) {
                listener.onResponse((Object)new org.opensearch.securityanalytics.action.GetFindingsResponse(getFindingsResponse.getTotalFindings(), getFindingsResponse.getFindings().stream().map(e -> FindingsService.this.mapFindingWithDocsToFindingDto((FindingWithDocs)e, (Detector)monitorToDetectorMapping.get(e.getFinding().getMonitorId()))).collect(Collectors.toList())));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static BoolQueryBuilder getBoolQueryBuilder(String detectionType, String severity, List<String> findingIds, Instant startTime, Instant endTime) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (detectionType != null && !detectionType.isBlank()) {
            BoolQueryBuilder nestedQuery = detectionType.equalsIgnoreCase("threat") ? QueryBuilders.boolQuery().filter((QueryBuilder)new PrefixQueryBuilder("queries.id", "threat_intel_")) : QueryBuilders.boolQuery().mustNot((QueryBuilder)new PrefixQueryBuilder("queries.id", "threat_intel_"));
            NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery((String)"queries", (QueryBuilder)nestedQuery, (ScoreMode)ScoreMode.None);
            boolQueryBuilder.must((QueryBuilder)nestedQueryBuilder);
        }
        if (findingIds != null && !findingIds.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"id", findingIds));
        }
        if (startTime != null && endTime != null) {
            long startTimeMillis = startTime.toEpochMilli();
            long endTimeMillis = endTime.toEpochMilli();
            RangeQueryBuilder timeRangeQuery = QueryBuilders.rangeQuery((String)"timestamp").from((Object)startTimeMillis).to((Object)endTimeMillis);
            boolQueryBuilder.filter((QueryBuilder)timeRangeQuery);
        }
        if (severity != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"queries", (QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"queries.tags", (Object)severity)), (ScoreMode)ScoreMode.None));
        }
        return boolQueryBuilder;
    }

    void setIndicesAdminClient(Client client) {
        this.client = client;
    }

    public void getFindings(final List<Detector> detectors, String logType, Table table, String severity, String detectionType, List<String> findingIds, Instant startTime, Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        if (detectors.size() == 0) {
            throw new OpenSearchStatusException("detector list is empty!", RestStatus.NOT_FOUND, new Object[0]);
        }
        ArrayList<String> allMonitorIds = new ArrayList<String>();
        HashMap<String, Detector> monitorToDetectorMapping = new HashMap<String, Detector>();
        detectors.forEach(detector -> {
            detector.getMonitorIds().forEach(monitorId -> monitorToDetectorMapping.put((String)monitorId, (Detector)detector));
            allMonitorIds.addAll(detector.getMonitorIds());
        });
        this.getFindingsByMonitorIds(monitorToDetectorMapping, allMonitorIds, DetectorMonitorConfig.getAllFindingsIndicesPattern(logType), table, severity, detectionType, findingIds, startTime, endTime, new ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse>(this){

            public void onResponse(org.opensearch.securityanalytics.action.GetFindingsResponse getFindingsResponse) {
                listener.onResponse((Object)getFindingsResponse);
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch findings for detectors: [" + detectors.stream().map(d -> d.getId()).collect(Collectors.joining(",")) + "]", (Throwable)e);
                listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
            }
        });
    }

    public FindingDto mapFindingWithDocsToFindingDto(FindingWithDocs findingWithDocs, Detector detector) {
        List<DocLevelQuery> docLevelQueries = findingWithDocs.getFinding().getDocLevelQueries();
        if (docLevelQueries.isEmpty()) {
            for (Map.Entry<String, String> entry : detector.getRuleIdMonitorIdMap().entrySet()) {
                if (!entry.getValue().equals(findingWithDocs.getFinding().getMonitorId())) continue;
                docLevelQueries = Collections.singletonList(new DocLevelQuery(entry.getKey(), "bucket_level_monitor", Collections.emptyList(), "", Collections.emptyList()));
            }
        }
        return new FindingDto(detector.getId(), findingWithDocs.getFinding().getId(), findingWithDocs.getFinding().getRelatedDocIds(), findingWithDocs.getFinding().getIndex(), docLevelQueries, findingWithDocs.getFinding().getTimestamp(), findingWithDocs.getDocuments());
    }
}

