/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.iocscan.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteMonitorTrigger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.correlation.alert.notifications.NotificationService;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.IocFindingService;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.ThreatIntelAlertService;
import org.opensearch.securityanalytics.threatIntel.iocscan.dto.IocScanContext;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.IoCScanService;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.ThreatIntelAlertContext;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelTrigger;
import org.opensearch.securityanalytics.threatIntel.model.monitor.TransportThreatIntelMonitorFanOutAction;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelMonitorUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.transport.client.Client;

public class SaIoCScanService
extends IoCScanService<SearchHit> {
    private static final Logger log = LogManager.getLogger(SaIoCScanService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final IocFindingService iocFindingService;
    private final ThreatIntelAlertService threatIntelAlertService;
    private final NotificationService notificationService;

    public SaIoCScanService(Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, IocFindingService iocFindingService, ThreatIntelAlertService threatIntelAlertService, NotificationService notificationService) {
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.iocFindingService = iocFindingService;
        this.threatIntelAlertService = threatIntelAlertService;
        this.notificationService = notificationService;
    }

    @Override
    void executeTriggers(List<STIX2IOC> maliciousIocs, List<IocFinding> iocFindings, IocScanContext<SearchHit> iocScanContext, List<SearchHit> searchHits, IoCScanService.IocLookupDtos iocLookupDtos, BiConsumer<List<ThreatIntelAlert>, Exception> triggerResultConsumer) {
        Monitor monitor = iocScanContext.getMonitor();
        if (maliciousIocs.isEmpty() || monitor.getTriggers().isEmpty()) {
            triggerResultConsumer.accept(Collections.emptyList(), null);
            return;
        }
        this.initAlertsIndex((ActionListener<Void>)ActionListener.wrap(r -> {
            GroupedActionListener<List<ThreatIntelAlert>> allTriggerResultListener = this.getGroupedListenerForAllTriggersResponse(iocScanContext.getMonitor(), triggerResultConsumer);
            for (Trigger trigger : monitor.getTriggers()) {
                this.executeTrigger(iocFindings, trigger, monitor, (ActionListener<List<ThreatIntelAlert>>)allTriggerResultListener);
            }
        }, e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {} Failed to execute triggers . Failed to initialize threat intel alerts index", (Object)monitor.getId()), (Throwable)e);
            triggerResultConsumer.accept(Collections.emptyList(), null);
        }));
    }

    private void executeTrigger(List<IocFinding> iocFindings, Trigger trigger, Monitor monitor, ActionListener<List<ThreatIntelAlert>> listener) {
        try {
            RemoteMonitorTrigger remoteMonitorTrigger = (RemoteMonitorTrigger)trigger;
            ThreatIntelTrigger threatIntelTrigger = ThreatIntelMonitorUtils.getThreatIntelTriggerFromBytesReference(remoteMonitorTrigger, this.xContentRegistry);
            ArrayList<IocFinding> triggerMatchedFindings = ThreatIntelMonitorUtils.getTriggerMatchedFindings(iocFindings, threatIntelTrigger);
            if (triggerMatchedFindings.isEmpty()) {
                log.debug("Threat intel monitor {} no matches for trigger {}", (Object)monitor.getId(), (Object)trigger.getName());
                listener.onResponse(Collections.emptyList());
            } else {
                this.fetchExistingAlertsForTrigger(monitor, triggerMatchedFindings, trigger, (ActionListener<List<ThreatIntelAlert>>)ActionListener.wrap(existingAlerts -> this.saveAlertsAndExecuteActions(iocFindings, trigger, monitor, (List<ThreatIntelAlert>)existingAlerts, triggerMatchedFindings, threatIntelTrigger, listener), e -> {
                    log.error(() -> new ParameterizedMessage("Threat intel monitor {} Failed to execute trigger {}. Failure while fetching existing alerts", (Object)monitor.getId(), (Object)trigger.getName()), (Throwable)e);
                    listener.onFailure(e);
                }));
            }
        }
        catch (Exception e2) {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {} Failed to execute trigger {}", (Object)monitor.getId(), (Object)trigger.getName()), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void saveAlertsAndExecuteActions(List<IocFinding> iocFindings, Trigger trigger, Monitor monitor, List<ThreatIntelAlert> existingAlerts, ArrayList<IocFinding> triggerMatchedFindings, ThreatIntelTrigger threatIntelTrigger, ActionListener<List<ThreatIntelAlert>> listener) {
        Map<String, ThreatIntelAlert> iocToUpdatedAlertsMap = ThreatIntelMonitorUtils.prepareAlertsToUpdate(triggerMatchedFindings, existingAlerts);
        List<ThreatIntelAlert> newAlerts = ThreatIntelMonitorUtils.prepareNewAlerts(monitor, trigger, triggerMatchedFindings, iocToUpdatedAlertsMap);
        ThreatIntelAlertContext ctx = new ThreatIntelAlertContext(threatIntelTrigger, trigger, iocFindings, monitor, newAlerts, existingAlerts);
        if (!trigger.getActions().isEmpty()) {
            this.saveAlerts(new ArrayList<ThreatIntelAlert>(iocToUpdatedAlertsMap.values()), newAlerts, monitor, (threatIntelAlerts, e) -> {
                if (e != null) {
                    log.error(String.format("Threat intel monitor %s: Failed to save alerts for trigger %s", monitor.getId(), trigger.getId()), (Throwable)e);
                    listener.onFailure(e);
                } else {
                    GroupedActionListener notifsListener = new GroupedActionListener(ActionListener.wrap(r -> listener.onResponse(threatIntelAlerts), ex -> {
                        log.error(String.format("Threat intel monitor {}: Failed to send notification for trigger {}", monitor.getId(), trigger.getId()), (Throwable)ex);
                        listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Failed to send notification", RestStatus.INTERNAL_SERVER_ERROR, (Exception)ex)));
                    }), trigger.getActions().size());
                    for (Action action : trigger.getActions()) {
                        try {
                            String transformedSubject = NotificationService.compileTemplate(ctx, action.getSubjectTemplate());
                            String transformedMessage = NotificationService.compileTemplate(ctx, action.getMessageTemplate());
                            String configId = action.getDestinationId();
                            this.notificationService.sendNotification(configId, trigger.getSeverity(), transformedSubject, transformedMessage, (ActionListener<Void>)notifsListener);
                        }
                        catch (Exception ex2) {
                            log.error(String.format("Threat intel monitor %s: Failed to send notification to %s for trigger %s", monitor.getId(), action.getDestinationId(), trigger.getId()), (Throwable)ex2);
                            notifsListener.onFailure((Exception)((Object)new SecurityAnalyticsException("Failed to send notification", RestStatus.INTERNAL_SERVER_ERROR, ex2)));
                        }
                    }
                }
            });
        } else {
            this.saveAlerts(new ArrayList<ThreatIntelAlert>(iocToUpdatedAlertsMap.values()), newAlerts, monitor, (threatIntelAlerts, e) -> {
                if (e != null) {
                    log.error(String.format("Threat intel monitor %s: Failed to save alerts for trigger %s", monitor.getId(), trigger.getId()), (Throwable)e);
                    listener.onFailure(e);
                } else {
                    listener.onResponse(threatIntelAlerts);
                }
            });
        }
    }

    private void fetchExistingAlertsForTrigger(Monitor monitor, ArrayList<IocFinding> findings, Trigger trigger, ActionListener<List<ThreatIntelAlert>> listener) {
        if (findings.isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        SearchSourceBuilder ssb = ThreatIntelMonitorUtils.getSearchSourceBuilderForExistingAlertsQuery(findings, trigger);
        this.threatIntelAlertService.search(ssb, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> {
            ArrayList<ThreatIntelAlert> alerts = new ArrayList<ThreatIntelAlert>();
            if (searchResponse.getHits() == null || searchResponse.getHits().getHits() == null) {
                listener.onResponse(alerts);
                return;
            }
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                if (xcp.currentToken() == null) {
                    xcp.nextToken();
                }
                ThreatIntelAlert alert = ThreatIntelAlert.parse(xcp, hit.getVersion());
                alerts.add(alert);
            }
            listener.onResponse(alerts);
        }, e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {} Failed to execute trigger {}. Unexpected error in fetching existing alerts for dedupe", (Object)monitor.getId(), (Object)trigger.getName()), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private GroupedActionListener<List<ThreatIntelAlert>> getGroupedListenerForAllTriggersResponse(Monitor monitor, BiConsumer<List<ThreatIntelAlert>, Exception> triggerResultConsumer) {
        return new GroupedActionListener(ActionListener.wrap(r -> {
            ArrayList list = new ArrayList();
            r.forEach(list::addAll);
            triggerResultConsumer.accept(list, null);
        }, e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {} Failed to execute triggers {}", (Object)monitor.getId()), (Throwable)e);
            triggerResultConsumer.accept(Collections.emptyList(), (Exception)e);
        }), monitor.getTriggers().size());
    }

    @Override
    void matchAgainstThreatIntelAndReturnMaliciousIocs(Map<String, Set<String>> iocsPerType, Monitor monitor, BiConsumer<List<STIX2IOC>, Exception> callback, Map<String, List<String>> iocTypeToIndices) {
        iocsPerType.forEach((s, strings) -> log.info("Threat intel monitor fanout : {} iocs to scan for ioc type {}", (Object)strings.size(), s));
        long startTime = System.currentTimeMillis();
        int numIocs = iocsPerType.values().stream().mapToInt(Set::size).sum();
        GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> groupedListenerForAllIocTypes = this.getGroupedListenerForIocScanFromAllIocTypes(iocsPerType, monitor, callback, startTime, numIocs);
        for (String iocType : iocsPerType.keySet()) {
            List<String> indices = iocTypeToIndices.get(iocType);
            iocsPerType.forEach((s, strings) -> log.info("Threat intel monitor fanout : {} iocs to scan for ioc type {}", (Object)strings.size(), s));
            Set<String> iocs = iocsPerType.get(iocType);
            if (iocTypeToIndices.containsKey(iocType)) {
                if (indices.isEmpty()) {
                    log.info("Threat intel monitor fanout {} : No ioc indices of type {} found so no scan performed.", (Object)monitor.getId(), (Object)iocType);
                    groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), null));
                    continue;
                }
                if (iocs.isEmpty()) {
                    log.info("Threat intel monitor fanout {} : No iocs of type {} found in user data so no scan performed.", (Object)monitor.getId(), (Object)iocType);
                    groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), null));
                    continue;
                }
                this.performScanForMaliciousIocsPerIocType(indices, iocs, monitor, iocType, groupedListenerForAllIocTypes);
                continue;
            }
            iocsPerType.forEach((s, strings) -> log.info("Threat intel monitor fanout : No ioc indices found for type {}. Not performing search.", (Object)iocType));
            groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), null));
        }
    }

    private GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> getGroupedListenerForIocScanFromAllIocTypes(Map<String, Set<String>> iocsPerType, Monitor monitor, BiConsumer<List<STIX2IOC>, Exception> callback, long startTime, int numIocs) {
        return new GroupedActionListener(ActionListener.wrap(lists -> {
            long endTime = System.currentTimeMillis();
            long timetaken = endTime - startTime;
            log.debug("IOC_SCAN: Threat intel monitor {} completed Ioc match phase in {} millis for {} iocs", (Object)monitor.getId(), (Object)timetaken, (Object)numIocs);
            ArrayList hits = new ArrayList();
            lists.forEach(hitsOrException -> hits.addAll(hitsOrException.getHits() == null ? Collections.emptyList() : hitsOrException.getHits()));
            ArrayList iocs = new ArrayList();
            hits.forEach(hit -> {
                try {
                    XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    xcp.nextToken();
                    STIX2IOC ioc = STIX2IOC.parse(xcp, hit.getId(), hit.getVersion());
                    iocs.add(ioc);
                }
                catch (Exception e) {
                    log.error(() -> new ParameterizedMessage("Failed to parse IOC doc from hit {} index {}", (Object)hit.getId(), (Object)hit.getIndex()), (Throwable)e);
                }
            });
            callback.accept(iocs, null);
        }, e -> {
            log.error("Threat intel monitor {} :Unexpected error while scanning data for malicious Iocs", (Throwable)e);
            callback.accept(Collections.emptyList(), (Exception)e);
        }), iocsPerType.size());
    }

    private void performScanForMaliciousIocsPerIocType(List<String> indices, Set<String> iocs, Monitor monitor, String iocType, GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> listener) {
        int maxTerms = (Integer)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.IOC_SCAN_MAX_TERMS_COUNT);
        GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> perIocTypeListener = this.getGroupedListenerForIocScanPerIocType(iocs, monitor, iocType, listener, maxTerms);
        ArrayList<String> iocList = new ArrayList<String>(iocs);
        int totalIocs = iocList.size();
        log.info("Threat intel monitor fanout : performScanForMaliciousIocsPerIocType for {} iocs of type {}", (Object)totalIocs, (Object)iocType);
        for (int start = 0; start < totalIocs; start += maxTerms) {
            int end = Math.min(start + maxTerms, totalIocs);
            List<String> iocsSublist = iocList.subList(start, end);
            SearchRequest searchRequest = SaIoCScanService.getSearchRequestForIocType(indices, iocType, iocsSublist);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                if (searchResponse.isTimedOut()) {
                    log.error("Threat intel monitor {} scan with {} user data indicators TIMED OUT for ioc Type {}", (Object)monitor.getId(), (Object)iocsSublist.size(), (Object)iocType);
                }
                if (searchResponse.getFailedShards() > 0) {
                    for (ShardSearchFailure shardFailure : searchResponse.getShardFailures()) {
                        log.error("Threat intel monitor {} scan with {} user data indicators for ioc Type {} has Shard failures {}", (Object)monitor.getId(), (Object)iocsSublist.size(), (Object)iocType, (Object)shardFailure.toString());
                    }
                }
                log.info("Threat intel monitor fanout : performScanForMaliciousIocsPerIocType for {} iocs of type {}.SearchResponse {}", (Object)totalIocs, (Object)iocType, searchResponse);
                perIocTypeListener.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(searchResponse.getHits() == null || searchResponse.getHits().getHits() == null ? Collections.emptyList() : Arrays.asList(searchResponse.getHits().getHits()), null));
            }, e -> {
                log.error(() -> new ParameterizedMessage("Threat intel monitor {} scan with {} user data indicators failed for ioc Type {}", new Object[]{monitor.getId(), iocsSublist.size(), iocType}), (Throwable)e);
                perIocTypeListener.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), (Exception)e));
            }));
        }
    }

    private static SearchRequest getSearchRequestForIocType(List<String> indices, String iocType, List<String> iocsSublist) {
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0]));
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)new TermsQueryBuilder("value", iocsSublist));
        boolQueryBuilder.must((QueryBuilder)new TermsQueryBuilder("type", new String[]{iocType}));
        searchRequest.source().query((QueryBuilder)boolQueryBuilder);
        log.info("Threat intel monitor fanout : searchRequest for ioc type {} is {}", (Object)iocType, (Object)searchRequest);
        return searchRequest;
    }

    private GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> getGroupedListenerForIocScanPerIocType(Set<String> iocs, Monitor monitor, String iocType, GroupedActionListener<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> groupedListenerForAllIocTypes, int maxTerms) {
        return new GroupedActionListener(ActionListener.wrap(searchHitsOrExceptions -> {
            if (!searchHitsOrExceptions.stream().allMatch(shoe -> shoe.getException() != null)) {
                ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
                searchHitsOrExceptions.forEach(searchHitsOrException -> {
                    if (searchHitsOrException.getException() != null) {
                        log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to perform ioc scan on one batch for ioc type : ", (Object)monitor.getId(), (Object)iocType), (Throwable)searchHitsOrException.getException());
                    } else {
                        searchHits.addAll(searchHitsOrException.getHits() != null ? searchHitsOrException.getHits() : Collections.emptyList());
                    }
                });
                groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(searchHits, null));
            } else {
                groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), this.buildException((Collection<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException>)searchHitsOrExceptions)));
            }
        }, e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to perform ioc scan for ioc type : ", (Object)monitor.getId(), (Object)iocType), (Throwable)e);
            groupedListenerForAllIocTypes.onResponse((Object)new TransportThreatIntelMonitorFanOutAction.SearchHitsOrException(Collections.emptyList(), (Exception)e));
        }), SaIoCScanService.getGroupSizeForIocs(iocs, maxTerms));
    }

    private Exception buildException(Collection<TransportThreatIntelMonitorFanOutAction.SearchHitsOrException> searchHitsOrExceptions) {
        Exception e = null;
        for (TransportThreatIntelMonitorFanOutAction.SearchHitsOrException searchHitsOrException : searchHitsOrExceptions) {
            if (e == null) {
                e = searchHitsOrException.getException();
                continue;
            }
            e.addSuppressed(searchHitsOrException.getException());
        }
        return e;
    }

    private static int getGroupSizeForIocs(Set<String> iocs, int maxTerms) {
        return iocs.size() / maxTerms + (iocs.size() % maxTerms == 0 ? 0 : 1);
    }

    @Override
    public List<String> getValuesAsStringList(SearchHit hit, String field) {
        if (hit.getFields().containsKey(field)) {
            DocumentField documentField = (DocumentField)hit.getFields().get(field);
            return documentField.getValues().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getIndexName(SearchHit hit) {
        return hit.getIndex();
    }

    @Override
    public String getId(SearchHit hit) {
        return hit.getId();
    }

    @Override
    void saveIocFindings(List<IocFinding> iocFindings, BiConsumer<List<IocFinding>, Exception> callback, Monitor monitor) {
        if (iocFindings == null || iocFindings.isEmpty()) {
            callback.accept(Collections.emptyList(), null);
            return;
        }
        log.debug("Threat intel monitor {}: Indexing {} ioc findings", (Object)monitor.getId(), (Object)iocFindings.size());
        this.iocFindingService.bulkIndexEntities(iocFindings, (ActionListener<Void>)ActionListener.wrap(v -> callback.accept(iocFindings, null), e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to index ioc findings ", (Object)monitor.getId()), (Throwable)e);
            callback.accept(Collections.emptyList(), (Exception)e);
        }));
    }

    @Override
    void saveAlerts(List<ThreatIntelAlert> updatedAlerts, List<ThreatIntelAlert> newAlerts, Monitor monitor, BiConsumer<List<ThreatIntelAlert>, Exception> callback) {
        if ((newAlerts == null || newAlerts.isEmpty()) && (updatedAlerts == null || updatedAlerts.isEmpty())) {
            callback.accept(Collections.emptyList(), null);
            return;
        }
        log.debug("Threat intel monitor {}: Indexing {} new threat intel alerts and updating {} existing alerts", (Object)monitor.getId(), (Object)newAlerts.size(), (Object)updatedAlerts.size());
        this.threatIntelAlertService.bulkIndexEntities(newAlerts, updatedAlerts, (ActionListener<Void>)ActionListener.wrap(v -> {
            ArrayList threatIntelAlerts = new ArrayList(newAlerts);
            threatIntelAlerts.addAll(updatedAlerts);
            callback.accept(threatIntelAlerts, null);
        }, e -> {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to index alerts ", (Object)monitor.getId()), (Throwable)e);
            callback.accept(Collections.emptyList(), (Exception)e);
        }));
    }

    private void initAlertsIndex(ActionListener<Void> listener) {
        this.threatIntelAlertService.createIndexIfNotExists(listener);
    }
}

