/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.securityanalytics.action.TestS3ConnectionRequest;
import org.opensearch.securityanalytics.action.TestS3ConnectionResponse;
import org.opensearch.securityanalytics.services.STIX2IOCFetchService;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportTestS3ConnectionAction
extends HandledTransportAction<TestS3ConnectionRequest, TestS3ConnectionResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportTestS3ConnectionAction.class);
    private final STIX2IOCFetchService stix2IOCFetchService;

    @Inject
    public TransportTestS3ConnectionAction(TransportService transportService, ActionFilters actionFilters, STIX2IOCFetchService stix2IOCFetchService) {
        super("cluster:admin/opensearch/securityanalytics/connections/test/s3", transportService, actionFilters, TestS3ConnectionRequest::new);
        this.stix2IOCFetchService = stix2IOCFetchService;
    }

    protected void doExecute(Task task, TestS3ConnectionRequest request, ActionListener<TestS3ConnectionResponse> listener) {
        try {
            this.stix2IOCFetchService.testS3Connection(request.constructS3ConnectorConfig(), listener);
        }
        catch (Exception e) {
            log.warn("S3 connection test failed with error: ", (Throwable)e);
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
        }
    }
}

