/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.util.Arrays;

public class HKDFKeyParameters {
    private final byte[] ikm;
    private final boolean skipExpand;
    private final byte[] salt;

    public HKDFKeyParameters(byte[] byArray, boolean bl, byte[] byArray2) {
        if (byArray == null) {
            throw new IllegalArgumentException("IKM (input keying material) should not be null");
        }
        this.ikm = Arrays.clone(byArray);
        this.skipExpand = bl;
        this.salt = (byte[])(byArray2 == null || byArray2.length == 0 ? null : Arrays.clone(byArray2));
    }

    public byte[] getIKM() {
        return Arrays.clone(this.ikm);
    }

    public boolean skipExtract() {
        return this.skipExpand;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }
}

