/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.RANKER_TYPE;
import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.learning.Ranker;
import ciir.umass.edu.learning.RankerFactory;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.utilities.SimpleMath;
import java.util.List;

public class RankerTrainer {
    protected RankerFactory rf = new RankerFactory();
    protected double trainingTime = 0.0;

    public Ranker train(RANKER_TYPE type, List<RankList> train, int[] features, MetricScorer scorer) {
        Ranker ranker = this.rf.createRanker(type, train, features, scorer);
        long start = System.nanoTime();
        ranker.init();
        ranker.learn();
        this.trainingTime = System.nanoTime() - start;
        return ranker;
    }

    public Ranker train(RANKER_TYPE type, List<RankList> train, List<RankList> validation, int[] features, MetricScorer scorer) {
        Ranker ranker = this.rf.createRanker(type, train, features, scorer);
        ranker.setValidationSet(validation);
        long start = System.nanoTime();
        ranker.init();
        ranker.learn();
        this.trainingTime = System.nanoTime() - start;
        return ranker;
    }

    public double getTrainingTime() {
        return this.trainingTime;
    }

    public void printTrainingTime() {
        System.out.println("Training time: " + SimpleMath.round(this.trainingTime / 1.0E9, 2) + " seconds");
    }
}

