/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.reader;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.core.reader.QueryInsightsReader;
import org.opensearch.plugin.insights.core.utils.IndexDiscoveryHelper;
import org.opensearch.plugin.insights.core.utils.QueryInsightsQueryBuilder;
import org.opensearch.plugin.insights.core.utils.SearchResponseParser;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.transport.client.Client;
import reactor.util.annotation.NonNull;

public final class LocalIndexReader
implements QueryInsightsReader {
    private static final int MAX_TOP_N_INDEX_READ_SIZE = 50;
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private DateTimeFormatter indexPattern;
    private final NamedXContentRegistry namedXContentRegistry;
    private final String id;

    public LocalIndexReader(Client client, DateTimeFormatter indexPattern, NamedXContentRegistry namedXContentRegistry, String id) {
        this.indexPattern = indexPattern;
        this.client = client;
        this.id = id;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public DateTimeFormatter getIndexPattern() {
        return this.indexPattern;
    }

    public LocalIndexReader setIndexPattern(DateTimeFormatter indexPattern) {
        this.indexPattern = indexPattern;
        return this;
    }

    @Override
    public void read(String from, String to, final String id, final Boolean verbose, final @NonNull MetricType metricType, final ActionListener<List<SearchQueryRecord>> listener) {
        ZonedDateTime now;
        if (from == null || to == null) {
            listener.onResponse(new ArrayList());
            return;
        }
        final ZonedDateTime start = ZonedDateTime.parse(from);
        ZonedDateTime end = ZonedDateTime.parse(to);
        if (end.isAfter(now = ZonedDateTime.now(ZoneOffset.UTC))) {
            end = now;
        }
        final ZonedDateTime finalEnd = end;
        IndexDiscoveryHelper.discoverIndicesInDateRange(this.client, this.indexPattern, start, finalEnd, new ActionListener<List<String>>(){

            public void onResponse(List<String> indexNames) {
                if (indexNames.isEmpty()) {
                    listener.onResponse(Collections.emptyList());
                    return;
                }
                LocalIndexReader.this.executeSearchRequest(indexNames, start, finalEnd, id, verbose, metricType, (ActionListener<List<SearchQueryRecord>>)listener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void executeSearchRequest(final List<String> indexNames, ZonedDateTime start, ZonedDateTime end, String id, Boolean verbose, MetricType metricType, final ActionListener<List<SearchQueryRecord>> listener) {
        SearchRequest searchRequest = QueryInsightsQueryBuilder.buildTopNSearchRequest(indexNames, start, end, id, verbose, metricType);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                SearchResponseParser.parseSearchResponse(searchResponse, LocalIndexReader.this.namedXContentRegistry, (ActionListener<List<SearchQueryRecord>>)listener);
            }

            public void onFailure(Exception e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.LOCAL_INDEX_READER_SEARCH_EXCEPTIONS);
                LocalIndexReader.this.logger.error("Failed to search indices {}: ", (Object)indexNames, (Object)e);
                listener.onFailure(e);
            }
        });
    }

    @Override
    public void close() {
        this.logger.debug("Closing the LocalIndexReader..");
    }
}

