/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.transport.top_queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueries;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesRequest;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesResponse;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

public class TransportTopQueriesAction
extends TransportNodesAction<TopQueriesRequest, TopQueriesResponse, NodeRequest, TopQueries> {
    private final QueryInsightsService queryInsightsService;

    @Inject
    public TransportTopQueriesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, QueryInsightsService queryInsightsService, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/insights/top_queries", threadPool, clusterService, transportService, actionFilters, TopQueriesRequest::new, NodeRequest::new, "generic", TopQueries.class);
        this.queryInsightsService = queryInsightsService;
    }

    ActionListener<TopQueriesResponse> createInMemoryDataCollectionListener(final TopQueriesRequest request, final ActionListener<TopQueriesResponse> finalListener) {
        return new ActionListener<TopQueriesResponse>(){

            public void onResponse(TopQueriesResponse inMemoryQueriesResponse) {
                TransportTopQueriesAction.this.handleInMemoryDataResponse(request, inMemoryQueriesResponse, (ActionListener<TopQueriesResponse>)finalListener);
            }

            public void onFailure(Exception e) {
                finalListener.onFailure(e);
            }
        };
    }

    void handleInMemoryDataResponse(TopQueriesRequest request, TopQueriesResponse inMemoryQueriesResponse, ActionListener<TopQueriesResponse> finalListener) {
        List inMemoryTopQueries = inMemoryQueriesResponse.getNodes();
        List inMemoryDataFailures = inMemoryQueriesResponse.failures();
        String from = request.getFrom();
        String to = request.getTo();
        if (from != null && to != null) {
            this.fetchHistoricalData(request, inMemoryTopQueries, inMemoryDataFailures, finalListener);
        } else {
            finalListener.onResponse((Object)inMemoryQueriesResponse);
        }
    }

    void fetchHistoricalData(final TopQueriesRequest request, final List<TopQueries> inMemoryTopQueries, final List<FailedNodeException> inMemoryDataFailures, final ActionListener<TopQueriesResponse> finalListener) {
        String from = request.getFrom();
        String to = request.getTo();
        String id = request.getId();
        Boolean verbose = request.getVerbose();
        try (ThreadContext.StoredContext storedContext = this.threadPool.getThreadContext().stashContext();){
            this.queryInsightsService.getTopQueriesService(request.getMetricType()).getTopQueriesRecordsFromIndex(from, to, id, verbose, new ActionListener<List<SearchQueryRecord>>(){

                public void onResponse(List<SearchQueryRecord> historicalRecords) {
                    TransportTopQueriesAction.this.onHistoricalDataResponse(request, inMemoryTopQueries, inMemoryDataFailures, historicalRecords, (ActionListener<TopQueriesResponse>)finalListener);
                }

                public void onFailure(Exception e) {
                    TransportTopQueriesAction.this.onHistoricalDataFailure(request, inMemoryTopQueries, inMemoryDataFailures, e, (ActionListener<TopQueriesResponse>)finalListener);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Synchronous failure while initiating historical top queries fetch", (Throwable)e);
            finalListener.onFailure(e);
        }
    }

    void onHistoricalDataResponse(TopQueriesRequest request, List<TopQueries> inMemoryTopQueries, List<FailedNodeException> inMemoryDataFailures, List<SearchQueryRecord> historicalRecords, ActionListener<TopQueriesResponse> finalListener) {
        List<SearchQueryRecord> deduplicatedHistoricalRecords;
        ArrayList<TopQueries> combinedTopQueriesList = new ArrayList<TopQueries>(inMemoryTopQueries);
        if (historicalRecords != null && !historicalRecords.isEmpty() && !(deduplicatedHistoricalRecords = this.removeDuplicates(inMemoryTopQueries, historicalRecords)).isEmpty()) {
            combinedTopQueriesList.add(new TopQueries(this.clusterService.localNode(), deduplicatedHistoricalRecords));
        }
        finalListener.onResponse((Object)new TopQueriesResponse(this.clusterService.getClusterName(), combinedTopQueriesList, inMemoryDataFailures, request.getMetricType()));
    }

    void onHistoricalDataFailure(TopQueriesRequest request, List<TopQueries> inMemoryTopQueries, List<FailedNodeException> inMemoryDataFailures, Exception e, ActionListener<TopQueriesResponse> finalListener) {
        this.logger.warn("Failed to fetch historical top queries, proceeding with in-memory data only.", (Throwable)e);
        finalListener.onResponse((Object)new TopQueriesResponse(this.clusterService.getClusterName(), inMemoryTopQueries, inMemoryDataFailures, request.getMetricType()));
    }

    private List<SearchQueryRecord> removeDuplicates(List<TopQueries> inMemoryTopQueries, List<SearchQueryRecord> historicalRecords) {
        LinkedHashSet<String> inMemoryRecordIds = new LinkedHashSet<String>();
        for (TopQueries topQueries : inMemoryTopQueries) {
            if (topQueries.getTopQueriesRecord() == null) continue;
            for (SearchQueryRecord record : topQueries.getTopQueriesRecord()) {
                inMemoryRecordIds.add(record.getId());
            }
        }
        ArrayList<SearchQueryRecord> deduplicatedRecords = new ArrayList<SearchQueryRecord>();
        for (SearchQueryRecord historicalRecord : historicalRecords) {
            if (inMemoryRecordIds.contains(historicalRecord.getId())) continue;
            deduplicatedRecords.add(historicalRecord);
        }
        return deduplicatedRecords;
    }

    protected void doExecute(Task task, TopQueriesRequest request, ActionListener<TopQueriesResponse> finalListener) {
        super.doExecute(task, (BaseNodesRequest)request, this.createInMemoryDataCollectionListener(request, finalListener));
    }

    protected TopQueriesResponse newResponse(TopQueriesRequest topQueriesRequest, List<TopQueries> collectedNodeResponses, List<FailedNodeException> failures) {
        return new TopQueriesResponse(this.clusterService.getClusterName(), collectedNodeResponses, failures, topQueriesRequest.getMetricType());
    }

    protected NodeRequest newNodeRequest(TopQueriesRequest request) {
        return new NodeRequest(request);
    }

    protected TopQueries newNodeResponse(StreamInput in) throws IOException {
        return new TopQueries(in);
    }

    protected TopQueries nodeOperation(NodeRequest nodeRequest) {
        TopQueriesRequest request = nodeRequest.request;
        return new TopQueries(this.clusterService.localNode(), this.queryInsightsService.getTopQueriesService(request.getMetricType()).getTopQueriesRecords(true, request.getFrom(), request.getTo(), request.getId(), request.getVerbose()));
    }

    public static class NodeRequest
    extends TransportRequest {
        final TopQueriesRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new TopQueriesRequest(in);
        }

        public NodeRequest(TopQueriesRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

