/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ad.client.AnomalyDetectionNodeClient;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.transport.GetAnomalyDetectorResponse;
import org.opensearch.agent.tools.utils.ToolConstants;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="SearchAnomalyDetectorsTool")
public class SearchAnomalyDetectorsTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchAnomalyDetectorsTool.class);
    public static final String TYPE = "SearchAnomalyDetectorsTool";
    private static final String DEFAULT_DESCRIPTION = "This is a tool that searches anomaly detectors. It takes 12 optional arguments named detectorName which is the explicit name of the detector (default is null), and detectorNamePattern which is a wildcard query to match detector name (default is null), and indices which defines the index or index pattern the detector is detecting over (default is null), and highCardinality which defines whether the anomaly detector is high cardinality (synonymous with multi-entity) of non-high-cardinality (synonymous with single-entity) (default is null, indicating both), and lastUpdateTime which defines the latest update time of the anomaly detector in epoch milliseconds (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0), and running which defines whether the anomaly detector is running (default is null, indicating both), and failed which defines whether the anomaly detector has failed (default is null, indicating both). The tool returns 2 values: a list of anomaly detectors (each containing the detector id, detector name, detector type indicating multi-entity or single-entity (where multi-entity also means high-cardinality), detector description, name of the configured index, last update time in epoch milliseconds), and the total number of anomaly detectors.";
    private String name = "SearchAnomalyDetectorsTool";
    private String description = "This is a tool that searches anomaly detectors. It takes 12 optional arguments named detectorName which is the explicit name of the detector (default is null), and detectorNamePattern which is a wildcard query to match detector name (default is null), and indices which defines the index or index pattern the detector is detecting over (default is null), and highCardinality which defines whether the anomaly detector is high cardinality (synonymous with multi-entity) of non-high-cardinality (synonymous with single-entity) (default is null, indicating both), and lastUpdateTime which defines the latest update time of the anomaly detector in epoch milliseconds (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0), and running which defines whether the anomaly detector is running (default is null, indicating both), and failed which defines whether the anomaly detector has failed (default is null, indicating both). The tool returns 2 values: a list of anomaly detectors (each containing the detector id, detector name, detector type indicating multi-entity or single-entity (where multi-entity also means high-cardinality), detector description, name of the configured index, last update time in epoch milliseconds), and the total number of anomaly detectors.";
    private String version;
    private Client client;
    private AnomalyDetectionNodeClient adClient;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;
    private Map<String, Object> attributes;

    public SearchAnomalyDetectorsTool(Client client, NamedWriteableRegistry namedWriteableRegistry) {
        this.client = client;
        this.adClient = new AnomalyDetectionNodeClient(client, namedWriteableRegistry);
        this.outputParser = new Parser<Object, Object>(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        String detectorName = parameters.getOrDefault("detectorName", null);
        String detectorNamePattern = parameters.getOrDefault("detectorNamePattern", null);
        String indices = parameters.getOrDefault("indices", null);
        Boolean highCardinality = parameters.containsKey("highCardinality") ? Boolean.valueOf(Boolean.parseBoolean(parameters.get("highCardinality"))) : null;
        Long lastUpdateTime = parameters.containsKey("lastUpdateTime") && StringUtils.isNumeric((CharSequence)parameters.get("lastUpdateTime")) ? Long.valueOf(Long.parseLong(parameters.get("lastUpdateTime"))) : null;
        String sortOrderStr = parameters.getOrDefault("sortOrder", "asc");
        SortOrder sortOrder = sortOrderStr.equalsIgnoreCase("asc") ? SortOrder.ASC : SortOrder.DESC;
        String sortString = parameters.getOrDefault("sortString", "name.keyword");
        int size = parameters.containsKey("size") ? Integer.parseInt(parameters.get("size")) : 20;
        int startIndex = parameters.containsKey("startIndex") ? Integer.parseInt(parameters.get("startIndex")) : 0;
        Boolean running = parameters.containsKey("running") ? Boolean.valueOf(Boolean.parseBoolean(parameters.get("running"))) : null;
        Boolean failed = parameters.containsKey("failed") ? Boolean.valueOf(Boolean.parseBoolean(parameters.get("failed"))) : null;
        ArrayList<Object> mustList = new ArrayList<Object>();
        if (detectorName != null) {
            mustList.add(new TermQueryBuilder("name.keyword", detectorName));
        }
        if (detectorNamePattern != null) {
            mustList.add(new WildcardQueryBuilder("name.keyword", detectorNamePattern));
        }
        if (indices != null) {
            mustList.add(new TermQueryBuilder("indices.keyword", indices));
        }
        if (highCardinality != null) {
            mustList.add(new TermQueryBuilder("detector_type", highCardinality != false ? "MULTI_ENTITY" : "SINGLE_ENTITY"));
        }
        if (lastUpdateTime != null) {
            mustList.add(new BoolQueryBuilder().filter((QueryBuilder)new RangeQueryBuilder("last_update_time").gte((Object)lastUpdateTime)));
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must().addAll(mustList);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).size(size).from(startIndex).sort(sortString, sortOrder);
        SearchRequest searchDetectorRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-anomaly-detectors"});
        ActionListener searchDetectorListener = ActionListener.wrap(response -> {
            StringBuilder sb = new StringBuilder();
            List<SearchHit> hits = Arrays.asList(response.getHits().getHits());
            HashMap<String, SearchHit> hitsAsMap = new HashMap<String, SearchHit>();
            for (SearchHit searchHit : hits) {
                hitsAsMap.put((String)searchHit.getSourceAsMap().get("name"), searchHit);
            }
            if (running != null || failed != null) {
                void var9_13;
                ArrayList profileFutures = new ArrayList();
                for (SearchHit hit : hits) {
                    CompletableFuture profileFuture = new CompletableFuture().orTimeout(30000L, TimeUnit.MILLISECONDS);
                    profileFutures.add(profileFuture);
                    ActionListener profileListener = ActionListener.wrap(profileResponse -> profileFuture.complete(profileResponse), e -> {
                        log.error("Failed to get anomaly detector profile.", (Throwable)e);
                        profileFuture.completeExceptionally((Throwable)e);
                        listener.onFailure(e);
                    });
                    GetConfigRequest profileRequest = new GetConfigRequest(hit.getId(), -3L, false, true, "", "", false, null);
                    this.adClient.getDetectorProfile(profileRequest, profileListener);
                }
                ArrayList arrayList = new ArrayList();
                try {
                    CompletionStage listFuture = CompletableFuture.allOf(profileFutures.toArray(new CompletableFuture[0])).thenApply(v -> profileFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
                    List list = (List)((CompletableFuture)listFuture).join();
                }
                catch (Exception e2) {
                    log.error("Failed to get all anomaly detector profiles.", (Throwable)e2);
                    listener.onFailure(e2);
                }
                for (GetAnomalyDetectorResponse profileResponse2 : var9_13) {
                    if (profileResponse2 == null || profileResponse2.getDetector() == null) continue;
                    String responseDetectorName = profileResponse2.getDetector().getName();
                    String detectorState = ToolConstants.DetectorStateString.Disabled.name();
                    ADTask realtimeTask = profileResponse2.getRealtimeAdTask();
                    if (realtimeTask != null) {
                        String taskState = realtimeTask.getState();
                        if (taskState.equalsIgnoreCase("CREATED") || taskState.equalsIgnoreCase("RUNNING")) {
                            detectorState = ToolConstants.DetectorStateString.Running.name();
                        } else if (taskState.equalsIgnoreCase("INIT_FAILURE") || taskState.equalsIgnoreCase("UNEXPECTED_FAILURE") || taskState.equalsIgnoreCase("FAILED")) {
                            detectorState = ToolConstants.DetectorStateString.Failed.name();
                        }
                    }
                    boolean includeRunning = running != null && running == true;
                    boolean includeFailed = failed != null && failed == true;
                    boolean isValid = true;
                    if (detectorState.equals(ToolConstants.DetectorStateString.Running.name())) {
                        isValid = !(running != null && running != true || includeFailed && running == null);
                    } else if (detectorState.equals(ToolConstants.DetectorStateString.Failed.name())) {
                        isValid = !(failed != null && failed != true || includeRunning && failed == null);
                    } else if (detectorState.equals(ToolConstants.DetectorStateString.Disabled.name())) {
                        boolean bl = isValid = !(running != null && running != false || includeFailed && running == null);
                    }
                    if (isValid) continue;
                    hitsAsMap.remove(responseDetectorName);
                }
            }
            this.processHits(hitsAsMap, listener);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                this.processHits(Collections.emptyMap(), listener);
            } else {
                log.error("Failed to search anomaly detectors.", (Throwable)e);
                listener.onFailure(e);
            }
        });
        this.adClient.searchAnomalyDetectors(searchDetectorRequest, searchDetectorListener);
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    private <T> void processHits(Map<String, SearchHit> hitsAsMap, ActionListener<T> listener) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnomalyDetectors=[");
        for (SearchHit hit : hitsAsMap.values()) {
            sb.append("{");
            sb.append("id=").append(hit.getId()).append(",");
            sb.append("name=").append(hit.getSourceAsMap().get("name")).append(",");
            sb.append("type=").append(hit.getSourceAsMap().get("detector_type")).append(",");
            sb.append("description=").append(hit.getSourceAsMap().get("description")).append(",");
            sb.append("index=").append(hit.getSourceAsMap().get("indices")).append(",");
            sb.append("lastUpdateTime=").append(hit.getSourceAsMap().get("last_update_time"));
            sb.append("}");
        }
        sb.append("]");
        sb.append("TotalAnomalyDetectors=").append(hitsAsMap.size());
        listener.onResponse((Object)sb.toString());
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class Factory
    implements Tool.Factory<SearchAnomalyDetectorsTool> {
        private Client client;
        private NamedWriteableRegistry namedWriteableRegistry;
        private AnomalyDetectionNodeClient adClient;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchAnomalyDetectorsTool> clazz = SearchAnomalyDetectorsTool.class;
            synchronized (SearchAnomalyDetectorsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedWriteableRegistry namedWriteableRegistry) {
            this.client = client;
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.adClient = new AnomalyDetectionNodeClient(client, namedWriteableRegistry);
        }

        public SearchAnomalyDetectorsTool create(Map<String, Object> map) {
            return new SearchAnomalyDetectorsTool(this.client, this.namedWriteableRegistry);
        }

        public String getDefaultDescription() {
            return SearchAnomalyDetectorsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchAnomalyDetectorsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

