/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.security.privileges.ExpressionEvaluationException;
import org.opensearch.security.privileges.UserAttributes;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;

public class PrivilegesEvaluationContext {
    private final User user;
    private final String action;
    private final ActionRequest request;
    private IndexResolverReplacer.Resolved resolvedRequest;
    private Map<String, IndexAbstraction> indicesLookup;
    private final Task task;
    private ImmutableSet<String> mappedRoles;
    private final IndexResolverReplacer indexResolverReplacer;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final Map<String, WildcardMatcher> renderedPatternTemplateCache = new HashMap<String, WildcardMatcher>();

    public PrivilegesEvaluationContext(User user, ImmutableSet<String> mappedRoles, String action, ActionRequest request, Task task, IndexResolverReplacer indexResolverReplacer, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<ClusterState> clusterStateSupplier) {
        this.user = user;
        this.mappedRoles = mappedRoles;
        this.action = action;
        this.request = request;
        this.clusterStateSupplier = clusterStateSupplier;
        this.indexResolverReplacer = indexResolverReplacer;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.task = task;
    }

    public User getUser() {
        return this.user;
    }

    public WildcardMatcher getRenderedMatcher(String template) throws ExpressionEvaluationException {
        WildcardMatcher matcher = this.renderedPatternTemplateCache.get(template);
        if (matcher == null) {
            try {
                matcher = WildcardMatcher.from(UserAttributes.replaceProperties(template, this));
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error while evaluating expression in " + template, e);
            }
            this.renderedPatternTemplateCache.put(template, matcher);
        }
        return matcher;
    }

    public String getAction() {
        return this.action;
    }

    public ActionRequest getRequest() {
        return this.request;
    }

    public IndexResolverReplacer.Resolved getResolvedRequest() {
        IndexResolverReplacer.Resolved result = this.resolvedRequest;
        if (result == null) {
            this.resolvedRequest = result = this.indexResolverReplacer.resolveRequest(this.request);
        }
        return result;
    }

    public Task getTask() {
        return this.task;
    }

    public ImmutableSet<String> getMappedRoles() {
        return this.mappedRoles;
    }

    void setMappedRoles(ImmutableSet<String> mappedRoles) {
        this.mappedRoles = mappedRoles;
    }

    public Supplier<ClusterState> getClusterStateSupplier() {
        return this.clusterStateSupplier;
    }

    public Map<String, IndexAbstraction> getIndicesLookup() {
        if (this.indicesLookup == null) {
            this.indicesLookup = this.clusterStateSupplier.get().metadata().getIndicesLookup();
        }
        return this.indicesLookup;
    }

    public IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public String toString() {
        return "PrivilegesEvaluationContext{user=" + String.valueOf(this.user) + ", action='" + this.action + "', request=" + String.valueOf(this.request) + ", resolvedRequest=" + String.valueOf(this.resolvedRequest) + ", mappedRoles=" + String.valueOf(this.mappedRoles) + "}";
    }
}

