/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.collect.ImmutableMap;
import com.selectivem.collections.CompactMapGroupBuilder;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.privileges.IndexPattern;
import org.opensearch.security.privileges.PrivilegesConfigurationValidationException;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.dlsfls.IndexToRuleMap;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

abstract class AbstractRuleBasedPrivileges<SingleRule, JoinedRule extends Rule> {
    private static final Logger log = LogManager.getLogger(AbstractRuleBasedPrivileges.class);
    protected final SecurityDynamicConfiguration<RoleV7> roles;
    protected final StaticRules<SingleRule> staticRules;
    private volatile StatefulRules<SingleRule> statefulRules;
    private final RoleToRuleFunction<SingleRule> roleToRuleFunction;
    private final boolean dfmEmptyOverridesAll;

    public AbstractRuleBasedPrivileges(SecurityDynamicConfiguration<RoleV7> roles, Map<String, IndexAbstraction> indexMetadata, RoleToRuleFunction<SingleRule> roleToRuleFunction, Settings settings) {
        this.roles = roles;
        this.roleToRuleFunction = roleToRuleFunction;
        this.staticRules = new StaticRules<SingleRule>(roles, roleToRuleFunction);
        this.dfmEmptyOverridesAll = settings.getAsBoolean("plugins.security.dfm_empty_overrides_all", Boolean.valueOf(false));
        this.statefulRules = new StatefulRules<SingleRule>(roles, indexMetadata, roleToRuleFunction);
    }

    public boolean isUniversallyUnrestricted(PrivilegesEvaluationContext context) {
        return this.dfmEmptyOverridesAll && CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles());
    }

    public boolean isUnrestricted(PrivilegesEvaluationContext context, IndexResolverReplacer.Resolved resolved) throws PrivilegesEvaluationException {
        if (context.getMappedRoles().isEmpty()) {
            return false;
        }
        if (this.dfmEmptyOverridesAll && CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles())) {
            return true;
        }
        if (resolved == null) {
            return false;
        }
        if (this.hasRestrictedRulesWithIndexWildcard(context)) {
            return false;
        }
        StatefulRules<SingleRule> statefulRules = this.statefulRules;
        for (String index : resolved.getAllIndicesResolved(context.getClusterStateSupplier(), context.getIndexNameExpressionResolver())) {
            if (this.dfmEmptyOverridesAll) {
                if (this.hasUnrestrictedRulesExplicit(context, statefulRules, index)) continue;
                return false;
            }
            if (this.hasRestrictedRulesExplicit(context, statefulRules, index)) {
                return false;
            }
            if (CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles()) || this.hasUnrestrictedRulesExplicit(context, statefulRules, index)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnrestricted(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
        if (context.getMappedRoles().isEmpty()) {
            return false;
        }
        if (this.dfmEmptyOverridesAll && CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles())) {
            return true;
        }
        if (this.hasRestrictedRulesWithIndexWildcard(context)) {
            return false;
        }
        if (this.dfmEmptyOverridesAll) {
            return this.hasUnrestrictedRulesExplicit(context, this.statefulRules, index);
        }
        if (this.hasRestrictedRulesExplicit(context, this.statefulRules, index)) {
            return false;
        }
        if (CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles())) {
            return true;
        }
        return this.hasUnrestrictedRulesExplicit(context, this.statefulRules, index);
    }

    private boolean hasUnrestrictedRulesExplicit(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, String index) throws PrivilegesEvaluationException {
        Set roleWithoutRule;
        if (statefulRules != null && statefulRules.covers(index) ? (roleWithoutRule = (Set)statefulRules.indexToRoleWithoutRule.get((Object)index)) != null && CollectionUtils.containsAny((Collection)roleWithoutRule, context.getMappedRoles()) : this.staticRules.hasUnrestrictedPatterns(context, index)) {
            return true;
        }
        if (this.staticRules.hasUnrestrictedPatternTemplates(context, index)) {
            return true;
        }
        IndexAbstraction indexAbstraction = context.getIndicesLookup().get(index);
        if (indexAbstraction != null) {
            for (String parent : this.getParents(indexAbstraction)) {
                if (!this.hasUnrestrictedRulesExplicit(context, statefulRules, parent)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRestrictedRulesExplicit(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, String index) throws PrivilegesEvaluationException {
        Map roleWithRule;
        if (statefulRules != null && statefulRules.covers(index) ? (roleWithRule = (Map)statefulRules.indexToRoleToRule.get((Object)index)) != null && CollectionUtils.containsAny(roleWithRule.keySet(), context.getMappedRoles()) : this.staticRules.hasRestrictedPatterns(context, index)) {
            return true;
        }
        if (this.staticRules.hasRestrictedPatternTemplates(context, index)) {
            return true;
        }
        IndexAbstraction indexAbstraction = context.getIndicesLookup().get(index);
        if (indexAbstraction != null) {
            for (String parent : this.getParents(indexAbstraction)) {
                if (!this.hasRestrictedRulesExplicit(context, statefulRules, parent)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRestrictedRulesWithIndexWildcard(PrivilegesEvaluationContext context) {
        return CollectionUtils.containsAny(this.staticRules.roleWithIndexWildcardToRule.keySet(), context.getMappedRoles());
    }

    public JoinedRule getRestriction(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
        return this.getRestriction(context, index, this.fullyRestricted());
    }

    public JoinedRule getRestriction(PrivilegesEvaluationContext context, String index, JoinedRule noRulesDefault) throws PrivilegesEvaluationException {
        if (context.getMappedRoles().isEmpty()) {
            return this.fullyRestricted();
        }
        if (this.dfmEmptyOverridesAll && CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles())) {
            return this.unrestricted();
        }
        StatefulRules<SingleRule> statefulRules = this.statefulRules;
        if (statefulRules != null && !statefulRules.covers(index)) {
            statefulRules = null;
        }
        if (this.dfmEmptyOverridesAll && this.hasUnrestrictedRulesExplicit(context, statefulRules, index)) {
            return this.unrestricted();
        }
        HashSet ruleSink = new HashSet();
        this.collectRules(context, ruleSink, index, statefulRules);
        IndexAbstraction indexAbstraction = context.getIndicesLookup().get(index);
        if (indexAbstraction != null) {
            for (String parent : this.getParents(indexAbstraction)) {
                this.collectRules(context, ruleSink, parent, statefulRules);
            }
        }
        if (ruleSink.isEmpty()) {
            if (this.dfmEmptyOverridesAll) {
                return noRulesDefault;
            }
            if (CollectionUtils.containsAny(this.staticRules.rolesWithIndexWildcardWithoutRule, context.getMappedRoles()) || this.hasUnrestrictedRulesExplicit(context, statefulRules, index)) {
                return this.unrestricted();
            }
            return noRulesDefault;
        }
        return this.compile(context, ruleSink);
    }

    public IndexToRuleMap<JoinedRule> getRestrictions(PrivilegesEvaluationContext context, Collection<String> indices) throws PrivilegesEvaluationException {
        return this.getRestrictions(context, indices, this.fullyRestricted());
    }

    public IndexToRuleMap<JoinedRule> getRestrictions(PrivilegesEvaluationContext context, Collection<String> indices, JoinedRule noRulesDefault) throws PrivilegesEvaluationException {
        if (this.isUniversallyUnrestricted(context)) {
            return IndexToRuleMap.unrestricted();
        }
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)indices.size());
        int restrictedIndices = 0;
        for (String index : indices) {
            JoinedRule restriction = this.getRestriction(context, index, noRulesDefault);
            if (!((Rule)restriction).isUnrestricted()) {
                ++restrictedIndices;
            }
            result.put((Object)index, restriction);
        }
        if (restrictedIndices == 0) {
            return IndexToRuleMap.unrestricted();
        }
        return new IndexToRuleMap(result.build());
    }

    private void collectRules(PrivilegesEvaluationContext context, Set<SingleRule> ruleSink, String index, StatefulRules<SingleRule> statefulRules) throws PrivilegesEvaluationException {
        boolean statefulRulesEffective;
        Map statefulRoleToRule = null;
        if (statefulRules != null) {
            statefulRoleToRule = (Map)statefulRules.indexToRoleToRule.get((Object)index);
            statefulRulesEffective = true;
        } else {
            statefulRulesEffective = false;
        }
        for (String role : context.getMappedRoles()) {
            Map dynamicIndexPatternToRule;
            Map indexPatternToRule;
            Object rule = this.staticRules.roleWithIndexWildcardToRule.get(role);
            if (rule != null) {
                ruleSink.add(rule);
            }
            if (statefulRoleToRule != null && (rule = statefulRoleToRule.get(role)) != null) {
                ruleSink.add(rule);
            }
            if (!statefulRulesEffective && (indexPatternToRule = this.staticRules.rolesToStaticIndexPatternToRule.get(role)) != null) {
                for (Map.Entry entry : indexPatternToRule.entrySet()) {
                    WildcardMatcher pattern = (WildcardMatcher)entry.getKey();
                    if (!pattern.test(index)) continue;
                    ruleSink.add(entry.getValue());
                }
            }
            if ((dynamicIndexPatternToRule = this.staticRules.rolesToDynamicIndexPatternToRule.get(role)) == null) continue;
            for (Map.Entry entry : dynamicIndexPatternToRule.entrySet()) {
                try {
                    if (!((IndexPattern)entry.getKey()).matches(index, context, context.getIndicesLookup())) continue;
                    ruleSink.add(entry.getValue());
                }
                catch (PrivilegesEvaluationException e) {
                    throw new PrivilegesEvaluationException("Error while evaluating index pattern of role " + role, e);
                }
            }
        }
    }

    protected abstract JoinedRule unrestricted();

    protected abstract JoinedRule fullyRestricted();

    protected abstract JoinedRule compile(PrivilegesEvaluationContext var1, Collection<SingleRule> var2) throws PrivilegesEvaluationException;

    synchronized void updateIndices(Map<String, IndexAbstraction> indexMetadata) {
        StatefulRules<SingleRule> statefulRules = this.statefulRules;
        if (statefulRules == null || !statefulRules.indexMetadata.keySet().equals(indexMetadata.keySet())) {
            this.statefulRules = new StatefulRules<SingleRule>(this.roles, indexMetadata, this.roleToRuleFunction);
        }
    }

    private Collection<String> getParents(IndexAbstraction indexAbstraction) {
        if (indexAbstraction instanceof IndexAbstraction.Index) {
            IndexAbstraction.Index index = (IndexAbstraction.Index)indexAbstraction;
            if (index.getWriteIndex().getAliases().isEmpty() && index.getParentDataStream() == null) {
                return Collections.emptySet();
            }
            ArrayList<String> result = new ArrayList<String>(index.getWriteIndex().getAliases().size() + 1);
            for (String aliasName : index.getWriteIndex().getAliases().keySet()) {
                result.add(aliasName);
            }
            if (indexAbstraction.getParentDataStream() != null) {
                result.add(indexAbstraction.getParentDataStream().getName());
            }
            return result;
        }
        return Collections.emptySet();
    }

    @FunctionalInterface
    static interface RoleToRuleFunction<SingleRule> {
        public SingleRule apply(RoleV7.Index var1) throws PrivilegesConfigurationValidationException;
    }

    static class StaticRules<SingleRule> {
        protected final Set<String> rolesWithIndexWildcardWithoutRule;
        protected final Map<String, SingleRule> roleWithIndexWildcardToRule;
        protected final Map<String, Map<IndexPattern, SingleRule>> rolesToDynamicIndexPatternToRule;
        protected final Map<String, Set<IndexPattern>> rolesToDynamicIndexPatternWithoutRule;
        protected final Map<String, Map<WildcardMatcher, SingleRule>> rolesToStaticIndexPatternToRule;
        protected final Map<String, WildcardMatcher> rolesToStaticIndexPatternWithoutRule;
        protected final RoleToRuleFunction<SingleRule> roleToRuleFunction;

        StaticRules(SecurityDynamicConfiguration<RoleV7> roles, RoleToRuleFunction<SingleRule> roleToRuleFunction) {
            this.roleToRuleFunction = roleToRuleFunction;
            HashSet<String> rolesWithIndexWildcardWithoutRule = new HashSet<String>();
            HashMap<String, SingleRule> roleWithIndexWildcardToRule = new HashMap<String, SingleRule>();
            HashMap<String, Map<IndexPattern, SingleRule>> rolesToDynamicIndexPatternToRule = new HashMap<String, Map<IndexPattern, SingleRule>>();
            HashMap<String, Set<IndexPattern>> rolesToDynamicIndexPatternWithoutRule = new HashMap<String, Set<IndexPattern>>();
            HashMap<String, Map<WildcardMatcher, SingleRule>> rolesToStaticIndexPatternToRule = new HashMap<String, Map<WildcardMatcher, SingleRule>>();
            HashMap<String, List> rolesToStaticIndexPatternWithoutRule = new HashMap<String, List>();
            for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    for (RoleV7.Index rolePermissions : role.getIndex_permissions()) {
                        SingleRule singleRule;
                        if (rolePermissions.getIndex_patterns().contains("*")) {
                            singleRule = this.roleToRule(rolePermissions);
                            if (singleRule == null) {
                                rolesWithIndexWildcardWithoutRule.add(roleName);
                                continue;
                            }
                            roleWithIndexWildcardToRule.put(roleName, singleRule);
                            continue;
                        }
                        singleRule = this.roleToRule(rolePermissions);
                        IndexPattern indexPattern = IndexPattern.from(rolePermissions.getIndex_patterns());
                        if (indexPattern.hasStaticPattern()) {
                            if (singleRule == null) {
                                rolesToStaticIndexPatternWithoutRule.computeIfAbsent(roleName, k -> new ArrayList()).add(indexPattern.getStaticPattern());
                            } else {
                                rolesToStaticIndexPatternToRule.computeIfAbsent(roleName, k -> new HashMap()).put(indexPattern.getStaticPattern(), singleRule);
                            }
                        }
                        if (!indexPattern.hasDynamicPattern()) continue;
                        if (singleRule == null) {
                            rolesToDynamicIndexPatternWithoutRule.computeIfAbsent(roleName, k -> new HashSet()).add(indexPattern.dynamicOnly());
                            continue;
                        }
                        rolesToDynamicIndexPatternToRule.computeIfAbsent(roleName, k -> new HashMap()).put(indexPattern.dynamicOnly(), singleRule);
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", entry2, (Object)e);
                }
            }
            this.rolesWithIndexWildcardWithoutRule = rolesWithIndexWildcardWithoutRule;
            this.roleWithIndexWildcardToRule = roleWithIndexWildcardToRule;
            this.rolesToDynamicIndexPatternToRule = rolesToDynamicIndexPatternToRule;
            this.rolesToDynamicIndexPatternWithoutRule = rolesToDynamicIndexPatternWithoutRule;
            this.rolesToStaticIndexPatternToRule = rolesToStaticIndexPatternToRule;
            this.rolesToStaticIndexPatternWithoutRule = (Map)rolesToStaticIndexPatternWithoutRule.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)entry.getKey(), entry -> WildcardMatcher.from((Collection)entry.getValue())));
        }

        protected SingleRule roleToRule(RoleV7.Index rolePermissions) throws PrivilegesConfigurationValidationException {
            return this.roleToRuleFunction.apply(rolePermissions);
        }

        boolean hasUnrestrictedPatterns(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                WildcardMatcher pattern = this.rolesToStaticIndexPatternWithoutRule.get(role);
                if (pattern == null || !pattern.test(index)) continue;
                return true;
            }
            return false;
        }

        boolean hasUnrestrictedPatternTemplates(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                Set<IndexPattern> dynamicIndexPatternsWithoutRule = this.rolesToDynamicIndexPatternWithoutRule.get(role);
                if (dynamicIndexPatternsWithoutRule == null) continue;
                for (IndexPattern indexPatternTemplate : dynamicIndexPatternsWithoutRule) {
                    try {
                        if (!indexPatternTemplate.matches(index, context, context.getIndicesLookup())) continue;
                        return true;
                    }
                    catch (PrivilegesEvaluationException e) {
                        log.error("Error while matching index pattern of role {}", (Object)role, (Object)e);
                    }
                }
            }
            return false;
        }

        boolean hasRestrictedPatterns(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                Map<WildcardMatcher, SingleRule> indexPatternToRule = this.rolesToStaticIndexPatternToRule.get(role);
                if (indexPatternToRule == null) continue;
                for (WildcardMatcher indexPattern : indexPatternToRule.keySet()) {
                    if (!indexPattern.test(index)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean hasRestrictedPatternTemplates(PrivilegesEvaluationContext context, String index) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                Map<IndexPattern, SingleRule> dynamicIndexPatternToRule = this.rolesToDynamicIndexPatternToRule.get(role);
                if (dynamicIndexPatternToRule == null) continue;
                for (IndexPattern indexPattern : dynamicIndexPatternToRule.keySet()) {
                    try {
                        if (!indexPattern.matches(index, context, context.getIndicesLookup())) continue;
                        return true;
                    }
                    catch (PrivilegesEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while evaluating index pattern of role " + role, e);
                    }
                }
            }
            return false;
        }
    }

    static class StatefulRules<SingleRule> {
        final Map<String, IndexAbstraction> indexMetadata;
        final ImmutableMap<String, Map<String, SingleRule>> indexToRoleToRule;
        final ImmutableMap<String, Set<String>> indexToRoleWithoutRule;
        private final RoleToRuleFunction<SingleRule> roleToRuleFunction;

        StatefulRules(SecurityDynamicConfiguration<RoleV7> roles, Map<String, IndexAbstraction> indexMetadata, RoleToRuleFunction<SingleRule> roleToRuleFunction) {
            this.roleToRuleFunction = roleToRuleFunction;
            this.indexMetadata = indexMetadata;
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            CompactMapGroupBuilder roleMapBuilder = new CompactMapGroupBuilder(roles.getCEntries().keySet());
            HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder> indexToRoleWithoutRule = new HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder>();
            HashMap<String, CompactMapGroupBuilder.MapBuilder> indexToRoleToRule = new HashMap<String, CompactMapGroupBuilder.MapBuilder>();
            for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                        WildcardMatcher indexMatcher;
                        if (indexPermissions.getIndex_patterns().contains("*") || (indexMatcher = IndexPattern.from(indexPermissions.getIndex_patterns()).getStaticPattern()) == WildcardMatcher.NONE) continue;
                        SingleRule rule = this.roleToRule(indexPermissions);
                        if (rule != null) {
                            for (String index : indexMatcher.iterateMatching(indexMetadata.keySet())) {
                                indexToRoleToRule.computeIfAbsent(index, k -> roleMapBuilder.createMapBuilder()).put((Object)roleName, rule);
                            }
                            continue;
                        }
                        for (String index : indexMatcher.iterateMatching(indexMetadata.keySet())) {
                            indexToRoleWithoutRule.computeIfAbsent(index, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", entry2, (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completed = roleSetBuilder.build();
            this.indexToRoleToRule = (ImmutableMap)indexToRoleToRule.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)entry.getKey(), entry -> ((CompactMapGroupBuilder.MapBuilder)entry.getValue()).build()));
            this.indexToRoleWithoutRule = (ImmutableMap)indexToRoleWithoutRule.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)entry.getKey(), entry -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)entry.getValue()).build(completed)));
        }

        protected SingleRule roleToRule(RoleV7.Index rolePermissions) throws PrivilegesConfigurationValidationException {
            return this.roleToRuleFunction.apply(rolePermissions);
        }

        boolean covers(String index) {
            return this.indexMetadata.get(index) != null;
        }
    }

    static abstract class Rule {
        Rule() {
        }

        abstract boolean isUnrestricted();
    }
}

