/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Objects;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.core.util.FileSystemUtils;

public class Build {
    public static final Build CURRENT;
    private final boolean isSnapshot;
    private final Type type;
    private final String hash;
    private final String date;
    private final String version;
    private final String distribution;

    static URL getOpenSearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public Build(Type type, String hash, String date, boolean isSnapshot, String version, String distribution) {
        this.type = type;
        this.hash = hash;
        this.date = date;
        this.isSnapshot = isSnapshot;
        this.version = version;
        this.distribution = distribution;
    }

    public String hash() {
        return this.hash;
    }

    public String date() {
        return this.date;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getQualifiedVersion() {
        return this.version;
    }

    public Type type() {
        return this.type;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isProductionRelease() {
        return this.version.matches("[0-9]+\\.[0-9]+\\.[0-9]+");
    }

    public String toString() {
        return "[" + this.type.displayName + "][" + this.hash + "][" + this.date + "][" + this.version + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (!this.type.equals((Object)build.type)) {
            return false;
        }
        if (this.isSnapshot != build.isSnapshot) {
            return false;
        }
        if (!this.hash.equals(build.hash)) {
            return false;
        }
        if (!this.version.equals(build.version)) {
            return false;
        }
        return this.date.equals(build.date);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.isSnapshot, this.hash, this.date, this.version});
    }

    static {
        String version;
        boolean isSnapshot;
        String date;
        String hash;
        Type type;
        block15: {
            String urlStr;
            String distribution = "opensearch";
            type = Type.fromDisplayName(System.getProperty("opensearch.distribution.type", "unknown"), true);
            String opensearchPrefix = "opensearch";
            URL url = Build.getOpenSearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith("opensearch-" + String.valueOf(Version.CURRENT) + ".jar") || urlStr.matches("(.*)opensearch(-)?(.*?)" + String.valueOf(Version.CURRENT) + "(-)?((alpha|beta|rc)[0-9]+)?(-SNAPSHOT)?.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    hash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-OpenSearch-Snapshot"));
                    version = manifest.getMainAttributes().getValue("X-Compile-OpenSearch-Version");
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            hash = "unknown";
            date = "unknown";
            version = Version.CURRENT.toString();
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean((String)buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (hash == null) {
            throw new IllegalStateException("Error finding the build hash. Stopping OpenSearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping OpenSearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (version == null) {
            throw new IllegalStateException("Error finding the build version. Stopping OpenSearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        CURRENT = new Build(type, hash, date, isSnapshot, version, "opensearch");
    }

    public static enum Type {
        DEB("deb"),
        DOCKER("docker"),
        RPM("rpm"),
        TAR("tar"),
        ZIP("zip"),
        UNKNOWN("unknown");

        final String displayName;

        public String displayName() {
            return this.displayName;
        }

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public static Type fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "deb": {
                    return DEB;
                }
                case "docker": {
                    return DOCKER;
                }
                case "rpm": {
                    return RPM;
                }
                case "tar": {
                    return TAR;
                }
                case "zip": {
                    return ZIP;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                throw new IllegalStateException("unexpected distribution type [" + displayName + "]; your distribution is broken");
            }
            return UNKNOWN;
        }
    }
}

