/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.spi.resources.sharing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.spi.resources.sharing.Recipients;

public class ShareWith
implements ToXContentFragment,
NamedWriteable {
    private final Map<String, Recipients> sharingInfo;

    public ShareWith(Map<String, Recipients> sharingInfo) {
        this.sharingInfo = sharingInfo;
    }

    public ShareWith(StreamInput in) throws IOException {
        this.sharingInfo = in.readMap(StreamInput::readString, Recipients::new);
    }

    public boolean isPublic() {
        return this.sharingInfo.values().stream().anyMatch(Recipients::isPublic);
    }

    public boolean isPrivate() {
        return this.sharingInfo == null || this.sharingInfo.isEmpty();
    }

    public Set<String> accessLevels() {
        return this.sharingInfo.keySet();
    }

    public Recipients atAccessLevel(String accessLevel) {
        return this.sharingInfo.get(accessLevel);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String accessLevel : this.sharingInfo.keySet()) {
            builder.field(accessLevel);
            Recipients recipients = this.sharingInfo.get(accessLevel);
            recipients.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public static ShareWith fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashMap<String, Recipients> sharingInfo = new HashMap<String, Recipients>();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String accessLevel = parser.currentName();
            parser.nextToken();
            Recipients recipients = Recipients.fromXContent(parser);
            sharingInfo.put(accessLevel, recipients);
        }
        return new ShareWith(sharingInfo);
    }

    public String getWriteableName() {
        return "share_with";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.sharingInfo, StreamOutput::writeString, (o, sw) -> sw.writeTo(o));
    }

    public String toString() {
        return "ShareWith " + String.valueOf(this.sharingInfo);
    }
}

