/*
 * Decompiled with CFR 0.152.
 */
package LocalCMC_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.CacheEntry;
import LocalCMC_Compile.DoublyLinkedCacheEntryList;
import LocalCMC_Compile.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache;

public class LocalCMC
implements ICryptographicMaterialsCache {
    public DoublyLinkedCacheEntryList queue = null;
    public MutableMap<DafnySequence<? extends Byte>, CacheEntry> cache = null;
    public BigInteger _entryCapacity = BigInteger.ZERO;
    public BigInteger _entryPruningTailSize = BigInteger.ZERO;
    private static final TypeDescriptor<LocalCMC> _TYPE = TypeDescriptor.referenceWithInitializer(LocalCMC.class, () -> null);

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> _out1 = _Companion_ICryptographicMaterialsCache.DeleteCacheEntry(this, input);
        return _out1;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> _out1 = _Companion_ICryptographicMaterialsCache.GetCacheEntry(this, input);
        return _out1;
    }

    @Override
    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> _out1 = _Companion_ICryptographicMaterialsCache.PutCacheEntry(this, input);
        return _out1;
    }

    @Override
    public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        Result<Tuple0, Error> _out1 = _Companion_ICryptographicMaterialsCache.UpdateUsageMetadata(this, input);
        return _out1;
    }

    public void __ctor(BigInteger entryCapacity_k, BigInteger entryPruningTailSize_k) {
        this._entryCapacity = entryCapacity_k;
        this._entryPruningTailSize = entryPruningTailSize_k;
        MutableMap _nw0 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), TypeDescriptor.reference(CacheEntry.class));
        this.cache = _nw0;
        DoublyLinkedCacheEntryList _nw1 = new DoublyLinkedCacheEntryList();
        _nw1.__ctor();
        this.queue = _nw1;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry_k(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> _out1;
        long _out0;
        Result<GetCacheEntryOutput, Error> output = null;
        long _0_now = _out0 = Time.__default.CurrentRelativeTime().longValue();
        output = _out1 = this.GetCacheEntryWithTime(input, _0_now);
        return output;
    }

    public Result<GetCacheEntryOutput, Error> GetCacheEntryWithTime(GetCacheEntryInput input, long now) {
        Result<GetCacheEntryOutput, Error> output = null;
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _0_entry = this.cache.Select(input.dtor_identifier());
            if (now <= _0_entry.expiryTime()) {
                this.queue.moveToFront(_0_entry);
                output = Result.create_Success(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput.create(_0_entry.materials(), _0_entry.creationTime(), _0_entry.expiryTime(), _0_entry.messagesUsed, _0_entry.bytesUsed));
                Result<Tuple0, Error> _1_valueOrError0 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
                Result<Tuple0, Error> _out0 = this.pruning(now);
                _1_valueOrError0 = _out0;
                if (_1_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _1_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _1_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            } else {
                Result<Tuple0, Error> _3_valueOrError1 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
                Result<Tuple0, Error> _out1 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _3_valueOrError1 = _out1;
                if (_3_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _3_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 _4___v1 = _3_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
                output = Result.create_Failure(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry past TTL")));
            }
        } else {
            output = Result.create_Failure(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        }
        return output;
    }

    @Override
    public Result<Tuple0, Error> PutCacheEntry_k(PutCacheEntryInput input) {
        Tuple0 tuple0;
        Result<Object, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        if (this.entryCapacity().signum() == 0) {
            output = Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
            return output;
        }
        if (this.cache.HasKey(input.dtor_identifier())) {
            Result<Tuple0, Error> _0_valueOrError0 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            Result<Tuple0, Error> _out0 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
            _0_valueOrError0 = _out0;
            if (_0_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                output = _0_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                return output;
            }
            tuple0 = _0_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
        }
        if (Objects.equals(this.entryCapacity(), this.cache.Size())) {
            Result<Tuple0, Error> _2_valueOrError1 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            Result<Tuple0, Error> _out1 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _2_valueOrError1 = _out1;
            if (_2_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                output = _2_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                return output;
            }
            tuple0 = _2_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
        }
        CacheEntry _nw0 = new CacheEntry();
        _nw0.__ctor(input.dtor_materials(), input.dtor_identifier(), input.dtor_creationTime(), input.dtor_expiryTime(), input.dtor_messagesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0), input.dtor_bytesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0));
        CacheEntry _4_cell = _nw0;
        this.queue.pushCell(_4_cell);
        this.cache.Put(input.dtor_identifier(), _4_cell);
        output = Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry_k(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _0_cell = this.cache.Select(input.dtor_identifier());
            this.cache.Remove(input.dtor_identifier());
            this.queue.remove(_0_cell);
        }
        output = Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> UpdateUsageMetadata_k(UpdateUsageMetadataInput input) {
        Result<Object, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _0_cell = this.cache.Select(input.dtor_identifier());
            if (_0_cell.messagesUsed <= __default.INT32__MAX__VALUE() - 1 && _0_cell.bytesUsed <= __default.INT32__MAX__VALUE() - input.dtor_bytesUsed()) {
                int _rhs0 = _0_cell.messagesUsed + 1;
                int _rhs1 = _0_cell.bytesUsed + input.dtor_bytesUsed();
                CacheEntry _lhs0 = _0_cell;
                CacheEntry _lhs1 = _0_cell;
                _lhs0.messagesUsed = _rhs0;
                _lhs1.bytesUsed = _rhs1;
            } else {
                Result<Tuple0, Error> _1_valueOrError0 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
                Result<Tuple0, Error> _out0 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _1_valueOrError0 = _out0;
                if (_1_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _1_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _1_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            }
        }
        output = Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<Tuple0, Error> pruning(long now) {
        Result<Tuple0, Error> result = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        BigInteger _hi0 = this.entryPruningTailSize();
        BigInteger _0_i = BigInteger.ZERO;
        while (_0_i.compareTo(_hi0) < 0) {
            if (!this.queue.tail.is_Ptr()) return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
            if (this.queue.tail.dtor_deref().expiryTime() >= now) return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
            Result<Tuple0, Error> _1_valueOrError0 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            Result<Tuple0, Error> _out0 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _1_valueOrError0 = _out0;
            if (_1_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                return _1_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
            }
            Tuple0 tuple0 = _1_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _0_i = _0_i.add(BigInteger.ONE);
        }
        return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
    }

    public BigInteger entryCapacity() {
        return this._entryCapacity;
    }

    public BigInteger entryPruningTailSize() {
        return this._entryPruningTailSize;
    }

    public static TypeDescriptor<LocalCMC> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "LocalCMC.LocalCMC";
    }
}

