/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.core.action.ActionListener;
import org.opensearch.env.Environment;
import org.opensearch.ingest.AbstractBatchingSystemProcessor;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestDocumentWrapper;
import org.opensearch.ml.common.MLModel;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.InferenceRequest;
import org.opensearch.neuralsearch.processor.TextInferenceRequest;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.dto.SemanticFieldInfo;
import org.opensearch.neuralsearch.processor.util.ChunkUtils;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.neuralsearch.util.ProcessorDocumentUtils;
import org.opensearch.neuralsearch.util.SemanticMLModelUtils;
import org.opensearch.neuralsearch.util.SemanticMappingUtils;
import org.opensearch.neuralsearch.util.TokenWeightUtil;
import org.opensearch.neuralsearch.util.prune.PruneType;
import org.opensearch.neuralsearch.util.prune.PruneUtils;

public class SemanticFieldProcessor
extends AbstractBatchingSystemProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(SemanticFieldProcessor.class);
    public static final String PROCESSOR_TYPE = "system_ingest_processor_semantic_field";
    private final Map<String, Map<String, Object>> pathToFieldConfig;
    private final Map<String, MLModel> modelIdToModelMap = new ConcurrentHashMap<String, MLModel>();
    private final Map<String, String> modelIdToModelTypeMap = new ConcurrentHashMap<String, String>();
    protected final MLCommonsClientAccessor mlCommonsClientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;
    private final Chunker defaultTextChunker;
    private static final float DEFAULT_PRUNE_RATIO = 0.1f;

    public SemanticFieldProcessor(@Nullable String tag, @Nullable String description, int batchSize, @NonNull Map<String, Map<String, Object>> pathToFieldConfig, @NonNull MLCommonsClientAccessor mlClientAccessor, @NonNull Environment environment, @NonNull ClusterService clusterService, @NonNull Chunker defaultTextChunker) {
        super(tag, description, batchSize);
        Objects.requireNonNull(pathToFieldConfig, "pathToFieldConfig is marked non-null but is null");
        Objects.requireNonNull(mlClientAccessor, "mlClientAccessor is marked non-null but is null");
        Objects.requireNonNull(environment, "environment is marked non-null but is null");
        Objects.requireNonNull(clusterService, "clusterService is marked non-null but is null");
        Objects.requireNonNull(defaultTextChunker, "defaultTextChunker is marked non-null but is null");
        this.pathToFieldConfig = pathToFieldConfig;
        this.mlCommonsClientAccessor = mlClientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
        this.defaultTextChunker = defaultTextChunker;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException(String.format(Locale.ROOT, "Should not try to use %s to ingest a doc synchronously.", PROCESSOR_TYPE));
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        EventStatsManager.increment(EventStatName.SEMANTIC_FIELD_PROCESSOR_EXECUTIONS);
        try {
            ProcessorDocumentUtils.unflattenIngestDoc(ingestDocument);
            List<SemanticFieldInfo> semanticFieldInfoList = this.getSemanticFieldInfo(ingestDocument);
            if (semanticFieldInfoList.isEmpty()) {
                handler.accept(ingestDocument, null);
            } else {
                this.fetchModelInfoThenProcess(ingestDocument, semanticFieldInfoList, handler);
            }
        }
        catch (Exception e) {
            handler.accept(null, e);
        }
    }

    private void fetchModelInfoThenProcess(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList, @NonNull BiConsumer<IngestDocument, Exception> handler) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        Set<String> modelIdsToGetModelInfo = semanticFieldInfoList.stream().map(SemanticFieldInfo::getModelId).collect(Collectors.toSet());
        for (String existingModelId : this.modelIdToModelMap.keySet()) {
            modelIdsToGetModelInfo.remove(existingModelId);
        }
        if (modelIdsToGetModelInfo.isEmpty()) {
            this.process(ingestDocument, semanticFieldInfoList, handler);
        } else {
            this.mlCommonsClientAccessor.getModels(modelIdsToGetModelInfo, modelIdToConfigMap -> {
                this.modelIdToModelMap.putAll((Map<String, MLModel>)modelIdToConfigMap);
                this.process(ingestDocument, semanticFieldInfoList, handler);
            }, e -> handler.accept((IngestDocument)null, (Exception)e));
        }
    }

    private void process(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList, @NonNull BiConsumer<IngestDocument, Exception> handler) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        this.setModelInfo(ingestDocument, semanticFieldInfoList);
        boolean isChunked = this.chunk(ingestDocument, semanticFieldInfoList);
        if (isChunked) {
            EventStatsManager.increment(EventStatName.SEMANTIC_FIELD_PROCESSOR_CHUNKING_EXECUTIONS);
        }
        this.generateAndSetEmbedding(ingestDocument, semanticFieldInfoList, handler);
    }

    private void setModelInfo(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        HashMap modelIdToInfoMap = new HashMap();
        for (Map.Entry<String, MLModel> entry : this.modelIdToModelMap.entrySet()) {
            String modelType;
            HashMap<String, String> modelInfo = new HashMap<String, String>();
            String modelId = entry.getKey();
            MLModel mlModel = entry.getValue();
            if (this.modelIdToModelTypeMap.containsKey(modelId)) {
                modelType = this.modelIdToModelTypeMap.get(modelId);
            } else {
                modelType = SemanticMLModelUtils.getModelType(mlModel);
                this.modelIdToModelTypeMap.put(modelId, modelType);
            }
            modelInfo.put("id", modelId);
            modelInfo.put("type", modelType);
            modelInfo.put("name", mlModel.getName());
            modelIdToInfoMap.put(modelId, modelInfo);
        }
        for (SemanticFieldInfo semanticFieldInfo : semanticFieldInfoList) {
            ingestDocument.setFieldValue(semanticFieldInfo.getFullPathForModelInfoInDoc(), modelIdToInfoMap.get(semanticFieldInfo.getModelId()));
        }
    }

    private void generateAndSetEmbedding(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList, @NonNull BiConsumer<IngestDocument, Exception> handler) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        Map<String, Set<String>> modelIdToRawDataMap = this.groupRawDataByModelId(semanticFieldInfoList);
        this.generateEmbedding(modelIdToRawDataMap, modelIdValueToEmbeddingMap -> {
            try {
                this.setInference(ingestDocument, semanticFieldInfoList, (Map<Pair<String, String>, Pair<Object, Exception>>)modelIdValueToEmbeddingMap, Float.valueOf(0.1f));
            }
            catch (Exception e) {
                handler.accept(null, e);
            }
            handler.accept(ingestDocument, null);
        });
    }

    private Map<String, Set<String>> groupRawDataByModelId(@NonNull Collection<List<SemanticFieldInfo>> semanticFieldInfoLists) {
        Objects.requireNonNull(semanticFieldInfoLists, "semanticFieldInfoLists is marked non-null but is null");
        HashMap<String, Set<String>> modelIdToRawDataMap = new HashMap<String, Set<String>>();
        for (List<SemanticFieldInfo> semanticFieldInfoList : semanticFieldInfoLists) {
            for (SemanticFieldInfo semanticFieldInfo : semanticFieldInfoList) {
                modelIdToRawDataMap.computeIfAbsent(semanticFieldInfo.getModelId(), k -> new HashSet()).addAll(semanticFieldInfo.getChunks());
            }
        }
        return modelIdToRawDataMap;
    }

    private Map<String, Set<String>> groupRawDataByModelId(@NonNull List<SemanticFieldInfo> semanticFieldInfoList) {
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        return this.groupRawDataByModelId(Collections.singleton(semanticFieldInfoList));
    }

    private void setInference(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList, @NonNull Map<Pair<String, String>, Pair<Object, Exception>> modelIdValueToEmbeddingMap, @NonNull Float pruneRatio) throws Exception {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        Objects.requireNonNull(modelIdValueToEmbeddingMap, "modelIdValueToEmbeddingMap is marked non-null but is null");
        Objects.requireNonNull(pruneRatio, "pruneRatio is marked non-null but is null");
        for (SemanticFieldInfo semanticFieldInfo : semanticFieldInfoList) {
            String modelId = semanticFieldInfo.getModelId();
            boolean isDenseModel = SemanticMLModelUtils.isDenseModel(this.modelIdToModelTypeMap.get(modelId));
            List<String> chunks = semanticFieldInfo.getChunks();
            for (int i = 0; i < chunks.size(); ++i) {
                String chunk = chunks.get(i);
                Exception exception = (Exception)modelIdValueToEmbeddingMap.get(Pair.of((Object)modelId, (Object)chunk)).getRight();
                if (exception != null) {
                    throw exception;
                }
                Map<String, Float> embedding = modelIdValueToEmbeddingMap.get(Pair.of((Object)modelId, (Object)chunk)).getLeft();
                if (!isDenseModel) {
                    embedding = PruneUtils.pruneSparseVector(PruneType.MAX_RATIO, pruneRatio.floatValue(), embedding);
                }
                String embeddingFullPath = semanticFieldInfo.getFullPathForEmbeddingInDoc(i);
                ingestDocument.setFieldValue(embeddingFullPath, embedding);
            }
        }
    }

    private List<SemanticFieldInfo> getSemanticFieldInfo(IngestDocument ingestDocument) {
        ArrayList<SemanticFieldInfo> semanticFieldInfos = new ArrayList<SemanticFieldInfo>();
        Map doc = ingestDocument.getSourceAndMetadata();
        this.pathToFieldConfig.forEach((path, config) -> this.collectSemanticFieldInfo(doc, path.split("\\."), (Map<String, Object>)config, 0, "", (List<SemanticFieldInfo>)semanticFieldInfos));
        return semanticFieldInfos;
    }

    private boolean chunk(@NonNull IngestDocument ingestDocument, @NonNull List<SemanticFieldInfo> semanticFieldInfoList) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        int maxTokenCount = ProcessorUtils.getMaxTokenCount(sourceAndMetadataMap, this.environment.settings(), this.clusterService);
        boolean isChunked = false;
        for (SemanticFieldInfo semanticFieldInfo : semanticFieldInfoList) {
            if (semanticFieldInfo.getChunkingEnabled().booleanValue()) {
                isChunked = true;
                if (semanticFieldInfo.getChunkers() == null || semanticFieldInfo.getChunkers().isEmpty()) {
                    semanticFieldInfo.setChunkers(List.of(this.defaultTextChunker));
                }
                this.executeChunkers(semanticFieldInfo, maxTokenCount);
                this.setChunkedText(ingestDocument, semanticFieldInfo);
                continue;
            }
            semanticFieldInfo.setChunks(List.of(semanticFieldInfo.getValue()));
        }
        return isChunked;
    }

    private void setChunkedText(@NonNull IngestDocument ingestDocument, @NonNull SemanticFieldInfo semanticFieldInfo) {
        Objects.requireNonNull(ingestDocument, "ingestDocument is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfo, "semanticFieldInfo is marked non-null but is null");
        ArrayList chunks = new ArrayList();
        for (String text : semanticFieldInfo.getChunks()) {
            HashMap<String, String> chunk = new HashMap<String, String>();
            chunk.put("text", text);
            chunks.add(chunk);
        }
        ingestDocument.setFieldValue(semanticFieldInfo.getFullPathForChunksInDoc(), chunks);
    }

    private void executeChunkers(@NonNull SemanticFieldInfo semanticFieldInfo, int maxTokenCount) {
        Objects.requireNonNull(semanticFieldInfo, "semanticFieldInfo is marked non-null but is null");
        for (Chunker chunker : semanticFieldInfo.getChunkers()) {
            HashMap<String, Object> runtimeParameters = new HashMap<String, Object>();
            List<String> chunks = semanticFieldInfo.getChunks();
            boolean isFirstChunker = chunks == null;
            runtimeParameters.put("max_token_count", maxTokenCount);
            runtimeParameters.put(Chunker.CHUNK_STRING_COUNT_FIELD, isFirstChunker ? 1 : chunks.size());
            runtimeParameters.put(Chunker.MAX_CHUNK_LIMIT_FIELD, Chunker.DEFAULT_MAX_CHUNK_LIMIT);
            ArrayList<String> chunkedText = new ArrayList<String>();
            if (isFirstChunker) {
                chunkedText.addAll(ChunkUtils.chunkString(chunker, semanticFieldInfo.getValue(), runtimeParameters));
            } else {
                chunkedText.addAll(ChunkUtils.chunkList(chunker, chunks, runtimeParameters));
            }
            semanticFieldInfo.setChunks(chunkedText);
        }
    }

    private void collectSemanticFieldInfo(@Nullable Object node, @NonNull String[] pathParts, @NonNull Map<String, Object> fieldConfig, int depth, @NonNull String currentPath, @NonNull List<SemanticFieldInfo> semanticFieldInfoList) {
        String key;
        Objects.requireNonNull(pathParts, "pathParts is marked non-null but is null");
        Objects.requireNonNull(fieldConfig, "fieldConfig is marked non-null but is null");
        Objects.requireNonNull(currentPath, "currentPath is marked non-null but is null");
        Objects.requireNonNull(semanticFieldInfoList, "semanticFieldInfoList is marked non-null but is null");
        if (depth > pathParts.length || node == null) {
            return;
        }
        String string = key = depth < pathParts.length ? pathParts[depth] : null;
        if (depth < pathParts.length && node instanceof Map) {
            Map mapNode = (Map)node;
            Object nextNode = mapNode.get(key);
            String newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
            this.collectSemanticFieldInfo(nextNode, pathParts, fieldConfig, depth + 1, newPath, semanticFieldInfoList);
        } else if (depth < pathParts.length && node instanceof List) {
            List listNode = (List)node;
            for (int i = 0; i < listNode.size(); ++i) {
                Object listItem = listNode.get(i);
                String indexedPath = currentPath + "." + i;
                this.collectSemanticFieldInfo(listItem, pathParts, fieldConfig, depth, indexedPath, semanticFieldInfoList);
            }
        } else if (depth == pathParts.length) {
            String pathToSemanticField = String.join((CharSequence)".", pathParts);
            if (!(node instanceof String)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expect the semantic field at path: %s to be a string but found: %s.", pathToSemanticField, node.getClass()));
            }
            SemanticFieldInfo semanticFieldInfo = SemanticFieldInfo.builder().value(node.toString()).modelId(SemanticMappingUtils.getModelId(fieldConfig, pathToSemanticField)).semanticFieldFullPathInMapping(currentPath).semanticInfoFullPathInDoc(SemanticMappingUtils.getSemanticInfoFieldFullPath(fieldConfig, currentPath, pathToSemanticField)).chunkingEnabled(SemanticMappingUtils.isChunkingEnabled(fieldConfig, pathToSemanticField)).build();
            semanticFieldInfoList.add(semanticFieldInfo);
        }
    }

    public void subBatchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler) {
        EventStatsManager.increment(EventStatName.SEMANTIC_FIELD_PROCESSOR_EXECUTIONS);
        if (ingestDocumentWrappers == null || ingestDocumentWrappers.isEmpty()) {
            handler.accept(ingestDocumentWrappers);
            return;
        }
        try {
            HashMap<IngestDocumentWrapper, List<SemanticFieldInfo>> docToSemanticFieldInfoMap = new HashMap<IngestDocumentWrapper, List<SemanticFieldInfo>>();
            for (IngestDocumentWrapper ingestDocumentWrapper : ingestDocumentWrappers) {
                IngestDocument ingestDocument = ingestDocumentWrapper.getIngestDocument();
                if (ingestDocument == null) continue;
                ProcessorDocumentUtils.unflattenIngestDoc(ingestDocument);
                List<SemanticFieldInfo> semanticFieldInfoList = this.getSemanticFieldInfo(ingestDocument);
                if (semanticFieldInfoList.isEmpty()) continue;
                docToSemanticFieldInfoMap.put(ingestDocumentWrapper, semanticFieldInfoList);
            }
            if (docToSemanticFieldInfoMap.isEmpty()) {
                handler.accept(ingestDocumentWrappers);
            } else {
                try {
                    this.fetchModelInfoThenBatchProcess(ingestDocumentWrappers, docToSemanticFieldInfoMap, handler);
                }
                catch (Exception e) {
                    this.addExceptionToImpactedDocs(docToSemanticFieldInfoMap.keySet(), e);
                    handler.accept(ingestDocumentWrappers);
                }
            }
        }
        catch (Exception e) {
            this.addExceptionToImpactedDocs(new HashSet<IngestDocumentWrapper>(ingestDocumentWrappers), e);
            handler.accept(ingestDocumentWrappers);
        }
    }

    private void fetchModelInfoThenBatchProcess(@NonNull List<IngestDocumentWrapper> ingestDocumentWrappers, @NonNull Map<IngestDocumentWrapper, List<SemanticFieldInfo>> docToSemanticFieldInfoMap, @NonNull Consumer<List<IngestDocumentWrapper>> handler) {
        Objects.requireNonNull(ingestDocumentWrappers, "ingestDocumentWrappers is marked non-null but is null");
        Objects.requireNonNull(docToSemanticFieldInfoMap, "docToSemanticFieldInfoMap is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        HashSet<String> modelIdsToGetConfig = new HashSet<String>();
        docToSemanticFieldInfoMap.values().forEach(semanticFieldInfoList -> semanticFieldInfoList.forEach(semanticFieldInfo -> modelIdsToGetConfig.add(semanticFieldInfo.getModelId())));
        for (String existingModelId : this.modelIdToModelMap.keySet()) {
            modelIdsToGetConfig.remove(existingModelId);
        }
        if (modelIdsToGetConfig.isEmpty()) {
            this.batchProcess(ingestDocumentWrappers, docToSemanticFieldInfoMap, handler);
        } else {
            this.mlCommonsClientAccessor.getModels(modelIdsToGetConfig, modelIdToConfigMap -> {
                this.modelIdToModelMap.putAll((Map<String, MLModel>)modelIdToConfigMap);
                this.batchProcess(ingestDocumentWrappers, docToSemanticFieldInfoMap, handler);
            }, e -> {
                this.addExceptionToImpactedDocs(docToSemanticFieldInfoMap.keySet(), (Exception)e);
                handler.accept(ingestDocumentWrappers);
            });
        }
    }

    private void batchProcess(@NonNull List<IngestDocumentWrapper> ingestDocumentWrappers, @NonNull Map<IngestDocumentWrapper, List<SemanticFieldInfo>> docToSemanticFieldInfoMap, @NonNull Consumer<List<IngestDocumentWrapper>> handler) {
        Objects.requireNonNull(ingestDocumentWrappers, "ingestDocumentWrappers is marked non-null but is null");
        Objects.requireNonNull(docToSemanticFieldInfoMap, "docToSemanticFieldInfoMap is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        boolean isChunked = false;
        for (Map.Entry<IngestDocumentWrapper, List<SemanticFieldInfo>> entry : docToSemanticFieldInfoMap.entrySet()) {
            IngestDocumentWrapper ingestDocumentWrapper = entry.getKey();
            IngestDocument ingestDocument = entry.getKey().getIngestDocument();
            List<SemanticFieldInfo> semanticFieldInfoList = entry.getValue();
            try {
                this.setModelInfo(ingestDocument, semanticFieldInfoList);
                if (!this.chunk(ingestDocument, semanticFieldInfoList)) continue;
                isChunked = true;
            }
            catch (Exception e) {
                log.error(String.format(Locale.ROOT, "Failed to set model info and chunk the semantic fields for the ingest document %s. Root cause: %s", ingestDocument.toString(), e.getMessage()), (Throwable)e);
                if (ingestDocumentWrapper.getException() != null) continue;
                ingestDocumentWrapper.update(ingestDocument, e);
            }
        }
        if (isChunked) {
            EventStatsManager.increment(EventStatName.SEMANTIC_FIELD_PROCESSOR_CHUNKING_EXECUTIONS);
        }
        this.batchGenerateAndSetEmbedding(ingestDocumentWrappers, docToSemanticFieldInfoMap, handler);
    }

    private void generateEmbedding(@NonNull Map<String, Set<String>> modelIdToRawDataMap, @NonNull Consumer<Map<Pair<String, String>, Pair<Object, Exception>>> onComplete) {
        Objects.requireNonNull(modelIdToRawDataMap, "modelIdToRawDataMap is marked non-null but is null");
        Objects.requireNonNull(onComplete, "onComplete is marked non-null but is null");
        AtomicInteger counter = new AtomicInteger(modelIdToRawDataMap.size());
        ConcurrentHashMap modelIdValueToEmbeddingMap = new ConcurrentHashMap();
        for (Map.Entry<String, Set<String>> entry : modelIdToRawDataMap.entrySet()) {
            String modelId = entry.getKey();
            boolean isDenseModel = SemanticMLModelUtils.isDenseModel(this.modelIdToModelTypeMap.get(modelId));
            ArrayList<String> values = new ArrayList<String>((Collection)entry.getValue());
            InferenceRequest textInferenceRequest = ((TextInferenceRequest.TextInferenceRequestBuilder)((InferenceRequest.InferenceRequestBuilder)TextInferenceRequest.builder().inputTexts(values)).modelId(modelId)).build();
            ActionListener listener = ActionListener.wrap(embeddings -> {
                List<Map<String, Float>> formattedEmbeddings = (List<Map<String, Float>>)embeddings;
                if (!isDenseModel) {
                    formattedEmbeddings = TokenWeightUtil.fetchListOfTokenWeightMap((List)embeddings);
                }
                for (int i = 0; i < values.size(); ++i) {
                    modelIdValueToEmbeddingMap.put(Pair.of((Object)modelId, (Object)((String)values.get(i))), Pair.of(formattedEmbeddings.get(i), null));
                }
                if (counter.decrementAndGet() == 0) {
                    onComplete.accept(modelIdValueToEmbeddingMap);
                }
            }, e -> {
                for (String value : values) {
                    modelIdValueToEmbeddingMap.put(Pair.of((Object)modelId, (Object)value), Pair.of(null, (Object)e));
                }
                if (counter.decrementAndGet() == 0) {
                    onComplete.accept(modelIdValueToEmbeddingMap);
                }
            });
            if (isDenseModel) {
                this.mlCommonsClientAccessor.inferenceSentences((TextInferenceRequest)textInferenceRequest, (ActionListener<List<List<Number>>>)listener);
                continue;
            }
            this.mlCommonsClientAccessor.inferenceSentencesWithMapResult((TextInferenceRequest)textInferenceRequest, listener);
        }
    }

    private void batchGenerateAndSetEmbedding(@NonNull List<IngestDocumentWrapper> ingestDocumentWrappers, @NonNull Map<IngestDocumentWrapper, List<SemanticFieldInfo>> docToSemanticFieldInfoMap, @NonNull Consumer<List<IngestDocumentWrapper>> handler) {
        Objects.requireNonNull(ingestDocumentWrappers, "ingestDocumentWrappers is marked non-null but is null");
        Objects.requireNonNull(docToSemanticFieldInfoMap, "docToSemanticFieldInfoMap is marked non-null but is null");
        Objects.requireNonNull(handler, "handler is marked non-null but is null");
        Map<String, Set<String>> modelIdToRawDataMap = this.groupRawDataByModelId(docToSemanticFieldInfoMap.values());
        this.generateEmbedding(modelIdToRawDataMap, modelIdValueToEmbeddingMap -> {
            this.batchSetInference(docToSemanticFieldInfoMap, (Map<Pair<String, String>, Pair<Object, Exception>>)modelIdValueToEmbeddingMap);
            handler.accept(ingestDocumentWrappers);
        });
    }

    private void batchSetInference(@NonNull Map<IngestDocumentWrapper, List<SemanticFieldInfo>> docToSemanticFieldInfoMap, @NonNull Map<Pair<String, String>, Pair<Object, Exception>> modelIdValueToEmbeddingMap) {
        Objects.requireNonNull(docToSemanticFieldInfoMap, "docToSemanticFieldInfoMap is marked non-null but is null");
        Objects.requireNonNull(modelIdValueToEmbeddingMap, "modelIdValueToEmbeddingMap is marked non-null but is null");
        for (Map.Entry<IngestDocumentWrapper, List<SemanticFieldInfo>> entry : docToSemanticFieldInfoMap.entrySet()) {
            IngestDocumentWrapper ingestDocumentWrapper = entry.getKey();
            IngestDocument ingestDocument = ingestDocumentWrapper.getIngestDocument();
            List<SemanticFieldInfo> semanticFieldInfoList = entry.getValue();
            try {
                this.setInference(ingestDocument, semanticFieldInfoList, modelIdValueToEmbeddingMap, Float.valueOf(0.1f));
            }
            catch (Exception e) {
                ingestDocumentWrapper.update(ingestDocument, e);
            }
        }
    }

    private void addExceptionToImpactedDocs(@NonNull Set<IngestDocumentWrapper> impactedDocs, @NonNull Exception e) {
        Objects.requireNonNull(impactedDocs, "impactedDocs is marked non-null but is null");
        Objects.requireNonNull(e, "e is marked non-null but is null");
        for (IngestDocumentWrapper ingestDocumentWrapper : impactedDocs) {
            if (ingestDocumentWrapper.getException() != null) continue;
            ingestDocumentWrapper.update(ingestDocumentWrapper.getIngestDocument(), e);
        }
    }

    public String getType() {
        return PROCESSOR_TYPE;
    }
}

