/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.settings;

import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.neuralsearch.settings.NeuralSearchSettings;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;

public class NeuralSearchSettingsAccessor {
    private volatile boolean isStatsEnabled;

    public NeuralSearchSettingsAccessor(ClusterService clusterService, Settings settings) {
        this.isStatsEnabled = (Boolean)NeuralSearchSettings.NEURAL_STATS_ENABLED.get(settings);
        this.registerSettingsCallbacks(clusterService);
    }

    private void registerSettingsCallbacks(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(NeuralSearchSettings.NEURAL_STATS_ENABLED, value -> {
            if (this.isStatsEnabled && !value.booleanValue()) {
                EventStatsManager.instance().reset();
            }
            this.isStatsEnabled = value;
        });
    }

    @Generated
    public boolean isStatsEnabled() {
        return this.isStatsEnabled;
    }
}

