/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class LTRSettings {
    private static Logger logger = LogManager.getLogger(LTRSettings.class);
    private static LTRSettings INSTANCE;
    public static final String LTR_PLUGIN_ENABLED = "ltr.plugin.enabled";
    public static final String LTR_BREAKER_ENABLED = "ltr.breaker.enabled";
    private final Map<String, Setting<?>> settings = Collections.unmodifiableMap(new HashMap<String, Setting<?>>(){
        {
            this.put(LTRSettings.LTR_PLUGIN_ENABLED, Setting.boolSetting((String)LTRSettings.LTR_PLUGIN_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            this.put(LTRSettings.LTR_BREAKER_ENABLED, Setting.boolSetting((String)LTRSettings.LTR_BREAKER_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        }
    });
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();
    private ClusterService clusterService;

    private LTRSettings() {
    }

    public static synchronized LTRSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LTRSettings();
        }
        return INSTANCE;
    }

    private void setSettingsUpdateConsumers() {
        for (Setting<?> setting : this.settings.values()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                logger.info("[LTR] The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                this.latestSettings.put(setting.getKey(), newVal);
            });
        }
    }

    public <T> T getSettingValue(String key) {
        return (T)this.latestSettings.getOrDefault(key, this.getSetting(key).getDefault(Settings.EMPTY));
    }

    private Setting<?> getSetting(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        throw new IllegalArgumentException("Cannot find setting by key [" + key + "]");
    }

    public static boolean isLTRPluginEnabled() {
        return (Boolean)LTRSettings.getInstance().getSettingValue(LTR_PLUGIN_ENABLED);
    }

    public static boolean isLTRBreakerEnabled() {
        return (Boolean)LTRSettings.getInstance().getSettingValue(LTR_BREAKER_ENABLED);
    }

    public void init(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.setSettingsUpdateConsumers();
    }

    public List<Setting<?>> getSettings() {
        return new ArrayList(this.settings.values());
    }
}

