/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import java.io.Serializable;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class JsonNameTransformer$
implements Serializable {
    private static final int nops;
    private static final String[] op2code;
    public static final JsonNameTransformer$ MODULE$;

    private JsonNameTransformer$() {
    }

    static {
        MODULE$ = new JsonNameTransformer$();
        nops = 128;
        op2code = new String[nops];
        MODULE$.enterOp('\"', "\\\"");
        MODULE$.enterOp('\\', "\\\\");
        MODULE$.enterOp('\b', "\\b");
        MODULE$.enterOp('\f', "\\f");
        MODULE$.enterOp('\n', "\\n");
        MODULE$.enterOp('\r', "\\r");
        MODULE$.enterOp('\t', "\\t");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonNameTransformer$.class);
    }

    private void enterOp(char op, String code) {
        JsonNameTransformer$.op2code[op] = code;
    }

    public String encode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i);
            if (c < nops && !(op2code[c] == null)) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.subSequence(0, i));
                }
                buf.append(op2code[c]);
                continue;
            }
            if (c <= '\u001f' || c >= '\u007f') {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.subSequence(0, i));
                }
                buf.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            if (!(!(buf == null))) continue;
            buf.append(c);
        }
        if (buf == null) {
            return name;
        }
        return buf.toString();
    }
}

