/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import java.util.Comparator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grouper<E> {
    public static final Object UNIQUE = Barcode.BLACK;
    public static final Object DUPLICATE = Barcode.WHITE;
    private static final Object UNIQUE_WITH_DUPLICATE = null;
    private static final Object TODO = Barcode.BLACK;
    private static final Object DONE = Barcode.WHITE;
    private static final int LEFT_GROUP = -1;
    private static final int NO_GROUP = 0;
    private static final int RIGHT_GROUP = 1;
    private SortedList<E> sortedList;
    private Comparator<? super E> comparator;
    private Client client;
    private Barcode barcode;

    public Grouper(SortedList<E> sortedList, Client client) {
        this.sortedList = sortedList;
        this.client = client;
        this.setComparator(sortedList.getComparator());
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (this.comparator == comparator) {
            return;
        }
        this.comparator = comparator;
        this.barcode = new Barcode();
        int n = this.sortedList.size();
        for (int i = 0; i < n; ++i) {
            this.barcode.add(i, this.groupTogether(i, i - 1) ? DUPLICATE : UNIQUE, 1);
        }
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public void listChanged(ListEvent<E> listChanges) {
        int changeType;
        int changeIndex;
        Barcode toDoList = new Barcode();
        toDoList.addWhite(0, this.barcode.size());
        LinkedList<Object> removedValues = new LinkedList<Object>();
        while (listChanges.next()) {
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                this.barcode.add(changeIndex, UNIQUE, 1);
                toDoList.add(changeIndex, TODO, 1);
                continue;
            }
            if (changeType == 1) {
                if (this.barcode.get(changeIndex) != UNIQUE || changeIndex + 1 >= this.barcode.size() || this.barcode.get(changeIndex + 1) != DUPLICATE) continue;
                this.barcode.set(changeIndex, UNIQUE, 2);
                toDoList.set(changeIndex, TODO, 1);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = this.barcode.get(changeIndex);
            this.barcode.remove(changeIndex, 1);
            toDoList.remove(changeIndex, 1);
            if (deleted == UNIQUE && changeIndex < this.barcode.size() && this.barcode.get(changeIndex) == DUPLICATE) {
                this.barcode.set(changeIndex, UNIQUE, 1);
                deleted = UNIQUE_WITH_DUPLICATE;
            }
            removedValues.addLast(deleted);
        }
        listChanges.reset();
        while (listChanges.next()) {
            int groupDeletedIndex;
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                if (this.tryJoinExistingGroup(changeIndex, toDoList) == 0) {
                    int groupIndex = this.barcode.getColourIndex(changeIndex, UNIQUE);
                    this.client.groupChanged(changeIndex, groupIndex, 2, true, changeType);
                    continue;
                }
                int groupIndex = this.barcode.getColourIndex(changeIndex, true, UNIQUE);
                this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                continue;
            }
            if (changeType == 1) {
                int oldGroup = 0;
                if (toDoList.get(changeIndex) == TODO) {
                    oldGroup = 1;
                } else if (this.barcode.get(changeIndex) == DUPLICATE) {
                    oldGroup = -1;
                } else if (this.barcode.get(changeIndex) == UNIQUE) {
                    oldGroup = 0;
                }
                int newGroup = this.tryJoinExistingGroup(changeIndex, toDoList);
                int groupIndex = this.barcode.getColourIndex(changeIndex, true, UNIQUE);
                if (newGroup == 0) {
                    if (oldGroup == 0) {
                        this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                        continue;
                    }
                    if (oldGroup == -1) {
                        this.client.groupChanged(changeIndex, groupIndex - 1, 1, false, changeType);
                        this.client.groupChanged(changeIndex, groupIndex, 2, true, changeType);
                        continue;
                    }
                    if (oldGroup != 1) continue;
                    this.client.groupChanged(changeIndex, groupIndex, 2, true, changeType);
                    this.client.groupChanged(changeIndex, groupIndex + 1, 1, false, changeType);
                    continue;
                }
                if (newGroup == -1) {
                    if (oldGroup == 0) {
                        this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                        this.client.groupChanged(changeIndex, groupIndex + 1, 0, false, changeType);
                        continue;
                    }
                    if (oldGroup == -1) {
                        this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                        continue;
                    }
                    if (oldGroup != 1) continue;
                    this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                    if (groupIndex + 1 >= this.barcode.blackSize()) continue;
                    this.client.groupChanged(changeIndex, groupIndex + 1, 1, false, changeType);
                    continue;
                }
                if (newGroup != 1) continue;
                if (oldGroup == 0) {
                    this.client.groupChanged(changeIndex, groupIndex, 0, false, changeType);
                    this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                    continue;
                }
                if (oldGroup == -1) {
                    if (groupIndex - 1 >= 0) {
                        this.client.groupChanged(changeIndex, groupIndex - 1, 1, false, changeType);
                    }
                    this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                    continue;
                }
                if (oldGroup != 1) continue;
                this.client.groupChanged(changeIndex, groupIndex, 1, true, changeType);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = removedValues.removeFirst();
            int sourceDeletedIndex = deleted == DUPLICATE ? changeIndex - 1 : changeIndex;
            int n = groupDeletedIndex = sourceDeletedIndex < this.barcode.size() ? this.barcode.getBlackIndex(sourceDeletedIndex, true) : this.barcode.blackSize();
            if (deleted == UNIQUE) {
                this.client.groupChanged(changeIndex, groupDeletedIndex, 0, true, changeType);
                continue;
            }
            this.client.groupChanged(changeIndex, groupDeletedIndex, 1, true, changeType);
        }
    }

    private boolean groupTogether(int sourceIndex0, int sourceIndex1) {
        if (sourceIndex0 < 0 || sourceIndex0 >= this.sortedList.size()) {
            return false;
        }
        if (sourceIndex1 < 0 || sourceIndex1 >= this.sortedList.size()) {
            return false;
        }
        return this.comparator.compare(this.sortedList.get(sourceIndex0), this.sortedList.get(sourceIndex1)) == 0;
    }

    private int tryJoinExistingGroup(int changeIndex, Barcode toDoList) {
        int predecessorIndex = changeIndex - 1;
        if (this.groupTogether(predecessorIndex, changeIndex)) {
            this.barcode.set(changeIndex, DUPLICATE, 1);
            return -1;
        }
        int successorIndex = changeIndex + 1;
        while (this.groupTogether(changeIndex, successorIndex)) {
            if (toDoList.get(successorIndex) == DONE) {
                this.barcode.set(changeIndex, UNIQUE, 1);
                this.barcode.set(successorIndex, DUPLICATE, 1);
                return 1;
            }
            ++successorIndex;
        }
        this.barcode.set(changeIndex, UNIQUE, 1);
        return 0;
    }

    public static interface Client {
        public void groupChanged(int var1, int var2, int var3, boolean var4, int var5);
    }
}

