/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.NbPlaces;
import org.openide.ServiceType;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Services
extends ServiceType.Registry
implements LookupListener {
    static final long serialVersionUID = -7558069607307508327L;
    private Lookup.Result<ServiceType> allTypes;
    private Map<String, ServiceType> name2Service = new HashMap<String, ServiceType>();

    public static Services getDefault() {
        return (Services)((Object)Lookup.getDefault().lookup(ServiceType.Registry.class));
    }

    public ServiceType find(Class clazz) {
        return (ServiceType)Lookup.getDefault().lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceType find(String string) {
        ServiceType serviceType;
        Map<String, ServiceType> map;
        Map<String, ServiceType> map2 = map = this.name2Service;
        synchronized (map2) {
            serviceType = map.get(string);
        }
        if (serviceType == null) {
            serviceType = super.find(string);
            map2 = map;
            synchronized (map2) {
                map.put(string, serviceType);
            }
        }
        return serviceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup.Result<ServiceType> getTypesResult() {
        boolean bl = false;
        Services services = this;
        synchronized (services) {
            if (this.allTypes == null) {
                this.allTypes = Lookup.getDefault().lookupResult(ServiceType.class);
                this.allTypes.addLookupListener((LookupListener)this);
                bl = true;
            }
        }
        if (bl) {
            this.resultChanged(null);
        }
        return this.allTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        Map<String, ServiceType> map = this.name2Service;
        synchronized (map) {
            this.name2Service.clear();
        }
    }

    public List<ServiceType> getServiceTypes() {
        return new ArrayList<ServiceType>(this.getTypesResult().allInstances());
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setServiceTypes(List list) {
        List<Object> list2;
        DataObject dataObject;
        if (list == null) {
            throw new NullPointerException();
        }
        List<ServiceType> list3 = this.ensureSingleness(list);
        HashMap<ServiceType, DataObject> hashMap = new HashMap<ServiceType, DataObject>(20);
        NbPlaces.getDefault();
        this.searchServices(NbPlaces.findSessionFolder("Services").getPrimaryFile(), hashMap);
        HashMap<DataObject, ArrayList<void>> hashMap2 = new HashMap<DataObject, ArrayList<void>>(10);
        for (ServiceType object : list3) {
            void var7_9;
            DataObject dataObject2 = hashMap.get(object);
            if (dataObject2 != null) {
                try {
                    InstanceDataObject instanceDataObject = InstanceDataObject.create((DataFolder)dataObject2.getFolder(), (String)dataObject2.getPrimaryFile().getName(), (Object)object, null);
                }
                catch (IOException iOException) {
                    Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, iOException);
                }
                hashMap.remove(object);
            } else {
                DataObject dataObject3 = this.storeNewServiceType(object);
            }
            if (var7_9 == null) continue;
            dataObject = var7_9.getFolder();
            list2 = (List)hashMap2.get(dataObject);
            if (list2 == null) {
                list2 = new ArrayList<void>(6);
                hashMap2.put(dataObject, (ArrayList<void>)list2);
            }
            list2.add(var7_9);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            dataObject = (DataObject)entry.getKey();
            list2 = (ArrayList<void>)entry.getValue();
            if (list2.size() < 2) continue;
            Iterator iterator = list2.iterator();
            StringBuffer stringBuffer = new StringBuffer(64);
            while (iterator.hasNext()) {
                DataObject dataObject4 = (DataObject)iterator.next();
                stringBuffer.append(dataObject4.getPrimaryFile().getNameExt()).append('/');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            try {
                dataObject.getPrimaryFile().setAttribute("OpenIDE-Folder-Order", (Object)stringBuffer.toString());
            }
            catch (IOException iOException) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        for (DataObject dataObject5 : hashMap.values()) {
            try {
                dataObject5.delete();
            }
            catch (IOException iOException) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    private DataObject storeNewServiceType(ServiceType serviceType) {
        Class<?> clazz = serviceType.getClass();
        while (clazz.getSuperclass() != ServiceType.class) {
            clazz = clazz.getSuperclass();
        }
        try {
            String string = Utilities.getShortClassName(clazz);
            NbPlaces.getDefault();
            DataFolder dataFolder = NbPlaces.findSessionFolder("Services");
            DataFolder dataFolder2 = DataFolder.create((DataFolder)dataFolder, (String)string);
            return InstanceDataObject.create((DataFolder)dataFolder2, null, (Object)serviceType, null);
        }
        catch (Exception exception) {
            Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, exception);
            return null;
        }
    }

    private List<ServiceType> ensureSingleness(List<ServiceType> list) {
        ArrayList<ServiceType> arrayList = new ArrayList<ServiceType>(list.size());
        for (ServiceType serviceType : list) {
            if (arrayList.contains(serviceType)) continue;
            arrayList.add(serviceType);
        }
        return arrayList;
    }

    private void searchServices(FileObject fileObject, Map<ServiceType, DataObject> map) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!fileObjectArray[i].isValid()) continue;
            if (fileObjectArray[i].isFolder()) {
                this.searchServices(fileObjectArray[i], map);
                continue;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObjectArray[i]);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie == null || !Services.instanceOf(instanceCookie, ServiceType.class)) continue;
                ServiceType serviceType = (ServiceType)instanceCookie.instanceCreate();
                map.put(serviceType, dataObject);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, exception);
            }
        }
    }

    private static boolean instanceOf(InstanceCookie instanceCookie, Class clazz) {
        if (instanceCookie instanceof InstanceCookie.Of) {
            return ((InstanceCookie.Of)instanceCookie).instanceOf(clazz);
        }
        try {
            return clazz.isAssignableFrom(instanceCookie.instanceClass());
        }
        catch (Exception exception) {
            Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, exception);
            return false;
        }
    }

    public Enumeration<ServiceType> services() {
        return Collections.enumeration(this.getServiceTypes());
    }

    public <T extends ServiceType> Enumeration<T> services(Class<T> clazz) {
        if (clazz == null) {
            return Enumerations.empty();
        }
        Collection collection = Lookup.getDefault().lookupAll(clazz);
        return Collections.enumeration(collection);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Enumeration<ServiceType> enumeration = this.services();
        while (enumeration.hasMoreElements()) {
            NbMarshalledObject nbMarshalledObject;
            ServiceType serviceType = enumeration.nextElement();
            try {
                nbMarshalledObject = new NbMarshalledObject((Object)serviceType);
            }
            catch (IOException iOException) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, iOException);
                nbMarshalledObject = null;
            }
            if (nbMarshalledObject == null) continue;
            objectOutputStream.writeObject(nbMarshalledObject);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NbMarshalledObject nbMarshalledObject;
        LinkedList<ServiceType> linkedList = new LinkedList<ServiceType>();
        while ((nbMarshalledObject = (NbMarshalledObject)objectInputStream.readObject()) != null) {
            try {
                ServiceType serviceType = (ServiceType)nbMarshalledObject.get();
                linkedList.add(serviceType);
            }
            catch (IOException iOException) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(Services.class.getName()).log(Level.WARNING, null, classNotFoundException);
            }
        }
        Services.getDefault().setServiceTypes(linkedList);
    }

    private Object readResolve() {
        return Services.getDefault();
    }
}

