'\"
'\" Generated from file 'pt_astree\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt::ast" n 1\&.1 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt::ast \- Abstract Syntax Tree Serialization
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::ast  ?1\&.1?\fR
.sp
\fB::pt::ast\fR \fBverify\fR \fIserial\fR ?\fIcanonvar\fR?
.sp
\fB::pt::ast\fR \fBverify-as-canonical\fR \fIserial\fR
.sp
\fB::pt::ast\fR \fBcanonicalize\fR \fIserial\fR
.sp
\fB::pt::ast\fR \fBprint\fR \fIserial\fR
.sp
\fB::pt::ast\fR \fBbottomup\fR \fIcmdprefix\fR \fIast\fR
.sp
\fBcmdprefix\fR \fIast\fR
.sp
\fB::pt::ast\fR \fBtopdown\fR \fIcmdprefix\fR \fIpe\fR
.sp
\fB::pt::ast\fR \fBequal\fR \fIseriala\fR \fIserialb\fR
.sp
\fB::pt::ast\fR \fBnew0\fR \fIs\fR \fIloc\fR ?\fIchild\fR\&.\&.\&.?
.sp
\fB::pt::ast\fR \fBnew\fR \fIs\fR \fIstart\fR \fIend\fR ?\fIchild\fR\&.\&.\&.?
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package provides commands to work with the serializations of
abstract syntax trees as managed by the Parser Tools, and specified in
section \fBAST serialization format\fR\&.
.PP
This is a supporting package in the Core Layer of Parser Tools\&.
.PP
IMAGE: arch_core_support
.PP
.SH API
.TP
\fB::pt::ast\fR \fBverify\fR \fIserial\fR ?\fIcanonvar\fR?
This command verifies that the content of \fIserial\fR is a valid
serialization of an abstract syntax tree and will throw an error if
that is not the case\&. The result of the command is the empty string\&.
.sp
If the argument \fIcanonvar\fR is specified it is interpreted as the
name of a variable in the calling context\&. This variable will be
written to if and only if \fIserial\fR is a valid regular
serialization\&. Its value will be a boolean, with \fBTrue\fR
indicating that the serialization is not only valid, but also
\fIcanonical\fR\&. \fBFalse\fR will be written for a valid, but
non-canonical serialization\&.
.sp
For the specification of serializations see the section
\fBAST serialization format\fR\&.
.TP
\fB::pt::ast\fR \fBverify-as-canonical\fR \fIserial\fR
This command verifies that the content of \fIserial\fR is a valid
\fIcanonical\fR serialization of an abstract syntax tree and will
throw an error if that is not the case\&. The result of the command is
the empty string\&.
.sp
For the specification of canonical serializations see the section
\fBAST serialization format\fR\&.
.TP
\fB::pt::ast\fR \fBcanonicalize\fR \fIserial\fR
This command assumes that the content of \fIserial\fR is a valid
\fIregular\fR serialization of an abstract syntax and will throw an
error if that is not the case\&.
.sp
It will then convert the input into the \fIcanonical\fR serialization
of the contained tree and return it as its result\&. If the input is
already canonical it will be returned unchanged\&.
.sp
For the specification of regular and canonical serializations see the
section \fBAST serialization format\fR\&.
.TP
\fB::pt::ast\fR \fBprint\fR \fIserial\fR
This command assumes that the argument \fIserial\fR contains a valid
serialization of an abstract syntax tree and returns a string
containing that tree in a human readable form\&.
.sp
The exact format of this form is not specified and cannot be relied on
for parsing or other machine-based activities\&.
.sp
For the specification of serializations see the section
\fBAST serialization format\fR\&.
.TP
\fB::pt::ast\fR \fBbottomup\fR \fIcmdprefix\fR \fIast\fR
This command walks the abstract syntax tree \fIast\fR from the bottom
up to the root, invoking the command prefix \fIcmdprefix\fR for each
node\&. This implies that the children of a node N are handled before N\&.
.sp
The command prefix has the signature
.RS
.TP
\fBcmdprefix\fR \fIast\fR
I\&.e\&. it is invoked with the ast node the walk is currently at\&.
.sp
The result returned by the command prefix replaces \fIast\fR in the
node it was a child of, allowing transformations of the tree\&.
.sp
This also means that for all inner node the contents of the children
elements are the results of the command prefix invoked for the
children of this node\&.
.RE
.TP
\fB::pt::ast\fR \fBtopdown\fR \fIcmdprefix\fR \fIpe\fR
This command walks the abstract syntax tree \fIast\fR from the root
down to the leaves, invoking the command prefix \fIcmdprefix\fR for
each node\&. This implies that the children of a node N are handled
after N\&.
.sp
The command prefix has the same signature as for \fBbottomup\fR,
see above\&.
.sp
The result returned by the command prefix is \fIignored\fR\&.
.TP
\fB::pt::ast\fR \fBequal\fR \fIseriala\fR \fIserialb\fR
This command tests the two sbstract syntax trees \fIseriala\fR and
\fIserialb\fR for structural equality\&. The result of the command is a
boolean value\&. It will be set to \fBtrue\fR if the trees are
identical, and \fBfalse\fR otherwise\&.
.sp
String equality is usable only if we can assume that the two trees are
pure Tcl lists\&.
.TP
\fB::pt::ast\fR \fBnew0\fR \fIs\fR \fIloc\fR ?\fIchild\fR\&.\&.\&.?
This command command constructs the ast for a nonterminal node
refering refering to the symbol \fIs\fR at position \fIloc\fR in the
input, and the set of child nodes \fIchild\fR \&.\&.\&., from left
right\&. The latter may be empty\&. The constructed node is returned as
the result of the command\&. The end position is \fIloc\fR-1, i\&.e\&. one
character before the start\&. This type of node is possible for rules
containing optional parts\&.
.TP
\fB::pt::ast\fR \fBnew\fR \fIs\fR \fIstart\fR \fIend\fR ?\fIchild\fR\&.\&.\&.?
This command command constructs the ast for a nonterminal node
refering to the symbol \fIs\fR covering the range of positions
\fIstart\fR to \fIend\fR in the input, and the set of child nodes
\fIchild\fR \&.\&.\&., from left right\&. The latter may be empty\&. The
constructed node is returned as the result of the command\&.
.PP
.SH "AST SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Abstract Syntax Trees (ASTs) as immutable values for transport,
comparison, etc\&.
.PP
Each node in an AST represents a nonterminal symbol of a grammar, and
the range of tokens/characters in the input covered by it\&. ASTs do not
contain terminal symbols, i\&.e\&. tokens/characters\&. These can be
recovered from the input given a symbol's location\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a tree may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR\&.
.TP
Regular serialization
.RS
.IP [1]
The serialization of any AST is the serialization of its root node\&.
.IP [2]
The serialization of any node is a Tcl list containing at least three
elements\&.
.RS
.IP [1]
The first element is the name of the nonterminal symbol stored in the
node\&.
.IP [2]
The second and third element are the locations of the first and last
token in the token stream the node represents (covers)\&.
.RS
.IP [1]
Locations are provided as non-negative integer offsets from the
beginning of the token stream, with the first token found in the
stream located at offset 0 (zero)\&.
.IP [2]
The end location has to be equal to or larger than the start location\&.
.RE
.IP [3]
All elements after the first three represent the children of the node,
which are themselves nodes\&. This means that the serializations of
nodes without children, i\&.e\&. leaf nodes, have exactly three elements\&.
The children are stored in the list with the leftmost child first, and
the rightmost child last\&.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of an abstract syntax tree has the format
as specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this tree\&.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list\&. I\&.e\&. it does not contain superfluous whitespace\&.
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression grammar below
.PP
.CS


PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'       ;
    Sign       <- '-' / '+'                                     ;
    Number     <- Sign? Digit+                                  ;
    Expression <- Term (AddOp Term)*                            ;
    MulOp      <- '*' / '/'                                     ;
    Term       <- Factor (MulOp Factor)*                        ;
    AddOp      <- '+'/'-'                                       ;
    Factor     <- '(' Expression ')' / Number                   ;
END;

.CE
.PP
and the input string
.CS

 120+5
.CE
then a parser should deliver the abstract syntax tree below (except for whitespace)
.PP
.CS


set ast {Expression 0 4
    {Factor 0 4
        {Term 0 2
            {Number 0 2
                {Digit 0 0}
                {Digit 1 1}
                {Digit 2 2}
            }
        }
        {AddOp 3 3}
        {Term 4 4
            {Number 4 4
                {Digit 4 4}
            }
        }
    }
}

.CE
.PP
Or, more graphical
.PP
.PS
\&.nf
+- Digit 0 0 | 1
|            |
+- Term 0 2 --- Number 0 2 -+- Digit 1 1 | 2
|                           |            |
|                           +- Digit 2 2 | 0
|                                        |
Expression 0 4 --- Factor 0 4 -+----------------------------- AddOp 3 3 | +
|                                        |
+- Term 4 4 --- Number 4 4 --- Digit 4 4 | 5
\&.fi
.PE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi