# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the ios_l3_interfaces module
"""


class L3_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_l3_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "autostate": {"type": "bool"},
                "mac_address": {"type": "str"},
                "name": {"type": "str", "required": True},
                "ipv4": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "secondary": {"type": "bool"},
                        "dhcp_client": {"type": "str"},
                        "dhcp_hostname": {"type": "str"},
                        "dhcp": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "client_id": {"type": "str"},
                                "hostname": {"type": "str"},
                            },
                        },
                        "pool": {"type": "str"},
                        "source_interface": {
                            "type": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "poll": {"type": "bool"},
                                "point_to_point": {"type": "bool"},
                            },
                        },
                    },
                },
                "ipv6": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "autoconfig": {
                            "type": "dict",
                            "options": {"enable": {"type": "bool"}, "default": {"type": "bool"}},
                        },
                        "dhcp": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "rapid_commit": {"type": "bool"},
                            },
                        },
                        "enable": {"type": "bool"},
                        "anycast": {"type": "bool"},
                        "cga": {"type": "bool"},
                        "eui": {"type": "bool"},
                        "link_local": {"type": "bool"},
                        "segment_routing": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "default": {"type": "bool"},
                                "ipv6_sr": {"type": "bool"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
