/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.IndexedValueExpression;
import javax.servlet.jsp.jstl.core.IteratedExpression;
import javax.servlet.jsp.jstl.core.IteratedValueExpression;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import org.apache.taglibs.standard.resources.Resources;

public abstract class ForEachSupport
extends LoopTagSupport {
    protected Iterator items;
    protected Object rawItems;

    protected void prepare() throws JspTagException {
        if (this.rawItems == null) {
            this.items = new ToEndIterator(this.end);
        } else if (this.rawItems instanceof ValueExpression) {
            this.deferredExpression = (ValueExpression)this.rawItems;
            Object o = this.deferredExpression.getValue(this.pageContext.getELContext());
            Iterator iterator = this.toIterator(o);
            this.items = this.isIndexed(o) ? new IndexedDeferredIterator(iterator, this.deferredExpression) : new IteratedDeferredIterator(iterator, new IteratedExpression(this.deferredExpression, this.getDelims()));
        } else {
            this.items = this.toIterator(this.rawItems);
        }
    }

    private Iterator toIterator(Object rawItems) throws JspTagException {
        if (rawItems instanceof Collection) {
            return ((Collection)rawItems).iterator();
        }
        if (rawItems.getClass().isArray()) {
            return new ArrayIterator(rawItems);
        }
        if (rawItems instanceof Iterator) {
            return (Iterator)rawItems;
        }
        if (rawItems instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)rawItems);
        }
        if (rawItems instanceof Map) {
            return ((Map)rawItems).entrySet().iterator();
        }
        if (rawItems instanceof String) {
            return new EnumerationIterator(new StringTokenizer((String)rawItems, ","));
        }
        throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
    }

    private boolean isIndexed(Object o) {
        return o.getClass().isArray();
    }

    protected boolean hasNext() throws JspTagException {
        return this.items.hasNext();
    }

    protected Object next() throws JspTagException {
        return this.items.next();
    }

    public void release() {
        super.release();
        this.items = null;
        this.rawItems = null;
    }

    private static abstract class ReadOnlyIterator
    implements Iterator {
        private ReadOnlyIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class DeferredIterator
    extends ReadOnlyIterator {
        protected final Iterator iterator;
        protected int currentIndex = 0;

        protected DeferredIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class IteratedDeferredIterator
    extends DeferredIterator {
        private final IteratedExpression itemsValueIteratedExpression;

        private IteratedDeferredIterator(Iterator iterator, IteratedExpression itemsValueIteratedExpression) {
            super(iterator);
            this.itemsValueIteratedExpression = itemsValueIteratedExpression;
        }

        public Object next() {
            this.iterator.next();
            return new IteratedValueExpression(this.itemsValueIteratedExpression, this.currentIndex++);
        }
    }

    private static class IndexedDeferredIterator
    extends DeferredIterator {
        private final ValueExpression itemsValueExpression;

        private IndexedDeferredIterator(Iterator iterator, ValueExpression itemsValueExpression) {
            super(iterator);
            this.itemsValueExpression = itemsValueExpression;
        }

        public Object next() {
            this.iterator.next();
            return new IndexedValueExpression(this.itemsValueExpression, this.currentIndex++);
        }
    }

    private static class ArrayIterator
    extends ReadOnlyIterator {
        private final Object array;
        private final int length;
        private int i = 0;

        private ArrayIterator(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        public boolean hasNext() {
            return this.i < this.length;
        }

        public Object next() {
            try {
                return Array.get(this.array, this.i++);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }

    private static class EnumerationIterator
    extends ReadOnlyIterator {
        private final Enumeration e;

        private EnumerationIterator(Enumeration e) {
            this.e = e;
        }

        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public Object next() {
            return this.e.nextElement();
        }
    }

    private static class ToEndIterator
    extends ReadOnlyIterator {
        private final int end;
        private int i;

        private ToEndIterator(int end) {
            this.end = end;
        }

        public boolean hasNext() {
            return this.i <= this.end;
        }

        public Object next() {
            if (this.i <= this.end) {
                return this.i++;
            }
            throw new NoSuchElementException();
        }
    }
}

