# gt - graph typesetting program
#
# $Id: gt,v 1.10 1994/02/03 00:45:57 pliam Exp $
#
$usage = "usage: $0 file[.gt]";
require 'graphtex.pl';

#
# command line
#
if ($#ARGV != 0) { die "$usage"; }
$file = shift;
$file =~ s/\.gt$//; # strip extension
$db = 1; # (future command line options...)
         # debug: -d
         # macro: -m (write a macro with same name as the filename)
         # print: -p (print arrays in perl style)
open(IN, "$file.gt") || die "cannot open $file.gt";
open(OUT, ">$file.tex") || die "cannot write to $file.tex";

#
# read from <IN>
#
&defaults; # set up all variables for use by \gtsetglb{}{}
$input = '';
while (<IN>) {
   s/\n/ /;
   s/%.*//; # ignore comments
   if (/^\\gtsetglb\{\\([^\}]+)\}\{([^\}]+)\}\s*$/) {
      eval("\$symtab{$1} = $2;"); # set global constant
      &defaults; # allows some calculations in preamble
   } 
   else { $input .= $_; }
}
&defaults; # now set up global symbol table

#
# form %connect and %posit arrays for rectangular grid
#
@lines = split(/\\\\\s*/, $input);
foreach $j (0..$#lines) {
   $l = $lines[$j];
   print OUT "%\n% line $j: $l\n%\n" if ($db);
   @entries = split(/&\s*/, $l);
   foreach $i (0..$#entries) {
      $e = $entries[$i];
      print OUT "%\n% entry: $e\n%\n" if ($db);
      $obj = "grid$i,$j";
      $posit{$obj} = sprintf("%f %f", $i*$versep, -$j*$versep*$vertstr);
      $connect{$obj} = $e;
   }
}

#
# print .tex commands to standard output
#
&parse;
