---
myst:
  html_meta:
    keywords: LaTeX,installer LaTeX,Mac,MacOs,distribution
---
# Quelles sont les distributions TeX pour les systèmes Mac ?

Trois [distributions TeX](/1_generalites/glossaire/distribution) sont
actuellement disponibles pour les systèmes Mac. Les deux premières,
[MacTeX](#mactex) et [TeX Live](#tex-live), sont sœurs : MacTeX inclus TeX Live.
La troisième est [MiKTeX](#miktex).

## MacTeX

[MacTeX](https://tug.org/mactex/) est la distribution TeX par excellence pour
[macOS](wpfr:macOS). Elle est basée sur [TeX Live](https://tug.org/texlive/)
(vous pouvez donc vous référer à son guide pratique, traduit français, qui est
disponible au format
[HTML](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html) et
[PDF](https://tug.org/texlive/doc/texlive-fr/texlive-fr.pdf)). MacTeX apporte
[plusieurs ajouts](https://tug.org/mactex/whatsinthepackage.html) à TeX Live
dont : un installateur et un gestionnaire graphique TeX Live natifs pour macOS,
et l'éditeur [TeXShop](http://www.uoregon.edu/~koch/texshop/texshop.html).

:::{attention}

Vérifiez sur la [page d'accueil](https://tug.org/mactex/) de MacTeX quelles
méthodes d'installation sont disponibles pour votre version de macOS.

:::

Notez que l'installation de MacTeX nécessite le privilège
[*root*](wpfr:Utilisateur_root). C'est dommage car il propose plusieurs extras non
disponibles sur une TeX Live standard et donc non accessibles aux personnes qui
n'ont pas ce privilège *root*. Pour ces derniers, l'alternative revient donc à
utiliser l'installateur `install-tl` de TeX Live (voir [cette
discussion](https://tex.stackexchange.com/questions/106113/is-there-any-way-to-have-a-latex-compiler-on-a-mac-without-root-access)
sur tex.stackexchange.com pour plus de détails).

De plus amples informations sont disponibles sur la [page
d'aide](https://www.tug.org/mactex/gettinghelp.html) de MacTeX.

### Installation classique de MacTeX

La méthode d'installation classique est décrite (en anglais)
[ici](https://tug.org/mactex/mactex-download.html). Elle commence par le
téléchargement du fichier
[MacTeX.pkg](https://mirror.ctan.org/systems/mac/mactex/MacTeX.pkg) (un gros
fichier de plus de 5,7 GB). Ensuite, l'ouverture de ce fichier lancera le
programme d'installation : vous pourrez procéder à une installation complète par
défaut ou, si vous le souhaitez, la personnaliser.

:Avantages: elle est par défaut *complète* et relativement *facile*.

:Inconvénient: elle nécessite une bonne connexion internet pour télécharger le
fichier `MacTeX.pkg`.

### Installation réduite de MacTeX (BasicTeX)

Une installation réduite de MacTeX existe, elle s'appelle BasicTeX et est
décrite sur [cette page](https://tug.org/mactex/morepackages.html) (voir aussi
[sa documentation](https://tug.org/mactex/BasicTeX.pdf)). Elle commence par le
téléchargement du fichier
[BasicTeX.pkg](https://mirror.ctan.org/systems/mac/mactex/BasicTeX.pkg).
Ensuite, l'ouverture de ce fichier lancera le programme d'installation qui
installera **seulement** le *small scheme* de TeX Live. En particulier, aucun
programme avec interface graphique spécifique à macOS ne sera installé ; vous
pouvez néanmoins les installer séparément à partir de [cette
page](https://tug.org/mactex/morepackages.html).

:Avantage: cette installation est plus légère que la classique.

:Inconvénients: vous serez sûrement amenés à installer des packages au fur et à
mesure de vos besoins. Vous ne disposerez pas des logiciels avec interfaces
graphiques spécifiques à macOS contenus dans MacTeX.

### Installation à partir du DVD TeX collection

Si vous n'avez pas accès à internet, ou si la qualité de votre connexion ne vous
permet pas de télécharger des gigaoctets de façon fiable, vous pouvez installer
MacTeX avec le [DVD TeX
collection](/6_distributions/installation/dvd_texcollection).

## TeX Live

[TeX Live](https://www.tug.org/texlive/) peut être installée en installant
[MacTeX](#mactex), mais cette TeX Live aussi peut être installée *sans* passer
par MacTeX. Pour ce faire, vous pouvez suivre les méthodes une des méthodes de
la rubrique « Installation de TeX Live « à la vanille » » de la page 
« [](/6_distributions/installation/latex_sous_unix_et_linux) »

## MiKTeX

[MiKTeX](https://miktex.org) est une alternative à [MacTeX](#mactex) et [TeX
Live](#tex-live) disponible sur Mac.

Son manuel (en anglais) est disponible au format
[HTML](https://docs.miktex.org/manual/index.html) et
[PDF](https://miktex.org/download/ctan/systems/win32/miktex/doc/miktex.pdf).

Après avoir vérifié que votre version de macOS est supportée (par exemple
[ici](https://miktex.org/kb/prerequisites)), la distribution MiKTeX peut être
installée sur Mac en suivant le [tutoriel
dédié](https://miktex.org/howto/install-miktex-mac) (en anglais).

:::{seealso}

Si vous venez d'installer une distribution TeX contenant LaTeX vous vous
demandez peut-être : « [](/6_distributions/installation/tester_son_installation) »

Concernant les distributions TeX pous d'autres systèmes d'exploitation :
- « [](/6_distributions/installation/latex_sous_unix_et_linux) »
- « [](/6_distributions/installation/latex_sous_windows) »
- « [](/6_distributions/installation/latex_pour_d_autres_plateformes) »

:::

```{sources}
- [Site de MacTeX](https://tug.org/mactex/)
- [Site de TeX Live](https://www.tug.org/texlive/) et son [guide
  pratique](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html)
- [Site de MiKTeX](https://miktex.org) et son
  [manuel](https://docs.miktex.org/manual/)
```
