<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Originally generated by mkstyle for beginlatex.xml 
     on 2002-07-23T00:40:24 -->

<!-- This stylesheet transforms a TypeBook document (DocBook modified
     for documenting typographical systems) into a HTML web page. 
     It is intended as a companion for the stylesheet which transforms 
     the same document to LaTeX for printing or PDF.

     GNU Copyleft 2002, 2003 Silmaril Consultants
     Peter Flynn <peter@silmaril.ie>

     You can do anything you like with this file except (a) prevent 
     others from doing likewise, or (b) pretend you wrote it.
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:m="http://www.w3.org/1998/Math/MathML"
  exclude-result-prefixes="m">
  
  <xsl:output method="html" encoding="iso-8859-1"
    doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"
    doctype-system="/dtds/html4t.dtd"/>
  
  <xsl:strip-space elements="*"/>
  
  <xsl:param name="fragment"/>
  <xsl:param name="today"/>
  <xsl:param name="filebase"/>
  <xsl:param name="scriptbase"/>

  <xsl:template match="/">
    <xsl:comment>
      <xsl:text>Generated from </xsl:text>
      <xsl:value-of select="$filebase"/>
      <xsl:text>.xml with </xsl:text>
      <xsl:value-of select="$scriptbase"/>
      <xsl:text>.xslt on </xsl:text>
      <xsl:value-of select="$today"/>
    </xsl:comment>
    <xsl:choose>
      <xsl:when test="$fragment=''">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <html>
          <head>
            <xsl:apply-templates select="book/bookinfo" mode="outline"/>
          </head>
          <body>
            <xsl:apply-templates select="book/toc"/>
            <xsl:apply-templates select="//*[@id=$fragment]"/>
            <hr/>
            <table width="100%">
              <tr>
                <td align="left">
                  <xsl:if test="//*[@id=$fragment]/preceding-sibling::*
                                [not(name()='toc') and not(name()='bookinfo')]">
                    <a>
                      <xsl:attribute name="href">
                        <xsl:call-template name="genfrag">
                          <xsl:with-param name="thisref" 
                            select="//*[@id=$fragment]/preceding-sibling::*[1]/@id"/>
                        </xsl:call-template>
                        <xsl:text>.html</xsl:text>                      
                      </xsl:attribute>
                      <img src="previous.png" alt="Previous" border="0"/>
                    </a>
                  </xsl:if>
                </td>
                <td align="center">
                  <a href="#doctoc"><img src="top.png" alt="Top" border="0"/></a>
                </td>
                <td align="right">
                  <xsl:if test="//*[@id=$fragment]/following-sibling::*">
                    <a>
                      <xsl:attribute name="href">
                        <xsl:call-template name="genfrag">
                          <xsl:with-param name="thisref" 
                            select="//*[@id=$fragment]/following-sibling::*[1]/@id"/>
                        </xsl:call-template>
                        <xsl:text>.html</xsl:text>                      
                      </xsl:attribute>
                      <img src="next.png" alt="Next" border="0"/>
                    </a>
                  </xsl:if>
                </td>
              </tr>
            </table>
          </body>
        </html>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="book">
    <html>
      <head>
        <xsl:apply-templates select="bookinfo" mode="outline"/>
      </head>
      <body>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="bookinfo" mode="outline">
    <xsl:apply-templates/>
    <link rel="stylesheet" href="typebook.css" type="text/css"/>
    <meta http-equiv="Content-Style-Type" content="text/css"/>
  </xsl:template>

  <xsl:template match="bookinfo/title">
    <title>
      <xsl:apply-templates/>
      <xsl:if test="$fragment">
        <xsl:text>: </xsl:text>
        <xsl:call-template name="getfragtitle"/>
      </xsl:if>
    </title>
  </xsl:template>

  <!-- Get the fragment title (and number if needed) for titling -->

  <xsl:template name="getfragtitle">
    <xsl:for-each select="//*[@id=$fragment]">
      <xsl:for-each select="(ancestor-or-self::preface |
                            ancestor-or-self::chapter |
                            ancestor-or-self::appendix |
                            ancestor-or-self::bibliography |
                            ancestor-or-self::index)[last()]">
        <xsl:choose>
          <xsl:when test="name()='chapter'">
            <xsl:text>Chapter </xsl:text>
            <xsl:number count="//chapter" level="any"/>
            <xsl:text>&#x00A0;&#x2014; </xsl:text>
          </xsl:when>
          <xsl:when test="name()='appendix'">
            <xsl:text>Appendix </xsl:text>
            <xsl:number count="//appendix" level="any" format="A"/>
            <xsl:text>&#x00A0;&#x2014; </xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:value-of select="title"/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="bookinfo/subtitle |
                       bookinfo/author | 
                       bookinfo/edition | 
                       bookinfo/legalnotice | 
                       bookinfo/othercredit | 
                       bookinfo/releaseinfo | 
                       bookinfo/revhistory"/>

  <xsl:template match="bookinfo/subtitle |
                       bookinfo/author | 
                       bookinfo/edition | 
                       bookinfo/legalnotice | 
                       bookinfo/othercredit | 
                       bookinfo/releaseinfo | 
                       bookinfo/revhistory" mode="outofline">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="toc">
    <table width="100%">
      <tr>
        <th class="title" width="66%">
          <h1>
            <a name="doctitle">
              <xsl:apply-templates select="../bookinfo/title" 
                mode="outofline"/>
            </a>
          </h1>
          <h2>
            <xsl:apply-templates select="../bookinfo/subtitle" 
              mode="outofline"/>
          </h2>
          <xsl:if test="$fragment">
            <h3>
              <xsl:call-template name="getfragtitle"/>
            </h3>
          </xsl:if>
          <h3>
            <xsl:value-of select="../bookinfo/author/firstname"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="../bookinfo/author/surname"/>
          </h3>
          <xsl:if test="../bookinfo/author/affiliation/orgname">
            <h4>
              <xsl:value-of select="../bookinfo/author/affiliation/orgname"/>
              <xsl:if test="../bookinfo/author/affiliation/orgdiv">
                <br/>
                <xsl:value-of select="../bookinfo/author/affiliation/orgdiv"/>
              </xsl:if>
            </h4>
          </xsl:if>
          <xsl:if test="../bookinfo/author/authorblurb">
            <xsl:apply-templates select="../bookinfo/author/authorblurb/*"/>
          </xsl:if>
          <br/>
          <xsl:text>v. </xsl:text>
          <xsl:value-of select="../bookinfo/revhistory/revision[1]/revnumber"/>
          <xsl:if test="../bookinfo/edition">
            <xsl:text> (</xsl:text>
            <xsl:value-of select="../bookinfo/edition"/>
            <xsl:text>)</xsl:text>
          </xsl:if>
        </th>
        <td class="toc" width="33%">
          <h4>
            <a name="doctoc">
              <xsl:value-of select="title"/>
            </a>
          </h4>
          <dl>
            <xsl:for-each select="../preface">
              <dd>
                <xsl:attribute name="class">
                  <xsl:if test="@id=$fragment">
                    <xsl:text>current</xsl:text>
                  </xsl:if>
                </xsl:attribute>
                <xsl:variable name="docfrag">
                  <xsl:if test="$fragment">
                    <xsl:value-of select="@id"/>
                    <xsl:text>.html</xsl:text>
                  </xsl:if>
                </xsl:variable>
                <a href="{$docfrag}#{@id}">
                  <xsl:apply-templates select="title" mode="citedtitle"/>
                </a>
              </dd>
            </xsl:for-each>
          </dl>
          <ol>
            <xsl:for-each select="../chapter">
              <xsl:variable name="docfrag">
                <xsl:if test="$fragment">
                  <xsl:text>chapter</xsl:text>
                  <xsl:number count="//chapter" level="any"/>
                  <xsl:text>.html</xsl:text>
                </xsl:if>
              </xsl:variable>
              <li>
                <xsl:attribute name="class">
                  <xsl:if test="@id=$fragment">
                    <xsl:text>current</xsl:text>
                  </xsl:if>
                </xsl:attribute>
                <a href="{$docfrag}#{@id}">
                  <xsl:apply-templates select="title" mode="citedtitle"/>
                </a>
              </li>
            </xsl:for-each>
          </ol>
          <ol type="A">
            <xsl:for-each select="//appendix">
              <xsl:variable name="docfrag">
                <xsl:if test="$fragment">
                  <xsl:text>appendix</xsl:text>
                  <xsl:number count="//appendix" level="any" format="A"/>
                  <xsl:text>.html</xsl:text>
                </xsl:if>
              </xsl:variable>
              <li>
                <xsl:attribute name="class">
                  <xsl:if test="@id=$fragment">
                    <xsl:text>current</xsl:text>
                  </xsl:if>
                </xsl:attribute>
                <a href="{$docfrag}#{@id}">
                  <xsl:apply-templates select="title" mode="citedtitle"/>
                </a>
              </li>
            </xsl:for-each>
          </ol>
          <dl>
            <xsl:for-each select="../bibliography | ../index">
              <xsl:variable name="docfrag">
                <xsl:if test="$fragment">
                  <xsl:value-of select="name()"/>
                  <xsl:text>.html</xsl:text>
                </xsl:if>
              </xsl:variable>
              <dd>
                <xsl:attribute name="class">
                  <xsl:if test="@id=$fragment">
                    <xsl:text>current</xsl:text>
                  </xsl:if>
                </xsl:attribute>
                <a href="{$docfrag}#{@id}">
                  <xsl:apply-templates select="title" mode="citedtitle"/>
                </a>
              </dd>
            </xsl:for-each>
          </dl>
        </td>
      </tr>
      <tr>
        <td class="credits">
          <xsl:apply-templates select="../bookinfo/othercredit" mode="title"/>
        </td>
        <td class="legal">
          <xsl:apply-templates select="../bookinfo/legalnotice" mode="title"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="bookinfo/othercredit | bookinfo/legalnotice" 
    mode="title">
    <p>
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="othercredit/contrib">
    <xsl:if test="preceding::contrib">
      <xsl:text>&#x000B6;&#x00A0;</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template match="toc/title | index/title"/>

  <xsl:template name="dofootnotes">
    <xsl:if test="descendant::footnote">
      <!-- calculate the starting number of the first footnote to handle -->
      <xsl:variable name="startfnote" select="descendant::footnote[1]"/>
      <xsl:variable name="fnote">
        <xsl:choose>
          <xsl:when test="ancestor::chapter">
            <xsl:variable name="allthis" 
              select="ancestor::chapter/descendant::footnote
                      [not(ancestor::tgroup)]"/>
            <xsl:variable name="allafter"
              select="$startfnote/following::footnote[not(ancestor::tgroup)]"/>
            <xsl:value-of 
              select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
          </xsl:when>
          <xsl:when test="ancestor::appendix">
            <xsl:variable name="allthis" 
              select="ancestor::appendix/descendant::footnote
                      [not(ancestor::tgroup)]"/>
            <xsl:variable name="allafter"
              select="$startfnote/following::footnote[not(ancestor::tgroup)]"/>
            <xsl:value-of 
              select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
          </xsl:when>
          <xsl:when test="ancestor::preface">
            <xsl:variable name="allthis" 
              select="ancestor::preface/descendant::footnote
                      [not(ancestor::tgroup)]"/>
            <xsl:variable name="allafter"
              select="$startfnote/following::footnote[not(ancestor::tgroup)]"/>
            <xsl:value-of 
              select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:message>
              <xsl:text>Counting footnotes in unknown environment&#x000A;</xsl:text>
            </xsl:message>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <!-- output the footnotes with a pre-calculated start value -->
      <ol class="footnotes">
        <xsl:attribute name="start">
          <xsl:value-of select="$fnote"/>
        </xsl:attribute>
        <xsl:for-each select="descendant::footnote[not(ancestor::tgroup)]">
          <li>
            <a>
              <xsl:attribute name="name">
                <xsl:text>F</xsl:text>
                <xsl:number level="any"/>
              </xsl:attribute>
              <xsl:apply-templates/>
            </a>
          </li>
        </xsl:for-each>
      </ol>
    </xsl:if>
  </xsl:template>

  <xsl:template name="dofootnotesinfloat">
    <!-- calculate the starting number of the first footnote to handle -->
    <!-- this is daft, why did we ever do it
    <xsl:variable name="fnote">
      <xsl:for-each select="descendant::footnote[1]">
        <xsl:value-of select="count(preceding::footnote)+1"/>
      </xsl:for-each>
    </xsl:variable>
    -->
    <!-- output the footnotes with a pre-calculated start value -->
    <div align="left">
      <ol class="footnotes" type="a">
        <!--
        <xsl:attribute name="start">
               <xsl:value-of select="$fnote"/>
        </xsl:attribute>
        -->
        <xsl:for-each select="descendant::footnote[not(@usenote)]">
          <li>
            <a>
              <xsl:attribute name="name">
                <xsl:choose>
                  <xsl:when test="@id">
                    <xsl:value-of select="@id"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>F</xsl:text>
                    <!-- make unique sequence for this float -->
                    <xsl:number 
                      count="//figure | //table | //informalfigure | //informaltable"/>
                    <xsl:number format="a" level="any" 
                      from="table|figure|informaltable|informalfigure"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:apply-templates/>
            </a>
          </li>
        </xsl:for-each>
      </ol>
    </div>
  </xsl:template>
  
  <xsl:template match="preface">
    <xsl:message>
      <xsl:value-of select="title"/>
    </xsl:message>
    <div class="prelim">
      <xsl:apply-templates/>
      <xsl:if test="not(sect1) and not(section)">
        <xsl:call-template name="dofootnotes"/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="footnote/para[1]">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="preface/title">
    <h3>
      <a href="#doctoc">
        <img src="up.png" title="Table of Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h3>
  </xsl:template>

  <xsl:template match="section">
    <xsl:if test="count(preceding-sibling::section)=0">
      <xsl:for-each select="preceding-sibling::*">
        <xsl:call-template name="dofootnotes"/>
      </xsl:for-each>
    </xsl:if>
    <div>
      <xsl:attribute name="class">
        <xsl:choose>
          <xsl:when test="parent::section">
            <xsl:text>subsection</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>section</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates/>
      <xsl:if test="not(parent::section)">
        <xsl:call-template name="dofootnotes"/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="section[not(parent::section)]/title">
    <h4>
      <a href="#doctoc">
        <img src="up.png" title="Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h4>
  </xsl:template>

  <xsl:template match="section/section/title">
    <h5>
      <a href="#doctoc">
        <img src="up.png" title="Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h5>
  </xsl:template>

  <xsl:template match="para">
    <xsl:choose>
      <xsl:when test="@remap='cmr'">
        <a href="cmr.pdf">
          <img src="cmr.png" width="100%"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <p>
          <xsl:if test="@remap='\raggedleft'">
            <xsl:attribute name="align">
              <xsl:text>right</xsl:text>
            </xsl:attribute>
          </xsl:if>
          <xsl:choose>
            <xsl:when test="../@id and name(..)='listitem'">
              <a name="{../@id}"></a>
              <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="@id">
              <a name="{@id}"></a>
              <xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates/>
            </xsl:otherwise>
          </xsl:choose>
        </p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="productname">
    <i>
      <a>
        <xsl:attribute name="name">
          <xsl:text>p</xsl:text>
          <xsl:number count="//productname" level="any"/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </i>
  </xsl:template>

  <xsl:template match="itemizedlist">
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="itemizedlist[not(parent::para)]/listitem | 
                        orderedlist[not(parent::para)]/listitem">
    <li>
      <xsl:choose>
        <xsl:when test="@id and count(child::para)=0">
          <a name="{@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </li>
  </xsl:template>

  <xsl:template match="acronym">
    <xsl:choose>
      <!-- If there is text content, display it as the defining instance -->
      <xsl:when test=".!=''">
        <xsl:choose>
          <!-- If there is an ID, make this a target and maybe a link, and
               put the acronym in parentheses after the explanation -->
          <xsl:when test="@id">
            <a name="{@id}" class="acroref">
              <xsl:if test="@xreflabel">
                <xsl:attribute name="href">
                  <xsl:value-of select="@xreflabel"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:apply-templates/>
            </a>
            <xsl:text>&#x00A0;(</xsl:text>
            <small>
                <xsl:value-of select="@id"/>
            </small>
            <xsl:text>)</xsl:text>
          </xsl:when>
          <!-- Text content but no ID is an error -->
          <xsl:otherwise>
            <xsl:apply-templates/>
            <xsl:text>&#x00A0;(UNDEFINED ACRONYM)</xsl:text>           
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- No text content means we just use the acronym -->
      <xsl:otherwise>
        <xsl:choose>
          <!-- Check the acronym is in ref 
               (DocBook doesn't provide an IDREF) -->
          <xsl:when test="@ref">
            <xsl:variable name="thisref" select="@ref"/>
            <!-- if this is chunking, make a URI for the ref -->
            <xsl:variable name="docfrag">
              <xsl:if test="$fragment">
                <xsl:call-template name="genfrag">
                  <xsl:with-param name="thisref" select="$thisref"/>
                </xsl:call-template>
                <xsl:text>.html</xsl:text>
              </xsl:if>
            </xsl:variable>
            <small>
              <!-- Don't provide a link if the @condition="noid"
                   this is for common acronyms which just need 
                   formatting as such, not linking -->
              <xsl:choose>
                <xsl:when test="@condition='noid'">
                  <xsl:value-of select="@ref"/>                  
                </xsl:when>
                <xsl:otherwise>
                  <a href="{$docfrag}#{@ref}" class="acroref">
                    <xsl:attribute name="name">
                      <xsl:text>A</xsl:text>
                      <xsl:number count="//acronym" level="any"/>
                    </xsl:attribute>
                    <xsl:attribute name="title">
                      <xsl:value-of 
                        select="normalize-space(//*[@id=current()/@ref])"/>
                    </xsl:attribute>
                    <xsl:value-of select="@ref"/>
                  </a>
                </xsl:otherwise>
              </xsl:choose>
            </small>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>(NOACRO)</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="genfrag">
    <xsl:param name="thisref"/>
    <xsl:for-each select="//*[@id=$thisref]">
      <xsl:for-each select="(ancestor-or-self::preface |
                            ancestor-or-self::chapter |
                            ancestor-or-self::appendix |
                            ancestor-or-self::bibliography |
                            ancestor-or-self::index)[last()]">
        <xsl:choose>
          <xsl:when test="name()='chapter'">
            <xsl:text>chapter</xsl:text>
            <xsl:number count="//chapter" level="any"/>
          </xsl:when>
          <xsl:when test="name()='appendix'">
            <xsl:text>appendix</xsl:text>
            <xsl:number count="//appendix" level="any" format="A"/>
          </xsl:when>
          <xsl:when test="name()='preface'">
            <xsl:value-of select="@id"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="name()"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="emphasis">
    <xsl:choose>
      <xsl:when test="@role='enhance' or @role='high'">
        <strong>
          <xsl:apply-templates/>
        </strong>
      </xsl:when>
      <xsl:when test="ancestor::emphasis or ancestor::format[@fontshape='it']">
        <span class="normal">
          <xsl:apply-templates/>
        </span>
      </xsl:when>
      <xsl:otherwise>
        <em>
          <xsl:apply-templates/>
        </em>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="wordasword">
    <xsl:text>&#x2018;</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>&#x2019;</xsl:text>
  </xsl:template>

  <xsl:template match="citetitle">
    <!-- if there is content and the @pubwork is given, use it -->
    <xsl:if test=".!='' and @pubwork">
      <xsl:if test="@pubwork">
        <xsl:text>the </xsl:text>
        <xsl:value-of select="@pubwork"/>
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:text>&#x2018;</xsl:text>
        <xsl:apply-templates/>
      <xsl:text>&#x2019;</xsl:text>
      <xsl:text> in </xsl:text>
    </xsl:if>
    <!-- if there is a ref, use it... -->
    <xsl:if test="@ref">
      <xsl:variable name="thisref" select="@ref"/>
      <!-- find out which chunk it will be in -->
      <xsl:variable name="docfrag">
        <xsl:if test="$fragment">
          <xsl:call-template name="genfrag">
            <xsl:with-param name="thisref" select="$thisref"/>
          </xsl:call-template>
          <xsl:text>.html</xsl:text>
        </xsl:if>
      </xsl:variable>
      <!-- identify what document it points at -->
      <xsl:variable name="docref" 
        select="//bibliography/biblioentry[@id=$thisref]"/>
      <xsl:choose>
        <xsl:when test="@ref='null'">
          <cite>
            <xsl:apply-templates/>
          </cite>
        </xsl:when>
        <!-- show=both means make an author-year citation (no title) -->
        <xsl:when test="@show='both'">
          <a href="{$docfrag}#{@ref}">
            <xsl:attribute name="name">
              <xsl:text>K</xsl:text>
              <xsl:number count="//citetitle | 
                                 //blockquote[@citedoc]" level="any"/>
            </xsl:attribute>
            <xsl:choose>
              <xsl:when test="$docref/authorgroup">
                <xsl:value-of 
                  select="$docref/authorgroup/author[1]/surname"/>
                <xsl:text> </xsl:text>
                <i>
                  <xsl:text>et al</xsl:text>
                </i>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of 
                  select="$docref/author[1]/surname"/>
              </xsl:otherwise>
            </xsl:choose>
          </a>
          <xsl:text>&#x00A0;(</xsl:text>
          <xsl:value-of 
            select="$docref/date"/>
          <xsl:text>)</xsl:text>
        </xsl:when>
        <!-- otherwise we may want the title... -->
        <xsl:otherwise>
          <!-- ...but before we do, see if there's a need to give the author.
               Author alone means make it a possessive before the title -->
          <xsl:if test="@show='author' or @show='authoronly'">
            <xsl:choose>
              <xsl:when test="$docref/authorgroup">
                <xsl:value-of 
                  select="$docref/authorgroup/author[1]/surname"/>
                <xsl:text> </xsl:text>
                <i>
                  <xsl:text>et al</xsl:text>
                </i>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of 
                  select="$docref/author[1]/surname"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="@show='author'">
              <xsl:text>&#x2019;s </xsl:text>
            </xsl:if>
          </xsl:if>
          <!-- now the title unless authoronly -->
          <xsl:if test="@show!='authoronly'">
            <xsl:choose>
              <!-- if there is a URL in the bib, use it as a link -->
              <xsl:when test="$docref/releaseinfo">
                <cite>
                  <a>
                    <xsl:attribute name="href">
                      <xsl:value-of select="$docref/releaseinfo"/>
                    </xsl:attribute>
                    <xsl:attribute name="name">
                      <xsl:text>C</xsl:text>
                      <xsl:number count="//citetitle | 
                                         //blockquote[@citedoc]" level="any"/>
                    </xsl:attribute>
                    <xsl:apply-templates 
                      select="$docref/title[1]" mode="citedtitle"/>
                    <xsl:if test="$docref/title[1]//following-sibling::subtitle">
                      <xsl:text>: </xsl:text>
                      <xsl:apply-templates mode="citedtitle"
                        select="$docref/title[1]//following-sibling::subtitle"/>
                    </xsl:if>
                  </a>
                </cite>
              </xsl:when>
              <!-- otherwise use the ID of the bib entry as the link
                   (same as this IDREF) -->
              <xsl:otherwise>
                <cite>
                  <a href="{$docfrag}#{@ref}">
                    <xsl:attribute name="name">
                      <xsl:text>C</xsl:text>
                      <xsl:number count="//citetitle | 
                                         //blockquote[@citedoc]" level="any"/>
                    </xsl:attribute>
                    <xsl:apply-templates 
                      select="$docref/title[1]" mode="citedtitle"/>
                    <xsl:if test="$docref/title[1]//following-sibling::subtitle">
                      <xsl:text>: </xsl:text>
                      <xsl:apply-templates mode="citedtitle" 
                        select="$docref/title[1]//following-sibling::subtitle"/>
                    </xsl:if>
                  </a>
                </cite>          
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <!-- end of test for @ref -->
    </xsl:if>
    <!-- if the content is non-null and no @pubwork, print it 
         (preceded by a space if there was an xref) -->
    <xsl:if test=".!='' and not(@pubwork) and not(@ref='null')">
      <xsl:if test="@ref">
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="title | subtitle" mode="citedtitle">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="systemitem">
    <xsl:choose>
      <xsl:when test="@remap">
        <code>
          <xsl:value-of select="substring-before(@remap,' ')"/>
          <br/>
          <xsl:value-of select="substring-after(@remap,' ')"/>
        </code>
      </xsl:when>
      <xsl:otherwise>
        <code>
          <xsl:apply-templates/>
        </code>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="footnote">
    <sup>
      <a>
        <xsl:attribute name="href">
          <xsl:choose>
            <xsl:when test="@id">
              <xsl:text>#</xsl:text>
              <xsl:value-of select="@id"/>
            </xsl:when>
            <xsl:when test="@usenote">
              <xsl:text>#</xsl:text>
              <xsl:value-of select="@usenote"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>#F</xsl:text>
              <xsl:choose>
                <xsl:when test="ancestor::table | 
                                ancestor::figure | 
                                ancestor::informaltable | 
                                ancestor::informalfigure">
                  <xsl:number count="//table | 
                                     //figure | 
                                     //informaltable | 
                                     //informalfigure"/>
                  <xsl:number format="a" level="any" 
                    from="table|figure|informaltable|informalfigure"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:number count="footnote" level="any"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <!-- OK, that was the HREF link, now for the actual number -->
        <xsl:choose>
          <xsl:when test="ancestor::tgroup">
            <i>
              <xsl:choose>
                <!-- if this refers to another footnote, 
                     assume it's one in the same table -->
                <xsl:when test="@usenote">
                  <xsl:variable name="thisnote">
                    <xsl:value-of select="@usenote"/>
                  </xsl:variable>
                  <xsl:for-each select="ancestor::tgroup/
                                        descendant::footnote[@id]">
                    <xsl:if test="$thisnote=@id">
                      <xsl:value-of 
                        select="substring('abcdefghijklmnopqrstuvwxyz',
                                position(),1)"/>
                    </xsl:if>
                  </xsl:for-each>
                </xsl:when>
                <!-- in both cases we need to work out the how-many'th 
                     this is -->
                <xsl:when test="@id">
                  <xsl:variable name="thisnote">
                    <xsl:value-of select="@id"/>
                  </xsl:variable>
                  <xsl:for-each select="ancestor::tgroup/
                                        descendant::footnote[@id]">
                    <xsl:choose>
                    <xsl:when test="$thisnote=@id">
                      <xsl:value-of 
                        select="substring('abcdefghijklmnopqrstuvwxyz',
                                position(),1)"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text></xsl:text>
                    </xsl:otherwise>
                    </xsl:choose>
                  </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:number format="a" level="any" 
                    from="table|figure|informaltable|informalfigure"/>
                </xsl:otherwise>
              </xsl:choose>
            </i>
          </xsl:when>
          <!-- otherwise it's a normal footnote -->
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="ancestor::chapter">
                <xsl:variable name="allthis" 
                  select="ancestor::chapter/descendant::footnote
                          [not(ancestor::tgroup)]"/>
                <xsl:variable name="allafter"
                  select="following::footnote[not(ancestor::tgroup)]"/>
                <xsl:value-of 
                  select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
              </xsl:when>
              <xsl:when test="ancestor::appendix">
                <xsl:variable name="allthis" 
                  select="ancestor::appendix/descendant::footnote
                          [not(ancestor::tgroup)]"/>
                <xsl:variable name="allafter"
                  select="following::footnote[not(ancestor::tgroup)]"/>
                <xsl:value-of 
                  select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
              </xsl:when>
              <xsl:when test="ancestor::preface">
                <xsl:variable name="allthis" 
                  select="ancestor::preface/descendant::footnote
                          [not(ancestor::tgroup)]"/>
                <xsl:variable name="allafter"
                  select="following::footnote[not(ancestor::tgroup)]"/>
                <xsl:value-of 
                  select="count($allthis[count(.|$allafter)!=count($allafter)])"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:message>
                  <xsl:text>Unlocated footnote&#x000A;</xsl:text>
                </xsl:message>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </a>
    </sup>
  </xsl:template>

  <xsl:template match="menuchoice">
    <span class="menu">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="sidebar">
    <div align="center" class="sidebar">
      <xsl:if test="@id and not(title)">
        <a name="{@id}"></a>
      </xsl:if>
      <table width="75%">
        <tr>
          <td align="left" class="sidebar">
            <xsl:apply-templates/>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="sidebar/title">
    <h3>
      <img src="ktip.png" align="middle"/>
      <xsl:text> &#x00A0; </xsl:text>
      <a name="{../@id}">
        <xsl:apply-templates/>
      </a>
    </h3>
  </xsl:template>

  <xsl:template match="warning">
    <blockquote class="warning">
      <xsl:if test="not(title)">
        <a name="{@id}"></a>
      </xsl:if>
      <xsl:apply-templates/>
    </blockquote>
  </xsl:template>

  <xsl:template match="warning/para[1]">
    <p>
      <xsl:if test="not(../title)">
        <img src="warning.png" align="left" alt="!!!"/>
      </xsl:if>
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="warning/title">
    <h4>
      <img src="warning.png" align="middle" alt="!!!"/>
      <xsl:text> &#x00A0; </xsl:text>
      <a name="{../@id}">
        <xsl:apply-templates/>
      </a>
    </h4>
  </xsl:template>

  <xsl:template match="personname">
    <a>
      <xsl:attribute name="name">
        <xsl:choose>
          <xsl:when test="@id">
            <xsl:value-of select="@id"/>            
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>N</xsl:text>
            <xsl:number count="//personname" level="any"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates/>
    </a>
  </xsl:template>

  <xsl:template match="chapter | appendix">
    <xsl:message>
      <xsl:choose>
        <xsl:when test="name()='chapter'">
          <xsl:text>Chapter </xsl:text>
          <xsl:number format="1"/>
        </xsl:when>
        <xsl:when test="name()='appendix'">
          <xsl:text>Appendix </xsl:text>
          <xsl:number format="A"/>
        </xsl:when>
      </xsl:choose>
    </xsl:message>
    <!-- Check if there are unprocessed footnotes from the previous segment -->
    <xsl:if test="count(preceding-sibling::chapter)=0 and $fragment=''">
      <xsl:for-each select="preceding-sibling::*">
        <xsl:call-template name="dofootnotes"/>
      </xsl:for-each>
    </xsl:if>
    <div class="chapter">
      <xsl:apply-templates/>
      <xsl:if test="not(sect1)">
        <xsl:call-template name="dofootnotes"/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="chapter/title | appendix/title">
    <!-- Make a banner for the chapter starts -->
    <table width="100%">
      <tr>
        <td align="center">
          <!-- First columns has chapter/appendix name above a large numeral -->
          <small>
            <i class="chaphead">
              <b>
                <a name="{../@id}">
                  <xsl:value-of select="translate(name(..),
                                        'abcdefghijklmnopqrstuvwxyz',
                                        'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
                </a>
              </b>
            </i>
          </small>
          <br/>
          <table border="1">
            <tr>
              <td class="chapno">
                <xsl:if test="parent::chapter">
                  <xsl:number count="chapter"/>
                </xsl:if>
                <xsl:if test="parent::appendix">
                  <xsl:number count="appendix" format="A"/>
                </xsl:if>
              </td>
            </tr>
          </table>
        </td>
        <td>
          <pre class="spacing"> </pre>
        </td>
        <td>
          <!-- Second visible column has the title -->
          <p>&#x00A0;</p>
          <h1>
            <xsl:apply-templates/>
          </h1>
          <xsl:if test="following-sibling::subtitle">
            <h2>
              <xsl:value-of select="following-sibling::subtitle"/>
            </h2>
          </xsl:if>
        </td>
        <td class="toc">
          <!-- Third column has the Chapter ToC -->
          <p>&#x00A0;</p>
          <ol>
            <xsl:for-each select="../sect1">
              <li>
                <xsl:choose>
                  <xsl:when test="@id">
                    <a href="#{@id}">
                      <xsl:apply-templates mode="citedtitle" 
                        select="title[1]"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:apply-templates mode="citedtitle" 
                      select="title[1]"/>
                  </xsl:otherwise>
                </xsl:choose>
              </li>
            </xsl:for-each>
          </ol>
        </td>
        <td align="right">
          <a href="#doctoc">
            <img src="top.png" title="Table of Contents" width="32" alt="ToC" align="right" border="0"/>
          </a>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="chapter/subtitle | appendix/subtitle"/>

  <xsl:template match="note">
    <xsl:if test="@role!='marginal'">
      <blockquote class="note">
        <xsl:apply-templates/>
      </blockquote>
    </xsl:if>
  </xsl:template>

  <xsl:template match="note/title">
    <h4>
      <xsl:apply-templates/>
    </h4>
  </xsl:template>

  <!-- Cross-references are the most complex part -->

  <xsl:template match="xref">
    <a>
      <xsl:variable name="thisref" select="@linkend"/>
      <xsl:variable name="docfrag">
        <xsl:if test="$fragment">
          <xsl:call-template name="genfrag">
            <xsl:with-param name="thisref" select="$thisref"/>
          </xsl:call-template>
          <xsl:text>.html</xsl:text>
        </xsl:if>
      </xsl:variable>
      <xsl:variable name="replacement">
        <xsl:choose>
          <xsl:when test="@xreflabel">
            <xsl:value-of select="@xreflabel"/>
            <xsl:text>&#x00A0;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <!-- Dummy is used when you want a reference that is *not* a link
           such as "skip section x.y.z and go on to..." -->
      <xsl:choose>
        <xsl:when test="not(@role)">
          <xsl:attribute name="href">
            <xsl:value-of select="$docfrag"/>
            <xsl:text>#</xsl:text>
            <xsl:value-of select="@linkend"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="@role!='dummy'">
          <xsl:attribute name="href">
            <xsl:value-of select="$docfrag"/>
            <xsl:text>#</xsl:text>
            <xsl:value-of select="@linkend"/>
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <!-- create a variable to hold the ID value -->
      <xsl:variable name="thislink">
        <xsl:value-of select="@linkend"/>
      </xsl:variable>
      <!-- ...and one to hold the structural ancestry. 
           Note that these are exclusive ORs and that XSLT will 
           select the one which occurs earliest in the document order,
           so we take the union of all and force the latest (thanks to
           Ken Holman and David Carlisle for reminding me of this).
           Note also that we are in an xref so the anchor parent must
           be an element type with a Mixed Content model. -->
      <xsl:variable name="anchor" 
        select="(
                ancestor::sidebar |
                ancestor::warning |
                ancestor::informallist |
                ancestor::note |
                ancestor::example |
                ancestor::orderedlist |
                ancestor::itemizedlist |
                ancestor::variablelist |
                ancestor::procedure |
                ancestor::varlistentry |
                ancestor::listitem |
                ancestor::step |
                ancestor::footnote |
                ancestor::sect3 |
                ancestor::sect2 |
                ancestor::sect1 |
                ancestor::section |
                ancestor::chapter |
                ancestor::appendix |
                ancestor::preface
                )[last()]"/>
      <!-- a <para> source (anchor) is excluded unless all the rest
           miss, because almost all text occurs in paragraphs -->
      <!-- Now "position" ourselves in the link target element -->
      <!-- There can only ever be one of these because it's an ID -->
      <xsl:for-each select="//*[@id=$thislink]">
        <!-- Create a variable to hold this target GI -->
        <xsl:variable name="gi">
          <xsl:value-of select="name()"/>
        </xsl:variable>
        <!-- First, quote the immediate context -->
        <xsl:choose>
          <!-- Floats -->
          <xsl:when test="$gi='table'">
            <xsl:text>Table </xsl:text>
            <xsl:choose>
              <xsl:when test="ancestor::chapter">
                <xsl:number level="multiple" format="1.1" 
                  count="chapter|table"/>
              </xsl:when>
              <xsl:when test="ancestor::appendix">
                <xsl:number level="multiple" format="A.1" 
                  count="appendix|table"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:message>
                  <xsl:text>Unexpected location for table&#x000A;</xsl:text>
                </xsl:message>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$gi='figure'">
            <xsl:text>Figure </xsl:text>
            <xsl:choose>
              <xsl:when test="ancestor::chapter">
                <xsl:number level="multiple" format="1.1" 
                  count="chapter|figure"/>
              </xsl:when>
              <xsl:when test="ancestor::appendix">
                <xsl:number level="multiple" format="A.1" 
                  count="appendix|figure"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:message>
                  <xsl:text>Unexpected location for figure&#x000A;</xsl:text>
                </xsl:message>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- Non-floating panels -->
          <xsl:when test="$gi='sidebar'">
            <xsl:text>the panel </xsl:text>
            <xsl:if test="title">
              <xsl:text>&#x2018;</xsl:text>
              <xsl:value-of select="title"/>
              <xsl:text>&#x2019;</xsl:text>
            </xsl:if>
          </xsl:when>
          <xsl:when test="$gi='warning'">
            <xsl:choose>
            <xsl:when test="title">
              <xsl:text>the panel </xsl:text>
              <xsl:text>&#x2018;</xsl:text>
              <xsl:value-of select="title"/>
              <xsl:text>&#x2019;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>the warning panel </xsl:text>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$gi='note'">
            <xsl:text>the note </xsl:text>
            <xsl:if test="title">
              <xsl:text>&#x2018;</xsl:text>
              <xsl:value-of select="title"/>
              <xsl:text>&#x2019;</xsl:text>
            </xsl:if>
          </xsl:when>
          <!-- Lists and items -->
          <xsl:when test="$gi='orderedlist' or
                          $gi='itemizedlist' or
                          $gi='variablelist'">
            <xsl:text>the list </xsl:text>
            <xsl:if test="title">
              <xsl:text>&#x2018;</xsl:text>
              <xsl:value-of select="title"/>
              <xsl:text>&#x2019;</xsl:text>
            </xsl:if>
          </xsl:when>
          <!-- labelled list entry -->
          <xsl:when test="$gi='varlistentry'">
            <xsl:text>the item &#x2018;</xsl:text>
            <xsl:value-of select="term"/>
            <xsl:text>&#x2019;</xsl:text>
          </xsl:when>
          <xsl:when test="$gi='listitem'">
            <xsl:choose>
              <!-- labelled list item -->
              <xsl:when test="parent::varlistentry">
                <xsl:text>the item &#x2018;</xsl:text>
                <xsl:value-of select="../term"/>
                <xsl:text>&#x2019;</xsl:text>
              </xsl:when>
              <!-- unnumbered lists we have to count ourselves -->
              <xsl:when test="parent::itemizedlist">
                <xsl:text>the </xsl:text>
                <xsl:number/>
                <xsl:variable name="ord">
                  <xsl:number/>
                </xsl:variable>
                <xsl:choose>
                  <xsl:when test="$ord=1">
                    <xsl:text>st </xsl:text>
                  </xsl:when>
                  <xsl:when test="$ord=2">
                    <xsl:text>nd </xsl:text>
                  </xsl:when>
                  <xsl:when test="$ord=3">
                    <xsl:text>rd </xsl:text>
                  </xsl:when>
                  <!-- valid up to 20 items only! -->
                  <xsl:otherwise>
                    <xsl:text>th </xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:text>item</xsl:text>
              </xsl:when>
              <!-- numbered lists have a counter of their own -->
              <xsl:when test="parent::orderedlist">
                <xsl:text>item </xsl:text>
                <xsl:number/>
              </xsl:when>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$gi='step'">
            <xsl:text>step </xsl:text>
            <xsl:number/>
          </xsl:when>
          <!-- Footnotes -->
          <xsl:when test="$gi='footnote'">
            <xsl:text>footnote </xsl:text>
            <xsl:number level="any"/>
          </xsl:when>
          <!-- Informal tables -->
          <xsl:when test="$gi='informaltable'">
            <xsl:text>the table </xsl:text>
          </xsl:when>
          <!-- Examples -->
          <xsl:when test="$gi='example'">
            <xsl:text>the example &#x2018;</xsl:text>
            <xsl:apply-templates select="title" mode="citedtitle"/>
            <xsl:text>&#x2019; </xsl:text>
          </xsl:when>
          <!-- Plain paragraphs -->
          <xsl:when test="$gi='para'">
            <xsl:choose>
              <xsl:when 
                test="count(preceding-sibling::para)=0">
                <xsl:text>the first paragraph </xsl:text>
              </xsl:when>
              <xsl:when 
                test="count(following-sibling::para)=0">
                <xsl:text>the last paragraph </xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>the text</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- Top-level divisions -->
          <xsl:when test="$gi='preface'">
            <xsl:choose>
              <xsl:when test="count(./ancestor::preface | $anchor)=1">
                <xsl:text>this </xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>the </xsl:text>
              </xsl:otherwise>
            </xsl:choose>
            <!-- expected to be "Introduction", "Foreword", etc -->
            <xsl:value-of select="title"/>
          </xsl:when>
          <xsl:when test="$gi='chapter'">
            <xsl:choose>
              <xsl:when test="count(./ancestor-or-self::chapter | 
                              $anchor/ancestor-or-self::chapter)=1">
                <xsl:text>this chapter</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>Chapter </xsl:text>
                <xsl:number/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$gi='appendix'">
            <xsl:choose>
              <xsl:when test="count(./ancestor::appendix | $anchor)=1">
                <xsl:text>this appendix</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>Appendix </xsl:text>
                <xsl:number format="A"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$gi='section' or
                          $gi='sect1' or
                          $gi='sect2' or
                          $gi='sect3'">
            <xsl:choose>
              <xsl:when test="$replacement=''">
                <xsl:text>section </xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$replacement"/>
              </xsl:otherwise>
            </xsl:choose>
            <!-- now we have to get hierarchical -->
            <xsl:choose>
              <xsl:when test="ancestor::appendix">
                <xsl:number level="multiple" format="A.1.1.1"
                  count="appendix|sect1|sect2|sect3"/>
              </xsl:when>
              <xsl:when test="ancestor::chapter">
                <xsl:number level="multiple" format="1.1.1.1"
                  count="chapter|sect1|sect2|sect3"/>
              </xsl:when>
              <xsl:when test="ancestor::preface">
                <xsl:number level="multiple" format="1"
                  count="section"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>Target not in chapter or appendix or preface</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:message>
              <xsl:text>Cross-reference to unhandled structure: </xsl:text>
              <xsl:value-of select="$gi"/>
              <xsl:text>&#x000A;</xsl:text>
            </xsl:message>
          </xsl:otherwise>
        </xsl:choose>
        <!-- Now see if the link is in an element for which the context 
             may need quoting. Chapters, Apps, Figures and Tables don't. -->
        <xsl:if test="$gi='sidebar' or
                      $gi='warning' or
                      $gi='informaltable' or
                      $gi='note' or
                      $gi='example' or
                      $gi='orderedlist' or
                      $gi='itemizedlist' or
                      $gi='variablelist' or
                      $gi='listitem' or
                      $gi='step' or
                      $gi='varlistentry' or
                      $gi='footnote' or
                      $gi='para'">
          <!-- So far we've ended up by just naming and numbering the ref.
               The point about referencing is that how much context needs
               quoting is itself context-dependent. Remember we are still
               positioned inside the TARGET (context) element here -->
          <xsl:variable name="target"
            select="(
                    ancestor-or-self::sidebar |
                    ancestor-or-self::warning |
                    ancestor-or-self::note |
                    ancestor-or-self::example |
                    ancestor-or-self::informaltable |
                    ancestor-or-self::orderedlist |
                    ancestor-or-self::itemizedlist |
                    ancestor-or-self::variablelist |
                    ancestor-or-self::procedure |
                    ancestor-or-self::varlistentry |
                    ancestor-or-self::listitem |
                    ancestor-or-self::step |
                    ancestor-or-self::footnote |
                    ancestor-or-self::para
                    )[last()]"/>
          <xsl:choose>
            <!-- For each possible ancestor structure, see if the anchor 
                 and the target are in the same element. If so, a simple
                 "in this..." reference is enough. Otherwise it needs a
                 numeric pointer to the target -->
            <!-- When the target (where we are now) is in a procedure... -->
            <xsl:when test="ancestor::procedure">
              <xsl:choose>
                <xsl:when test="count(./ancestor::procedure | 
                                $anchor/ancestor::procedure)=1">
                  <xsl:text></xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in the procedure in section </xsl:text>
                  <xsl:number level="multiple" 
                    count="chapter|sect1|sect2|sect3" format="1.1.1.1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="ancestor::itemizedlist | ancestor::orderedlist">
              <xsl:choose>
                <xsl:when test="count(./ancestor::itemizedlist | $anchor)=1 or
                                count(./ancestor::orderedlist | $anchor)=1">
                  <xsl:text></xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in the list in section </xsl:text>
                  <xsl:number level="multiple" 
                    count="chapter|sect1|sect2|sect3" format="1.1.1.1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="ancestor::sect3">
              <xsl:choose>
                <xsl:when test="count(./ancestor::sect3 | $anchor)=1">
                  <xsl:text> in this section</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in section </xsl:text>
                  <xsl:number level="multiple" count="chapter|sect1|sect2|sect3" format="1.1.1.1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="ancestor::sect2">
              <xsl:choose>
                <xsl:when test="count(./ancestor::sect2 | $anchor)=1">
                  <xsl:text> in this section</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in section </xsl:text>
                  <xsl:number level="multiple" count="chapter|sect1|sect2" format="1.1.1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="ancestor::sect1">
              <xsl:choose>
                <xsl:when test="count(./ancestor::sect1 | $anchor)=1">
                  <xsl:text> in this section</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in section </xsl:text>
                  <xsl:number level="multiple" count="chapter|sect1" format="1.1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <!-- section in a preface -->
            <xsl:when test="ancestor::section">
              <xsl:choose>
                <xsl:when test="count(./ancestor::section | $anchor)=1">
                  <xsl:text> in this section</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in section </xsl:text>
                  <xsl:number count="section" format="1"/>
                  <xsl:if test="count(./ancestor::preface | 
                                $anchor/ancestor::preface)!=1">
                    <xsl:text> of the </xsl:text>
                    <xsl:value-of select="$target/ancestor::preface/title"/>
                  </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <!-- chapter -->
            <xsl:when test="ancestor::chapter">
              <xsl:choose>
                <xsl:when test="count(./ancestor::chapter | 
                                $anchor/ancestor::chapter)=1">
                  <xsl:text> in this chapter</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in chapter </xsl:text>
                  <xsl:number count="chapter" format="1"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <!-- appendix -->
            <xsl:when test="ancestor::appendix">
              <xsl:choose>
                <xsl:when test="count(./ancestor::appendix | 
                                $anchor/ancestor::appendix)=1">
                  <xsl:text> in this appendix</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in Appendix </xsl:text>
                  <xsl:number count="appendix" format="A"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <!-- preface -->
            <xsl:when test="ancestor::preface">
              <xsl:choose>
                <xsl:when test="count(./ancestor::preface | 
                                $anchor)=1">
                  <xsl:text> in this </xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> in the </xsl:text>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="$target/ancestor::preface/title"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>[untracked reference]</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </a>
  </xsl:template>

  <xsl:template match="sect1">
    <xsl:if test="count(preceding-sibling::sect1)=0">
      <xsl:for-each select="preceding-sibling::*">
        <xsl:call-template name="dofootnotes"/>
      </xsl:for-each>
    </xsl:if>
    <div class="sect1">
      <xsl:apply-templates/>
      <xsl:if test="not(sect2)">
        <xsl:call-template name="dofootnotes"/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="sect1/title">
    <h2>
      <a href="#{../../@id}">
        <img src="up.png" title="Chapter Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:if test="ancestor::chapter">
        <xsl:number level="multiple" count="chapter | sect1" format="1.1"/>
      </xsl:if>
      <xsl:if test="ancestor::appendix">
        <xsl:choose>
          <xsl:when test="contains(../@id,'-') and 
                          number(substring-after(../@id,'-')) != 'NaN'">
            <xsl:number count="appendix" format="A"/>
            <xsl:text>.</xsl:text>
            <xsl:value-of select="substring-after(../@id,'-')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:number level="multiple" count="appendix | sect1" format="A.1"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>   
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h2>
  </xsl:template>

  <xsl:template match="quote">
    <xsl:text>&#x2018;</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>&#x2019;</xsl:text>
  </xsl:template>

  <xsl:template match="firstterm">
    <b>
      <i>
        <a>
          <xsl:attribute name="name">
            <xsl:choose>
              <xsl:when test="@id">
                <xsl:value-of select="@id"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="string(.)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test=".=''">
              <xsl:value-of select="@id"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates/>
            </xsl:otherwise>
          </xsl:choose>
        </a>
      </i>
    </b>
  </xsl:template>

  <xsl:template match="literal">
    <xsl:if test="@role='line'">
      <br/>
    </xsl:if>
    <code class="literal">
      <xsl:apply-templates/>
    </code>
    <xsl:if test="@role='line'">
      <br/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="programlisting">
    <blockquote>
      <pre>
        <xsl:if test="@width">
          <xsl:attribute name="class">
            <xsl:value-of select="@width"/>
          </xsl:attribute>            
        </xsl:if>
        <xsl:apply-templates/>
      </pre>
    </blockquote>
  </xsl:template>

  <xsl:template match="example">
    <blockquote class="exercise">
      <xsl:if test="@id">
        <a name="{@id}"></a>
      </xsl:if>
      <hr/>
      <xsl:apply-templates/>
      <hr/>
    </blockquote>
  </xsl:template>

  <xsl:template match="example/title">
    <h4>
      <img src="kwrite.png" align="middle" />
      <xsl:text> &#x00A0; </xsl:text>
      <i>
        <xsl:text>Exercise </xsl:text>
        <xsl:number count="example/title" level="any"/>
      </i>
      <xsl:text>. </xsl:text>
      <xsl:apply-templates/>
    </h4>
  </xsl:template>

  <xsl:template match="informalexample">
    <blockquote class="example">
      <xsl:apply-templates/>
    </blockquote>
  </xsl:template>

  <xsl:template match="informalexample/programlisting">
    <pre>
      <xsl:apply-templates/>
    </pre>
  </xsl:template>

  <xsl:template match="informalexample/para">
    <p class="example">
      <xsl:choose>
        <xsl:when test="@remap">
          <img src="{@remap}.png" width="75%"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </p>
  </xsl:template>

  <xsl:template match="informaltable">
    <div align="center">
      <xsl:if test="descendant::mediaobject">
        <xsl:attribute name="class">
          <xsl:text>sampler</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@id">
        <a name="{@id}"></a>
      </xsl:if>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="informaltable/blockinfo/title">
    <h3 align="left" class="tablehead">
      <xsl:apply-templates/>
    </h3>
    <hr/>
  </xsl:template>

  <xsl:template match="mediaobject">
    <table width="100%">
      <tr>
        <th align="left">
          <small>
            <xsl:value-of select="@xreflabel"/>
          </small>
        </th>
        <td align="right">
          <small>
            <xsl:if test="textobject/arch">
              <xsl:value-of select="textobject/arch"/>
              <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="textobject/@xreflabel"/>
          </small>
        </td>
      </tr>
    </table>
    <xsl:apply-templates/>
    <hr/>
  </xsl:template>

  <xsl:template match="textobject">
    <img src="{@altfilename}.png" alt="Sample of {@xreflabel}" width="100%"/>
  </xsl:template>

  <xsl:template match="tgroup">
    <table>
      <xsl:if test="ancestor::informaltable[@frame='all']">
        <xsl:attribute name="border">
          <xsl:text>1</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="ancestor::informaltable[@colsep]">
        <xsl:attribute name="cellpadding">
          <xsl:value-of select="ancestor::informaltable/@colsep"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="../title">
        <caption>
          <xsl:if test="not(ancestor::informaltable)">
            <i>
              <xsl:choose>
                <xsl:when test="ancestor::table">
                  <xsl:text>Table </xsl:text>
                  <xsl:number count="chapter | table" level="multiple" format="1.1"/>
                </xsl:when>
                <xsl:when test="ancestor::figure">
                  <xsl:text>Figure </xsl:text>
                  <xsl:number count="chapter | figure" level="multiple" format="1.1"/>
                </xsl:when>
              </xsl:choose>
            </i>
            <xsl:text>.</xsl:text>
            <xsl:text>&#x00A0;</xsl:text>
          </xsl:if>
          <a name="{ancestor::table/@id}">
            <xsl:apply-templates select="../title" mode="citedtitle"/>
          </a>
        </caption>
      </xsl:if>
      <xsl:apply-templates/>
    </table>
    <xsl:if test="para | simplelist">
      <div align="left">
        <xsl:apply-templates select="para | simplelist" mode="intable"/>
      </div>
    </xsl:if>
    <xsl:if test="descendant::footnote">
      <xsl:call-template name="dofootnotesinfloat"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="tgroup/para | tgroup/simplelist"/>

  <xsl:template match="para" mode="intable">
    <p>
      <small>
        <xsl:apply-templates/>
      </small>
    </p>
  </xsl:template>

  <xsl:template match="simplelist" mode="intable">
    <dl>
      <small>
        <xsl:apply-templates/>
      </small>
    </dl>
  </xsl:template>

  <xsl:template match="table">
    <div align="center" class="table">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="table/title"/>
  <xsl:template match="tfoot"/>
  <xsl:template match="colspec"/>

  <xsl:template match="thead">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tfoot" mode="indirect">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tbody">
    <xsl:apply-templates/>
    <xsl:if test="../tfoot">
      <xsl:apply-templates select="../tfoot" mode="indirect"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="thead/row | tfoot/row">
    <tr class="headfoot">
      <xsl:apply-templates/>
    </tr>
  </xsl:template>

  <xsl:template match="tbody/row">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>

  <xsl:template match="thead/row/entry">
    <th valign="bottom">
      <!-- determine column number -->
      <xsl:variable name="nth">
        <xsl:value-of select="count(preceding-sibling::entry)+1"/>
      </xsl:variable>
      <!-- use alignment [lrcjc]-->
      <xsl:attribute name="align">
        <xsl:variable name="align">
          <xsl:choose>
            <xsl:when test="@align">
              <xsl:value-of select="@align"/>
            </xsl:when>
            <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@align">
              <xsl:value-of select="ancestor::tgroup/colspec[position()=$nth]/@align"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>left</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
          <xsl:choose>
            <xsl:when test="$align='char'">
              <xsl:text>right</xsl:text>
            </xsl:when>
            <xsl:when test="$align='justify'">
              <xsl:text>left</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$align"/>
            </xsl:otherwise>
          </xsl:choose>
      </xsl:attribute>
      <!-- use width if there is one -->
      <xsl:if test="ancestor::tgroup/colspec[position()=$nth]/@colwidth">
        <xsl:attribute name="width">
          <xsl:variable name="cw">
            <xsl:value-of 
              select="ancestor::tgroup/colspec[position()=$nth]/@colwidth"/>
          </xsl:variable>
          <xsl:choose>
            <!-- like graphics, double the widths for a browser -->
            <xsl:when test="contains($cw,'in')">
              <xsl:value-of select="substring-before($cw,'in') * 72 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'cm')">
              <xsl:value-of select="substring-before($cw,'cm') * 28 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'mm')">
              <xsl:value-of select="substring-before($cw,'mm') * 3 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'pt')">
              <xsl:value-of select="$cw"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$cw"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </th>
  </xsl:template>

  <xsl:template match="tbody/row/entry">
    <td valign="top">
      <!-- determine column number -->
      <xsl:variable name="nth">
        <xsl:value-of select="count(preceding-sibling::entry)+1"/>
      </xsl:variable>
      <!-- use width if there is one -->
      <xsl:if test="ancestor::tgroup/colspec[position()=$nth]/@colwidth">
        <xsl:attribute name="width">
          <xsl:variable name="cw">
            <xsl:value-of 
              select="ancestor::tgroup/colspec[position()=$nth]/@colwidth"/>
          </xsl:variable>
          <xsl:choose>
            <!-- like graphics, double the widths for a browser -->
            <xsl:when test="contains($cw,'in')">
              <xsl:value-of select="substring-before($cw,'in') * 72 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'cm')">
              <xsl:value-of select="substring-before($cw,'cm') * 28 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'mm')">
              <xsl:value-of select="substring-before($cw,'mm') * 3 * 2"/>
            </xsl:when>
            <xsl:when test="contains($cw,'pt')">
              <xsl:value-of select="$cw"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$cw"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </xsl:if>
      <!-- always an alignment, but prevent 'justify' leaking out -->
      <xsl:attribute name="align">
        <xsl:variable name="align">
          <xsl:choose>
            <xsl:when test="@align">
              <xsl:value-of select="@align"/>
            </xsl:when>
            <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@align">
              <xsl:value-of select="ancestor::tgroup/colspec[position()=$nth]/@align"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>left</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
          <xsl:choose>
            <xsl:when test="$align='char'">
              <xsl:text>right</xsl:text>
            </xsl:when>
            <xsl:when test="$align='justify'">
              <xsl:text>left</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$align"/>
            </xsl:otherwise>
          </xsl:choose>
      </xsl:attribute>
      <!-- see if either this col or this colspec shows a font -->
      <xsl:choose>
        <xsl:when test="@colname">
          <xsl:attribute name="class">
            <xsl:value-of select="substring(@colname,2)"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@colname">
          <xsl:attribute name="class">
            <xsl:value-of select="substring(ancestor::tgroup/colspec[position()=$nth]/@colname,2)"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@role">
          <xsl:attribute name="style">
            <xsl:if test="contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\itshape')">
              <xsl:text>font-style:italic;</xsl:text>
            </xsl:if>
            <xsl:if test="contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\bfseries')">
              <xsl:text>font-weight:bold;</xsl:text>
            </xsl:if>
            <xsl:if test="contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\ttfamily')">
              <xsl:text>font-family:monospace;</xsl:text>
            </xsl:if>
            <xsl:if test="contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\sffamily')">
              <xsl:text>font-family:sans-serif;</xsl:text>
            </xsl:if>
            <xsl:if test="contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\small') or
                          contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\footnotesize') or
                          contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\scriptsize') or
                          contains(ancestor::tgroup/colspec[position()=$nth]/@role,
                          '\tiny')">
              <xsl:text>font-size:small;</xsl:text>
            </xsl:if>
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <!-- test spanning -->
      <xsl:if test="@spanname">
        <xsl:attribute name="colspan">
          <xsl:value-of select="@spanname"/>
        </xsl:attribute>
      </xsl:if>
      <!-- should be an llap -->
      <xsl:if test="@xreflabel">
        <xsl:value-of select="@xreflabel"/>
        <xsl:text> </xsl:text>
      </xsl:if>
      <!-- finally, output some content -->
      <xsl:choose>
        <xsl:when test="../@role='heading'">
          <b>
            <i>
              <xsl:apply-templates/>
            </i>
          </b>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <!-- Hopefully only on the last col! -->
    <xsl:if test="@charoff">
      <td valign="top">
        <xsl:value-of select="@charoff"/>
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="tfoot/row/entry">
    <th valign="top">
      <!-- determine column number -->
      <xsl:variable name="nth">
        <xsl:value-of select="position()"/>
      </xsl:variable>
      <!-- use width if there is one -->
      <xsl:if test="ancestor::tgroup/colspec[position()=$nth]/@colwidth">
        <xsl:attribute name="width">
          <xsl:value-of select="ancestor::tgroup/colspec[position()=$nth]/@colwidth"/>
        </xsl:attribute>
      </xsl:if>
      <!-- always an alignment, but prevent 'justify' leaking out -->
      <xsl:attribute name="align">
        <xsl:choose>
          <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@align='justify'">
            <xsl:text>left</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="ancestor::tgroup/colspec[position()=$nth]/@align"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <!-- see if either this col or this colspec shows a font -->
      <xsl:choose>
      <xsl:when test="@colname">
        <xsl:attribute name="class">
          <xsl:value-of select="substring(@colname,2)"/>
        </xsl:attribute>
      </xsl:when>
      <xsl:when test="ancestor::tgroup/colspec[position()=$nth]/@colname">
        <xsl:attribute name="class">
          <xsl:value-of select="substring(ancestor::tgroup/colspec[position()=$nth]/@colname,2)"/>
        </xsl:attribute>
      </xsl:when>
      </xsl:choose>
      <!-- test spanning -->
      <xsl:if test="@spanname">
        <xsl:attribute name="colspan">
          <xsl:value-of select="@spanname"/>
        </xsl:attribute>
      </xsl:if>
      <!-- should be an llap -->
      <xsl:if test="@xreflabel">
        <xsl:value-of select="@xreflabel"/>
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:apply-templates/>
    </th>
  </xsl:template>

  <xsl:template match="inlineequation">
    <span class="math">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="m:msup/*[2] | m:msubsup/*[3] | m:msup/m:mtext">
    <sup>
      <xsl:apply-templates/>
    </sup>
  </xsl:template>

  <xsl:template match="m:msub/*[2] | m:msubsup/*[2]">
    <sub>
      <xsl:apply-templates/>
    </sub>
  </xsl:template>

  <xsl:template match="m:msub | m:msup | m:subsup">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:mtext | m:mi">
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="m:mo | m:mrow | m:mfrac | m:munder | m:mn">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:mover">
    <xsl:apply-templates/>
    <xsl:text>/</xsl:text>
  </xsl:template>

  <xsl:template match="command">
    <code class="command">
      <a>
        <xsl:attribute name="name">
          <xsl:text>c</xsl:text>
          <xsl:number count="//command" level="any"/>
        </xsl:attribute>
        <xsl:if test="@userlevel='math'">
          <xsl:text>$</xsl:text>
        </xsl:if>
        <xsl:text>\</xsl:text>
        <xsl:apply-templates/>
        <xsl:if test="@userlevel='math'">
          <xsl:text>$</xsl:text>
      </xsl:if>
    </a>
    </code>
  </xsl:template>

  <xsl:template match="errorcode">
    <code class="error">
      <xsl:apply-templates/>
    </code>
  </xsl:template>

  <xsl:template match="cmdsynopsis/command">
    <code class="command">
      <xsl:apply-templates/>
    </code>
  </xsl:template>

  <xsl:template match="methodname">
    <span class="package">
      <a>
        <xsl:attribute name="name">
          <xsl:text>m</xsl:text>
          <xsl:number count="//methodname" level="any"/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </span>
  </xsl:template>

  <xsl:template match="modespec">
    <span class="environment">
      <a>
        <xsl:attribute name="name">
          <xsl:text>e</xsl:text>
          <xsl:number count="//modespec" level="any"/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </span>
  </xsl:template>

  <xsl:template match="keycap">
    <xsl:if test="parent::keycombo and 
                  count(preceding-sibling::keycap)&gt;0">
      <xsl:text>&#x2013;</xsl:text>
    </xsl:if>
    <xsl:if test="preceding-sibling::keycombo">
      <xsl:text>&#x00A0;</xsl:text>
    </xsl:if>
    <tt class="keycap">
      <xsl:apply-templates/>
    </tt>
  </xsl:template>

  <xsl:template match="keycombo">
    <xsl:apply-templates/>
    <xsl:text>&#x00A0;</xsl:text>
  </xsl:template>

  <xsl:template match="userinput">
    <code>
      <u>
        <xsl:apply-templates/>
      </u>
    </code>
  </xsl:template>

  <xsl:template match="exceptionname">
    <nobr>
      <xsl:apply-templates/>
    </nobr>
  </xsl:template>

  <xsl:template match="sect2">
    <xsl:if test="count(preceding-sibling::sect2)=0">
      <xsl:for-each select="preceding-sibling::*">
        <xsl:call-template name="dofootnotes"/>
      </xsl:for-each>
    </xsl:if>
    <div class="sect2">
      <xsl:apply-templates/>
      <xsl:if test="not(sect2)">
        <xsl:call-template name="dofootnotes"/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="sect3">
    <xsl:if test="count(preceding-sibling::sect3)=0">
      <xsl:for-each select="preceding-sibling::*">
        <xsl:call-template name="dofootnotes"/>
      </xsl:for-each>
    </xsl:if>
    <div class="sect3">
      <xsl:apply-templates/>
      <xsl:call-template name="dofootnotes"/>
    </div>
  </xsl:template>

  <xsl:template match="sect2/title">
    <h3>
      <a href="#doctoc">
        <img src="up.png" title="Chapter Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:number level="multiple" count="chapter | sect1 | sect2" format="1.1.1"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>   
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h3>
  </xsl:template>

  <xsl:template match="sect3/title">
    <h4>
      <a href="#doctoc">
        <img src="up.png" title="Chapter Contents" width="32" alt="ToC" align="right" border="0"/>
      </a>
      <xsl:number level="multiple" count="chapter|sect1|sect2|sect3" format="1.1.1.1"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>   
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h4>
  </xsl:template>

  <xsl:template match="equation">
    <blockquote>
      <i>
        <xsl:apply-templates/>
      </i>
    </blockquote>
  </xsl:template>

  <xsl:template match="link">
    <xsl:variable name="thisref" select="@linkend"/>
    <xsl:variable name="docfrag">
      <xsl:if test="$fragment">
        <xsl:call-template name="genfrag">
          <xsl:with-param name="thisref" select="$thisref"/>
        </xsl:call-template>
        <xsl:text>.html</xsl:text>
      </xsl:if>
    </xsl:variable>
    <a href="{$docfrag}#{$thisref}">
      <xsl:attribute name="title">
        <xsl:value-of select="name(//*[@id=$thisref])"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </a>
  </xsl:template>

  <xsl:template match="ulink">
    <a>
      <xsl:attribute name="href">
        <xsl:if test="@type">
          <xsl:value-of select="@type"/>
        </xsl:if>
        <xsl:value-of select="@url"/>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test=".=''">
          <tt>
            <xsl:value-of select="@url"/>
          </tt>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </a>
  </xsl:template>

  <xsl:template match="figure">
    <div class="figure" align="center">
      <hr/>
      <xsl:apply-templates/>
      <hr/>
    </div>
  </xsl:template>

  <xsl:template match="figure/title">
    <caption>
      <i>
        <xsl:text>Figure </xsl:text>
        <xsl:number count="chapter|figure" level="multiple" format="1.1"/>
      </i>
      <xsl:text>:&#x00A0;</xsl:text>
      <a name="{ancestor::figure/@id}">
        <xsl:apply-templates/>
      </a>
    </caption>
  </xsl:template>

  <xsl:template match="graphic">
    <div align="center">
      <xsl:attribute name="style">
        <xsl:text>margin:</xsl:text>
        <xsl:choose>
          <xsl:when test="@contentwidth">
            <xsl:value-of select="@contentwidth"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>12px</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:for-each select=".|following-sibling::graphic">
        <img src="{@fileref}.png">
          <xsl:if test="@remap='frame'">
            <xsl:attribute name="style">
              <xsl:text>border:thin solid black;</xsl:text>
            </xsl:attribute>
          </xsl:if>
          <xsl:if test="@width">
            <xsl:attribute name="width">
              <xsl:choose>
                <xsl:when test="contains(@width,'%')">
                  <xsl:value-of select="@width"/>
                </xsl:when>
                <!-- dimensions converted are too small so double them -->
                <xsl:when test="contains(@width,'in')">
                  <xsl:value-of select="substring-before(@width,'in')*72*2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'cm')">
                  <xsl:value-of select="substring-before(@width,'cm')*28 * 2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'mm')">
                  <xsl:value-of select="substring-before(@width,'mm')*3 * 2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'pt')">
                  <xsl:value-of select="substring-before(@width,'pt')"/>
                </xsl:when>
                <xsl:when test="contains(@width,'bp')">
                  <xsl:value-of select="substring-before(@width,'bp')"/>
                </xsl:when>
                <xsl:when test="contains(@width,'cc')">
                  <xsl:value-of select="substring-before(@width,'cc')*12 * 2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'dd')">
                  <xsl:value-of select="substring-before(@width,'dd')"/>
                </xsl:when>
                <xsl:when test="contains(@width,'pc')">
                  <xsl:value-of select="substring-before(@width,'pc')*12 * 2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'sp')">
                  <xsl:value-of select="substring-before(@width,'sp') div 65535 * 2"/>
                </xsl:when>
                <xsl:when test="contains(@width,'em')">
                  <xsl:value-of select="substring-before(@width,'em')*10"/>
                </xsl:when>
                <xsl:when test="contains(@width,'ex')">
                  <xsl:value-of select="substring-before(@width,'ex')*6"/>
                </xsl:when>
              </xsl:choose>
            </xsl:attribute>
          </xsl:if>
        </img>
        <xsl:if test="following-sibling::graphic">
          <xsl:text> &#x00A0; </xsl:text>
        </xsl:if>
      </xsl:for-each>
    </div>
  </xsl:template>

  <xsl:template match="graphic[preceding-sibling::graphic]"/>

  <xsl:template match="guimenu">
    <span class="guimenu">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="guisubmenu">
    <xsl:if test="preceding-sibling::guimenu or preceding-sibling::guisubmenu">
      <xsl:text>&#x2192;</xsl:text>
    </xsl:if>
    <span class="guisubmenu">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="guimenuitem">
    <xsl:if test="preceding-sibling::guimenu or preceding-sibling::guisubmenu">
      <xsl:text>&#x2192;</xsl:text>
    </xsl:if>
    <span class="guimenuitem">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="variablelist">
    <!-- Attributes:
variablelist id="docfontsize"
    -->
    <blockquote>
      <dl>
        <xsl:apply-templates/>
      </dl>
    </blockquote>
  </xsl:template>

  <xsl:template match="variablelist/title">
    <h4>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </h4>
  </xsl:template>

  <xsl:template match="varlistentry">
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="term">
    <dt>
      <b>
        <xsl:choose>
          <xsl:when test="../@id">
            <a name="{../@id}">
              <xsl:apply-templates/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates/>
          </xsl:otherwise>
        </xsl:choose>
      </b>
    </dt>
  </xsl:template>

  <xsl:template match="varlistentry/listitem">
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <xsl:template match="varlistentry/listitem/p[1]">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="varname">
    <xsl:choose>
      <xsl:when test="@role='counter'">
        <tt>
          <i>
            <a>
              <xsl:attribute name="name">
                <xsl:text>l</xsl:text>
                <xsl:number count="varname" level="any"/>
              </xsl:attribute>
              <xsl:apply-templates/>
            </a>
          </i>
        </tt>
      </xsl:when>
      <xsl:when test="@role='dimension'">
        <tt>
          <xsl:text>\</xsl:text>
          <a>
            <xsl:attribute name="name">
              <xsl:text>d</xsl:text>
              <xsl:number count="varname" level="any"/>
            </xsl:attribute>
            <xsl:apply-templates/>
          </a>
        </tt>
      </xsl:when>
      <xsl:otherwise>
        <i>
          <a>
            <xsl:attribute name="name">
              <xsl:text>v</xsl:text>
              <xsl:number count="varname" level="any"/>
            </xsl:attribute>
            <xsl:value-of select="."/>
          </a>
        </i>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="guiicon">
    <span class="guiicon">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="filename">
    <code>
      <xsl:apply-templates/>
    </code>
  </xsl:template>

  <xsl:template match="cmdsynopsis">
    <blockquote>
      <xsl:apply-templates/>
    </blockquote>
  </xsl:template>

  <xsl:template match="arg">
    <code>
      <xsl:text> </xsl:text>
      <xsl:apply-templates/>
    </code>
  </xsl:template>

  <xsl:template match="option">
    <span class="option">
      <a>
        <xsl:attribute name="name">
          <xsl:text>o</xsl:text>
          <xsl:number count="option" level="any"/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </span>
  </xsl:template>

  <xsl:template match="replaceable">
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="function">
    <b>
      <xsl:apply-templates/>
    </b>
  </xsl:template>

  <xsl:template match="sbr">
    <xsl:text>&#x00A0;| </xsl:text>
  </xsl:template>

  <xsl:template match="orderedlist">
    <ol>
      <xsl:attribute name="type">
        <xsl:choose>
          <xsl:when test="../parent::orderedlist">
            <xsl:choose>
              <xsl:when test="../parent::orderedlist/../parent::orderedlist">
                <xsl:choose>
                  <xsl:when test="../parent::orderedlist/../parent::orderedlist/../parent::orderedlist">
                    <xsl:text>A</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>i</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>a</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- top level -->
          <xsl:otherwise>
          <xsl:text>1</xsl:text>
        </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates/>
    </ol>
  </xsl:template>

  <xsl:template match="para/orderedlist | para/itemizedlist">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="para/orderedlist/listitem | para/itemizedlist/listitem">
    <xsl:text> </xsl:text>
    <xsl:if test="position()=last()">
      <xsl:value-of select="../@boolean"/>
      <xsl:text> </xsl:text>
    </xsl:if>
    <i>
      <xsl:number format="a"/>
    </i>
    <xsl:text>)&#x00A0;</xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="position()!=last()">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="para/orderedlist/listitem/para |
                       para/itemizedlist/listitem/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="formalpara">
    <dl>
      <xsl:apply-templates/>
    </dl>
  </xsl:template>

  <xsl:template match="formalpara/title">
    <dt>
      <b>
        <xsl:apply-templates/>
      </b>
    </dt>
  </xsl:template>

  <xsl:template match="formalpara/para">
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <xsl:template match="tertiary"/>

  <xsl:template match="literallayout">
    <!-- @remap holds the image file name for use in HTML,
         @role holds an alternative text value for HTML -->
    <xsl:choose>
      <xsl:when test="@remap">
        <xsl:choose>
          <xsl:when test="parent::para">
            <img src="{@remap}.png" align="middle" height="10px"
              alt="{normalize-space(.)}">
              <xsl:if test="@width">
                <xsl:attribute name="width">
                  <xsl:value-of select="@width"/>
                </xsl:attribute>
              </xsl:if>
            </img>          
          </xsl:when>
          <xsl:otherwise>
            <img src="{@remap}.png" align="middle">
              <xsl:attribute name="width">
                <xsl:choose>
                  <xsl:when test="@width">
                    <xsl:value-of select="@width"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>75%</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
            </img>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="@role">
        <xsl:value-of select="@role"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="simplesect">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="parameter">
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="simplelist">
    <dl>
      <xsl:apply-templates/>
    </dl>
  </xsl:template>

  <xsl:template match="member">
    <dd>
      <xsl:if test="@xreflabel">
        <i>
          <xsl:value-of select="@xreflabel"/>
        </i>
        <xsl:text>) </xsl:text>
      </xsl:if>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <xsl:template match="procedure">
    <ol>
      <xsl:apply-templates/>
    </ol>
  </xsl:template>

  <xsl:template match="procedure/title">
    <lh>
      <xsl:apply-templates/>
    </lh>
  </xsl:template>

  <xsl:template match="step">
    <li>
      <xsl:choose>
        <xsl:when test="@id and count(child::para)=0">
          <a name="{@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </li>
  </xsl:template>

  <xsl:template match="step/title">
    <b>
      <xsl:choose>
        <xsl:when test="../@id">
          <a name="{../@id}">
            <xsl:apply-templates/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
    </b>
    <br/>
  </xsl:template>

  <xsl:template match="abbrev">
    <u>
      <b>
        <xsl:apply-templates/>
      </b>
    </u>
  </xsl:template>

  <xsl:template match="para[descendant::note[@role='marginal']]">
    <table width="100%">
      <tr>
        <td width="95%" valign="top">
          <xsl:apply-templates/>
        </td>
        <td width="5%" valign="top">
          <xsl:apply-templates select="descendant::note[@role='marginal']" 
            mode="marginal"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="note[@role='marginal']">
    <a>
      <xsl:attribute name="href">
        <xsl:text>#M</xsl:text>
        <xsl:number level="any"/>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>See margin</xsl:text>
      </xsl:attribute>
      <xsl:text>&#x219E;</xsl:text>
    </a>
  </xsl:template>

  <xsl:template match="note[@role='marginal']" mode="marginal">
    <small>
      <a>
        <xsl:attribute name="name">
          <xsl:text>M</xsl:text>
          <xsl:number level="any"/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </small>
  </xsl:template>

  <xsl:template match="note[@role='marginal']/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="blockquote">
    <blockquote class="citation">
      <a>
        <xsl:attribute name="name">
          <xsl:text>K</xsl:text>
          <xsl:number count="//citetitle | //blockquote[@citedoc]" level="any"/>
        </xsl:attribute>
        <xsl:text>&#x00A0;</xsl:text>
      </a>
      <xsl:choose>
        <xsl:when test="@condition='news'">
          <tt>
            <xsl:apply-templates/>
          </tt>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="@citedoc">
        <p class="citation">
          <xsl:variable name="thisref" select="@citedoc"/>
          <xsl:variable name="docref" 
            select="//bibliography/biblioentry[@id=$thisref]"/>
          <xsl:variable name="docfrag">
            <xsl:if test="$fragment">
              <xsl:call-template name="genfrag">
                <xsl:with-param name="thisref" select="$thisref"/>
              </xsl:call-template>
              <xsl:text>.html</xsl:text>
            </xsl:if>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="$docref/authorgroup">
              <xsl:value-of select="$docref/authorgroup/author[1]/surname"/>
              <xsl:text> </xsl:text>
              <i>
                <xsl:text>et al</xsl:text>
              </i>
            </xsl:when>
            <xsl:when test="$docref/author/othername">
              <xsl:value-of select="$docref/author/othername"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$docref/author/firstname"/>
              <xsl:text> </xsl:text>
              <xsl:value-of select="$docref/author/surname"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:text> (</xsl:text>
          <xsl:value-of select="$docref/date"/>
          <xsl:text>), </xsl:text>
          <cite>
            <a href="{$docfrag}#{@citedoc}">
              <xsl:apply-templates mode="citedtitle" 
                select="$docref/title[1]"/>
            </a>
          </cite>
          <xsl:if test="@citedetail">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@citedetail"/>
          </xsl:if>
        </p>
      </xsl:if>
    </blockquote>
  </xsl:template>

  <xsl:template match="bibliography">
    <xsl:message>
      <xsl:text>Bibliography</xsl:text>
    </xsl:message>
    <div class="bib">
      <h2>
        <a href="#doctoc">
          <img src="top.png" title="Table of Contents" width="32" alt="ToC" align="right" border="0"/>
        </a>
        <a name="{@id}">
          <xsl:value-of select="title"/>
        </a>
      </h2>
      <xsl:for-each select="biblioentry">
        <xsl:sort select="descendant::surname[1]"/>
        <xsl:sort select="descendant::forename[1]"/>
        <xsl:sort select="descendant::othername[1]"/>
        <xsl:sort select="title[1]"/>
        <xsl:sort select="date/@YYYY-MM-DD"/>
        <p>
          <xsl:apply-templates/>
          <xsl:text>. </xsl:text>
          <xsl:variable name="bibid">
            <xsl:value-of select="@id"/>
          </xsl:variable>
          <xsl:for-each select="//citetitle[@ref=$bibid] | 
                                //blockquote[@citedoc=$bibid]">
            <xsl:variable name="docfrag">
              <xsl:if test="$fragment">
                <xsl:for-each select="(ancestor-or-self::preface |
                                      ancestor-or-self::chapter |
                                      ancestor-or-self::appendix |
                                      ancestor-or-self::bibliography |
                                      ancestor-or-self::index)[last()]">
                  <xsl:choose>
                    <xsl:when test="name()='chapter'">
                      <xsl:text>chapter</xsl:text>
                      <xsl:number count="//chapter" level="any"/>
                    </xsl:when>
                    <xsl:when test="name()='appendix'">
                      <xsl:text>appendix</xsl:text>
                      <xsl:number count="//appendix" level="any" format="A"/>
                    </xsl:when>
                    <xsl:when test="name()='preface'">
                      <xsl:value-of select="@id"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="name()"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
                <xsl:text>.html</xsl:text>
              </xsl:if>
            </xsl:variable>
            <xsl:text>[</xsl:text>
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="$docfrag"/>
                <xsl:text>#K</xsl:text>
                <xsl:number count="//citetitle | 
                                   //blockquote[@citedoc]" level="any"/>
              </xsl:attribute>
              <xsl:call-template name="genref"/>
            </a>
            <xsl:text>] </xsl:text>
          </xsl:for-each>
        </p>
      </xsl:for-each>
    </div>
  </xsl:template>

  <xsl:template match="bibliography/title"/>

  <xsl:template match="biblioentry"/>

  <xsl:template match="authorgroup">
    <a>
      <xsl:attribute name="name">
        <xsl:value-of select="../@id"/>
      </xsl:attribute>
      <xsl:apply-templates/>
      <xsl:if test="editor">
        <xsl:text> (Eds.)</xsl:text>
      </xsl:if>
      <xsl:text>: </xsl:text>
    </a>    
  </xsl:template>

  <xsl:template match="authorgroup/author | authorgroup/editor">
    <b>
      <xsl:if test="count(preceding-sibling::author|preceding-sibling::editor)>0 and 
                    position()!=last()">
        <xsl:text>; </xsl:text>
      </xsl:if>
      <xsl:if test="position()=last()">
        <xsl:if test="count(preceding-sibling::author|preceding-sibling::editor)>1">
          <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:text> and </xsl:text>
      </xsl:if>
      <xsl:apply-templates/>
    </b>
  </xsl:template>

  <xsl:template match="author | editor">
    <b>
      <a>
        <xsl:attribute name="name">
          <xsl:value-of select="../@id"/>
        </xsl:attribute>
        <xsl:if test="parent::authorgroup and position()=last()">
          <xsl:text> and </xsl:text>
        </xsl:if>
        <xsl:apply-templates/>
      </a>
      <xsl:if test="not(parent::authorgroup) and name()='editor'">
        <xsl:text> (Ed.)</xsl:text>
      </xsl:if>
      <xsl:text>: </xsl:text>
    </b>
  </xsl:template>

  <xsl:template match="surname">
    <xsl:if test="parent::personname">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="othername">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="firstname">
    <xsl:if test="not(parent::personname)">
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="affiliation">
    <xsl:text> </xsl:text>
    <span class="affil">
      <xsl:text>(</xsl:text>
      <xsl:apply-templates/>
      <xsl:text>)</xsl:text>
    </span>
  </xsl:template>

  <xsl:template match="biblioentry/title[1]">
    <xsl:choose>
      <xsl:when test="ancestor::biblioentry[@type='book' or
                      @type='techreport' or
                      @type='proceedings']">
        <cite>
          <xsl:apply-templates/>
          <xsl:if test="following-sibling::subtitle">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="following-sibling::subtitle"/>
          </xsl:if>
        </cite>
      </xsl:when>
      <xsl:when test="ancestor::biblioentry[@type='article']">
        <xsl:text>&#x2018;</xsl:text>
          <xsl:apply-templates/>
          <xsl:if test="following-sibling::subtitle">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="following-sibling::subtitle"/>
          </xsl:if>
        <xsl:text>&#x2019;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message>
          <xsl:text>Unhandled biblio doc type: </xsl:text>
          <xsl:value-of select="ancestor::biblioentry/@type"/>
          <xsl:text>&#x000A;</xsl:text>
        </xsl:message>
        <cite>
          <xsl:apply-templates/>
          <xsl:if test="following-sibling::subtitle">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="following-sibling::subtitle"/>
          </xsl:if>
        </cite>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>. </xsl:text>
  </xsl:template>

  <xsl:template match="biblioentry/subtitle"/>

  <xsl:template match="biblioentry/title[2]">
    <xsl:text>In </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>, </xsl:text>
  </xsl:template>

  <xsl:template match="titleabbrev"/>

  <xsl:template match="publisher">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="publishername">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="address">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="isbn | issn">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="date">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="releaseinfo">
    <xsl:text>, </xsl:text>
    <tt>
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="."/>
        </xsl:attribute>
        <xsl:apply-templates/>
      </a>
    </tt>
  </xsl:template>

  <xsl:template match="orgname">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="volumenum">
    <b>
      <xsl:apply-templates/>
    </b>
  </xsl:template>

  <xsl:template match="issuenum">
    <xsl:choose>
      <xsl:when test="preceding-sibling::volumenum">
        <xsl:text>:</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>, </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="pagenums">
    <xsl:text>, </xsl:text>
    <xsl:if test="number(.)">
      <xsl:text>p.</xsl:text>
    </xsl:if>
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="trademark">
    <a>
      <xsl:attribute name="name">
        <xsl:text>t</xsl:text>
        <xsl:number count="//trademark" level="any"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </a>
  </xsl:template>

  <!-- Indexing taken partly from Jeni's book -->

  <!-- Some keys to identify the initial characters of the things we need -->

  <xsl:key name="terms" match="acronym/@id|
                               command|
                               firstterm/@id|
                               indexterm|
                               indexterm/primary/@sortas|
                               methodname|
                               modespec|
                               personname/surname|
                               productname|
                               option |
                               trademark|
                               varname" 
    use="translate(substring(string(.),1,1),
         'abcdefghijklmnopqrstuvwxyz',
         'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>

  <!-- Acronyms are identified at explanation with the ID attribute
       and for all other references-to with the REF attribute, which
       is why we put the @id in the $terms index but create a separate
       one below to locate the @refs.

       Commands, methodnames (packages), modespecs (environments),
       productnames, trademarks, and varnames are all the same type,
       they can all occur multiple times without distinction. 

       Firstterms are all ID'd, so they occur once only, so they need
       no additional index for locating subsequent occurrences.

       Indexterms are special: the primary subelement is indexed by virtue
       of the default being the string value of the element content, but
       the printing of them requires a 2-stage check. -->

  <xsl:key name="acroref"     match="acronym/@ref" use="@ref"/>
  <xsl:key name="command"     match="command" use="string(.)"/>
  <xsl:key name="prim"        match="indexterm/primary" use="string(.)"/>
  <xsl:key name="methodname"  match="methodname" use="string(.)"/>
  <xsl:key name="modespec"    match="modespec" use="string(.)"/>
  <xsl:key name="option"      match="option" use="string(.)"/>
  <xsl:key name="productname" match="productname" use="string(.)"/>
  <xsl:key name="sec"         match="indexterm/secondary" use="string(.)"/>
  <xsl:key name="ter"         match="indexterm/tertiary" use="string(.)"/>
  <xsl:key name="trademark"   match="trademark" use="string(.)"/>
  <xsl:key name="varname"     match="varname" use="string(.)"/>

  <!-- The index template starts it all off with the heading, then
       calls create-index to make the body -->

  <xsl:template match="index">
    <xsl:message>
      <xsl:text>Index</xsl:text>
    </xsl:message>
    <div class="ind">
      <h2>
        <a href="#doctoc">
          <img src="top.png" title="Table of Contents" width="32" alt="ToC" align="right" border="0"/>
        </a>
        <a name="{@id}">
          <xsl:value-of select="title"/>
        </a>
      </h2>
      <xsl:apply-templates/>
      <hr/>
      <div align="center">
        <table>
          <tr>
            <xsl:call-template name="test-index">
              <xsl:with-param name="letters">
                <xsl:text>ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:text>
              </xsl:with-param>
            </xsl:call-template>
          </tr>
        </table>
      </div>
      <hr/>
      <xsl:call-template name="create-index"/>
    </div>
  </xsl:template>

  <xsl:template name="test-index">
    <xsl:param name="letters"/>
    <xsl:choose>
      <xsl:when test="$letters!=''">
        <xsl:variable name="letter">
          <xsl:value-of select="substring($letters,1,1)"/>
        </xsl:variable>
        <xsl:variable name="terms" select="key('terms',$letter)"/>
        <xsl:if test="$terms">
          <td>
            <a href="#{$letter}">
              <xsl:value-of select="$letter"/>
            </a>
          </td>
        </xsl:if>
        <xsl:call-template name="test-index">
          <xsl:with-param name="letters">
            <xsl:value-of select="substring($letters,2)"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text></xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- create-index calls itself, slicing off one letter from the 
       alphabet each time, and calling create-index-section with
       the letter as parameter -->

  <xsl:template name="create-index">
    <xsl:param name="letters">
      <xsl:text>ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:text>
    </xsl:param>
    <xsl:call-template name="create-index-section">
      <xsl:with-param name="letter" select="substring($letters,1,1)"/>
    </xsl:call-template>
    <xsl:variable name="remainder" select="substring($letters,2)"/>
    <xsl:if test="$remainder">
      <xsl:call-template name="create-index">
        <xsl:with-param name="letters" select="$remainder"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- create-index-section outputs a H4 element with the letter as
       the heading, then goes through all the entries in key "terms"
       beginning with that letter, sorted into string order. Each
       entry is handled according to the name of its containing
       element type: acronym, firstterm, indexterm, etc as above. -->

  <xsl:template name="create-index-section">
    <!-- called with letter value to do each letter of the alphabet -->
    <xsl:param name="letter"/>
    <xsl:message>
      <xsl:value-of select="$letter"/>
    </xsl:message>
    <!-- pick out those terms we have indexed beginning with $letter -->
    <xsl:variable name="terms" select="key('terms',$letter)"/>
    <!-- only do anything if there's something to do -->
    <xsl:if test="$terms">
      <h4>
        <a name="{$letter}">
          <xsl:value-of select="$letter"/>
        </a>
      </h4>
      <!-- go through each set of terms for this letter in sort order -->
      <xsl:for-each select="$terms">
        <xsl:sort/>
        <!-- declare some variables to hold indexable strings -->
        <xsl:variable name="curval">
          <xsl:value-of select="string(.)"/>
        </xsl:variable>
        <!-- identify where it occurs in the text, 
             to use as a possible filename -->
        <xsl:variable name="docfrag">
          <xsl:if test="$fragment">
            <xsl:for-each select="(ancestor-or-self::preface |
                                  ancestor-or-self::chapter |
                                  ancestor-or-self::appendix |
                                  ancestor-or-self::bibliography |
                                  ancestor-or-self::index)[last()]">
              <xsl:choose>
                <xsl:when test="name()='chapter'">
                  <xsl:text>chapter</xsl:text>
                  <xsl:number count="//chapter" level="any"/>
                </xsl:when>
                <xsl:when test="name()='appendix'">
                  <xsl:text>appendix</xsl:text>
                  <xsl:number count="//appendix" level="any" format="A"/>
                </xsl:when>
                <xsl:when test="name()='preface'">
                  <xsl:value-of select="@id"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="name()"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
            <xsl:text>.html</xsl:text>
          </xsl:if>
        </xsl:variable>
        <!-- decide what kind of thing we are indexing -->
        <xsl:choose>
          <!-- ACRONYMS -->
          <xsl:when test="name()='id' and name(..)='acronym'">
            <!-- Acronyms are indexed by ID in key "terms", so all that is
                 there are the ones with an ID attribute: the defining
                 instances. Output them, with a link to their ID in the
                 document, followed by the expansion in parentheses and
                 the document section where it occurred (from genref).
                 Then go through the key "acroref" for all matches for
                 the ID (all the references to this entry), in document
                 order (implicitly, as they are unsorted) and print the
                 genref IFF it is the first entry in its division. -->
            <xsl:text>&#x000A;</xsl:text>
            <br/>
            <a href="{$docfrag}#{../@id}" class="acroid">
              <xsl:value-of select="../@id"/>
            </a>
            <xsl:text>&#x00A0;(</xsl:text>
            <xsl:value-of select="string(..)"/>
            <xsl:text>)&#x00A0;</xsl:text>
            <xsl:call-template name="genref"/>
            <!-- for the referring occurrences -->
            <xsl:variable name="acroid">
              <xsl:value-of select="../@id"/>
            </xsl:variable>
            <xsl:for-each select="//acronym[@ref=$acroid]">
              <!-- This test finds the division which contains the current
                   acronym ref entry, then finds all the acronym refs in it
                   which refer to the same acronym as the one we are using,
                   and picks the first one in document order, and performs
                   a union with the current entry. If they are the same 
                   element, this must be the first acronym ref of its kind 
                   in the div, so print it. -->
              <xsl:if test="count(.|(ancestor::sect3 |
                            ancestor::sect2 |
                            ancestor::sect1 |
                            ancestor::chapter |
                            ancestor::appendix |
                            ancestor::preface |
                            ancestor::index)[last()]/
                            descendant::acronym[@ref=$acroid]
                                               [position()=1])=1">
                <xsl:text>, </xsl:text>
                <a class="acrorefs">
                  <xsl:attribute name="href">
                    <xsl:value-of select="$docfrag"/>
                    <xsl:text>#A</xsl:text>
                    <xsl:number count="//acronym" level="any"/>
                  </xsl:attribute>
                  <xsl:call-template name="genref"/>
                </a>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <!-- FIRSTTERMs -->
          <!-- these all have an ID so there can only ever be one of each -->
          <xsl:when test="name(..)='firstterm'">
            <xsl:text>&#x000A;</xsl:text>
            <br/>
            <b>
              <i>
                <a href="{$docfrag}#{../@id}" class="firstterm">
                  <xsl:value-of select=".."/>
                </a>
              </i>
            </b>
            <xsl:text>&#x00A0;</xsl:text>
            <xsl:call-template name="genref"/>
          </xsl:when>
          <!-- PERSONNAME -->
          <!-- Only surnames are indexed, so look for remaps -->
          <xsl:when test="name()='surname' and name(..)='personname'">
            <xsl:text>&#x000A;</xsl:text>
            <br/>
            <a href="{$docfrag}#{../@id}" class="personname">
              <xsl:value-of select="."/>
              <xsl:text>, </xsl:text>
              <xsl:value-of select="../firstname"/>
            </a>
            <xsl:text>&#x00A0;</xsl:text>
            <xsl:call-template name="genref"/>
            <xsl:variable name="pid">
              <xsl:value-of select="../@id"/>
            </xsl:variable>
            <xsl:for-each select="//personname[@remap=$pid]">
              <xsl:text>, </xsl:text>
              <a class="personname">
                <xsl:attribute name="href">
                  <xsl:value-of select="$docfrag"/>
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="@remap"/>
                </xsl:attribute>
                <xsl:call-template name="genref"/>
              </a>
            </xsl:for-each>
          </xsl:when>
          <!-- COMMAND,METHODNAME,MODESPEC,OPTION,PRODUCTNAME,TRADEMARK,VARNAME-->
          <!-- These differ from acronyms in that they are all idempotent, so
               there is no primacy of an ID-bearing defining instance to print
               first. The template mkindex identifies solo occurrences and the
               first and subsequent occurrences of multiple entries. -->
          <xsl:when test="name()='command' or
                          name()='methodname' or
                          name()='modespec' or
                          name()='option' or
                          name()='productname' or
                          name()='trademark' or
                          name()='varname'">
            <xsl:call-template name="mkindex">
              <xsl:with-param name="gi" select="name()"/>
              <xsl:with-param name="curval" select="$curval"/>
              <xsl:with-param name="docfrag" select="$docfrag"/>
            </xsl:call-template>
          </xsl:when>
          <!-- INDEXTERMS -->
          <!-- These are even more complex, as they may have secondary 
               subterms.
               The "see" entries are simple and are got out of the way first.
               As with the grouped entries above, we detect singletons, and
               the first and subsequent occurrences of multiple entries. -->
          <xsl:when test="name()='indexterm'">
            <xsl:variable name="curpri">
              <xsl:value-of select="string(primary)"/>
            </xsl:variable>
            <xsl:variable name="cursec">
              <xsl:value-of select="string(secondary)"/>
            </xsl:variable>
            <xsl:choose>
              <!-- print "see" references as text -->
              <xsl:when test="see">
                <xsl:text>&#x000A;</xsl:text>
                <br/>
                <xsl:apply-templates mode="see"/>
              </xsl:when>
              <!-- if this is the only occurrence of the term, anywhere -->
              <xsl:when test="count(preceding::indexterm[primary=$curpri])+
                              count(following::indexterm[primary=$curpri])=0">
                <xsl:text>&#x000A;</xsl:text>
                <br/>
                <a class="soloindex">
                  <xsl:attribute name="href">
                    <xsl:value-of select="$docfrag"/>
                    <xsl:text>#I</xsl:text>
                    <xsl:number count="//indexterm" level="any"/>
                  </xsl:attribute>
                  <xsl:apply-templates select="primary" mode="plain"/>
                </a>
              </xsl:when>
              <!-- else this is one of multiple occurrences, we first want 
                   to print the headword, then its secondary, if any, then
                   remaining entries -->
              <xsl:otherwise>
                <xsl:choose>
                  <!-- print the primary value as the headword in the first
                       case only -->
                  <xsl:when test="count(primary|key('prim',string(primary))[1])=1">
                    <xsl:text>&#x000A;</xsl:text>
                    <br/>
                    <a class="headword">
                      <xsl:attribute name="href">
                        <xsl:value-of select="$docfrag"/>
                        <xsl:text>#I</xsl:text>
                        <xsl:number count="//indexterm" level="any"/>
                      </xsl:attribute>
                      <xsl:apply-templates select="primary" mode="plain"/>
                    </a>
                    <xsl:if test="secondary">
                      <a class="secondary">
                        <xsl:attribute name="href">
                          <xsl:value-of select="$docfrag"/>
                          <xsl:text>#I</xsl:text>
                          <xsl:number count="//indexterm" level="any"/>
                        </xsl:attribute>
                        <xsl:apply-templates select="secondary" mode="plain"/>
                      </a>
                      <xsl:text>&#x00A0;</xsl:text>
                      <xsl:call-template name="genref"/>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- otherwise test if the secondary has changed: if
                         so, print it, otherwise print the div ref only -->
                    <xsl:choose>
                      <xsl:when test="count(tertiary|key('ter',string(tertiary))[1])=1">
                        <br/>
                        <xsl:text>&#x00A0;&#x00A0;&#x00A0;&#x00A0;&#x00A0;&#x00A0;</xsl:text>
                        <a class="tertiary">
                          <xsl:attribute name="href">
                            <xsl:value-of select="$docfrag"/>
                            <xsl:text>#I</xsl:text>
                            <xsl:number count="//indexterm" level="any"/>
                          </xsl:attribute>
                          <xsl:apply-templates select="tertiary" mode="plain"/>
                        </a>
                        <xsl:text>&#x00A0;</xsl:text>
                        <xsl:call-template name="genref"/>
                      </xsl:when>
                      <xsl:when test="count(secondary|key('sec',string(secondary))[1])=1">
                        <br/>
                        <xsl:text>&#x00A0;&#x00A0;&#x00A0;</xsl:text>
                        <a class="secondary">
                          <xsl:attribute name="href">
                            <xsl:value-of select="$docfrag"/>
                            <xsl:text>#I</xsl:text>
                            <xsl:number count="//indexterm" level="any"/>
                          </xsl:attribute>
                          <xsl:apply-templates select="secondary" mode="plain"/>
                        </a>
                        <xsl:text>&#x00A0;</xsl:text>
                        <xsl:call-template name="genref"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text>,&#x000A;</xsl:text>
                        <a class="primary">
                          <xsl:attribute name="href">
                            <xsl:value-of select="$docfrag"/>
                            <xsl:text>#I</xsl:text>
                            <xsl:number count="//indexterm" level="any"/>
                          </xsl:attribute>
                          <xsl:call-template name="genref"/>
                        </a>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
                <!--
                    <xsl:if test="count(.|((ancestor::sect3 |
                            ancestor::sect2 |
                            ancestor::sect1 |
                            ancestor::chapter |
                            ancestor::appendix |
                            ancestor::preface)[last()]/
                            descendant::indexterm[secondary=$sec])[position()=1])=1">
-->
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- Missed something -->
          <xsl:otherwise>
            <xsl:text>&#x000A;</xsl:text>
            <br/>
            <font color="red">
              <xsl:value-of select="name()"/>
              <xsl:text>:</xsl:text>
              <xsl:value-of select="."/>
            </font>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <xsl:template name="mkindex">
    <!-- Here we accept the GI and current character data value of
         an element recorded in the index. The element will have been
         instantiated as a link target in the document body using the
         first character of its GI and its sequential position, so we
         generate the same value here as a link HREF. The exception is
         <modespec> as we have already used "m" for another element type.
         We therefore have to identify three types of index entry: 
         (a) the single occurrences, used nowhere else (identified by
             only occurring once in the index;
         (b) the first occurrences of multiple references to the same
             string value;
         (c) the subsequent occurrences of multiple references.
    -->
    <xsl:param name="gi"/>
    <xsl:param name="curval"/>
    <xsl:param name="docfrag"/>
    <xsl:variable name="hrefchar">
      <xsl:choose>
        <xsl:when test="$gi='modespec'">
          <xsl:text>e</xsl:text>  
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($gi,1,1)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <!-- check if this is a singleton -->
      <xsl:when test="count(key($gi,.))=1">
        <xsl:text>&#x000A;</xsl:text>
        <br/>
        <a class="{$gi}-single">
          <xsl:attribute name="href">
            <xsl:value-of select="$docfrag"/>
            <xsl:text>#</xsl:text>
            <xsl:value-of select="$hrefchar"/>
            <xsl:number count="//*[name()=$gi]" level="any"/>
          </xsl:attribute>
          <!-- prefix LaTeX commands with a backslash -->
          <xsl:if test="$gi='command'">
            <xsl:text>\</xsl:text>
          </xsl:if>
          <xsl:apply-templates/>
        </a>
        <xsl:text>&#x00A0;</xsl:text>
        <xsl:call-template name="genref"/>
      </xsl:when>
      <!-- otherwise it has multiple references -->
      <xsl:otherwise>
        <xsl:choose>
          <!-- if this is the first one, output in full. 
               This uses the same technique as in create-index-section -->
          <xsl:when test="count(.|key($gi,.)[1])=1">
            <xsl:text>&#x000A;</xsl:text>
            <br/>
            <a class="{$gi}-first">
              <xsl:attribute name="href">
                <xsl:value-of select="$docfrag"/>
                <xsl:text>#</xsl:text>
                <xsl:value-of select="$hrefchar"/>
                <xsl:number count="//*[name()=$gi]" level="any"/>
              </xsl:attribute>
              <xsl:if test="$gi='command'">
                <xsl:text>\</xsl:text>
              </xsl:if>
              <xsl:apply-templates/>
            </a>
            <xsl:text> </xsl:text>
            <xsl:call-template name="genref"/>
          </xsl:when>
          <!-- else it's a subsequent entry, 
               output just the section number using genref -->
          <xsl:otherwise>
            <!-- check this is not subsequent in its div. this is tricky. As before: 
                 1. find the nearest enclosing structural div;
                 2. find all descendant elements within it of the 
                    same type as this one (and that will include this one)
                    which have the same value as this one, but restrict the
                    selection to the first one: you now have the first
                    occurrence of this element type for this value within
                    the same div as this one;
                 3. no union with the current node this time: we want those
                    elements which are first in their section, not those
                    which are not the same as the current element (think);
                 4. if the result is 1, this *is* the first, so use it
                    as an extra ref. 
                 This is in effect the same as the technique used
                 earlier for Acronyms to detect the first occurrence. -->
            <xsl:if test="count(.|(ancestor::sect3 |
                          ancestor::sect2 |
                          ancestor::sect1 |
                          ancestor::chapter |
                          ancestor::appendix |
                          ancestor::preface)[last()]/
                          descendant::*[name()=$gi]
                                       [string(.)=$curval]
                                       [position()=1])=1">
              <xsl:text>,&#x000A;    </xsl:text>
              <a class="{$gi}-subseq">
                <xsl:attribute name="href">
                  <xsl:value-of select="$docfrag"/>
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="$hrefchar"/>
                  <xsl:number count="//*[name()=$gi]" level="any"/>
                </xsl:attribute>
                <xsl:call-template name="genref"/>
              </a>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>                
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="indexterm">
    <!-- this is used in the document body to create targets -->
    <!-- if this is a <see> entry, ignore it here -->
    <xsl:if test="primary and not(see)">
      <a>
        <xsl:attribute name="name">
          <xsl:text>I</xsl:text>
          <xsl:number count="//indexterm" level="any"/>
        </xsl:attribute>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="primary" mode="see">
    <xsl:value-of select="."/>
    <xsl:text>, see </xsl:text>
    <xsl:value-of select="following-sibling::see"/>
  </xsl:template>

  <xsl:template match="primary|secondary|tertiary" mode="plain">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template name="genref">
    <xsl:text>(</xsl:text>
    <xsl:choose>
      <xsl:when test="ancestor::chapter">
        <xsl:number count="//chapter|sect1|sect2|sect3" 
          level="multiple" format="1.1.1.1"/>
      </xsl:when>
      <xsl:when test="ancestor::appendix">
        <xsl:number count="//appendix|sect1|sect2|sect3" 
          level="multiple" format="A.1.1.1"/>
      </xsl:when>
      <xsl:when test="ancestor::preface">
        <xsl:value-of select="ancestor::preface/title"/>
      </xsl:when>
      <xsl:when test="ancestor::index">
        <xsl:value-of select="ancestor::index/title"/>
      </xsl:when>
      <xsl:when test="ancestor::releaseinfo">
        <xsl:text>Release Info</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::revision">
        <xsl:text>Revision Info</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>UNKNOWN DIV</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>)</xsl:text>
  </xsl:template>

  <xsl:template match="see"/>

  <xsl:template match="format">
    <xsl:choose>
      <xsl:when test="@condition='HTML' or @condition='both'">
        <span>
          <xsl:attribute name="style">
            <!-- family specified or default rm|sf|tt -->
            <xsl:if test="@fontfamily or @fontdefault">
              <xsl:text>font-family:</xsl:text>
              <xsl:choose>
                <xsl:when test="@fontfamily">
                  <xsl:choose>
                    <xsl:when test="@fontfamily='ptm' or @fontfamily='cmr'">
                      <xsl:text>Times</xsl:text>
                    </xsl:when>
                    <xsl:when test="@fontfamily='phv' or @fontfamily='cmss'">
                      <xsl:text>Helvetica</xsl:text>
                    </xsl:when>
                    <xsl:when test="@fontfamily='pcr' or @fontfamily='cmtt'">
                      <xsl:text>Courier</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="@fontamily"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="@fontdefault">
                  <xsl:choose>
                    <xsl:when test="@fontdefault='rm'">
                      <xsl:text>serif</xsl:text>
                    </xsl:when>
                    <xsl:when test="@fontdefault='sf'">
                      <xsl:text>sans-serif</xsl:text>
                    </xsl:when>
                    <xsl:when test="@fontdefault='tt'">
                      <xsl:text>monospace</xsl:text>
                    </xsl:when>
                  </xsl:choose>
                </xsl:when>
              </xsl:choose>
              <xsl:text>; </xsl:text>
            </xsl:if>
            <!-- size or step specified -->
            <xsl:if test="@fontsize or @fontstep">
              <xsl:text>font-size:</xsl:text>
              <xsl:choose>
                <xsl:when test="@fontsize">
                  <xsl:value-of select="@fontsize"/>
                  <xsl:text>pt; </xsl:text>
                </xsl:when>
                <xsl:when test="@fontstep='large' or 
                                @fontstep='Large' or
                                @fontstep='LARGE' or
                                @fontstep='huge' or
                                @fontstep='Huge'">
                  <xsl:text>big; </xsl:text>
                </xsl:when>
                <xsl:when test="@fontstep='small' or 
                                @fontstep='footnotesize' or
                                @fontstep='scriptsize' or
                                @fontstep='tiny'">
                  <xsl:text>small; </xsl:text>
                </xsl:when>
                <xsl:when test="@fontstep='normalsize'">
                  <xsl:text>normal; </xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>unknown; </xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
            <xsl:if test="@fontseries">
              <xsl:text>font-weight:</xsl:text>
              <xsl:choose>
                <xsl:when test="@fontseries='m'">
                  <xsl:text>normal</xsl:text>
                </xsl:when>
                <xsl:when test="@fontseries='b' or 
                                @fontseries='bx' or 
                                @fontseries='k'">
                  <xsl:text>bold</xsl:text>
                </xsl:when>
                <xsl:when test="@fontseries='l'">
                  <xsl:text>light</xsl:text>
                </xsl:when>
              </xsl:choose>
              <xsl:text>; </xsl:text>
            </xsl:if>
            <xsl:if test="@fontshape">
              <xsl:text>font-style:</xsl:text>
              <xsl:choose>
                <xsl:when test="@fontshape='n'">
                  <xsl:text>normal</xsl:text>
                </xsl:when>
                <xsl:when test="@fontshape='it' or 
                                @fontshape='sl' or 
                                @fontshape='ui'">
                  <xsl:text>italic</xsl:text>
                </xsl:when>
                <xsl:when test="@fontshape='sc'">
                  <xsl:text>smallcaps</xsl:text>
                </xsl:when>
              </xsl:choose>
              <xsl:text>; </xsl:text>
            </xsl:if>
            <xsl:if test="@background">
              <xsl:text>background-color:#</xsl:text>
              <xsl:value-of select="@background"/>
              <xsl:text>;</xsl:text>
            </xsl:if>
            <xsl:if test="@colour or @colourcode">
              <xsl:text>color:</xsl:text>
              <xsl:choose>
                <xsl:when test="@colourcode">
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="@colourcode"/>
                </xsl:when>
                <xsl:when test="@colour">
                  <xsl:value-of select="@colour"/>
                </xsl:when>
              </xsl:choose>
              <xsl:text>; </xsl:text>
            </xsl:if>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test="@fontshape='sc'">
              <small>
                <xsl:value-of select="translate(.,
                                      'abcdefghijklmnopqrstuvwxyz',
                                      'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
              </small>          
            </xsl:when>
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="@image">
                  <img src="{@image}.png" width="100%" class="invisible"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="@lining">
                      <u>
                        <xsl:apply-templates/>
                      </u>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:apply-templates/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
        </span>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="@image">
          <img src="{@image}.png" align="middle" alt="{normalize-space(.)}">
            <xsl:if test="@fontsize">
              <xsl:attribute name="height">
                <xsl:value-of select="@fontsize"/>
                <xsl:text>pt</xsl:text>
              </xsl:attribute>
            </xsl:if>
          </img>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="foreignphrase">
    <xsl:if test="@remap">
      <xsl:value-of select="@remap"/>
      <xsl:text> (</xsl:text>
    </xsl:if>
    <i>
      <xsl:apply-templates/>
    </i>
    <xsl:if test="@lang='gr'">
      <xsl:text>)</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="caution">
    <img src="{@remap}.png">
      <xsl:attribute name="width">
        <xsl:variable name="cw">
          <xsl:value-of select="@colwidth"/>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($cw,'in')">
            <xsl:value-of select="substring-before($cw,'in') * 72"/>
          </xsl:when>
          <xsl:when test="contains($cw,'cm')">
            <xsl:value-of select="substring-before($cw,'cm') * 28"/>
          </xsl:when>
          <xsl:when test="contains($cw,'mm')">
            <xsl:value-of select="substring-before($cw,'mm') * 3"/>
          </xsl:when>
          <xsl:when test="contains($cw,'pt')">
            <xsl:value-of select="$cw"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$cw"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="align">
        <xsl:choose>
          <xsl:when test="@role">
            <xsl:value-of select="@role"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>middle</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
    </img>
  </xsl:template>

  <xsl:template match="processing-instruction('html')">
    <xsl:choose>
      <xsl:when test=".='&lt;br>'">
        <br/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="squeeze">
    <xsl:param name="string">
      <xsl:text></xsl:text>
    </xsl:param>
    <xsl:param name="LF">
      <xsl:text>&#x000A;</xsl:text>
    </xsl:param>
    <xsl:param name="CR">
      <xsl:text>&#x000D;</xsl:text>
    </xsl:param>
    <xsl:param name="TAB">
      <xsl:text>&#x0009;</xsl:text>
    </xsl:param>
    <xsl:choose>
      <xsl:when test="contains($string,$LF)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,$LF),' ')"/>
            <xsl:choose>
              <xsl:when test="substring(substring-after($string,$LF),1,1)=' ' or
                              substring(substring-after($string,$LF),1,1)=$TAB">
                <xsl:value-of select="substring(substring-after($string,$LF),2)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="substring-after($string,$LF)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,$CR)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,$CR),' ')"/>
            <xsl:choose>
              <xsl:when test="substring(substring-after($string,$CR),1,1)=' ' or
                              substring(substring-after($string,$CR),1,1)=$TAB">
                <xsl:value-of select="substring(substring-after($string,$CR),2)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="substring-after($string,$CR)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,$TAB)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="translate($string,$TAB,' ')"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,'  ')">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,'  '),
                                  ' ',substring-after($string,'  '))"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="ordinal">
    <xsl:param name="cardinal"/>
    <xsl:variable name="units">
      <xsl:value-of select="substring($cardinal,string-length($cardinal),1)"/>
    </xsl:variable>
    <xsl:variable name="tens">
      <xsl:value-of select="substring($cardinal,string-length($cardinal)-1,1)"/>
    </xsl:variable>
    <xsl:value-of select="$cardinal"/>
    <xsl:choose>
      <xsl:when test="number($cardinal)='NaN'">
        <xsl:text> (Not A Number)</xsl:text>
      </xsl:when>
      <xsl:when test="$units='1' and $tens != '1'">
        <xsl:text>st</xsl:text>
      </xsl:when>
      <xsl:when test="$units='2' and $tens != '1'">
        <xsl:text>nd</xsl:text>
      </xsl:when>
      <xsl:when test="$units='3' and $tens != '1'">
        <xsl:text>rd</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>th</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="TeX">
    <span class="TEX">T<span class="E">E</span>X</span>
  </xsl:template>

  <xsl:template match="LaTeX">
    <span class="LATEX">L<span class="A">A</span><span class="TEX">T<span class="E">E</span>X</span></span>
  </xsl:template>

  <xsl:template match="LaTeXe">
    <span class="LATEX">L<span class="A">A</span><span class="TEX">T<span class="E">E</span>X</span>&#x003B5;</span>
  </xsl:template>

  <xsl:template match="BibTeX">
    <span class="BIBTEX">B<span class="I">I</span>B<span class="TEX">T<span class="E">E</span>X</span></span>
  </xsl:template>

  <xsl:template match="LyX">
    <span class="LYX">L<span class="Y">Y</span>X</span>
  </xsl:template>

</xsl:stylesheet>
