%
%  cweave.ch  by Mark Motl for the purpose of separating the index
%  and module names into files INDEX.tex and MODULE_NAMES.tex
%  respectively.  These are used in the web-mode for gnu-emacs.

@x
@* Introduction.
The ``banner line'' defined here should be changed whenever \.{CWEAVE}
is modified.

@d banner "This is CWEAVE ($Revision: 1.9 $)\n"
@y
@* Introduction.
The ``banner line'' defined here should be changed whenever \.{CWEAVE}
is modified.

@d banner "CWEAVE ($Rev: 1.9 $), writes INDEX.tex and MODULE_NAMES.tex\n"
@z


@x
@ @c phase_three() {
if (no_xref) {
  finish_line();
  out_str("\\vfill\\end");
  finish_line();
}
else {
  phase=3; printf("\nWriting the index...");
  if (change_exists) {
    finish_line(); @<Tell about changed modules@>;
  }
  finish_line(); out_str("\\inx"); finish_line();
@.\\inx@>
  @<Do the first pass of sorting@>;
  @<Sort and output the index@>;
  out_str("\\fin"); finish_line();
@.\\fin@>
  @<Output all the module names@>;
  out_str("\\con"); finish_line();
@.\\con@>
}
printf("Done.");
check_complete(); /* was all of the change file used? */
}
@y
@ @c phase_three() {
if (no_xref) {
  finish_line();
  out_str("\\vfill\\end");
  finish_line();
}
else {
  phase=3; printf("\nWriting the index...");
  finish_line(); 
  out_str("\\input INDEX"); finish_line(); finish_line();
  out_str("\\input MODULE_NAMES"); finish_line(); fclose(tex_file);
  if ((tex_file=fopen("INDEX.tex","w"))==NULL)
    fatal("! Cannot open ouput file ","INDEX.tex");  
  if (change_exists) { @<Tell about changed modules@>;
    finish_line(); finish_line(); }
  out_str("\\inx"); finish_line();
@.\\inx@>
  @<Do the first pass of sorting@>;
  @<Sort and output the index@>;
  out_str("\\fin"); finish_line(); fclose(tex_file);
@.\\fin@>
  if ((tex_file=fopen("MODULE_NAMES.tex","w"))==NULL)
    fatal("! Cannot open ouput file ","MODULE_NAMES.tex");  
  @<Output all the module names@>;
  out_str("\\con"); finish_line(); fclose(tex_file);
@.\\con@>
}
printf("Done.");
check_complete(); /* was all of the change file used? */
}
@z
