/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.FileField;
import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JpdfxAppSelector
extends JDialog
implements ActionListener {
    private File selectedFile = null;
    private JLabel message = new JLabel(Jmakepdfx.getLabel("appselect.pathlabel"));
    private FileField fileField;
    private JFileChooser fileChooser;
    private Jmakepdfx app;
    private String pathEnvSep = ":";
    private String exeSuffix = "";
    private String path;

    public JpdfxAppSelector(Jmakepdfx jmakepdfx) {
        super(jmakepdfx, Jmakepdfx.getLabel("appselect.title"), true);
        this.message.setDisplayedMnemonic(Jmakepdfx.getMnemonic("appselect.pathlabel"));
        this.getContentPane().add((Component)this.message, "North");
        this.fileChooser = new JFileChooser();
        this.fileField = new FileField(this, this.fileChooser);
        this.getContentPane().add((Component)this.fileField, "Center");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.add(JpdfxResources.createOkayButton(this));
        jPanel.add(JpdfxResources.createCancelButton(this));
        String string = System.getProperty("os.name").toLowerCase();
        this.path = System.getenv("PATH");
        if (string.indexOf("win") >= 0) {
            this.pathEnvSep = ";";
            this.exeSuffix = ".exe";
        } else {
            this.pathEnvSep = ":";
            this.exeSuffix = "";
        }
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width += 50;
        dimension.height += 10;
        this.setSize(dimension);
        this.setLocationRelativeTo(jmakepdfx);
    }

    private File findApp(String string) {
        return this.findApp(string, null);
    }

    private File findApp(String string, String string2) {
        return this.findApp(string, null, null);
    }

    private File findApp(String string, String string2, String string3) {
        String string4 = string + this.exeSuffix;
        String string5 = string2 == null ? null : string2 + this.exeSuffix;
        String string6 = string3 == null ? null : string3 + this.exeSuffix;
        String[] stringArray = this.path.split(this.pathEnvSep);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i], string4);
            if (file.exists()) {
                return file;
            }
            if (string5 != null && (file = new File(stringArray[i], string5)).exists()) {
                return file;
            }
            if (string6 == null || !(file = new File(stringArray[i], string6)).exists()) continue;
            return file;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("choose")) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.fileField.setFileName(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (string.equals("okay")) {
            this.selectedFile = this.fileField.getFile();
            if (this.selectedFile == null || this.selectedFile.equals("")) {
                JpdfxResources.error((Component)this, Jmakepdfx.getLabel("error.no_file"));
            } else {
                this.setVisible(false);
            }
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }

    public File fetchApplicationPath(String string, String string2) {
        return this.fetchApplicationPath(string, null, string2);
    }

    public File fetchApplicationPath(String string, String string2, String string3) {
        return this.fetchApplicationPath(string, null, null, string3);
    }

    public File fetchApplicationPath(String string, String string2, String string3, String string4) {
        this.selectedFile = null;
        File file = this.findApp(string, string2, string3);
        if (file != null) {
            this.fileChooser.setCurrentDirectory(file.getParentFile());
            this.fileChooser.setSelectedFile(file);
            this.fileField.setFileName(file.getAbsolutePath());
        } else {
            this.fileField.setFileName(string + this.exeSuffix);
        }
        this.message.setText(string4);
        this.setVisible(true);
        return this.selectedFile;
    }

    public File fetchApplicationPath(String string) {
        this.selectedFile = null;
        this.fileChooser.setSelectedFile(null);
        this.fileField.setFileName("");
        this.message.setText(string);
        this.setVisible(true);
        return this.selectedFile;
    }
}

