/*
* Parse LaTeX (and TeX).
* Usage: l2x parser_file input_file
*  %comment
*
* Read paragraph or bracketed {} section.
*/
#include <stdio.h>
#include <stdlib.h>     /* getopt() */
#include <tclExtend.h>  /* DString */
#include "ansi.h"
#include "l2x.h"

int Tcl_AppInit(Tcl_Interp *interp)
{
  Tcl_CreateCommand(interp, "include",        parse_file,     NULL, 
    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "input",          parse_file,     NULL, 
    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "parse",          parse,          NULL, 
    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "parser_init",    parser_init,    NULL, 
    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "parser_suspend", parser_suspend, 
    (ClientData)1, (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "parser_resume",  parser_suspend, 
    (ClientData)0, (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "substitute",     substitute,     NULL, 
    (Tcl_CmdDeleteProc *)NULL);

  return 0;
} /* Tcl_AppInit */

void main(int argc, char *argv[])
{
  Tcl_Main(argc, argv, Tcl_AppInit);
  exit(0);
}
