/*
* Remove initial and trailing blank lines.
*
* Usage: vise < in > out 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  int c;
  int valid = 0;
  int nl_count = 0;
  int i;

  while ((c = getchar()) != EOF) {
    if (c == '\n') {
      if (valid) nl_count++;
    }
    else {
      for (i = 0; i < nl_count; i++) {
        putchar('\n');
      }
      nl_count = 0;
      valid++;
      putchar(c);
    }
  }
  putchar('\n');
  return 0;
}
